/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.db2z;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.community.database.db2z.DB2ZDatabase;
import org.flywaydb.community.database.db2z.DB2ZJdbcTemplate;
import org.flywaydb.community.database.db2z.DB2ZSchema;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.exception.FlywaySqlException;

public class DB2ZConnection
extends org.flywaydb.core.internal.database.base.Connection<DB2ZDatabase> {
    private static final Log LOG = LogFactory.getLog(DB2ZConnection.class);

    DB2ZConnection(DB2ZDatabase database, Connection connection) {
        super((Database)database, connection);
        this.jdbcTemplate = new DB2ZJdbcTemplate(connection, database.getDatabaseType());
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("select current_schema from sysibm.sysdummy1", new String[0]);
    }

    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (!schema.exists()) {
                return;
            }
            this.doChangeCurrentSchemaOrSearchPathTo(schema.getName());
        }
        catch (SQLException e) {
            String sqlId = ((DB2ZDatabase)this.database).getSqlId() == "" ? schema.getName() : ((DB2ZDatabase)this.database).getSqlId();
            LOG.info("SET CURRENT SQLID = '" + sqlId + "'");
            LOG.info("SET SCHEMA " + ((DB2ZDatabase)this.database).quote(new String[]{schema.getName()}));
            throw new FlywaySqlException("Error setting current sqlid and/or schema", e);
        }
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        String sqlId = ((DB2ZDatabase)this.database).getSqlId() == "" ? schema : ((DB2ZDatabase)this.database).getSqlId();
        this.jdbcTemplate.execute("SET CURRENT SQLID = '" + sqlId + "'", new Object[0]);
        this.jdbcTemplate.execute("SET SCHEMA " + ((DB2ZDatabase)this.database).quote(new String[]{schema}), new Object[0]);
    }

    public Schema getSchema(String name) {
        return new DB2ZSchema(this.jdbcTemplate, (DB2ZDatabase)this.database, name);
    }
}

