/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.iris;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.community.database.IRISDatabaseExtension;
import org.flywaydb.community.database.iris.IRISDatabase;
import org.flywaydb.community.database.iris.IRISParser;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.CommunityDatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;

public class IRISDatabaseType
extends BaseDatabaseType
implements CommunityDatabaseType {
    public String getName() {
        return "InterSystems IRIS Data Platform";
    }

    public int getNullType() {
        return 0;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:IRIS:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return "com.intersystems.jdbc.IRISDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        int majorVersion;
        try {
            majorVersion = connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new FlywayException(String.format("Unable to load database major version for %s-%s", databaseProductName, databaseProductVersion), (Throwable)e);
        }
        return databaseProductName.startsWith("InterSystems IRIS") && majorVersion >= 2019;
    }

    public IRISDatabase createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new IRISDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new IRISParser(configuration, parsingContext, 3);
    }

    public String getPluginVersion(Configuration config) {
        return IRISDatabaseExtension.readVersion();
    }
}

