/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.iris;

import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.flywaydb.community.database.iris.IRISDatabase;
import org.flywaydb.community.database.iris.IRISSchema;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class IRISTable
extends Table<IRISDatabase, IRISSchema> {
    public static JdbcTemplate lockedJdbcTemplate = null;
    public static String lockedTable = null;
    public static AtomicInteger totalLocks = new AtomicInteger(0);

    public IRISTable(JdbcTemplate jdbcTemplate, IRISDatabase database, IRISSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForBoolean("SELECT DECODE((select 1 from %dictionary.compiledclass where SqlSchemaName = ? and SqlTableName = ?), 1, 1, 0)", new String[]{((IRISSchema)this.schema).getName(), this.name});
    }

    protected void doLock() throws SQLException {
        try {
            if (lockedJdbcTemplate == null && lockedTable == null) {
                lockedJdbcTemplate = this.jdbcTemplate;
                lockedTable = ((IRISDatabase)this.database).quote(new String[]{((IRISSchema)this.schema).getName(), this.name});
            }
            if (this.acquireLock()) {
                this.jdbcTemplate.execute("LOCK TABLE " + lockedTable + " IN EXCLUSIVE MODE", new Object[0]);
                totalLocks.incrementAndGet();
            } else {
                this.jdbcTemplate.execute("LOCK TABLE " + lockedTable + " IN EXCLUSIVE MODE", new Object[0]);
                this.jdbcTemplate.execute("UNLOCK " + lockedTable + " IN EXCLUSIVE MODE", new Object[0]);
                totalLocks.set(0);
                this.retry(15000L);
            }
        }
        catch (SQLException sqlException) {
            if (this.unsuccessfulLockAcquiring()) {
                totalLocks.decrementAndGet();
            }
            this.retry(10000L);
        }
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("SET OPTION COMPILEMODE = NOCHECK", new Object[0]);
        this.jdbcTemplate.execute("DROP TABLE " + ((IRISDatabase)this.database).quote(new String[]{((IRISSchema)this.schema).getName(), this.name}) + " CASCADE", new Object[0]);
    }

    private boolean acquireLock() {
        return totalLocks.get() >= 0;
    }

    private boolean unsuccessfulLockAcquiring() {
        return totalLocks.get() == 0;
    }

    private void retry(long backoffTime) throws SQLException {
        try {
            Thread.sleep(backoffTime);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.doLock();
        }
    }
}

