/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.questdb;

import java.sql.Connection;
import org.flywaydb.community.database.questdb.QuestDBConnection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;

public class QuestDBDatabase
extends Database<QuestDBConnection> {
    public boolean useSingleConnection() {
        return true;
    }

    public QuestDBDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected QuestDBConnection doGetConnection(Connection connection) {
        return new QuestDBConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "true";
    }

    public String getBooleanFalse() {
        return "false";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE IF NOT EXISTS " + table.getName() + " (\n    \"installed_rank\" INT,\n    \"version\" STRING,\n    \"description\" STRING,\n    \"type\" STRING,\n    \"script\" STRING,\n    \"checksum\" INT,\n    \"installed_by\" STRING,\n    \"installed_on\" TIMESTAMP,\n    \"execution_time\" INT,\n    \"success\" BOOLEAN\n) timestamp (installed_on) partition by day wal\n";
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table.getName() + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"installed_on"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ") VALUES (?, ?, ?, ?, ?, ?, ?, now(), ?, ?)";
    }

    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote(new String[]{"installed_rank"}) + "," + this.quote(new String[]{"version"}) + "," + this.quote(new String[]{"description"}) + "," + this.quote(new String[]{"type"}) + "," + this.quote(new String[]{"script"}) + "," + this.quote(new String[]{"checksum"}) + "," + this.quote(new String[]{"installed_on"}) + "," + this.quote(new String[]{"installed_by"}) + "," + this.quote(new String[]{"execution_time"}) + "," + this.quote(new String[]{"success"}) + " FROM " + table.getName() + " WHERE " + this.quote(new String[]{"installed_rank"}) + " > ? ORDER BY " + this.quote(new String[]{"installed_rank"});
    }
}

