/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.timeplus;

import java.io.IOException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;

public class TimeplusParser
extends Parser {
    private static final String ALTERNATIVE_QUOTE = "$$";

    protected TimeplusParser(Configuration configuration, ParsingContext parsingContext, int peekDepth) {
        super(configuration, parsingContext, peekDepth);
    }

    protected boolean isAlternativeStringLiteral(String peek) {
        if (peek.startsWith(ALTERNATIVE_QUOTE)) {
            return true;
        }
        return super.isAlternativeStringLiteral(peek);
    }

    protected Token handleAlternativeStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        String alternativeQuoteOpen = ALTERNATIVE_QUOTE;
        String alternativeQuoteEnd = ALTERNATIVE_QUOTE;
        reader.swallow(alternativeQuoteOpen.length());
        String text = reader.readUntilExcluding(new String[]{alternativeQuoteOpen, alternativeQuoteEnd});
        reader.swallow(alternativeQuoteEnd.length());
        return new Token(TokenType.STRING, pos, line, col, text, text, context.getParensDepth());
    }

    protected boolean isSingleLineComment(String peek, ParserContext context, int col) {
        return peek.startsWith("--") || peek.startsWith("//");
    }
}

