/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.UnsupportedConversionException;
import org.geolatte.geom.codec.WkbGeometryType;

class WkbVisitor<P extends Position>
implements GeometryVisitor<P> {
    private final ByteBuffer output;

    WkbVisitor(ByteBuffer byteBuffer) {
        this.output = byteBuffer;
    }

    @Override
    public void visit(Point<P> geom) {
        this.writeByteOrder(this.output);
        this.writeTypeCodeAndSrid(geom, this.output);
        if (geom.isEmpty()) {
            this.output.putUInt(0L);
        } else {
            this.writePoints(geom.getPositions(), geom.getCoordinateDimension(), this.output);
        }
    }

    @Override
    public void visit(LineString<P> geom) {
        this.writeByteOrder(this.output);
        this.writeTypeCodeAndSrid(geom, this.output);
        if (geom.isEmpty()) {
            this.output.putUInt(0L);
        } else {
            this.output.putUInt(geom.getNumPositions());
            this.writePoints(geom.getPositions(), geom.getCoordinateDimension(), this.output);
        }
    }

    @Override
    public void visit(Polygon<P> geom) {
        this.writeByteOrder(this.output);
        this.writeTypeCodeAndSrid(geom, this.output);
        if (geom.isEmpty()) {
            this.output.putUInt(0L);
        } else {
            this.writeNumRings(geom, this.output);
            for (LinearRing<P> ring : geom) {
                this.writeRing(ring);
            }
        }
    }

    @Override
    public <G extends Geometry<P>> void visit(GeometryCollection<P, G> geom) {
        this.writeByteOrder(this.output);
        this.writeTypeCodeAndSrid(geom, this.output);
        this.output.putUInt(geom.getNumGeometries());
    }

    protected void writeRing(LinearRing<P> geom) {
        this.output.putUInt(geom.getNumPositions());
        this.writePoints(geom.getPositions(), geom.getCoordinateDimension(), this.output);
    }

    protected void writeNumRings(Polygon<P> geom, ByteBuffer byteBuffer) {
        byteBuffer.putUInt(geom.isEmpty() ? 0L : (long)(geom.getNumInteriorRing() + 1));
    }

    protected void writePoint(double[] coordinates, ByteBuffer output) {
        for (double coordinate : coordinates) {
            output.putDouble(coordinate);
        }
    }

    protected void writePoints(PositionSequence<P> points, int coordinateDimension, ByteBuffer output) {
        double[] coordinates = new double[coordinateDimension];
        for (int i = 0; i < points.size(); ++i) {
            points.getCoordinates(i, coordinates);
            this.writePoint(coordinates, output);
        }
    }

    protected void writeByteOrder(ByteBuffer output) {
        output.put(output.getByteOrder().byteValue());
    }

    protected void writeTypeCodeAndSrid(Geometry<P> geometry, ByteBuffer output) {
        int typeCode = this.getGeometryType(geometry);
        output.putUInt(typeCode);
    }

    protected int getGeometryType(Geometry<P> geometry) {
        if (geometry.isEmpty()) {
            return WkbGeometryType.GEOMETRY_COLLECTION.getTypeCode();
        }
        WkbGeometryType type = WkbGeometryType.forClass(geometry.getClass());
        if (type == null) {
            throw new UnsupportedConversionException(String.format("Can't convert geometries of type %s", geometry.getClass().getCanonicalName()));
        }
        return type.getTypeCode();
    }
}

