/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans;

import org.geolatte.geom.crs.GeographicCoordinateReferenceSystem;
import org.geolatte.geom.crs.trans.CoordinateOperation;
import org.geolatte.geom.crs.trans.WithEpsgGOperationMethod;

public class GeographicToGeocentricConversion
implements CoordinateOperation,
WithEpsgGOperationMethod {
    final double eccentricity2;
    final double semiMajorAxis;
    final double primeMerid;
    final double epsilon;
    final double semiMinorAxis;

    public GeographicToGeocentricConversion(GeographicCoordinateReferenceSystem sourceCRS) {
        this.primeMerid = sourceCRS.getPrimeMeridian().getLongitude();
        this.semiMajorAxis = sourceCRS.getDatum().getEllipsoid().getSemiMajorAxis();
        double invFlatt = sourceCRS.getDatum().getEllipsoid().getInverseFlattening();
        double flatt = 1.0 / invFlatt;
        this.eccentricity2 = (2.0 - flatt) * flatt;
        this.epsilon = this.eccentricity2 / (1.0 - this.eccentricity2);
        this.semiMinorAxis = this.semiMajorAxis * (1.0 - flatt);
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public int inCoordinateDimension() {
        return 3;
    }

    @Override
    public int outCoordinateDimension() {
        return 3;
    }

    @Override
    public void forward(double[] inCoordinate, double[] outCoordinate) {
        double phi = Math.toRadians(inCoordinate[1]);
        double lon = Math.toRadians(inCoordinate[0] - this.primeMerid);
        double h = inCoordinate[2];
        double primeVerticalRadius = this.semiMajorAxis / Math.sqrt(1.0 - this.eccentricity2 * Math.pow(Math.sin(phi), 2.0));
        double vhc = (primeVerticalRadius + h) * Math.cos(phi);
        outCoordinate[0] = vhc * Math.cos(lon);
        outCoordinate[1] = vhc * Math.sin(lon);
        outCoordinate[2] = ((1.0 - this.eccentricity2) * primeVerticalRadius + h) * Math.sin(phi);
    }

    @Override
    public void reverse(double[] inCoordinate, double[] outCoordinate) {
        double x = inCoordinate[0];
        double y = inCoordinate[1];
        double z = inCoordinate[2];
        double p = Math.hypot(x, y);
        double q = Math.atan(z * this.semiMajorAxis / (p * this.semiMinorAxis));
        double phi = Math.atan((z + this.epsilon * this.semiMinorAxis * Math.pow(Math.sin(q), 3.0)) / (p - this.eccentricity2 * this.semiMajorAxis * Math.pow(Math.cos(q), 3.0)));
        double lambda = Math.atan(y / x);
        double primeVerticalRadius = this.semiMajorAxis / Math.sqrt(1.0 - this.eccentricity2 * Math.pow(Math.sin(phi), 2.0));
        double h = p / Math.cos(phi) - primeVerticalRadius;
        outCoordinate[0] = Math.toDegrees(lambda);
        outCoordinate[1] = Math.toDegrees(phi);
        outCoordinate[2] = h;
    }

    @Override
    public String getMethodId() {
        return "9602";
    }
}

