/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.HashMap;
import java.util.Map;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.Db2WktDecoder;
import org.geolatte.geom.codec.Db2WktEncoder;
import org.geolatte.geom.codec.HANAWktDecoder;
import org.geolatte.geom.codec.HANAWktEncoder;
import org.geolatte.geom.codec.PostgisWktDecoder;
import org.geolatte.geom.codec.PostgisWktEncoder;
import org.geolatte.geom.codec.Sfa110WktDecoder;
import org.geolatte.geom.codec.Sfa110WktEncoder;
import org.geolatte.geom.codec.Sfa121WktDecoder;
import org.geolatte.geom.codec.Sfa121WktEncoder;
import org.geolatte.geom.codec.WktDecoder;
import org.geolatte.geom.codec.WktEncoder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class Wkt {
    private static final Dialect DEFAULT_DIALECT = Dialect.POSTGIS_EWKT_1;
    private static final Map<Dialect, Class<? extends WktDecoder>> DECODERS = new HashMap<Dialect, Class<? extends WktDecoder>>();
    private static final Map<Dialect, Class<? extends WktEncoder>> ENCODERS = new HashMap<Dialect, Class<? extends WktEncoder>>();

    public static <P extends Position> Geometry<P> fromWkt(String wkt, CoordinateReferenceSystem<P> crs) {
        WktDecoder decoder = Wkt.newDecoder();
        return decoder.decode(wkt, crs);
    }

    public static Geometry<?> fromWkt(String wkt) {
        WktDecoder decoder = Wkt.newDecoder();
        return decoder.decode(wkt);
    }

    public static <P extends Position> Geometry<P> fromWkt(String wkt, CoordinateReferenceSystem<P> crs, Dialect dialect) {
        WktDecoder decoder = Wkt.newDecoder(dialect);
        return decoder.decode(wkt, crs);
    }

    public static Geometry<?> fromWkt(String wkt, Dialect dialect) {
        WktDecoder decoder = Wkt.newDecoder(dialect);
        return decoder.decode(wkt);
    }

    public static String toWkt(Geometry<?> geometry) {
        WktEncoder encoder = Wkt.newEncoder();
        return encoder.encode(geometry);
    }

    public static String toWkt(Geometry<?> geometry, Dialect dialect) {
        WktEncoder encoder = Wkt.newEncoder(dialect);
        return encoder.encode(geometry);
    }

    public static WktDecoder newDecoder(Dialect dialect) {
        Class<? extends WktDecoder> decoderClass = DECODERS.get((Object)dialect);
        assert (decoderClass != null) : "A variant declared, but no encoder/decoder registered.";
        return Wkt.createInstance(decoderClass);
    }

    public static WktDecoder newDecoder() {
        return Wkt.newDecoder(DEFAULT_DIALECT);
    }

    public static WktEncoder newEncoder(Dialect dialect) {
        Class<? extends WktEncoder> decoderClass = ENCODERS.get((Object)dialect);
        assert (decoderClass != null) : "A variant declared, but no encoder/decoder registered.";
        return Wkt.createInstance(decoderClass);
    }

    public static WktEncoder newEncoder() {
        return Wkt.newEncoder(DEFAULT_DIALECT);
    }

    private static <T> T createInstance(Class<? extends T> codecClass) {
        if (codecClass == null) {
            throw new IllegalArgumentException("Null WKT codec class is not allowed.");
        }
        try {
            return codecClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        DECODERS.put(Dialect.SFA_1_1_0, Sfa110WktDecoder.class);
        DECODERS.put(Dialect.SFA_1_2_1, Sfa121WktDecoder.class);
        DECODERS.put(Dialect.POSTGIS_EWKT_1, PostgisWktDecoder.class);
        DECODERS.put(Dialect.MYSQL_WKT, PostgisWktDecoder.class);
        DECODERS.put(Dialect.HANA_EWKT, HANAWktDecoder.class);
        DECODERS.put(Dialect.DB2_WKT, Db2WktDecoder.class);
        ENCODERS.put(Dialect.SFA_1_1_0, Sfa110WktEncoder.class);
        ENCODERS.put(Dialect.SFA_1_2_1, Sfa121WktEncoder.class);
        ENCODERS.put(Dialect.POSTGIS_EWKT_1, PostgisWktEncoder.class);
        ENCODERS.put(Dialect.MYSQL_WKT, PostgisWktEncoder.class);
        ENCODERS.put(Dialect.HANA_EWKT, HANAWktEncoder.class);
        ENCODERS.put(Dialect.DB2_WKT, Db2WktEncoder.class);
    }

    public static enum Dialect {
        SFA_1_1_0,
        SFA_1_2_1,
        POSTGIS_EWKT_1,
        MYSQL_WKT,
        HANA_EWKT,
        DB2_WKT;

    }
}

