/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.coverage;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageReadParam;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.PropertySource;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Utilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public final class CoverageUtilities {
    public static final InternationalString NODATA = Vocabulary.formatInternational((int)147);
    public static final AffineTransform AXES_SWAP = new AffineTransform2D(0.0, 1.0, 1.0, 0.0, 0.0, 0.0);
    public static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform2D(AffineTransform.getRotateInstance(0.0));
    public static final AffineTransform CENTER_TO_CORNER = AffineTransform.getTranslateInstance(PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER), PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER));
    public static final AffineTransform CORNER_TO_CENTER = AffineTransform.getTranslateInstance(-PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER), -PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER));

    private CoverageUtilities() {
    }

    public static CoordinateReferenceSystem getCRS2D(Coverage coverage) throws TransformException {
        if (coverage instanceof GridCoverage2D) {
            return ((GridCoverage2D)coverage).getCoordinateReferenceSystem2D();
        }
        if (coverage instanceof GridCoverage) {
            GridGeometry2D geometry = GridGeometry2D.wrap(((GridCoverage)coverage).getGridGeometry());
            if (geometry.isDefined(1)) {
                return geometry.getCoordinateReferenceSystem2D();
            }
            try {
                return geometry.reduce(coverage.getCoordinateReferenceSystem());
            }
            catch (FactoryException factoryException) {
                // empty catch block
            }
        }
        return CRSUtilities.getCRS2D((CoordinateReferenceSystem)coverage.getCoordinateReferenceSystem());
    }

    public static CoordinateReferenceSystem getHorizontalCRS(Coverage coverage) throws TransformException {
        CoordinateReferenceSystem returnedCRS = null;
        if (coverage instanceof GridCoverage2D) {
            returnedCRS = ((GridCoverage2D)coverage).getCoordinateReferenceSystem2D();
        }
        if (coverage instanceof GridCoverage) {
            GridGeometry2D geometry = GridGeometry2D.wrap(((GridCoverage)coverage).getGridGeometry());
            if (geometry.isDefined(1)) {
                returnedCRS = geometry.getCoordinateReferenceSystem2D();
            } else {
                try {
                    returnedCRS = geometry.reduce(coverage.getCoordinateReferenceSystem());
                }
                catch (FactoryException factoryException) {
                    // empty catch block
                }
            }
        }
        if (returnedCRS == null) {
            returnedCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)coverage.getCoordinateReferenceSystem());
        }
        if (returnedCRS == null) {
            throw new TransformException(Errors.format((int)29, (Object)returnedCRS));
        }
        return returnedCRS;
    }

    public static Envelope2D getEnvelope2D(Coverage coverage) throws MismatchedDimensionException {
        if (coverage instanceof GridCoverage2D) {
            return ((GridCoverage2D)coverage).getEnvelope2D();
        }
        if (coverage instanceof GridCoverage) {
            GridGeometry2D geometry = GridGeometry2D.wrap(((GridCoverage)coverage).getGridGeometry());
            if (geometry.isDefined(2)) {
                return geometry.getEnvelope2D();
            }
            return geometry.reduce(coverage.getEnvelope());
        }
        return new Envelope2D(coverage.getEnvelope());
    }

    public static double[] getBackgroundValues(GridCoverage2D coverage) {
        if (coverage == null) {
            throw new NullPointerException(Errors.format((int)146, (Object)"coverage", (Object)"GridCoverage2D"));
        }
        Object noData = coverage.getProperty("GC_NODATA");
        if (noData != null && noData instanceof Number) {
            return new double[]{(Double)noData};
        }
        GridSampleDimension[] sampleDimensions = coverage.getSampleDimensions();
        double[] background = new double[sampleDimensions.length];
        boolean found = false;
        int dataType = coverage.getRenderedImage().getSampleModel().getDataType();
        for (int i = 0; i < background.length; ++i) {
            List<Category> categories = sampleDimensions[i].getCategories();
            if (categories != null && categories.size() > 0) {
                for (Category category : categories) {
                    if (!category.getName().equals(NODATA)) continue;
                    background[i] = category.geophysics(true).getRange().getMinimum();
                    found = true;
                    break;
                }
            }
            if (found) continue;
            background[i] = CoverageUtilities.suggestNoDataValue(dataType).doubleValue();
        }
        return background;
    }

    public static boolean hasRenderingCategories(GridCoverage gridCoverage) {
        int numSampleDimensions = gridCoverage.getNumSampleDimensions();
        if (numSampleDimensions == 0) {
            return false;
        }
        SampleDimension[] sampleDimensions = new SampleDimension[numSampleDimensions];
        for (int i = 0; i < numSampleDimensions; ++i) {
            sampleDimensions[i] = gridCoverage.getSampleDimension(i);
        }
        return CoverageUtilities.hasTransform(sampleDimensions);
    }

    public static boolean hasTransform(SampleDimension[] sampleDimensions) {
        int i = sampleDimensions.length;
        while (--i >= 0) {
            MathTransform1D tr;
            SampleDimension sd = sampleDimensions[i];
            if (sd instanceof GridSampleDimension) {
                sd = ((GridSampleDimension)sd).geophysics(false);
            }
            if ((tr = sd.getSampleToGeophysics()) == null || tr.isIdentity()) continue;
            return true;
        }
        return false;
    }

    public static boolean uses(GridCoverage coverage, RenderedImage image) {
        if (coverage != null) {
            if (coverage.getRenderedImage() == image) {
                return true;
            }
            List sources = coverage.getSources();
            if (sources != null) {
                for (GridCoverage source : sources) {
                    if (!CoverageUtilities.uses(source, image)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getVisibleBand(Object image) {
        Object candidate = null;
        if (image instanceof RenderedImage) {
            candidate = ((RenderedImage)image).getProperty("GC_VisibleBand");
        } else if (image instanceof PropertySource) {
            candidate = ((PropertySource)image).getProperty("GC_VisibleBand");
        }
        if (candidate instanceof Integer) {
            return (Integer)candidate;
        }
        return 0;
    }

    public static ViewType preferredViewForOperation(GridCoverage2D coverage, Interpolation interpolation, boolean hasFilter, RenderingHints hints) {
        Vector<RenderedImage> sources;
        GridCoverage2D candidate;
        Object candidate2;
        if (hints != null && (candidate2 = hints.get(Hints.COVERAGE_PROCESSING_VIEW)) instanceof ViewType) {
            return (ViewType)((Object)candidate2);
        }
        RenderedImage sourceImage = coverage.getRenderedImage();
        if (sourceImage.getColorModel() instanceof IndexColorModel) {
            if (!CoverageUtilities.hasRenderingCategories(coverage)) {
                return ViewType.PHOTOGRAPHIC;
            }
            if (hints != null && Boolean.FALSE.equals(hints.get(Hints.REPLACE_NON_GEOPHYSICS_VIEW))) {
                return ViewType.PHOTOGRAPHIC;
            }
            if (!hasFilter && (interpolation == null || interpolation instanceof InterpolationNearest)) {
                if (hints != null) {
                    Object rendering = hints.get(RenderingHints.KEY_RENDERING);
                    if (RenderingHints.VALUE_RENDER_QUALITY.equals(rendering)) {
                        return ViewType.NATIVE;
                    }
                    if (RenderingHints.VALUE_RENDER_SPEED.equals(rendering)) {
                        return ViewType.SAME;
                    }
                }
                return ViewType.SAME;
            }
            return ViewType.GEOPHYSICS;
        }
        if (!hasFilter && (interpolation == null || interpolation instanceof InterpolationNearest) && (candidate = coverage.view(ViewType.NATIVE)) != coverage && (sources = coverage.getRenderedImage().getSources()) != null && sources.contains(candidate.getRenderedImage())) {
            return ViewType.NATIVE;
        }
        return ViewType.SAME;
    }

    public static ViewType preferredViewAfterOperation(GridCoverage2D coverage) {
        Set<ViewType> views = coverage.getViewTypes();
        if (views.contains((Object)ViewType.GEOPHYSICS)) {
            return ViewType.GEOPHYSICS;
        }
        if (views.contains((Object)ViewType.RENDERED)) {
            return ViewType.RENDERED;
        }
        if (views.contains((Object)ViewType.PACKED)) {
            return ViewType.PACKED;
        }
        if (views.contains((Object)ViewType.PHOTOGRAPHIC)) {
            return ViewType.PHOTOGRAPHIC;
        }
        return ViewType.SAME;
    }

    public static boolean isScaleTranslate(MathTransform transform, double EPS) {
        if (!(transform instanceof AffineTransform)) {
            return false;
        }
        AffineTransform at = (AffineTransform)transform;
        double rotation = Math.abs(XAffineTransform.getRotation((AffineTransform)at));
        return rotation < EPS;
    }

    public static double[] getResolution(AffineTransform gridToCRS) {
        double[] requestedRes = null;
        if (gridToCRS != null) {
            requestedRes = new double[]{XAffineTransform.getScaleX0((AffineTransform)gridToCRS), XAffineTransform.getScaleY0((AffineTransform)gridToCRS)};
        }
        return requestedRes;
    }

    public static boolean isSimpleGridToWorldTransform(AffineTransform gridToCRS, double EPS) {
        double rotation = XAffineTransform.getRotation((AffineTransform)gridToCRS);
        double quadrantRotation = Math.abs(rotation / 1.5707963267948966);
        return Math.abs(quadrantRotation - Math.floor(quadrantRotation)) < EPS;
    }

    public static boolean checkEmptySourceRegion(ImageReadParam readParameters, Rectangle dimensions) {
        Utilities.ensureNonNull((String)"readDimension", (Object)dimensions);
        Utilities.ensureNonNull((String)"readP", (Object)readParameters);
        Rectangle sourceRegion = readParameters.getSourceRegion();
        Rectangle.intersect(sourceRegion, dimensions, sourceRegion);
        if (sourceRegion.isEmpty()) {
            return true;
        }
        readParameters.setSourceRegion(sourceRegion);
        return false;
    }

    public static double getMosaicThreshold(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: {
                return 0.0;
            }
            case 3: {
                return -2.147483648E9;
            }
            case 2: {
                return -32768.0;
            }
            case 5: {
                return -1.7976931348623157E308;
            }
            case 4: {
                return -3.4028234663852886E38;
            }
        }
        return 0.0;
    }

    public static Number suggestNoDataValue(int dataType) {
        switch (dataType) {
            case 0: {
                return (byte)0;
            }
            case 1: {
                return (short)0;
            }
            case 3: {
                return Integer.MIN_VALUE;
            }
            case 2: {
                return (short)Short.MIN_VALUE;
            }
            case 5: {
                return Double.NaN;
            }
            case 4: {
                return Float.valueOf(Float.NaN);
            }
        }
        throw new IllegalAccessError(Errors.format((int)58, (Object)"dataType", (Object)dataType));
    }

    public static class UCUM {
        public static final UCUMUnit TIME_UNITS = new UCUMUnit("second", "s");
        public static final UCUMUnit ELEVATION_UNITS = new UCUMUnit("meter", "m");

        public static class UCUMUnit {
            private String name;
            private String symbol;

            public UCUMUnit(String name, String symbol) {
                this.name = name;
                this.symbol = symbol;
            }

            public String getName() {
                return this.name;
            }

            public String getSymbol() {
                return this.symbol;
            }
        }
    }
}

