/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.DelegatingHandler;
import org.geotools.geojson.GeoJSONUtil;
import org.geotools.geojson.IContentHandler;
import org.geotools.geojson.feature.AttributeIO;
import org.geotools.geojson.feature.CRSHandler;
import org.geotools.geojson.feature.ComplexPropertyHandler;
import org.geotools.geojson.feature.DefaultAttributeIO;
import org.geotools.geojson.geom.GeometryCollectionHandler;
import org.geotools.geojson.geom.GeometryHandler;
import org.json.simple.parser.ParseException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class FeatureHandler
extends DelegatingHandler<SimpleFeature> {
    private int fid = 0;
    private String separator = "-";
    String id;
    Geometry geometry;
    List<Object> values;
    List<String> properties;
    CoordinateReferenceSystem crs;
    SimpleFeatureBuilder builder;
    AttributeIO attio;
    SimpleFeature feature;
    private String baseId = "feature";
    private boolean autoFID = false;

    public FeatureHandler() {
        this(null, new DefaultAttributeIO());
    }

    public FeatureHandler(SimpleFeatureBuilder builder, AttributeIO attio) {
        this.builder = builder;
        this.attio = attio;
    }

    @Override
    public boolean startObject() throws ParseException, IOException {
        if (this.delegate != NULL) {
            return this.delegate.startObject();
        }
        if (this.properties == NULL_LIST) {
            this.properties = new ArrayList<String>();
        } else if (this.properties != null) {
            ComplexPropertyHandler propertyHandler = new ComplexPropertyHandler();
            this.delegate = propertyHandler;
            this.delegate.startObject();
            this.values.add(propertyHandler.getValue());
            return true;
        }
        return super.startObject();
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if (this.delegate != NULL) {
            return this.delegate.startObjectEntry(key);
        }
        if ("id".equals(key) && this.properties == null) {
            this.id = "";
            return true;
        }
        if ("crs".equals(key) && this.properties == null) {
            this.delegate = new CRSHandler();
            return true;
        }
        if ("geometry".equals(key) && this.properties == null) {
            this.delegate = new GeometryHandler(new GeometryFactory());
            return true;
        }
        if ("properties".equals(key) && this.delegate == NULL) {
            this.properties = NULL_LIST;
            this.values = new ArrayList<Object>();
        } else if (this.properties != null && this.delegate == NULL) {
            this.properties.add(key);
            return true;
        }
        return super.startObjectEntry(key);
    }

    @Override
    public boolean startArray() throws ParseException, IOException {
        if (this.properties != null && this.delegate == NULL) {
            ComplexPropertyHandler propertyHandler = new ComplexPropertyHandler();
            this.delegate = propertyHandler;
            this.delegate.startArray();
            this.values.add(propertyHandler.getValue());
            return true;
        }
        return super.startArray();
    }

    @Override
    public boolean endArray() throws ParseException, IOException {
        if (!this.delegate.endArray()) {
            this.delegate = NULL;
        }
        return true;
    }

    @Override
    public boolean endObject() throws ParseException, IOException {
        if (this.delegate instanceof IContentHandler) {
            boolean keepGoing = this.delegate.endObject();
            if (this.delegate instanceof GeometryHandler) {
                GeometryHandler geometryHandler = (GeometryHandler)this.delegate;
                Geometry g = (Geometry)geometryHandler.getValue();
                if (g != null || !(((GeometryHandler)this.delegate).getDelegate() instanceof GeometryCollectionHandler)) {
                    if (this.properties != null) {
                        this.values.add(g);
                    } else {
                        this.geometry = g;
                    }
                    this.delegate = NULL;
                }
            } else if (this.delegate instanceof CRSHandler) {
                this.crs = ((CRSHandler)this.delegate).getValue();
                this.delegate = UNINITIALIZED;
            }
            if (!keepGoing && this.delegate instanceof ComplexPropertyHandler) {
                int valueCount = this.values.size();
                if (valueCount > 0) {
                    Object justAdded = this.values.get(valueCount - 1);
                    Object perhapsReplacedGeometry = GeoJSONUtil.replaceGeometry(justAdded);
                    this.values.set(valueCount - 1, perhapsReplacedGeometry);
                }
                this.delegate = NULL;
            }
            return true;
        }
        if (this.delegate == UNINITIALIZED) {
            this.delegate = NULL;
            return true;
        }
        if (this.properties != null) {
            if (this.builder == null) {
                this.builder = this.createBuilder();
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                String att = this.properties.get(i);
                Object val = this.values.get(i);
                if (val instanceof String) {
                    val = this.attio.parse(att, (String)val);
                }
                this.builder.set(att, val);
            }
            this.properties = null;
            this.values = null;
            return true;
        }
        this.feature = this.buildFeature();
        this.id = null;
        this.geometry = null;
        this.properties = null;
        this.values = null;
        return true;
    }

    @Override
    public boolean primitive(Object value) throws ParseException, IOException {
        if (this.delegate instanceof GeometryHandler && value == null) {
            this.delegate = NULL;
            return true;
        }
        if ("".equals(this.id)) {
            this.id = value.toString();
            this.setFID(this.id);
            return true;
        }
        if (this.values != null && this.delegate == NULL) {
            this.values.add(value);
            return true;
        }
        return super.primitive(value);
    }

    @Override
    public SimpleFeature getValue() {
        return this.feature;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public void init() {
        this.feature = null;
    }

    SimpleFeatureBuilder createBuilder() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("feature");
        typeBuilder.setNamespaceURI("http://geotools.org");
        typeBuilder.setCRS(this.crs);
        if (this.properties != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                String prop = this.properties.get(i);
                Object valu = this.values.get(i);
                typeBuilder.add(prop, valu != null ? valu.getClass() : Object.class);
            }
        }
        if (this.geometry != null) {
            this.addGeometryType(typeBuilder, this.geometry);
        }
        return new SimpleFeatureBuilder(typeBuilder.buildFeatureType());
    }

    void addGeometryType(SimpleFeatureTypeBuilder typeBuilder, Geometry geometry) {
        typeBuilder.add("geometry", geometry != null ? geometry.getClass() : Geometry.class);
        typeBuilder.setDefaultGeometry("geometry");
    }

    SimpleFeature buildFeature() {
        SimpleFeatureBuilder builder = this.builder != null ? this.builder : this.createBuilder();
        SimpleFeatureType featureType = builder.getFeatureType();
        SimpleFeature f = builder.buildFeature(this.getFID());
        if (this.geometry != null) {
            if (featureType.getGeometryDescriptor() == null) {
                SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
                typeBuilder.init(featureType);
                this.addGeometryType(typeBuilder, this.geometry);
                featureType = typeBuilder.buildFeatureType();
                SimpleFeatureBuilder newBuilder = new SimpleFeatureBuilder(featureType);
                newBuilder.init(f);
                f = newBuilder.buildFeature(this.getFID());
            }
            f.setAttribute(featureType.getGeometryDescriptor().getLocalName(), (Object)this.geometry);
        }
        this.incrementFID();
        return f;
    }

    private void incrementFID() {
        ++this.fid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFID(String f) {
        int index = f.lastIndexOf(46);
        if (index < 0) {
            index = f.indexOf(45);
            if (index < 0) {
                this.autoFID = false;
                this.id = f;
                return;
            }
            this.separator = "-";
        } else {
            this.separator = ".";
        }
        this.baseId = f.substring(0, index);
        try {
            this.fid = Integer.parseInt(f.substring(index + 1));
            return;
        }
        catch (NumberFormatException e) {
            this.autoFID = false;
            this.id = f;
        }
    }

    private String getFID() {
        if (this.id == null || this.autoFID) {
            return this.baseId + this.separator + this.fid;
        }
        return this.id;
    }
}

