/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.complex;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.geometry.iso.complex.CompositeCurveImpl;
import org.geotools.geometry.iso.complex.CompositePointImpl;
import org.geotools.geometry.iso.complex.CompositeSurfaceImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.geometry.complex.ComplexFactory;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.complex.CompositePoint;
import org.opengis.geometry.complex.CompositeSurface;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.geometry.primitive.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ComplexFactoryImpl
implements Factory,
ComplexFactory {
    private CoordinateReferenceSystem crs;
    private Map hintsWeCareAbout = new HashMap();

    public ComplexFactoryImpl() {
        this((Hints)null);
    }

    public ComplexFactoryImpl(Hints hints) {
        if (hints == null) {
            this.crs = DefaultGeographicCRS.WGS84;
            hints = GeoTools.getDefaultHints();
            hints.put((Object)Hints.CRS, (Object)this.crs);
        } else {
            this.crs = (CoordinateReferenceSystem)hints.get((Object)Hints.CRS);
            if (this.crs == null) {
                throw new NullPointerException("A CRS Hint is required in order to use ComplexFactoryImpl");
            }
        }
        this.hintsWeCareAbout.put(Hints.CRS, this.crs);
    }

    public ComplexFactoryImpl(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.hintsWeCareAbout.put(Hints.CRS, crs);
    }

    public Map getImplementationHints() {
        return Collections.unmodifiableMap(this.hintsWeCareAbout);
    }

    public CompositePoint createCompositePoint(Point generator) {
        return new CompositePointImpl(this.crs, (PointImpl)generator);
    }

    public CompositeCurve createCompositeCurve(List<OrientableCurve> generator) {
        return new CompositeCurveImpl(generator);
    }

    public CompositeSurface createCompositeSurface(List<OrientableSurface> generator) {
        return new CompositeSurfaceImpl((List<? extends OrientableSurface>)generator);
    }
}

