/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.complex;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.iso.primitive.PrimitiveImpl;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class ComplexImpl
extends GeometryImpl
implements Complex {
    private Set<Complex> subComplex = null;
    private Set<Complex> superComplex = null;
    protected List<? extends Primitive> elements = null;

    public ComplexImpl(List<? extends Primitive> elements) {
        super(elements.get(0).getCoordinateReferenceSystem());
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("Array of Elements is empty. At least one element expected.");
        }
        this.elements = elements;
        this.subComplex = this.createBoundary();
        this.superComplex = null;
    }

    public ComplexImpl(CoordinateReferenceSystem crs) {
        super(crs);
        this.elements = null;
        this.subComplex = null;
        this.superComplex = null;
    }

    public void setElements(List<? extends Primitive> element) {
        this.elements = element;
    }

    public abstract Set<Complex> createBoundary();

    public Collection<? extends Primitive> getElements() {
        return this.elements;
    }

    boolean hasElement(PrimitiveImpl primitive) {
        return this.elements.contains(primitive);
    }

    void removeElement(PrimitiveImpl primitive) {
        this.elements.remove(primitive);
    }

    public boolean isMaximal() {
        return this.superComplex == null || this.superComplex.isEmpty();
    }

    protected void addSubComplex(Complex subComplex1) {
        this.subComplex.add(subComplex1);
    }

    protected void addSuperComplex(ComplexImpl superComplex1) {
        this.superComplex.add(superComplex1);
    }

    public Complex[] getSuperComplexes() {
        return this.superComplex == null ? null : this.superComplex.toArray(new Complex[this.superComplex.size()]);
    }

    public Complex[] getSubComplexes() {
        return this.subComplex == null ? null : this.subComplex.toArray(new Complex[this.subComplex.size()]);
    }

    public Set<Complex> getMaximalComplex() {
        HashSet<Complex> result = new HashSet<Complex>();
        if (this.isMaximal()) {
            result.add(this);
        } else {
            for (Complex c : this.superComplex) {
                result.addAll(c.getMaximalComplex());
            }
        }
        return result;
    }
}

