/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.complex;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.iso.complex.CompositeImpl;
import org.geotools.geometry.iso.io.GeometryToString;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.util.SuppressFBWarnings;
import org.opengis.geometry.Boundary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.complex.CompositePoint;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CompositePointImpl
extends CompositeImpl<PointImpl>
implements CompositePoint {
    private static final long serialVersionUID = 3391515492110694489L;

    public CompositePointImpl(PointImpl generator) {
        this(generator.getCoordinateReferenceSystem(), generator);
    }

    public CompositePointImpl(CoordinateReferenceSystem crs, PointImpl generator) {
        super(crs);
        ArrayList<PointImpl> list = new ArrayList<PointImpl>();
        list.add(generator);
        this.setElements(list);
    }

    @Override
    @SuppressFBWarnings(value={"NP_CLONE_COULD_RETURN_NULL"})
    public CompositePointImpl clone() throws CloneNotSupportedException {
        return null;
    }

    @Override
    public Set<Complex> createBoundary() {
        return null;
    }

    @Override
    public Class getGeneratorClass() {
        return PointImpl.class;
    }

    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isCycle() {
        return true;
    }

    public List getGenerators() {
        return this.elements;
    }

    @Override
    public Boundary getBoundary() {
        return null;
    }

    @Override
    public int getDimension(DirectPosition point) {
        return this.getCoordinateDimension();
    }

    @Override
    public Envelope getEnvelope() {
        return ((Primitive)this.elements.get(0)).getEnvelope();
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return ((PointImpl)this.elements.get(0)).getDirectPosition();
    }

    public String toString() {
        return GeometryToString.getString(this);
    }
}

