/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Mercator;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MercatorHandlerFactory
implements ProjectionHandlerFactory {
    private static final ReferencedEnvelope VALID_AREA = new ReferencedEnvelope(-1.7976931348623157E308, Double.MAX_VALUE, -85.0, 85.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)renderingEnvelope.getCoordinateReferenceSystem());
        if (renderingEnvelope != null && mapProjection instanceof Mercator) {
            ProjectionHandler handler;
            double centralMeridian = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode()).doubleValue();
            if (wrap && maxWraps > 0) {
                handler = new WrappingProjectionHandler(renderingEnvelope, VALID_AREA, sourceCrs, centralMeridian, maxWraps);
            } else {
                handler = new ProjectionHandler(sourceCrs, (Envelope)VALID_AREA, renderingEnvelope);
                handler.setCentralMeridian(centralMeridian);
            }
            if (!wrap) {
                handler.queryAcrossDateline = false;
            }
            return handler;
        }
        return null;
    }
}

