/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeToRegexConverter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class LikeFilterImpl
extends AbstractFilter
implements PropertyIsLike {
    private Expression attribute = null;
    private String pattern = null;
    private String wildcardSingle = ".?";
    private String wildcardMulti = ".*";
    private String escape = "\\";
    private Pattern compPattern = null;
    boolean matchingCase;
    protected MultiValuedFilter.MatchAction matchAction;

    public static String convertToSQL92(char escape, char multi, char single, boolean matchCase, String pattern) throws IllegalArgumentException {
        if (escape == '\'' || multi == '\'' || single == '\'') {
            throw new IllegalArgumentException("do not use single quote (') as special char!");
        }
        StringBuffer result = new StringBuffer(pattern.length() + 5);
        for (int i = 0; i < pattern.length(); ++i) {
            char chr = pattern.charAt(i);
            if (chr == escape) {
                if (i != pattern.length() - 1) {
                    result.append(pattern.charAt(i + 1));
                }
                ++i;
                continue;
            }
            if (chr == single) {
                result.append('_');
                continue;
            }
            if (chr == multi) {
                result.append('%');
                continue;
            }
            if (chr == '\'') {
                result.append('\'');
                result.append('\'');
                continue;
            }
            result.append(matchCase ? chr : Character.toUpperCase(chr));
        }
        return result.toString();
    }

    public String getSQL92LikePattern() throws IllegalArgumentException {
        if (this.escape.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> escape char should be of length exactly 1");
        }
        if (this.wildcardSingle.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> wildcardSingle char should be of length exactly 1");
        }
        if (this.wildcardMulti.length() != 1) {
            throw new IllegalArgumentException("Like Pattern --> wildcardMulti char should be of length exactly 1");
        }
        return LikeFilterImpl.convertToSQL92(this.escape.charAt(0), this.wildcardMulti.charAt(0), this.wildcardSingle.charAt(0), this.matchingCase, this.pattern);
    }

    public void setWildCard(String wildCard) {
        this.wildcardMulti = wildCard;
        this.compPattern = null;
    }

    public void setSingleChar(String singleChar) {
        this.wildcardSingle = singleChar;
        this.compPattern = null;
    }

    public void setEscape(String escape) {
        this.escape = escape;
        this.compPattern = null;
    }

    public void setMatchCase(boolean matchingCase) {
        this.matchingCase = matchingCase;
        this.compPattern = null;
    }

    public boolean isMatchingCase() {
        return this.matchingCase;
    }

    public MultiValuedFilter.MatchAction getMatchAction() {
        return this.matchAction;
    }

    public void setMatchingCase(boolean matchingCase) {
        this.matchingCase = matchingCase;
    }

    private Matcher getMatcher(String string) {
        if (this.compPattern == null) {
            String pattern = new LikeToRegexConverter(this).getPattern();
            this.compPattern = this.isMatchingCase() ? Pattern.compile(pattern) : Pattern.compile(pattern, 66);
        }
        return this.compPattern.matcher(string);
    }

    protected LikeFilterImpl() {
        this(MultiValuedFilter.MatchAction.ANY);
    }

    public LikeFilterImpl(Expression expr, String pattern, String wildcardMulti, String wildcardSingle, String escape) {
        this();
        this.setExpression(expr);
        this.setLiteral(pattern);
        this.setWildCard(wildcardMulti);
        this.setSingleChar(wildcardSingle);
        this.setEscape(escape);
    }

    protected LikeFilterImpl(MultiValuedFilter.MatchAction matchAction) {
        this.matchAction = matchAction;
    }

    public LikeFilterImpl(Expression expr, String pattern, String wildcardMulti, String wildcardSingle, String escape, MultiValuedFilter.MatchAction matchAction) {
        this(matchAction);
        this.setExpression(expr);
        this.setLiteral(pattern);
        this.setWildCard(wildcardMulti);
        this.setSingleChar(wildcardSingle);
        this.setEscape(escape);
    }

    public final void setValue(Expression attribute) throws IllegalFilterException {
        this.setExpression(attribute);
    }

    public Expression getExpression() {
        return this.attribute;
    }

    public void setExpression(Expression e) {
        this.attribute = e;
    }

    public final void setPattern(Expression p, String wildcardMulti, String wildcardSingle, String escape) {
        Object value;
        if (p instanceof Literal) {
            Literal literal = (Literal)p;
            value = literal.getValue();
            if (value == null || !(value instanceof String)) {
                throw new ClassCastException("Pattern Literal must be a string:" + value);
            }
        } else {
            throw new ClassCastException("Pattern must be a literal String");
        }
        String pattern = (String)value;
        this.setPattern(pattern, wildcardMulti, wildcardSingle, escape);
    }

    public final void setPattern(String pattern, String wildcardMulti, String wildcardSingle, String escape) {
        this.setLiteral(pattern);
        this.setWildCard(wildcardMulti);
        this.setSingleChar(wildcardSingle);
        this.setEscape(escape);
    }

    public final String getPattern() {
        return this.getLiteral();
    }

    public String getLiteral() {
        return this.pattern;
    }

    public void setLiteral(String literal) {
        this.pattern = literal;
        this.compPattern = null;
    }

    public boolean evaluate(Object feature) {
        if (this.attribute == null) {
            return false;
        }
        Object value = this.eval(this.attribute, feature);
        if (null == value) {
            return false;
        }
        if (value instanceof Collection) {
            int count = 0;
            for (Object element : (Collection)value) {
                Matcher matcher = this.getMatcher(element.toString());
                boolean temp = matcher.matches();
                if (temp) {
                    ++count;
                }
                switch (this.matchAction) {
                    case ONE: {
                        if (count <= 1) break;
                        return false;
                    }
                    case ALL: {
                        if (temp) break;
                        return false;
                    }
                    case ANY: {
                        if (!temp) break;
                        return true;
                    }
                }
            }
            switch (this.matchAction) {
                case ONE: {
                    return count == 1;
                }
                case ALL: {
                    return true;
                }
                case ANY: {
                    return false;
                }
            }
            return false;
        }
        Matcher matcher = this.getMatcher(value.toString());
        return matcher.matches();
    }

    public String toString() {
        return "[ " + this.attribute.toString() + " is like " + this.pattern + " ]";
    }

    public String getEscape() {
        return this.escape;
    }

    public final String getWildcardMulti() {
        return this.wildcardMulti;
    }

    public String getWildCard() {
        return this.getWildcardMulti();
    }

    public final String getWildcardSingle() {
        return this.wildcardSingle;
    }

    public String getSingleChar() {
        return this.getWildcardSingle();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LikeFilterImpl) {
            LikeFilterImpl lFilter = (LikeFilterImpl)obj;
            return Filters.getFilterType(lFilter) == Filters.getFilterType(this) && lFilter.getExpression().equals(this.attribute) && lFilter.getPattern().equals(this.pattern);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 37 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsLike)this, extraData);
    }
}

