/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Expression;

public abstract class MathExpressionImpl
extends DefaultExpression
implements BinaryExpression {
    private Expression leftValue = null;
    private Expression rightValue = null;

    protected MathExpressionImpl() {
    }

    protected MathExpressionImpl(Expression e1, Expression e2) {
        this.leftValue = e1;
        this.rightValue = e2;
    }

    public Expression getExpression1() {
        return this.leftValue;
    }

    public void setExpression1(Expression expression) {
        if (MathExpressionImpl.isGeometryExpression(Filters.getExpressionType(expression))) {
            throw new IllegalFilterException("Attempted to add Geometry expression to math expression.");
        }
        this.leftValue = expression;
    }

    public Expression getExpression2() {
        return this.rightValue;
    }

    public void setExpression2(Expression expression) {
        if (MathExpressionImpl.isGeometryExpression(Filters.getExpressionType(expression))) {
            throw new IllegalFilterException("Attempted to add Geometry expression to math expression.");
        }
        this.rightValue = expression;
    }

    protected void ensureOperandsSet() throws IllegalArgumentException {
        if (this.leftValue == null || this.rightValue == null) {
            throw new IllegalArgumentException("Attempted read math expression with missing sub expressions.");
        }
    }

    protected Object number(double number) {
        return number;
    }
}

