/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.Mercator;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.MathTransform;

public class GeographicHandlerFactory
implements ProjectionHandlerFactory {
    static final double MAX_LATITUDE = 89.99;
    static final double MIN_LATITUDE = -89.99;

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        if (renderingEnvelope != null && renderingEnvelope.getCoordinateReferenceSystem() instanceof GeographicCRS) {
            CoordinateReferenceSystem crs = renderingEnvelope.getCoordinateReferenceSystem();
            GeographicCRS geogCrs = (GeographicCRS)CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
            SingleCRS horizontalSourceCrs = CRS.getHorizontalCRS((CoordinateReferenceSystem)sourceCrs);
            ReferencedEnvelope validArea = null;
            if (horizontalSourceCrs instanceof GeographicCRS && !CRS.equalsIgnoreMetadata((Object)horizontalSourceCrs, (Object)geogCrs) && !CRS.equalsIgnoreMetadata((Object)horizontalSourceCrs, (Object)geogCrs)) {
                validArea = CRS.getAxisOrder((CoordinateReferenceSystem)sourceCrs) == CRS.AxisOrder.NORTH_EAST ? new ReferencedEnvelope(-89.99, 89.99, 3.4028234663852886E38, -3.4028234663852886E38, (CoordinateReferenceSystem)horizontalSourceCrs) : new ReferencedEnvelope(2.147483647E9, -2.147483647E9, -89.99, 89.99, (CoordinateReferenceSystem)horizontalSourceCrs);
            }
            if (wrap && maxWraps > 0) {
                double centralMeridian = geogCrs.getDatum().getPrimeMeridian().getGreenwichLongitude();
                WrappingProjectionHandler handler = new WrappingProjectionHandler(renderingEnvelope, validArea, sourceCrs, centralMeridian, maxWraps);
                handler.setDatelineWrappingCheckEnabled(!this.isWrappingException(crs, (CoordinateReferenceSystem)horizontalSourceCrs));
                return handler;
            }
            return new ProjectionHandler(sourceCrs, validArea, renderingEnvelope);
        }
        return null;
    }

    private boolean isWrappingException(CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem targetCRS) throws FactoryException {
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)targetCRS);
        return mt instanceof Mercator;
    }
}

