/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DelegatingFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.filter.visitor.BindingFilterVisitor;
import org.opengis.feature.Feature;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class FilteringFeatureReader<T extends FeatureType, F extends Feature>
implements DelegatingFeatureReader<T, F> {
    protected final FeatureReader<T, F> featureReader;
    protected final Filter filter;
    protected F next;

    public FilteringFeatureReader(FeatureReader<T, F> featureReader, Filter filter) {
        this.featureReader = featureReader;
        this.filter = (Filter)filter.accept((FilterVisitor)new BindingFilterVisitor((FeatureType)featureReader.getFeatureType()), null);
        this.next = null;
    }

    @Override
    public FeatureReader<T, F> getDelegate() {
        return this.featureReader;
    }

    @Override
    public F next() throws IOException, IllegalAttributeException, NoSuchElementException {
        F f = null;
        if (this.hasNext()) {
            f = this.next;
            this.next = null;
            return f;
        }
        throw new NoSuchElementException("No such Feature exsists");
    }

    @Override
    public void close() throws IOException {
        this.featureReader.close();
    }

    @Override
    public T getFeatureType() {
        return this.featureReader.getFeatureType();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        try {
            while (this.featureReader.hasNext()) {
                F peek = this.featureReader.next();
                if (!this.filter.evaluate(peek)) continue;
                this.next = peek;
                return true;
            }
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Could not peek ahead", e);
        }
        return this.next != null;
    }
}

