/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.AzimuthalEquidistant;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class AzimulthalEquidistantProjectionHandlerFactory
implements ProjectionHandlerFactory {
    static final Logger LOGGER = Logging.getLogger(AzimulthalEquidistantProjectionHandlerFactory.class);
    static final ReferencedEnvelope AZEQ_VALID_AREA = new ReferencedEnvelope(-1.7976931348623157E308, Double.MAX_VALUE, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    static final double EPS = 0.001;

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCRS, boolean wrap, int wrapLimit) throws FactoryException {
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)renderingEnvelope.getCoordinateReferenceSystem());
        if (renderingEnvelope != null && mapProjection instanceof AzimuthalEquidistant.Abstract) {
            try {
                AzimuthalEquidistantProjectionHandler ph = new AzimuthalEquidistantProjectionHandler(sourceCRS, AZEQ_VALID_AREA, renderingEnvelope);
                return ph;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not create an azimuthal equidistant projection handler, rendering without it", e);
                return null;
            }
        }
        return null;
    }

    private static class AzimuthalEquidistantProjectionHandler
    extends ProjectionHandler {
        Geometry simplifiedDateline;
        Geometry bufferedDateline;
        GeometryFactory gf = new GeometryFactory();
        Polygon renderingGeometry;
        boolean renderingGeometryReduced;

        public AzimuthalEquidistantProjectionHandler(CoordinateReferenceSystem sourceCRS, Envelope validAreaBounds, ReferencedEnvelope renderingEnvelope) throws FactoryException, MismatchedDimensionException, TransformException {
            super(sourceCRS, validAreaBounds, renderingEnvelope);
            CoordinateReferenceSystem crs = renderingEnvelope.getCoordinateReferenceSystem();
            Point2D.Double center = this.getCenter(crs);
            this.initializeDatelineCutter(crs, center);
            double radius = this.getRadius(crs, center);
            this.renderingGeometry = JTS.toGeometry(renderingEnvelope);
            if (!this.checkRenderingWithinRadius(center, radius)) {
                this.renderingGeometryReduced = true;
                Polygon azeqProjectedExtents = this.getAzeqProjectedExtents(radius);
                Geometry intersection = this.renderingGeometry.intersection((Geometry)azeqProjectedExtents);
                if (intersection.isEmpty()) {
                    this.renderingGeometry = null;
                } else {
                    List polygons = PolygonExtracter.getPolygons((Geometry)intersection);
                    this.renderingGeometry = (Polygon)polygons.get(0);
                }
            }
        }

        private double getRadius(CoordinateReferenceSystem crs, Point2D.Double center) throws TransformException, FactoryException {
            double lon1 = center.x;
            double lon2 = (lon1 + 180.0) % 360.0;
            double lat1 = center.y;
            double lat2 = -center.y;
            double[] line = new double[]{lon1, lat1, lon2, lat2};
            CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs).transform(line, 0, line, 0, 2);
            double dx = line[2] - line[0];
            double dy = line[3] - line[1];
            return Math.sqrt(dx * dx + dy * dy);
        }

        private void initializeDatelineCutter(CoordinateReferenceSystem crs, Point2D.Double center) throws TransformException, FactoryException {
            Geometry dateLine = this.getDateLine(center);
            Geometry datelineAzeq = JTS.transform(dateLine, CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs));
            this.simplifiedDateline = DouglasPeuckerSimplifier.simplify((Geometry)datelineAzeq, (double)100.0);
            this.bufferedDateline = this.simplifiedDateline.buffer(100.0, 1, 3);
        }

        @Override
        public List<ReferencedEnvelope> getQueryEnvelopes() throws TransformException, FactoryException {
            if (this.renderingGeometry == null) {
                return Collections.emptyList();
            }
            if (this.simplifiedDateline.intersects((Geometry)this.renderingGeometry)) {
                ArrayList<ReferencedEnvelope> results = new ArrayList<ReferencedEnvelope>();
                Geometry difference = this.renderingGeometry.difference(this.bufferedDateline);
                List polygons = PolygonExtracter.getPolygons((Geometry)difference);
                for (Polygon p : polygons) {
                    Geometry transformed = JTS.transform((Geometry)p, CRS.findMathTransform((CoordinateReferenceSystem)this.renderingEnvelope.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.sourceCRS));
                    Envelope envelope = this.getFullEnvelope(transformed);
                    results.add(new ReferencedEnvelope(envelope, this.sourceCRS));
                }
                this.mergeEnvelopes(results);
                return results;
            }
            if (this.renderingGeometryReduced) {
                MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)this.renderingEnvelope.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.sourceCRS);
                Geometry transformed = JTS.transform((Geometry)this.renderingGeometry, mt);
                Envelope envelope = this.getFullEnvelope(transformed);
                ReferencedEnvelope re = new ReferencedEnvelope(envelope, this.sourceCRS);
                return Collections.singletonList(re);
            }
            return super.getQueryEnvelopes();
        }

        private Envelope getFullEnvelope(Geometry transformed) {
            final Envelope envelope = transformed.getEnvelopeInternal();
            transformed.apply(new GeometryComponentFilter(){

                public void filter(Geometry geom) {
                    envelope.expandToInclude(geom.getEnvelopeInternal());
                }
            });
            return envelope;
        }

        public boolean checkRenderingWithinRadius(Point2D.Double center, double radius) {
            boolean renderingWithinRadius = true;
            double radiusSquared = radius * radius;
            for (int i = 0; i < 4; ++i) {
                double y;
                double x;
                switch (i) {
                    case 0: {
                        x = this.renderingEnvelope.getMinX();
                        y = this.renderingEnvelope.getMinY();
                        break;
                    }
                    case 1: {
                        x = this.renderingEnvelope.getMinX();
                        y = this.renderingEnvelope.getMaxY();
                        break;
                    }
                    case 2: {
                        x = this.renderingEnvelope.getMaxX();
                        y = this.renderingEnvelope.getMinY();
                        break;
                    }
                    case 3: {
                        x = this.renderingEnvelope.getMaxX();
                        y = this.renderingEnvelope.getMaxY();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                double dx = x - center.x;
                double dy = y - center.y;
                double distanceSquared = dx * dx + dy * dy;
                renderingWithinRadius &= distanceSquared < radiusSquared;
            }
            return renderingWithinRadius;
        }

        private Point2D.Double getCenter(CoordinateReferenceSystem crs) {
            MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)this.renderingEnvelope.getCoordinateReferenceSystem());
            ParameterValue<?> centralMeridian = this.getParameter(mapProjection, MapProjection.AbstractProvider.CENTRAL_MERIDIAN);
            ParameterValue<?> latitudeOfOrigin = this.getParameter(mapProjection, MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN);
            double centerLon = centralMeridian != null ? centralMeridian.doubleValue() : 0.0;
            double centerLat = latitudeOfOrigin != null ? latitudeOfOrigin.doubleValue() : 0.0;
            return new Point2D.Double(centerLon, centerLat);
        }

        private Geometry getDateLine(Point2D.Double center) {
            if (Math.abs(center.x) < 1.0E-6) {
                LineString ls1 = this.sampleDateLineBetweenLatitudes(this.gf, -90.0, center.y - 1.0E-6);
                LineString ls2 = this.sampleDateLineBetweenLatitudes(this.gf, center.y + 1.0E-6, 90.0);
                MultiLineString mls = this.gf.createMultiLineString(new LineString[]{ls1, ls2});
                return mls;
            }
            LineString ls = this.sampleDateLineBetweenLatitudes(this.gf, -90.0, 90.0);
            return ls;
        }

        private ParameterValue<?> getParameter(MapProjection mapProjection, ParameterDescriptor<?> pd) {
            ParameterValue centralMeridian = null;
            try {
                centralMeridian = mapProjection.getParameterValues().parameter(pd.getName().getCode());
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                // empty catch block
            }
            return centralMeridian;
        }

        private LineString sampleDateLineBetweenLatitudes(GeometryFactory gf, double start, double end) {
            ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
            for (double lat = start; lat < end; lat += 1.0) {
                coordinates.add(new Coordinate(180.0, lat));
                if (!(lat + 1.0 > end)) continue;
                coordinates.add(new Coordinate(180.0, end));
            }
            Coordinate[] array = coordinates.toArray(new Coordinate[coordinates.size()]);
            LineString ls = gf.createLineString(array);
            return ls;
        }

        public Polygon getAzeqProjectedExtents(double radius) {
            int POINTS = 180;
            Coordinate[] coordinates = new Coordinate[181];
            double distance = radius - 100.0;
            for (int i = 0; i < 180; ++i) {
                Coordinate c = new Coordinate();
                c.x = Math.cos(Math.toRadians(2.0 * (double)i)) * distance;
                c.y = Math.sin(Math.toRadians(2.0 * (double)i)) * distance;
                coordinates[i] = new Coordinate(c.x, c.y);
            }
            coordinates[180] = coordinates[0];
            LinearRing ring = this.gf.createLinearRing(coordinates);
            return this.gf.createPolygon(ring);
        }
    }
}

