/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.filter.AndImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.FunctionFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.IsBetweenImpl;
import org.geotools.filter.IsEqualsToImpl;
import org.geotools.filter.IsGreaterThanImpl;
import org.geotools.filter.IsGreaterThanOrEqualToImpl;
import org.geotools.filter.IsLessThenImpl;
import org.geotools.filter.IsLessThenOrEqualToImpl;
import org.geotools.filter.IsNilImpl;
import org.geotools.filter.IsNotEqualToImpl;
import org.geotools.filter.IsNullImpl;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.NativeFilterImpl;
import org.geotools.filter.NotImpl;
import org.geotools.filter.OrImpl;
import org.geotools.filter.SortByImpl;
import org.geotools.filter.capability.ArithmeticOperatorsImpl;
import org.geotools.filter.capability.ComparisonOperatorsImpl;
import org.geotools.filter.capability.FilterCapabilitiesImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.capability.FunctionsImpl;
import org.geotools.filter.capability.IdCapabilitiesImpl;
import org.geotools.filter.capability.OperatorImpl;
import org.geotools.filter.capability.ScalarCapabilitiesImpl;
import org.geotools.filter.capability.SpatialCapabiltiesImpl;
import org.geotools.filter.capability.SpatialOperatorImpl;
import org.geotools.filter.capability.SpatialOperatorsImpl;
import org.geotools.filter.capability.TemporalCapabilitiesImpl;
import org.geotools.filter.capability.TemporalOperatorImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.DivideImpl;
import org.geotools.filter.expression.MultiplyImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.identity.FeatureIdVersionedImpl;
import org.geotools.filter.identity.GmlObjectIdImpl;
import org.geotools.filter.identity.ResourceIdImpl;
import org.geotools.filter.spatial.BBOX3DImpl;
import org.geotools.filter.spatial.BBOXImpl;
import org.geotools.filter.spatial.BeyondImpl;
import org.geotools.filter.spatial.ContainsImpl;
import org.geotools.filter.spatial.CrossesImpl;
import org.geotools.filter.spatial.DWithinImpl;
import org.geotools.filter.spatial.DisjointImpl;
import org.geotools.filter.spatial.EqualsImpl;
import org.geotools.filter.spatial.IntersectsImpl;
import org.geotools.filter.spatial.OverlapsImpl;
import org.geotools.filter.spatial.TouchesImpl;
import org.geotools.filter.spatial.WithinImpl;
import org.geotools.filter.temporal.AfterImpl;
import org.geotools.filter.temporal.AnyInteractsImpl;
import org.geotools.filter.temporal.BeforeImpl;
import org.geotools.filter.temporal.BeginsImpl;
import org.geotools.filter.temporal.BegunByImpl;
import org.geotools.filter.temporal.DuringImpl;
import org.geotools.filter.temporal.EndedByImpl;
import org.geotools.filter.temporal.EndsImpl;
import org.geotools.filter.temporal.MeetsImpl;
import org.geotools.filter.temporal.MetByImpl;
import org.geotools.filter.temporal.OverlappedByImpl;
import org.geotools.filter.temporal.TContainsImpl;
import org.geotools.filter.temporal.TEqualsImpl;
import org.geotools.filter.temporal.TOverlapsImpl;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.Hints;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.NativeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.capability.ArithmeticOperators;
import org.opengis.filter.capability.ComparisonOperators;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.capability.Functions;
import org.opengis.filter.capability.GeometryOperand;
import org.opengis.filter.capability.IdCapabilities;
import org.opengis.filter.capability.Operator;
import org.opengis.filter.capability.ScalarCapabilities;
import org.opengis.filter.capability.SpatialCapabilities;
import org.opengis.filter.capability.SpatialOperator;
import org.opengis.filter.capability.SpatialOperators;
import org.opengis.filter.capability.TemporalCapabilities;
import org.opengis.filter.capability.TemporalOperator;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.GmlObjectId;
import org.opengis.filter.identity.ResourceId;
import org.opengis.filter.identity.Version;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BBOX3D;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.BoundingBox3D;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.Parameter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;
import org.xml.sax.helpers.NamespaceSupport;

public class FilterFactoryImpl
implements Factory,
FilterFactory2 {
    private FunctionFinder functionFinder = new FunctionFinder(null);

    public FilterFactoryImpl() {
        this(null);
    }

    public FilterFactoryImpl(Hints hints) {
    }

    public FeatureId featureId(String id) {
        return new FeatureIdImpl(id);
    }

    public GmlObjectId gmlObjectId(String id) {
        return new GmlObjectIdImpl(id);
    }

    public FeatureId featureId(String fid, String featureVersion) {
        return new FeatureIdVersionedImpl(fid, featureVersion);
    }

    public ResourceId resourceId(String fid, String featureVersion, Version version) {
        return new ResourceIdImpl(fid, featureVersion, version);
    }

    public ResourceId resourceId(String fid, Date startTime, Date endTime) {
        return new ResourceIdImpl(fid, startTime, endTime);
    }

    public And and(Filter f, Filter g) {
        ArrayList<Filter> list = new ArrayList<Filter>(2);
        list.add(f);
        list.add(g);
        return new AndImpl(list);
    }

    public And and(List filters) {
        return new AndImpl(filters);
    }

    public Or or(Filter f, Filter g) {
        ArrayList<Filter> list = new ArrayList<Filter>(2);
        list.add(f);
        list.add(g);
        return new OrImpl(list);
    }

    public Or or(List filters) {
        return new OrImpl(filters);
    }

    public Not not(Filter filter) {
        return new NotImpl(filter);
    }

    public Id id(Set id) {
        return new FidFilterImpl(id);
    }

    public Id id(FeatureId ... fids) {
        HashSet<FeatureId> selection = new HashSet<FeatureId>();
        for (FeatureId featureId : fids) {
            if (featureId == null) continue;
            selection.add(featureId);
        }
        return this.id(selection);
    }

    public PropertyName property(String name) {
        return new AttributeExpressionImpl(name);
    }

    public PropertyIsBetween between(Expression expr, Expression lower, Expression upper) {
        return new IsBetweenImpl(lower, expr, upper);
    }

    public PropertyIsBetween between(Expression expr, Expression lower, Expression upper, MultiValuedFilter.MatchAction matchAction) {
        return new IsBetweenImpl(lower, expr, upper, matchAction);
    }

    public PropertyIsEqualTo equals(Expression expr1, Expression expr2) {
        return this.equal(expr1, expr2, true);
    }

    public PropertyIsEqualTo equal(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsEqualsToImpl(expr1, expr2, matchCase);
    }

    public PropertyIsEqualTo equal(Expression expr1, Expression expr2, boolean matchCase, MultiValuedFilter.MatchAction matchAction) {
        return new IsEqualsToImpl(expr1, expr2, matchCase, matchAction);
    }

    public PropertyIsNotEqualTo notEqual(Expression expr1, Expression expr2) {
        return this.notEqual(expr1, expr2, false);
    }

    public PropertyIsNotEqualTo notEqual(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsNotEqualToImpl(expr1, expr2, matchCase);
    }

    public PropertyIsNotEqualTo notEqual(Expression expr1, Expression expr2, boolean matchCase, MultiValuedFilter.MatchAction matchAction) {
        return new IsNotEqualToImpl(expr1, expr2, matchCase, matchAction);
    }

    public PropertyIsGreaterThan greater(Expression expr1, Expression expr2) {
        return this.greater(expr1, expr2, false);
    }

    public PropertyIsGreaterThan greater(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsGreaterThanImpl(expr1, expr2);
    }

    public PropertyIsGreaterThan greater(Expression expr1, Expression expr2, boolean matchCase, MultiValuedFilter.MatchAction matchAction) {
        return new IsGreaterThanImpl(expr1, expr2, matchAction);
    }

    public PropertyIsGreaterThanOrEqualTo greaterOrEqual(Expression expr1, Expression expr2) {
        return this.greaterOrEqual(expr1, expr2, false);
    }

    public PropertyIsGreaterThanOrEqualTo greaterOrEqual(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsGreaterThanOrEqualToImpl(expr1, expr2, matchCase);
    }

    public PropertyIsGreaterThanOrEqualTo greaterOrEqual(Expression expr1, Expression expr2, boolean matchCase, MultiValuedFilter.MatchAction matchAction) {
        return new IsGreaterThanOrEqualToImpl(expr1, expr2, matchCase, matchAction);
    }

    public PropertyIsLessThan less(Expression expr1, Expression expr2) {
        return this.less(expr1, expr2, false);
    }

    public PropertyIsLessThan less(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsLessThenImpl(expr1, expr2, matchCase);
    }

    public PropertyIsLessThan less(Expression expr1, Expression expr2, boolean matchCase, MultiValuedFilter.MatchAction matchAction) {
        return new IsLessThenImpl(expr1, expr2, matchCase, matchAction);
    }

    public PropertyIsLessThanOrEqualTo lessOrEqual(Expression expr1, Expression expr2) {
        return this.lessOrEqual(expr1, expr2, false);
    }

    public PropertyIsLessThanOrEqualTo lessOrEqual(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsLessThenOrEqualToImpl(expr1, expr2, false);
    }

    public PropertyIsLessThanOrEqualTo lessOrEqual(Expression expr1, Expression expr2, boolean matchCase, MultiValuedFilter.MatchAction matchAction) {
        return new IsLessThenOrEqualToImpl(expr1, expr2, false, matchAction);
    }

    public PropertyIsLike like(Expression expr, String pattern) {
        return this.like(expr, pattern, "*", "?", "\\");
    }

    public PropertyIsLike like(Expression expr, String pattern, String wildcard, String singleChar, String escape) {
        return this.like(expr, pattern, wildcard, singleChar, escape, false);
    }

    public PropertyIsLike like(Expression expr, String pattern, String wildcard, String singleChar, String escape, boolean matchCase) {
        LikeFilterImpl filter = new LikeFilterImpl();
        filter.setExpression(expr);
        filter.setLiteral(pattern);
        filter.setWildCard(wildcard);
        filter.setSingleChar(singleChar);
        filter.setEscape(escape);
        filter.setMatchingCase(matchCase);
        return filter;
    }

    public PropertyIsLike like(Expression expr, String pattern, String wildcard, String singleChar, String escape, boolean matchCase, MultiValuedFilter.MatchAction matchAction) {
        LikeFilterImpl filter = new LikeFilterImpl(matchAction);
        filter.setExpression(expr);
        filter.setLiteral(pattern);
        filter.setWildCard(wildcard);
        filter.setSingleChar(singleChar);
        filter.setEscape(escape);
        filter.setMatchingCase(matchCase);
        return filter;
    }

    public PropertyIsNull isNull(Expression expr) {
        return new IsNullImpl(expr);
    }

    public PropertyIsNil isNil(Expression expr, Object nilReason) {
        return new IsNilImpl(expr, nilReason);
    }

    public BBOX bbox(String propertyName, double minx, double miny, double maxx, double maxy, String srs) {
        PropertyName name = this.property(propertyName);
        return this.bbox((Expression)name, minx, miny, maxx, maxy, srs);
    }

    public BBOX bbox(Expression geometry, Expression bounds) {
        return new BBOXImpl(geometry, bounds);
    }

    public BBOX bbox(Expression geometry, Expression bounds, MultiValuedFilter.MatchAction machAction) {
        if (bounds instanceof Literal) {
            org.locationtech.jts.geom.Geometry g;
            Object value = ((Literal)bounds).getValue();
            if (value instanceof BoundingBox3D) {
                return this.bbox(geometry, (BoundingBox3D)value, machAction);
            }
            if (value instanceof org.locationtech.jts.geom.Geometry && geometry instanceof PropertyName && (g = (org.locationtech.jts.geom.Geometry)value).getUserData() instanceof CoordinateReferenceSystem) {
                CoordinateReferenceSystem crs = (CoordinateReferenceSystem)g.getUserData();
                ReferencedEnvelope3D envelope = (ReferencedEnvelope3D)JTS.bounds(g, crs);
                return new BBOX3DImpl((PropertyName)geometry, envelope, (FilterFactory)this);
            }
        }
        return new BBOXImpl(geometry, bounds, machAction);
    }

    public BBOX bbox(Expression geometry, BoundingBox bounds) {
        if (bounds instanceof BoundingBox3D) {
            return this.bbox(geometry, (BoundingBox3D)bounds);
        }
        return this.bbox2d(geometry, bounds, MultiValuedFilter.MatchAction.ANY);
    }

    public BBOX bbox(Expression geometry, BoundingBox bounds, MultiValuedFilter.MatchAction matchAction) {
        if (bounds instanceof BoundingBox3D) {
            return this.bbox(geometry, (BoundingBox3D)bounds);
        }
        return this.bbox2d(geometry, bounds, matchAction);
    }

    private BBOXImpl bbox2d(Expression e, BoundingBox bounds, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = null;
        if (!(e instanceof PropertyName)) {
            throw new IllegalArgumentException("BBOX requires PropertyName expression");
        }
        name = (PropertyName)e;
        Literal bbox = null;
        try {
            ReferencedEnvelope env = ReferencedEnvelope.reference((Envelope)bounds);
            bbox = this.literal((Object)env);
        }
        catch (IllegalFilterException ife) {
            new IllegalArgumentException("Unable to convert to Polygon:" + bounds).initCause(ife);
        }
        return new BBOXImpl((Expression)name, (Expression)bbox, matchAction);
    }

    public BBOX bbox(String propertyName, double minx, double miny, double maxx, double maxy, String srs, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        return this.bbox((Expression)name, minx, miny, maxx, maxy, srs, matchAction);
    }

    public BBOX bbox(Expression geometry, double minx, double miny, double maxx, double maxy, String srs) {
        return this.bbox(geometry, minx, miny, maxx, maxy, srs, MultiValuedFilter.MatchAction.ANY);
    }

    public BBOX bbox(Expression e, double minx, double miny, double maxx, double maxy, String srs, MultiValuedFilter.MatchAction matchAction) {
        BBOXImpl box = null;
        try {
            CoordinateReferenceSystem crs;
            if (srs == null || srs.isEmpty()) {
                crs = null;
            } else {
                try {
                    crs = CRS.decode((String)srs);
                }
                catch (MismatchedDimensionException ex) {
                    throw new RuntimeException(ex);
                }
                catch (NoSuchAuthorityCodeException ex) {
                    crs = CRS.parseWKT((String)srs);
                }
            }
            box = this.bbox2d(e, new ReferencedEnvelope(minx, maxx, miny, maxy, crs), matchAction);
        }
        catch (FactoryException e1) {
            throw new RuntimeException("Failed to setup bbox SRS", e1);
        }
        return box;
    }

    public BBOX3D bbox(String propertyName, BoundingBox3D env) {
        return this.bbox((Expression)this.property(propertyName), env, MultiValuedFilter.MatchAction.ANY);
    }

    public BBOX3D bbox(String propertyName, BoundingBox3D env, MultiValuedFilter.MatchAction matchAction) {
        return this.bbox((Expression)this.property(propertyName), env, matchAction);
    }

    public BBOX3D bbox(Expression geometry, BoundingBox3D env) {
        return this.bbox(geometry, env, MultiValuedFilter.MatchAction.ANY);
    }

    public BBOX3D bbox(Expression e, BoundingBox3D env, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = null;
        if (!(e instanceof PropertyName)) {
            throw new IllegalArgumentException();
        }
        name = (PropertyName)e;
        return new BBOX3DImpl(name, new ReferencedEnvelope3D(env), (FilterFactory)this);
    }

    public Beyond beyond(String propertyName, Geometry geometry, double distance, String units) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.beyond((Expression)name, (Expression)geom, distance, units);
    }

    public Beyond beyond(String propertyName, Geometry geometry, double distance, String units, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.beyond((Expression)name, (Expression)geom, distance, units, matchAction);
    }

    public Beyond beyond(Expression geometry1, Expression geometry2, double distance, String units) {
        BeyondImpl beyond = new BeyondImpl(geometry1, geometry2);
        beyond.setDistance(distance);
        beyond.setUnits(units);
        return beyond;
    }

    public Beyond beyond(Expression geometry1, Expression geometry2, double distance, String units, MultiValuedFilter.MatchAction matchAction) {
        BeyondImpl beyond = new BeyondImpl(geometry1, geometry2, matchAction);
        beyond.setDistance(distance);
        beyond.setUnits(units);
        return beyond;
    }

    public Contains contains(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.contains((Expression)name, (Expression)geom);
    }

    public Contains contains(Expression geometry1, Expression geometry2) {
        return new ContainsImpl(geometry1, geometry2);
    }

    public Contains contains(Expression geometry1, Expression geometry2, MultiValuedFilter.MatchAction matchAction) {
        return new ContainsImpl(geometry1, geometry2, matchAction);
    }

    public Contains contains(String propertyName, Geometry geometry, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.contains((Expression)name, (Expression)geom, matchAction);
    }

    public Crosses crosses(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.crosses((Expression)name, (Expression)geom);
    }

    public Crosses crosses(String propertyName, Geometry geometry, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.crosses((Expression)name, (Expression)geom, matchAction);
    }

    public Crosses crosses(Expression geometry1, Expression geometry2) {
        return new CrossesImpl(geometry1, geometry2);
    }

    public Crosses crosses(Expression geometry1, Expression geometry2, MultiValuedFilter.MatchAction matchAction) {
        return new CrossesImpl(geometry1, geometry2, matchAction);
    }

    public Disjoint disjoint(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.disjoint((Expression)name, (Expression)geom);
    }

    public Disjoint disjoint(String propertyName, Geometry geometry, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.disjoint((Expression)name, (Expression)geom, matchAction);
    }

    public Disjoint disjoint(Expression geometry1, Expression geometry2, MultiValuedFilter.MatchAction matchAction) {
        return new DisjointImpl(geometry1, geometry2, matchAction);
    }

    public Disjoint disjoint(Expression geometry1, Expression geometry2) {
        return new DisjointImpl(geometry1, geometry2);
    }

    public DWithin dwithin(String propertyName, Geometry geometry, double distance, String units) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.dwithin((Expression)name, (Expression)geom, distance, units);
    }

    public DWithin dwithin(String propertyName, Geometry geometry, double distance, String units, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.dwithin((Expression)name, (Expression)geom, distance, units, matchAction);
    }

    public DWithin dwithin(Expression geometry1, Expression geometry2, double distance, String units, MultiValuedFilter.MatchAction matchAction) {
        DWithinImpl dwithin = new DWithinImpl(geometry1, geometry2, matchAction);
        dwithin.setDistance(distance);
        dwithin.setUnits(units);
        return dwithin;
    }

    public DWithin dwithin(Expression geometry1, Expression geometry2, double distance, String units) {
        DWithinImpl dwithin = new DWithinImpl(geometry1, geometry2);
        dwithin.setDistance(distance);
        dwithin.setUnits(units);
        return dwithin;
    }

    public Equals equals(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.equal((Expression)name, (Expression)geom);
    }

    public Equals equals(String propertyName, Geometry geometry, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.equal((Expression)name, (Expression)geom, matchAction);
    }

    public Equals equal(Expression geometry1, Expression geometry2) {
        return new EqualsImpl(geometry1, geometry2);
    }

    public Equals equal(Expression geometry1, Expression geometry2, MultiValuedFilter.MatchAction matchAction) {
        return new EqualsImpl(geometry1, geometry2, matchAction);
    }

    public Intersects intersects(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.intersects((Expression)name, (Expression)geom);
    }

    public Intersects intersects(String propertyName, Geometry geometry, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.intersects((Expression)name, (Expression)geom, matchAction);
    }

    public Intersects intersects(Expression geometry1, Expression geometry2) {
        return new IntersectsImpl(geometry1, geometry2);
    }

    public Intersects intersects(Expression geometry1, Expression geometry2, MultiValuedFilter.MatchAction matchAction) {
        return new IntersectsImpl(geometry1, geometry2, matchAction);
    }

    public Overlaps overlaps(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.overlaps((Expression)name, (Expression)geom);
    }

    public Overlaps overlaps(String propertyName, Geometry geometry, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.overlaps((Expression)name, (Expression)geom, matchAction);
    }

    public Overlaps overlaps(Expression geometry1, Expression geometry2) {
        return new OverlapsImpl(geometry1, geometry2);
    }

    public Overlaps overlaps(Expression geometry1, Expression geometry2, MultiValuedFilter.MatchAction matchAction) {
        return new OverlapsImpl(geometry1, geometry2, matchAction);
    }

    public Touches touches(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.touches((Expression)name, (Expression)geom);
    }

    public Touches touches(String propertyName, Geometry geometry, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.touches((Expression)name, (Expression)geom, matchAction);
    }

    public Touches touches(Expression geometry1, Expression geometry2) {
        return new TouchesImpl(geometry1, geometry2);
    }

    public Touches touches(Expression geometry1, Expression geometry2, MultiValuedFilter.MatchAction matchAction) {
        return new TouchesImpl(geometry1, geometry2, matchAction);
    }

    public Within within(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.within((Expression)name, (Expression)geom);
    }

    public Within within(String propertyName, Geometry geometry, MultiValuedFilter.MatchAction matchAction) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.within((Expression)name, (Expression)geom, matchAction);
    }

    public Within within(Expression geometry1, Expression geometry2) {
        return new WithinImpl(geometry1, geometry2);
    }

    public Within within(Expression geometry1, Expression geometry2, MultiValuedFilter.MatchAction matchAction) {
        return new WithinImpl(geometry1, geometry2, matchAction);
    }

    public Add add(Expression expr1, Expression expr2) {
        return new AddImpl(expr1, expr2);
    }

    public Divide divide(Expression expr1, Expression expr2) {
        return new DivideImpl(expr1, expr2);
    }

    public Multiply multiply(Expression expr1, Expression expr2) {
        return new MultiplyImpl(expr1, expr2);
    }

    public Subtract subtract(Expression expr1, Expression expr2) {
        return new SubtractImpl(expr1, expr2);
    }

    public Function function(String name, Expression[] args) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(args));
        return function;
    }

    public Function function(Name name, Expression ... args) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(args));
        return function;
    }

    public Function function(String name, Expression arg1) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(arg1));
        return function;
    }

    public Function function(String name, Expression arg1, Expression arg2) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(arg1, arg2));
        return function;
    }

    public Function function(String name, Expression arg1, Expression arg2, Expression arg3) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(arg1, arg2, arg3));
        return function;
    }

    public Literal literal(Object obj) {
        try {
            return new LiteralExpressionImpl(obj);
        }
        catch (IllegalFilterException e) {
            new IllegalArgumentException().initCause(e);
            return null;
        }
    }

    public Literal literal(byte b) {
        return new LiteralExpressionImpl(b);
    }

    public Literal literal(short s) {
        return new LiteralExpressionImpl(s);
    }

    public Literal literal(int i) {
        return new LiteralExpressionImpl(i);
    }

    public Literal literal(long l) {
        return new LiteralExpressionImpl(l);
    }

    public Literal literal(float f) {
        return new LiteralExpressionImpl(f);
    }

    public Literal literal(double d) {
        return new LiteralExpressionImpl(d);
    }

    public Literal literal(char c) {
        return new LiteralExpressionImpl(c);
    }

    public Literal literal(boolean b) {
        return b ? new LiteralExpressionImpl(Boolean.TRUE) : new LiteralExpressionImpl(Boolean.FALSE);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public SortBy sort(String propertyName, SortOrder order) {
        return new SortByImpl(this.property(propertyName), order);
    }

    public After after(Expression expr1, Expression expr2) {
        return new AfterImpl(expr1, expr2);
    }

    public After after(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new AfterImpl(expr1, expr2, matchAction);
    }

    public AnyInteracts anyInteracts(Expression expr1, Expression expr2) {
        return new AnyInteractsImpl(expr1, expr2);
    }

    public AnyInteracts anyInteracts(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new AnyInteractsImpl(expr1, expr2, matchAction);
    }

    public Before before(Expression expr1, Expression expr2) {
        return new BeforeImpl(expr1, expr2);
    }

    public Before before(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new BeforeImpl(expr1, expr2, matchAction);
    }

    public Begins begins(Expression expr1, Expression expr2) {
        return new BeginsImpl(expr1, expr2);
    }

    public Begins begins(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new BeginsImpl(expr1, expr2, matchAction);
    }

    public BegunBy begunBy(Expression expr1, Expression expr2) {
        return new BegunByImpl(expr1, expr2);
    }

    public BegunBy begunBy(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new BegunByImpl(expr1, expr2, matchAction);
    }

    public During during(Expression expr1, Expression expr2) {
        return new DuringImpl(expr1, expr2);
    }

    public During during(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new DuringImpl(expr1, expr2, matchAction);
    }

    public EndedBy endedBy(Expression expr1, Expression expr2) {
        return new EndedByImpl(expr1, expr2);
    }

    public EndedBy endedBy(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new EndedByImpl(expr1, expr2, matchAction);
    }

    public Ends ends(Expression expr1, Expression expr2) {
        return new EndsImpl(expr1, expr2);
    }

    public Ends ends(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new EndsImpl(expr1, expr2, matchAction);
    }

    public Meets meets(Expression expr1, Expression expr2) {
        return new MeetsImpl(expr1, expr2);
    }

    public Meets meets(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new MeetsImpl(expr1, expr2, matchAction);
    }

    public MetBy metBy(Expression expr1, Expression expr2) {
        return new MetByImpl(expr1, expr2);
    }

    public MetBy metBy(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new MetByImpl(expr1, expr2, matchAction);
    }

    public OverlappedBy overlappedBy(Expression expr1, Expression expr2) {
        return new OverlappedByImpl(expr1, expr2);
    }

    public OverlappedBy overlappedBy(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new OverlappedByImpl(expr1, expr2, matchAction);
    }

    public TContains tcontains(Expression expr1, Expression expr2) {
        return new TContainsImpl(expr1, expr2);
    }

    public TContains tcontains(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new TContainsImpl(expr1, expr2, matchAction);
    }

    public TEquals tequals(Expression expr1, Expression expr2) {
        return new TEqualsImpl(expr1, expr2);
    }

    public TEquals tequals(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new TEqualsImpl(expr1, expr2, matchAction);
    }

    public TOverlaps toverlaps(Expression expr1, Expression expr2) {
        return new TOverlapsImpl(expr1, expr2);
    }

    public TOverlaps toverlaps(Expression expr1, Expression expr2, MultiValuedFilter.MatchAction matchAction) {
        return new TOverlapsImpl(expr1, expr2, matchAction);
    }

    public Beyond beyond(Expression geometry1, Geometry geometry2, double distance, String units) {
        return this.beyond(geometry1, (Expression)this.literal(geometry2), distance, units);
    }

    public PropertyName property(Name name) {
        return new AttributeExpressionImpl(name);
    }

    public PropertyName property(String name, NamespaceSupport namespaceContext) {
        if (namespaceContext == null) {
            return this.property(name);
        }
        return new AttributeExpressionImpl(name, namespaceContext);
    }

    public Within within(Expression geometry1, Geometry geometry2) {
        return this.within(geometry1, (Expression)this.literal(geometry2));
    }

    public Operator operator(String name) {
        return new OperatorImpl(name);
    }

    public SpatialOperator spatialOperator(String name, GeometryOperand[] geometryOperands) {
        return new SpatialOperatorImpl(name, geometryOperands);
    }

    public TemporalOperator temporalOperator(String name) {
        return new TemporalOperatorImpl(name);
    }

    public <T> Parameter<T> parameter(String name, Class<T> type, InternationalString title, InternationalString description, boolean required, int minOccurs, int maxOccurs, T defaultValue) {
        return new org.geotools.data.Parameter<T>(name, type, title, description, required, minOccurs, maxOccurs, defaultValue, null);
    }

    public FunctionName functionName(String name, int nargs) {
        return new FunctionNameImpl(name, nargs);
    }

    public FunctionName functionName(Name name, int nargs) {
        return new FunctionNameImpl(name, nargs);
    }

    public FunctionName functionName(String name, int nargs, List<String> argNames) {
        return new FunctionNameImpl(name, nargs, argNames);
    }

    public FunctionName functionName(Name name, int nargs, List<String> argNames) {
        return new FunctionNameImpl(name, nargs, argNames);
    }

    public FunctionName functionName(String name, List<Parameter<?>> args, Parameter<?> ret) {
        return new FunctionNameImpl(name, ret, args);
    }

    public FunctionName functionName(Name name, List<Parameter<?>> args, Parameter<?> ret) {
        return new FunctionNameImpl(name, ret, args);
    }

    public Functions functions(FunctionName[] functionNames) {
        return new FunctionsImpl(functionNames);
    }

    public SpatialOperators spatialOperators(SpatialOperator[] spatialOperators) {
        return new SpatialOperatorsImpl(spatialOperators);
    }

    public ArithmeticOperators arithmeticOperators(boolean simple, Functions functions) {
        return new ArithmeticOperatorsImpl(simple, functions);
    }

    public ComparisonOperators comparisonOperators(Operator[] comparisonOperators) {
        return new ComparisonOperatorsImpl(comparisonOperators);
    }

    public FilterCapabilities capabilities(String version, ScalarCapabilities scalar, SpatialCapabilities spatial, IdCapabilities id) {
        return new FilterCapabilitiesImpl(version, scalar, spatial, id);
    }

    public FilterCapabilities capabilities(String version, ScalarCapabilities scalar, SpatialCapabilities spatial, IdCapabilities id, TemporalCapabilities temporal) {
        return new FilterCapabilitiesImpl(version, scalar, spatial, id, temporal);
    }

    public ScalarCapabilities scalarCapabilities(ComparisonOperators comparison, ArithmeticOperators arithmetic, boolean logicalOperators) {
        return new ScalarCapabilitiesImpl(comparison, arithmetic, logicalOperators);
    }

    public SpatialCapabilities spatialCapabilities(GeometryOperand[] geometryOperands, SpatialOperators spatial) {
        return new SpatialCapabiltiesImpl(geometryOperands, spatial);
    }

    public IdCapabilities idCapabilities(boolean eid, boolean fid) {
        return new IdCapabilitiesImpl(eid, fid);
    }

    public TemporalCapabilities temporalCapabilities(TemporalOperator[] temporalOperators) {
        return new TemporalCapabilitiesImpl(Arrays.asList(temporalOperators));
    }

    public NativeFilter nativeFilter(String nativeFilter) {
        return new NativeFilterImpl(nativeFilter);
    }
}

