/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Collection;
import org.geotools.api.feature.Association;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureFactory;
import org.geotools.api.feature.GeometryAttribute;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AssociationDescriptor;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.api.referencing.crs.CRSFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AssociationImpl;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.simple.SimpleFeatureImpl;

public abstract class AbstractFeatureFactoryImpl
implements FeatureFactory {
    CRSFactory crsFactory;
    public FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    boolean validating = false;

    public CRSFactory getCRSFactory() {
        return this.crsFactory;
    }

    public void setCRSFactory(CRSFactory crsFactory) {
        this.crsFactory = crsFactory;
    }

    public Association createAssociation(Attribute related, AssociationDescriptor descriptor) {
        return new AssociationImpl(related, descriptor);
    }

    public Attribute createAttribute(Object value, AttributeDescriptor descriptor, String id) {
        return new AttributeImpl(value, descriptor, (Identifier)(id == null ? null : this.ff.gmlObjectId(id)));
    }

    public GeometryAttribute createGeometryAttribute(Object value, GeometryDescriptor descriptor, String id, CoordinateReferenceSystem crs) {
        return new GeometryAttributeImpl(value, descriptor, (Identifier)(id == null ? null : this.ff.gmlObjectId(id)));
    }

    public ComplexAttribute createComplexAttribute(Collection<Property> value, AttributeDescriptor descriptor, String id) {
        return new ComplexAttributeImpl(value, descriptor, (Identifier)(id == null ? null : this.ff.gmlObjectId(id)));
    }

    public ComplexAttribute createComplexAttribute(Collection<Property> value, ComplexType type, String id) {
        return new ComplexAttributeImpl(value, type, (Identifier)(id == null ? null : this.ff.gmlObjectId(id)));
    }

    public Feature createFeature(Collection<Property> value, AttributeDescriptor descriptor, String id) {
        return new FeatureImpl(value, descriptor, this.ff.featureId(id));
    }

    public Feature createFeature(Collection<Property> value, FeatureType type, String id) {
        return new FeatureImpl(value, type, this.ff.featureId(id));
    }

    public SimpleFeature createSimpleFeature(Object[] array, SimpleFeatureType type, String id) {
        if (type.isAbstract()) {
            throw new IllegalArgumentException("Cannot create an feature of an abstract FeatureType " + type.getTypeName());
        }
        return new SimpleFeatureImpl(array, type, this.ff.featureId(id), this.validating);
    }

    public SimpleFeature createSimpleFeautre(Object[] array, AttributeDescriptor descriptor, String id) {
        return this.createSimpleFeature(array, (SimpleFeatureType)descriptor, id);
    }
}

