/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.regex.Pattern;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;

public class FilterFunction_listMultiply
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("listMultiply", String.class, FunctionNameImpl.parameter("factor", Number.class), FunctionNameImpl.parameter("list", String.class));
    private static final Pattern WHITE_SPACE_SPLIT = Pattern.compile("\\s+");

    public FilterFunction_listMultiply() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        String arg1;
        Number arg0;
        try {
            Object o = this.getExpression(0).evaluate(feature);
            arg0 = o instanceof String ? (Number)Double.valueOf((String)o) : (Number)((Number)o);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function listMultiply argument #0 - expected type Double (" + e.getMessage() + ")");
        }
        try {
            Expression exprArg1 = this.getExpression(1);
            if (exprArg1 == null) {
                return null;
            }
            Object data = exprArg1.evaluate(feature);
            if (data instanceof Number) {
                return ((Number)data).doubleValue() * arg0.doubleValue();
            }
            arg1 = (String)data;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function listMultiply argument #1 - expected type String (" + e.getMessage() + ")");
        }
        if (arg1 == null || arg1.isEmpty()) {
            return null;
        }
        String[] values = WHITE_SPACE_SPLIT.split(arg1);
        StringBuilder b = new StringBuilder();
        for (String value : values) {
            if ("".equals(value)) continue;
            if (b.length() != 0) {
                b.append(" ");
            }
            b.append(Double.valueOf(value) * arg0.doubleValue());
        }
        return b.toString();
    }
}

