/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.geotools.api.temporal.CalendarDate;
import org.geotools.api.temporal.DateAndTime;
import org.geotools.api.temporal.JulianDate;
import org.geotools.api.temporal.OrdinalPosition;
import org.geotools.api.temporal.Position;
import org.geotools.api.temporal.TemporalCoordinate;
import org.geotools.api.temporal.TemporalPosition;
import org.geotools.api.util.InternationalString;
import org.geotools.temporal.object.DefaultJulianDate;
import org.geotools.temporal.object.Utils;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;

public class DefaultPosition
implements Position {
    private final Object position;

    public DefaultPosition(Date date) {
        this.position = date;
    }

    public DefaultPosition(InternationalString datetime) throws ParseException {
        this.position = Utils.getDateFromString(datetime.toString());
    }

    public DefaultPosition(TemporalPosition anyOther) {
        this.position = anyOther;
    }

    public TemporalPosition anyOther() {
        return this.position instanceof TemporalPosition ? (TemporalPosition)this.position : null;
    }

    public Date getDate() {
        if (this.position instanceof Date) {
            return (Date)this.position;
        }
        if (this.position instanceof TemporalPosition) {
            if (this.position instanceof JulianDate) {
                return Utils.JulianToDate((DefaultJulianDate)this.position);
            }
            if (this.position instanceof DateAndTime) {
                return Utils.dateAndTimeToDate((DateAndTime)this.position);
            }
            if (this.position instanceof CalendarDate) {
                return Utils.calendarDateToDate((CalendarDate)this.position);
            }
            if (this.position instanceof TemporalCoordinate) {
                return Utils.temporalCoordToDate((TemporalCoordinate)this.position);
            }
            if (this.position instanceof OrdinalPosition) {
                return Utils.ordinalToDate((OrdinalPosition)this.position);
            }
        }
        return null;
    }

    public Time getTime() {
        return this.position instanceof Time ? (Time)this.position : null;
    }

    public InternationalString getDateTime() {
        if (this.position instanceof Date) {
            String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            return new SimpleInternationalString(dateFormat.format(this.position));
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultPosition) {
            DefaultPosition that = (DefaultPosition)object;
            return Utilities.equals((Object)this.position, (Object)that.position);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.position != null ? this.position.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "Position{" + this.position + "}";
    }
}

