/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.legend;

import java.awt.Color;
import javax.swing.Icon;
import org.geotools.legend.GlyphFactory;
import org.geotools.map.MapLayer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class DefaultGlyphFactory
implements GlyphFactory {
    @Override
    public Icon icon(MapLayer layer) {
        if (layer == null || layer.getFeatureSource() == null) {
            return this.geometry(null, null);
        }
        FeatureType schema = layer.getFeatureSource().getSchema();
        if ("GridCoverage".equals(schema.getName().getLocalPart())) {
            return this.grid(Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW);
        }
        Rule rule = SLD.rules((Style)layer.getStyle())[0];
        Class binding = schema.getBinding();
        if (this.isPolygon(binding)) {
            return this.polygon(rule);
        }
        if (this.isLine(binding)) {
            return this.line(rule);
        }
        if (this.isPoint(binding)) {
            return this.point(rule);
        }
        return this.geometry(rule);
    }

    private boolean isPolygon(Class<?> type) {
        return type == Polygon.class || type == MultiPolygon.class;
    }

    private boolean isPoint(Class<?> type) {
        return true;
    }

    private boolean isLine(Class<?> type) {
        return true;
    }

    private boolean isGeometry(Class<?> type) {
        return this.isPolygon(type) || this.isPoint(type) || this.isLine(type);
    }

    @Override
    public Icon polygon(Rule rule) {
        return null;
    }

    @Override
    public Icon geometry(Color color, Color fill) {
        return null;
    }

    @Override
    public Icon geometry(Rule rule) {
        return null;
    }

    @Override
    public Icon grid(Color color1, Color color2, Color color3, Color color4) {
        return null;
    }

    @Override
    public Icon icon(SimpleFeatureType schema) {
        return null;
    }

    @Override
    public Icon line(Color line, int width) {
        return null;
    }

    @Override
    public Icon line(Rule rule) {
        return null;
    }

    @Override
    public Icon palette(Color[] colors) {
        return null;
    }

    @Override
    public Icon point(Color point, Color fill) {
        return null;
    }

    @Override
    public Icon point(Rule rule) {
        return null;
    }

    @Override
    public Icon polygon(Color color, Color fill, int width) {
        return null;
    }

    @Override
    public Icon swatch(Color color) {
        return null;
    }
}

