/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.composite.BlendComposite;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.geotools.renderer.lite.gridcoverage2d.ChannelSelectionUpdateStyleVisitor;
import org.geotools.renderer.lite.gridcoverage2d.Compositing;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageReaderHelper;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.GridGeometryReducer;
import org.geotools.renderer.lite.gridcoverage2d.PolygonExtractor;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.algorithm.match.HausdorffSimilarityMeasure;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.style.ContrastEnhancement;

public final class GridCoverageRenderer {
    private static final double EPS = 1.0E-6;
    private static final Logger LOGGER = Logging.getLogger(GridCoverageRenderer.class);
    private static final AffineTransform IDENTITY = AffineTransform2D.getTranslateInstance((double)0.0, (double)0.0);
    private static boolean DEBUG = Boolean.getBoolean("org.geotools.renderer.lite.gridcoverage2d.debug");
    private static String DUMP_DIRECTORY;
    private final CoordinateReferenceSystem destinationCRS;
    private final GeneralEnvelope destinationEnvelope;
    private final Rectangle destinationSize;
    private final AffineTransform finalGridToWorld;
    private final AffineTransform finalWorldToGrid;
    private Hints hints = new Hints();
    private Interpolation interpolation = new InterpolationNearest();
    private final GridCoverageFactory gridCoverageFactory;
    private boolean wrapEnabled = true;
    private boolean advancedProjectionHandlingEnabled = true;
    public static final String PARENT_COVERAGE_PROPERTY = "ParentCoverage";
    public static final Hints.Key PADDING;
    public static final String KEY_COMPOSITING = "Compositing";

    public void setWrapEnabled(boolean wrapEnabled) {
        this.wrapEnabled = wrapEnabled;
    }

    public boolean isWrapEnabled() {
        return this.wrapEnabled;
    }

    public void setAdvancedProjectionHandlingEnabled(boolean enabled) {
        this.advancedProjectionHandlingEnabled = enabled;
    }

    public boolean isAdvancedProjectionHandlingEnabled() {
        return this.advancedProjectionHandlingEnabled;
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, org.locationtech.jts.geom.Envelope envelope, Rectangle screenSize, AffineTransform worldToScreen) throws TransformException, NoninvertibleTransformException {
        this(destinationCRS, envelope, screenSize, worldToScreen, null);
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, org.locationtech.jts.geom.Envelope envelope, Rectangle screenSize, AffineTransform worldToScreen, RenderingHints newHints) throws TransformException, NoninvertibleTransformException {
        this.destinationSize = screenSize;
        this.destinationCRS = destinationCRS;
        if (this.destinationCRS == null) {
            throw new TransformException(Errors.format((int)31, (Object)this.destinationCRS));
        }
        this.destinationEnvelope = new GeneralEnvelope((Envelope)new ReferencedEnvelope(envelope, this.destinationCRS));
        if (worldToScreen != null && XAffineTransform.getRotation((AffineTransform)worldToScreen) != 0.0) {
            this.finalWorldToGrid = new AffineTransform(worldToScreen);
            this.finalGridToWorld = this.finalWorldToGrid.createInverse();
        } else {
            GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper();
            gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
            gridToEnvelopeMapper.setGridRange((GridEnvelope)new GridEnvelope2D(this.destinationSize));
            gridToEnvelopeMapper.setEnvelope((Envelope)this.destinationEnvelope);
            this.finalGridToWorld = new AffineTransform(gridToEnvelopeMapper.createAffineTransform());
            this.finalWorldToGrid = this.finalGridToWorld.createInverse();
        }
        if (newHints != null) {
            this.hints.add(newHints);
        }
        this.gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        if (this.hints.containsKey((Object)JAI.KEY_INTERPOLATION)) {
            this.interpolation = (Interpolation)newHints.get(JAI.KEY_INTERPOLATION);
        } else {
            this.hints.add(new RenderingHints(JAI.KEY_INTERPOLATION, this.interpolation));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Rendering using interpolation " + this.interpolation);
        }
        this.setInterpolationHints();
        if (this.hints.containsKey((Object)JAI.KEY_IMAGE_LAYOUT)) {
            ImageLayout layout = (ImageLayout)this.hints.get((Object)JAI.KEY_IMAGE_LAYOUT);
            layout.unsetImageBounds();
            layout.unsetValid(0);
        }
        this.hints.put((Object)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        this.hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
    }

    private void setInterpolationHints() {
        if (this.interpolation instanceof InterpolationNearest) {
            this.hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
            this.hints.add(new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.TRUE));
        } else {
            this.hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE));
            this.hints.add(new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE));
        }
    }

    static void writeRenderedImage(RenderedImage raster, String fileName) {
        if (DUMP_DIRECTORY == null) {
            throw new NullPointerException("Unable to write the provided coverage in the debug directory");
        }
        if (!DEBUG) {
            throw new IllegalStateException("Unable to write the provided coverage since we are not in debug mode");
        }
        try {
            ImageIO.write(raster, "tiff", new File(DUMP_DIRECTORY, fileName + ".tiff"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public RenderedImage renderImage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, double[] bkgValues) throws Exception {
        GridCoverage2D symbolizerGC = this.renderCoverage(gridCoverage, symbolizer, bkgValues);
        return this.getImageFromParentCoverage(symbolizerGC);
    }

    private GridCoverage2D renderCoverage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, double[] bkgValues) throws FactoryException {
        GridCoverage2D preReprojection;
        GridCoverageRendererUtilities.ensureNotNull(gridCoverage, "gridCoverage");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Drawing coverage " + gridCoverage.toString());
        }
        boolean doReprojection = false;
        CoordinateReferenceSystem coverageCRS = gridCoverage.getCoordinateReferenceSystem2D();
        if (!CRS.equalsIgnoreMetadata((Object)coverageCRS, (Object)this.destinationCRS)) {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)coverageCRS, (CoordinateReferenceSystem)this.destinationCRS, (boolean)true);
            boolean bl = doReprojection = !transform.isIdentity();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Reproject needed for rendering provided coverage");
            }
        }
        if ((preReprojection = this.crop(gridCoverage, this.destinationEnvelope, doReprojection, bkgValues)) == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Skipping current coverage because crop failed");
            }
            return null;
        }
        GridCoverage2D afterReprojection = this.reproject(preReprojection, doReprojection, bkgValues);
        return this.symbolize(afterReprojection, symbolizer, bkgValues);
    }

    private GridCoverage2D symbolize(GridCoverage2D coverage, RasterSymbolizer symbolizer, double[] bkgValues) {
        GridCoverage2D symbolizerGC;
        GridCoverage2D preSymbolizer = this.affine(coverage, bkgValues, symbolizer);
        if (preSymbolizer == null) {
            return null;
        }
        GridCoverage2D sanitized = preSymbolizer;
        RenderedImage preSymbolizerImage = preSymbolizer.getRenderedImage();
        RenderedImage preAffineImage = coverage.getRenderedImage();
        if (preSymbolizerImage.getWidth() > preAffineImage.getWidth() * 2 || preSymbolizerImage.getHeight() > preAffineImage.getHeight() * 2) {
            sanitized = this.crop(preSymbolizer, this.destinationEnvelope, false, bkgValues);
        }
        if (symbolizer != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Applying Raster Symbolizer ");
            }
            RasterSymbolizerHelper rsp = new RasterSymbolizerHelper(sanitized, this.hints);
            rsp.visit(symbolizer);
            symbolizerGC = (GridCoverage2D)rsp.getOutput();
            symbolizerGC = this.lookForCompositing(symbolizerGC);
        } else {
            symbolizerGC = preSymbolizer;
        }
        if (DEBUG) {
            GridCoverageRenderer.writeRenderedImage(symbolizerGC.getRenderedImage(), "postSymbolizer");
        }
        return symbolizerGC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCoverage2D reproject(GridCoverage2D preResample, boolean doReprojection, double[] bkgValues) throws FactoryException {
        GridCoverage2D afterReprojection = null;
        try {
            if (doReprojection) {
                preResample = this.addRoiIfMissing(preResample);
                afterReprojection = GridCoverageRendererUtilities.reproject(preResample, this.destinationCRS, this.interpolation, this.destinationEnvelope, bkgValues, this.hints);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Reprojecting to crs " + this.destinationCRS.toString());
                }
            } else {
                afterReprojection = preResample;
            }
            GridCoverage2D gridCoverage2D = afterReprojection;
            return gridCoverage2D;
        }
        finally {
            if (DEBUG && afterReprojection != null) {
                GridCoverageRenderer.writeRenderedImage(afterReprojection.getRenderedImage(), "afterReprojection");
            }
        }
    }

    private GridCoverage2D crop(GridCoverage2D inputCoverage, GeneralEnvelope destinationEnvelope, boolean doReprojection, double[] backgroundValues) {
        GridCoverage2D outputCoverage = inputCoverage;
        GeneralEnvelope coverageEnvelope = (GeneralEnvelope)inputCoverage.getEnvelope();
        CoordinateReferenceSystem coverageCRS = inputCoverage.getCoordinateReferenceSystem2D();
        try {
            GeneralEnvelope renderingEnvelopeInCoverageCRS = null;
            renderingEnvelopeInCoverageCRS = doReprojection ? GridCoverageRendererUtilities.reprojectEnvelopeWithWGS84Pivot(destinationEnvelope, coverageCRS) : new GeneralEnvelope((Envelope)destinationEnvelope);
            GeneralEnvelope cropEnvelope = new GeneralEnvelope((Envelope)renderingEnvelopeInCoverageCRS);
            cropEnvelope.intersect((Envelope)coverageEnvelope);
            if (cropEnvelope.isEmpty() || cropEnvelope.isNull()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("The destination envelope does not intersect the envelope of the source coverage.");
                }
                return null;
            }
            outputCoverage = GridCoverageRendererUtilities.crop(inputCoverage, cropEnvelope, backgroundValues, this.hints);
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Crop Failed for reason: " + t.getLocalizedMessage(), t);
            }
            outputCoverage = inputCoverage;
        }
        if (DEBUG) {
            GridCoverageRenderer.writeRenderedImage(outputCoverage.getRenderedImage(), "crop");
        }
        return outputCoverage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GridCoverage2D affine(GridCoverage2D input, double[] bkgValues, RasterSymbolizer symbolizer) {
        RenderedImage im;
        ROI roi;
        Range noData;
        block9: {
            RenderedImage finalImage = input.getRenderedImage();
            GridGeometry2D preSymbolizerGridGeometry = input.getGridGeometry();
            MathTransform2D finalGCTransform = preSymbolizerGridGeometry.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
            if (!(finalGCTransform instanceof AffineTransform)) {
                throw new UnsupportedOperationException("Non-affine transformations not yet implemented");
            }
            AffineTransform finalGCgridToWorld = new AffineTransform((AffineTransform)finalGCTransform);
            noData = CoverageUtilities.getNoDataProperty((GridCoverage2D)input) != null ? CoverageUtilities.getNoDataProperty((GridCoverage2D)input).getAsRange() : null;
            roi = CoverageUtilities.getROIProperty((GridCoverage2D)input);
            AffineTransform finalRasterTransformation = (AffineTransform)this.finalWorldToGrid.clone();
            finalRasterTransformation.concatenate(finalGCgridToWorld);
            Rectangle2D finalLayout = GridCoverageRendererUtilities.layoutHelper(finalImage, (float)Math.abs(finalRasterTransformation.getScaleX()), (float)Math.abs(finalRasterTransformation.getScaleY()), (float)finalRasterTransformation.getTranslateX(), (float)finalRasterTransformation.getTranslateY(), this.interpolation);
            if (finalLayout.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Unable to create a granuleDescriptor " + this.toString() + " due to jai scale bug");
                }
                return null;
            }
            im = null;
            try {
                Hints localHints = new Hints();
                localHints.putAll((Map)this.hints);
                if (symbolizer != null && symbolizer.getColorMap() != null) {
                    localHints.put((Object)JAI.KEY_REPLACE_INDEX_COLOR_MODEL, (Object)false);
                }
                ImageWorker iw = new ImageWorker(finalImage);
                iw.setRenderingHints((RenderingHints)localHints);
                iw.setROI(roi);
                iw.setNoData(noData);
                iw.affine(finalRasterTransformation, this.interpolation, bkgValues);
                im = iw.getRenderedImage();
                roi = iw.getROI();
                noData = iw.extractNoDataProperty(im);
                if (!DEBUG) break block9;
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    GridCoverageRenderer.writeRenderedImage(im, "postAffine");
                }
                throw throwable;
            }
            GridCoverageRenderer.writeRenderedImage(im, "postAffine");
        }
        int numBands = im.getSampleModel().getNumBands();
        GridSampleDimension[] sd = new GridSampleDimension[numBands];
        for (int i = 0; i < numBands; ++i) {
            sd[i] = new GridSampleDimension((CharSequence)TypeMap.getColorInterpretation((ColorModel)im.getColorModel(), (int)i).name());
        }
        HashMap properties = input.getProperties();
        if (properties == null) {
            properties = new HashMap();
        }
        CoverageUtilities.setNoDataProperty((Map)properties, (Object)noData);
        CoverageUtilities.setROIProperty(properties, (ROI)roi);
        return this.gridCoverageFactory.create((CharSequence)input.getName(), im, new GridGeometry2D((GridEnvelope)new GridEnvelope2D(PlanarImage.wrapRenderedImage((RenderedImage)im).getBounds()), input.getEnvelope()), sd, new GridCoverage[]{input}, properties);
    }

    public RenderedImage renderImage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, Interpolation interpolation, Color background, int tileSizeX, int tileSizeY) throws FactoryException, TransformException, NoninvertibleTransformException {
        GridCoverage2D coverage = this.renderCoverage(gridCoverage, symbolizer, interpolation, background, tileSizeX, tileSizeY);
        return this.getImageFromParentCoverage(coverage);
    }

    private GridCoverage2D renderCoverage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, Interpolation interpolation, Color background, int tileSizeX, int tileSizeY) throws FactoryException {
        Hints oldHints = this.hints.clone();
        this.setupTilingHints(tileSizeX, tileSizeY);
        this.setupInterpolationHints(interpolation);
        try {
            GridCoverage2D gridCoverage2D = this.renderCoverage(gridCoverage, symbolizer, GridCoverageRendererUtilities.colorToArray(background));
            return gridCoverage2D;
        }
        catch (Exception e) {
            throw new FactoryException(e);
        }
        finally {
            this.hints = oldHints;
        }
    }

    private RenderedImage getImageFromParentCoverage(GridCoverage2D parentCoverage) {
        if (parentCoverage == null) {
            return null;
        }
        RenderedImage ri = parentCoverage.getRenderedImage();
        if (ri != null) {
            PlanarImage pi = PlanarImage.wrapRenderedImage((RenderedImage)ri);
            pi.setProperty(PARENT_COVERAGE_PROPERTY, (Object)parentCoverage);
            ri = pi;
        }
        return ri;
    }

    private void setupTilingHints(int tileSizeX, int tileSizeY) {
        if (tileSizeX > 0 && tileSizeY > 0) {
            ImageLayout2 layout = new ImageLayout2();
            layout.setTileGridXOffset(0).setTileGridYOffset(0).setTileHeight(tileSizeY).setTileWidth(tileSizeX);
            this.hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        }
    }

    private void setupInterpolationHints(Interpolation interpolation) {
        if (interpolation != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering using interpolation " + interpolation);
            }
            this.interpolation = interpolation;
            this.hints.add(new RenderingHints(JAI.KEY_INTERPOLATION, this.interpolation));
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering using interpolation " + interpolation);
            }
            this.setInterpolationHints();
        }
    }

    public RenderedImage renderImage(GridCoverage2DReader reader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer, Interpolation interpolation, Color background, int tileSizeX, int tileSizeY) throws FactoryException, TransformException, NoninvertibleTransformException, IOException {
        this.setupTilingHints(tileSizeX, tileSizeY);
        this.setupInterpolationHints(interpolation);
        return this.renderImage(reader, readParams, symbolizer, interpolation, background);
    }

    /*
     * WARNING - void declaration
     */
    private RenderedImage renderImage(GridCoverage2DReader reader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer, Interpolation interpolation, Color background) throws FactoryException, IOException, TransformException {
        void var18_47;
        List<Object> coverages;
        CoordinateReferenceSystem sourceCRS = reader.getCoordinateReferenceSystem();
        CoordinateReferenceSystem targetCRS = this.destinationEnvelope.getCoordinateReferenceSystem();
        RasterSymbolizer finalSymbolizer = symbolizer;
        if (symbolizer != null && GridCoverageRenderer.isBandsSelectionApplicable((GridCoverageReader)reader, symbolizer)) {
            readParams = this.applyBandsSelectionParameter((GridCoverageReader)reader, readParams, symbolizer);
            finalSymbolizer = GridCoverageRenderer.setupSymbolizerForBandsSelection(symbolizer);
        }
        ProjectionHandler handler = null;
        GridCoverageReaderHelper rh = new GridCoverageReaderHelper(reader, this.destinationSize, ReferencedEnvelope.reference((Envelope)this.destinationEnvelope), interpolation, this.hints);
        if (GridCoverageReaderHelper.isReprojectingReader(reader)) {
            GridCoverage2D coverage = rh.readCoverage(readParams);
            coverages = new ArrayList<GridCoverage2D>();
            coverages.add(coverage);
        } else {
            if (this.advancedProjectionHandlingEnabled && (handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)rh.getReadEnvelope(), (CoordinateReferenceSystem)sourceCRS, (boolean)this.wrapEnabled)) instanceof WrappingProjectionHandler) {
                ((WrappingProjectionHandler)handler).setDatelineWrappingCheckEnabled(false);
            }
            coverages = rh.readCoverages(readParams, handler, this.gridCoverageFactory);
        }
        boolean reprojectionNeeded = false;
        for (GridCoverage2D gridCoverage2D : coverages) {
            CoordinateReferenceSystem coverageCRS;
            if (gridCoverage2D == null || CRS.equalsIgnoreMetadata((Object)(coverageCRS = gridCoverage2D.getCoordinateReferenceSystem()), (Object)this.destinationCRS)) continue;
            reprojectionNeeded = true;
            break;
        }
        double[] bgValues = GridCoverageRendererUtilities.colorToArray(background);
        if (!coverages.isEmpty() && coverages.get(0) != null) {
            ColorModel colorModel = ((GridCoverage2D)coverages.get(0)).getRenderedImage().getColorModel();
            if (colorModel instanceof IndexColorModel && background != null) {
                IndexColorModel icm = (IndexColorModel)colorModel;
                int n = ColorUtilities.findColorIndex((Color)background, (IndexColorModel)icm);
                if (n < 0) {
                    for (int i = 0; i < coverages.size(); ++i) {
                        GridCoverage2D gridCoverage2D = (GridCoverage2D)coverages.get(i);
                        ImageWorker iw = new ImageWorker(gridCoverage2D.getRenderedImage());
                        iw.forceComponentColorModel();
                        GridCoverage2D expandedCoverage = this.gridCoverageFactory.create((CharSequence)gridCoverage2D.getName(), iw.getRenderedImage(), gridCoverage2D.getGridGeometry(), null, (GridCoverage[])new GridCoverage2D[]{gridCoverage2D}, gridCoverage2D.getProperties());
                        coverages.set(i, expandedCoverage);
                    }
                }
            } else {
                bgValues = GridCoverageRendererUtilities.colorToArray(background);
            }
        }
        if (reprojectionNeeded && handler != null && handler.getValidAreaBounds() != null) {
            ArrayList<GridCoverage2D> arrayList = new ArrayList<GridCoverage2D>();
            ReferencedEnvelope validArea = handler.getValidAreaBounds();
            GridGeometryReducer gridGeometryReducer = new GridGeometryReducer(validArea);
            for (GridCoverage2D gridCoverage2D : coverages) {
                GridGeometry2D gg = gridCoverage2D.getGridGeometry();
                GridGeometry2D reduced = gridGeometryReducer.reduce(gg);
                if (!reduced.equals((Object)gg)) {
                    GeneralEnvelope cutEnvelope = gridGeometryReducer.getCutEnvelope(reduced);
                    GridCoverage2D croppedCoverage = this.crop(gridCoverage2D, cutEnvelope, false, bgValues);
                    if (croppedCoverage == null) continue;
                    arrayList.add(croppedCoverage);
                    continue;
                }
                arrayList.add(gridCoverage2D);
            }
            coverages = arrayList;
        }
        ArrayList<GridCoverage2D> arrayList = new ArrayList<GridCoverage2D>();
        for (GridCoverage2D gridCoverage2D : coverages) {
            if (gridCoverage2D == null) continue;
            CoordinateReferenceSystem coverageCRS = gridCoverage2D.getCoordinateReferenceSystem();
            if (!CRS.equalsIgnoreMetadata((Object)coverageCRS, (Object)this.destinationCRS)) {
                GridCoverage2D gridCoverage2D2 = this.reproject(gridCoverage2D, true, bgValues);
                if (gridCoverage2D2 == null) continue;
                arrayList.add(gridCoverage2D2);
                continue;
            }
            arrayList.add(gridCoverage2D);
        }
        ArrayList<GridCoverage2D> displacedCoverages = new ArrayList<GridCoverage2D>();
        if (handler != null) {
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((Envelope)this.destinationEnvelope);
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            PolygonExtractor polygonExtractor = new PolygonExtractor();
            for (GridCoverage2D coverage : arrayList) {
                Polygon polygon = JTS.toGeometry((BoundingBox)coverage.getEnvelope2D());
                Geometry postProcessed = handler.postProcess(mt, (Geometry)polygon);
                List<Polygon> polygons = polygonExtractor.getPolygons(postProcessed);
                for (Polygon displaced : polygons) {
                    org.locationtech.jts.geom.Envelope intersection = referencedEnvelope.intersection(displaced.getEnvelopeInternal());
                    if (intersection == null || intersection.isNull() || intersection.getArea() == 0.0) continue;
                    if (displaced.equals((Geometry)polygon)) {
                        displacedCoverages.add(coverage);
                        continue;
                    }
                    double[] tx = this.getTranslationFactors(polygon, displaced);
                    if (tx == null) continue;
                    GridCoverage2D displacedCoverage = GridCoverageRendererUtilities.displace(coverage, tx[0], tx[1], this.gridCoverageFactory);
                    displacedCoverages.add(displacedCoverage);
                }
            }
        } else {
            displacedCoverages.addAll(arrayList);
        }
        Iterator iterator = displacedCoverages.iterator();
        while (iterator.hasNext()) {
            GridCoverage2D coverage = (GridCoverage2D)iterator.next();
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((Envelope)coverage.getEnvelope2D());
            if (this.destinationEnvelope.intersects((Envelope)referencedEnvelope, false)) continue;
            iterator.remove();
        }
        ArrayList<GridCoverage2D> arrayList2 = new ArrayList<GridCoverage2D>();
        int ii = 0;
        for (GridCoverage2D displaced : displacedCoverages) {
            GridCoverage2D symbolized = this.symbolize(displaced, finalSymbolizer, bgValues);
            if (symbolized != null) {
                arrayList2.add(symbolized);
            }
            ++ii;
        }
        Object var18_44 = null;
        if (arrayList2.size() == 0) {
            return null;
        }
        if (arrayList2.size() == 1) {
            GridCoverage2D gridCoverage2D = (GridCoverage2D)arrayList2.get(0);
        } else {
            Comparator sliverComparator = (c1, c2) -> {
                RenderedImage r1 = c1.getRenderedImage();
                RenderedImage r2 = c2.getRenderedImage();
                long areaDiff = (long)r2.getWidth() * (long)r2.getHeight() - (long)r1.getWidth() * (long)r1.getHeight();
                return (int)Math.signum(areaDiff);
            };
            Collections.sort(arrayList2, sliverComparator);
            Hints mosaicHints = new Hints((RenderingHints)this.hints);
            mosaicHints.put((Object)JAI.KEY_REPLACE_INDEX_COLOR_MODEL, (Object)false);
            GridCoverage2D gridCoverage2D = GridCoverageRendererUtilities.mosaic(arrayList2, new ArrayList<GridCoverage2D>(), this.destinationEnvelope, mosaicHints, bgValues);
        }
        if (var18_47 == null) {
            return null;
        }
        GridCoverage2D cropped = this.crop((GridCoverage2D)var18_47, this.destinationEnvelope, false, bgValues);
        return this.getImageFromParentCoverage(cropped);
    }

    private GridCoverage2D addRoiIfMissing(GridCoverage2D coverage) {
        RenderedImage input = coverage.getRenderedImage();
        Object roiObject = input.getProperty("ROI");
        Object gcRoiObject = coverage.getProperty("GC_ROI");
        if (!(roiObject instanceof ROI) && !(gcRoiObject instanceof ROI)) {
            org.locationtech.jts.geom.Envelope env = new org.locationtech.jts.geom.Envelope((double)input.getMinX(), (double)(input.getMinX() + input.getWidth()), (double)input.getMinY(), (double)(input.getMinY() + input.getHeight()));
            ROI roi = new ROI((RenderedImage)new ROIGeometry((Geometry)JTS.toGeometry((org.locationtech.jts.geom.Envelope)env)).getAsImage());
            PlanarImage pi = PlanarImage.wrapRenderedImage((RenderedImage)input);
            pi.setProperty("ROI", (Object)roi);
            Map sourceProperties = coverage.getProperties();
            HashMap<String, ROI> properties = sourceProperties == null ? new HashMap<String, ROI>() : new HashMap(sourceProperties);
            properties.put("GC_ROI", roi);
            return this.gridCoverageFactory.create((CharSequence)coverage.getName(), (RenderedImage)pi, coverage.getGridGeometry(), null, (GridCoverage[])new GridCoverage2D[]{coverage}, properties);
        }
        return coverage;
    }

    private GridCoverage2D createAlphaBand(GridCoverage2D coverage) {
        RenderedImage input = coverage.getRenderedImage();
        ImageLayout layout = new ImageLayout();
        layout.setMinX(input.getMinX());
        layout.setMinY(input.getMinY());
        layout.setWidth(input.getWidth());
        layout.setHeight(input.getHeight());
        layout.setTileHeight(input.getTileHeight());
        layout.setTileWidth(input.getTileWidth());
        RenderingHints renderHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        RenderedOp alpha = ConstantDescriptor.create((Float)Float.valueOf(input.getWidth()), (Float)Float.valueOf(input.getHeight()), (Number[])new Byte[]{(byte)-1}, (RenderingHints)renderHints);
        ImageWorker w = new ImageWorker((RenderedImage)alpha).format(input.getSampleModel().getDataType());
        GridCoverage2D newCoverage = this.gridCoverageFactory.create((CharSequence)(coverage.getName() + "Alpha"), w.getRenderedImage(), coverage.getGridGeometry(), null, (GridCoverage[])new GridCoverage2D[]{coverage}, coverage.getProperties());
        return newCoverage;
    }

    private double[] getTranslationFactors(Polygon reference, Polygon displaced) {
        org.locationtech.jts.geom.Envelope re = reference.getEnvelopeInternal();
        org.locationtech.jts.geom.Envelope de = displaced.getEnvelopeInternal();
        double dw = Math.abs(re.getWidth() - de.getWidth());
        double dh = Math.abs(re.getHeight() - de.getHeight());
        if (dw > 1.0E-6 * re.getWidth() || dh > 1.0E-6 * re.getWidth()) {
            return null;
        }
        double dx = de.getMinX() - re.getMinX();
        double dy = de.getMinY() - re.getMinY();
        Polygon cloned = (Polygon)displaced.copy();
        cloned.apply((CoordinateSequenceFilter)AffineTransformation.translationInstance((double)(-dx), (double)(-dy)));
        HausdorffSimilarityMeasure hausdorffSimilarityMeasure = new HausdorffSimilarityMeasure();
        if (1.0 - hausdorffSimilarityMeasure.measure((Geometry)cloned, (Geometry)reference) > 1.0E-6) {
            return null;
        }
        return new double[]{dx, dy};
    }

    public void paint(Graphics2D graphics, GridCoverage2D gridCoverage, RasterSymbolizer symbolizer) throws Exception {
        this.paint(graphics, gridCoverage, symbolizer, null);
    }

    public void paint(Graphics2D graphics, GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, double[] bkgValues) throws Exception {
        if (graphics == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"graphics"));
        }
        if (gridCoverage == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"gridCoverage"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Drawing coverage " + gridCoverage.toString());
        }
        RenderedImage finalImage = this.renderImage(gridCoverage, symbolizer, bkgValues);
        this.paintImage(graphics, finalImage, symbolizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics, GridCoverage2DReader gridCoverageReader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer, Interpolation interpolation, Color background) throws Exception {
        if (graphics == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"graphics"));
        }
        if (gridCoverageReader == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"gridCoverageReader"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Drawing reader " + gridCoverageReader.toString());
        }
        this.setupInterpolationHints(interpolation);
        RenderedImage finalImage = this.renderImage(gridCoverageReader, readParams, symbolizer, interpolation, background);
        if (finalImage != null) {
            try {
                this.paintImage(graphics, finalImage, symbolizer);
            }
            finally {
                if (finalImage instanceof PlanarImage) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)finalImage));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintImage(Graphics2D graphics, RenderedImage inputImage, RasterSymbolizer symbolizer) {
        RenderingHints oldHints = graphics.getRenderingHints();
        graphics.setRenderingHints((Map<?, ?>)this.hints);
        if (inputImage == null) {
            return;
        }
        RenderedImage transparentImage = new ImageWorker(inputImage).prepareForRendering().getRenderedImage();
        try {
            boolean multiply;
            if (DEBUG) {
                GridCoverageRenderer.writeRenderedImage(transparentImage, "final");
            }
            boolean bl = multiply = symbolizer.getShadedRelief() != null && symbolizer.getShadedRelief().isBrightnessOnly();
            if (multiply) {
                graphics.setComposite(BlendComposite.getInstance(BlendComposite.BlendingMode.MULTIPLY, 1.0f));
                transparentImage = Compositing.forceToRGB(transparentImage, true);
            } else {
                graphics.setComposite(AlphaComposite.getInstance(3));
            }
            graphics.drawRenderedImage(transparentImage, IDENTITY);
        }
        catch (Throwable t) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
                }
                if (t instanceof IllegalArgumentException) {
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(transparentImage, "preWORKAROUND1");
                    }
                    RenderedImage componentImage = new ImageWorker(transparentImage).forceComponentColorModel(true).getRenderedImage();
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(componentImage, "WORKAROUND1");
                    }
                    graphics.drawRenderedImage(componentImage, IDENTITY);
                } else if (t instanceof ImagingOpException) {
                    BufferedImage buf;
                    BufferedImage bufferedImage = buf = transparentImage.getColorModel().hasAlpha() ? new BufferedImage(transparentImage.getWidth(), transparentImage.getHeight(), 6) : new BufferedImage(transparentImage.getWidth(), transparentImage.getHeight(), 5);
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(buf, "preWORKAROUND2");
                    }
                    Graphics2D g = (Graphics2D)buf.getGraphics();
                    int translationX = transparentImage.getMinX();
                    int translationY = transparentImage.getMinY();
                    g.drawRenderedImage(transparentImage, AffineTransform.getTranslateInstance(-translationX, -translationY));
                    g.dispose();
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(buf, "WORKAROUND2");
                    }
                    IDENTITY.concatenate(AffineTransform.getTranslateInstance(translationX, translationY));
                    graphics.drawImage(buf, IDENTITY, null);
                    buf.flush();
                    buf = null;
                } else if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to renderer this raster, no workaround found", t);
                }
            }
            catch (Throwable t1) {
                LOGGER.log(Level.WARNING, t1.getLocalizedMessage(), t1);
            }
            finally {
                graphics.setRenderingHints(oldHints);
            }
        }
    }

    private GeneralParameterValue[] applyBandsSelectionParameter(GridCoverageReader reader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer) {
        int[] bandIndices = ChannelSelectionUpdateStyleVisitor.getBandIndicesFromSelectionChannels(symbolizer);
        Parameter bandIndicesParam = null;
        bandIndicesParam = (Parameter)AbstractGridFormat.BANDS.createValue();
        bandIndicesParam.setValue((Object)bandIndices);
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (readParams != null) {
            paramList.addAll(Arrays.asList(readParams));
        }
        paramList.add(bandIndicesParam);
        return paramList.toArray(new GeneralParameterValue[paramList.size()]);
    }

    public static RasterSymbolizer setupSymbolizerForBandsSelection(RasterSymbolizer symbolizer) {
        ChannelSelection selection = symbolizer.getChannelSelection();
        SelectedChannelType[] originalChannels = selection.getSelectedChannels();
        if (originalChannels != null) {
            int i = 0;
            SelectedChannelType[] channels = new SelectedChannelType[originalChannels.length];
            for (SelectedChannelType originalChannel : originalChannels) {
                SelectedChannelTypeImpl channel = new SelectedChannelTypeImpl();
                channel.setChannelName(Integer.toString(i + 1));
                channel.setContrastEnhancement((ContrastEnhancement)originalChannel.getContrastEnhancement());
                channels[i] = channel;
                ++i;
            }
            ChannelSelectionUpdateStyleVisitor channelsUpdateVisitor = new ChannelSelectionUpdateStyleVisitor(channels);
            symbolizer.accept((StyleVisitor)channelsUpdateVisitor);
            return (RasterSymbolizer)channelsUpdateVisitor.getCopy();
        }
        return symbolizer;
    }

    public static boolean isBandsSelectionApplicable(GridCoverageReader reader, RasterSymbolizer symbolizer) {
        int[] bandIndices = ChannelSelectionUpdateStyleVisitor.getBandIndicesFromSelectionChannels(symbolizer);
        return reader.getFormat() != null && reader.getFormat().getReadParameters().getDescriptor().descriptors().contains(AbstractGridFormat.BANDS) && bandIndices != null;
    }

    private GridCoverage2D lookForCompositing(GridCoverage2D source) {
        Object compositing = source.getProperty(KEY_COMPOSITING);
        if (compositing != null && compositing instanceof Compositing) {
            return ((Compositing)compositing).composeGridCoverage(source, CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints));
        }
        return source;
    }

    static {
        if (DEBUG) {
            File tempDir = new File(System.getProperty("user.home"), "gt-renderer");
            if (!tempDir.exists()) {
                if (!tempDir.mkdir()) {
                    System.out.println("Unable to create debug dir, exiting application!!!");
                }
                DEBUG = false;
                DUMP_DIRECTORY = null;
            } else {
                DUMP_DIRECTORY = tempDir.getAbsolutePath();
                System.out.println("Rendering debug dir " + DUMP_DIRECTORY);
            }
        }
        PADDING = new Hints.Key(Integer.class);
    }
}

