/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ColorUtilities;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.i18n.Errors;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.composite.BlendComposite;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.geotools.renderer.lite.gridcoverage2d.ChannelSelectionUpdateStyleVisitor;
import org.geotools.renderer.lite.gridcoverage2d.Compositing;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageReaderHelper;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.style.ContrastEnhancement;

public final class GridCoverageRenderer {
    private static final Logger LOGGER = Logging.getLogger(GridCoverageRenderer.class);
    private static final AffineTransform IDENTITY = AffineTransform2D.getTranslateInstance((double)0.0, (double)0.0);
    private static boolean DEBUG = Boolean.getBoolean("org.geotools.renderer.lite.gridcoverage2d.debug");
    private static String DUMP_DIRECTORY;
    private final CoordinateReferenceSystem destinationCRS;
    private final GeneralEnvelope destinationEnvelope;
    private final Rectangle destinationSize;
    private final AffineTransform finalGridToWorld;
    private final AffineTransform finalWorldToGrid;
    private Hints hints = new Hints();
    private Interpolation interpolation = new InterpolationNearest();
    private final GridCoverageFactory gridCoverageFactory;
    private boolean wrapEnabled = true;
    private boolean advancedProjectionHandlingEnabled = true;
    public static final String PARENT_COVERAGE_PROPERTY = "ParentCoverage";
    public static final Hints.Key PADDING;
    public static final String KEY_COMPOSITING = "Compositing";

    public void setWrapEnabled(boolean wrapEnabled) {
        this.wrapEnabled = wrapEnabled;
    }

    public boolean isWrapEnabled() {
        return this.wrapEnabled;
    }

    public void setAdvancedProjectionHandlingEnabled(boolean enabled) {
        this.advancedProjectionHandlingEnabled = enabled;
    }

    public boolean isAdvancedProjectionHandlingEnabled() {
        return this.advancedProjectionHandlingEnabled;
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, Envelope envelope, Rectangle screenSize, AffineTransform worldToScreen) throws TransformException, NoninvertibleTransformException {
        this(destinationCRS, envelope, screenSize, worldToScreen, null);
    }

    public GridCoverageRenderer(CoordinateReferenceSystem destinationCRS, Envelope envelope, Rectangle screenSize, AffineTransform worldToScreen, RenderingHints newHints) throws TransformException, NoninvertibleTransformException {
        this.destinationSize = screenSize;
        this.destinationCRS = destinationCRS;
        if (this.destinationCRS == null) {
            throw new TransformException(Errors.format((int)31, (Object)this.destinationCRS));
        }
        this.destinationEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)new ReferencedEnvelope(envelope, this.destinationCRS));
        if (worldToScreen != null && XAffineTransform.getRotation((AffineTransform)worldToScreen) != 0.0) {
            this.finalWorldToGrid = new AffineTransform(worldToScreen);
            this.finalGridToWorld = this.finalWorldToGrid.createInverse();
        } else {
            GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper();
            gridToEnvelopeMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
            gridToEnvelopeMapper.setGridRange((GridEnvelope)new GridEnvelope2D(this.destinationSize));
            gridToEnvelopeMapper.setEnvelope((org.opengis.geometry.Envelope)this.destinationEnvelope);
            this.finalGridToWorld = new AffineTransform(gridToEnvelopeMapper.createAffineTransform());
            this.finalWorldToGrid = this.finalGridToWorld.createInverse();
        }
        if (newHints != null) {
            this.hints.add(newHints);
        }
        this.gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        if (this.hints.containsKey((Object)JAI.KEY_INTERPOLATION)) {
            this.interpolation = (Interpolation)newHints.get(JAI.KEY_INTERPOLATION);
        } else {
            this.hints.add(new RenderingHints(JAI.KEY_INTERPOLATION, this.interpolation));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Rendering using interpolation " + this.interpolation);
        }
        this.setInterpolationHints();
        if (this.hints.containsKey((Object)JAI.KEY_IMAGE_LAYOUT)) {
            ImageLayout layout = (ImageLayout)this.hints.get((Object)JAI.KEY_IMAGE_LAYOUT);
            layout.unsetImageBounds();
            layout.unsetValid(0);
        }
        this.hints.put((Object)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        this.hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
    }

    private void setInterpolationHints() {
        if (this.interpolation instanceof InterpolationNearest) {
            this.hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
            this.hints.add(new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.TRUE));
        } else {
            this.hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE));
            this.hints.add(new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE));
        }
    }

    static void writeRenderedImage(RenderedImage raster, String fileName) {
        if (DUMP_DIRECTORY == null) {
            throw new NullPointerException("Unable to write the provided coverage in the debug directory");
        }
        if (!DEBUG) {
            throw new IllegalStateException("Unable to write the provided coverage since we are not in debug mode");
        }
        try {
            ImageIO.write(raster, "tiff", new File(DUMP_DIRECTORY, fileName + ".tiff"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public RenderedImage renderImage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, double[] bkgValues) throws Exception {
        GridCoverage2D symbolizerGC = this.renderCoverage(gridCoverage, symbolizer, bkgValues);
        return this.getImageFromParentCoverage(symbolizerGC);
    }

    private GridCoverage2D renderCoverage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, double[] bkgValues) throws FactoryException {
        GridCoverage2D preReprojection;
        GridCoverageRendererUtilities.ensureNotNull(gridCoverage, "gridCoverage");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Drawing coverage " + gridCoverage.toString());
        }
        boolean doReprojection = false;
        CoordinateReferenceSystem coverageCRS = gridCoverage.getCoordinateReferenceSystem2D();
        if (!CRS.equalsIgnoreMetadata((Object)coverageCRS, (Object)this.destinationCRS)) {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)coverageCRS, (CoordinateReferenceSystem)this.destinationCRS, (boolean)true);
            boolean bl = doReprojection = !transform.isIdentity();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Reproject needed for rendering provided coverage");
            }
        }
        if ((preReprojection = this.crop(gridCoverage, this.destinationEnvelope, doReprojection, bkgValues)) == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Skipping current coverage because crop failed");
            }
            return null;
        }
        Hints warpAffineHints = this.getReprojectionHints(this.hints, preReprojection);
        GridCoverage2D afterReprojection = preReprojection;
        if (doReprojection) {
            afterReprojection = GridCoverageRendererUtilities.reproject(preReprojection, this.destinationCRS, this.interpolation, this.destinationEnvelope, bkgValues, this.gridCoverageFactory, warpAffineHints);
        }
        if (DEBUG && afterReprojection != null) {
            GridCoverageRenderer.writeRenderedImage(afterReprojection.getRenderedImage(), "afterReprojection");
        }
        GridCoverage2D symbolized = afterReprojection;
        if (afterReprojection != null) {
            symbolized = this.symbolize(afterReprojection, symbolizer, bkgValues, warpAffineHints);
        }
        return symbolized;
    }

    private GridCoverage2D symbolize(GridCoverage2D coverage, RasterSymbolizer symbolizer, double[] bkgValues, Hints hints) {
        GridCoverage2D symbolizerGC;
        GridCoverage2D preSymbolizer = this.affine(coverage, bkgValues, symbolizer, hints);
        if (preSymbolizer == null) {
            return null;
        }
        GridCoverage2D sanitized = preSymbolizer;
        RenderedImage preSymbolizerImage = preSymbolizer.getRenderedImage();
        RenderedImage preAffineImage = coverage.getRenderedImage();
        if (preSymbolizerImage.getWidth() > preAffineImage.getWidth() * 2 || preSymbolizerImage.getHeight() > preAffineImage.getHeight() * 2) {
            sanitized = this.crop(preSymbolizer, this.destinationEnvelope, false, bkgValues);
        }
        if (symbolizer != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Applying Raster Symbolizer ");
            }
            RasterSymbolizerHelper rsp = new RasterSymbolizerHelper(sanitized, this.hints);
            rsp.visit(symbolizer);
            symbolizerGC = (GridCoverage2D)rsp.getOutput();
            symbolizerGC = this.lookForCompositing(symbolizerGC);
        } else {
            symbolizerGC = preSymbolizer;
        }
        if (DEBUG) {
            GridCoverageRenderer.writeRenderedImage(symbolizerGC.getRenderedImage(), "postSymbolizer");
        }
        return symbolizerGC;
    }

    private GridCoverage2D crop(GridCoverage2D inputCoverage, GeneralEnvelope destinationEnvelope, boolean doReprojection, double[] backgroundValues) {
        GridCoverage2D outputCoverage = GridCoverageRendererUtilities.crop(inputCoverage, destinationEnvelope, doReprojection, backgroundValues, this.hints);
        if (DEBUG && outputCoverage != null) {
            GridCoverageRenderer.writeRenderedImage(outputCoverage.getRenderedImage(), "crop");
        }
        return outputCoverage;
    }

    private GridCoverage2D affine(GridCoverage2D input, double[] bkgValues, RasterSymbolizer symbolizer, Hints hints) {
        Hints localHints = new Hints();
        localHints.putAll((Map)hints);
        if (symbolizer != null && symbolizer.getColorMap() != null) {
            localHints.put((Object)JAI.KEY_REPLACE_INDEX_COLOR_MODEL, (Object)false);
        }
        boolean useInputSampleDimensions = symbolizer == null;
        GridCoverage2D gc = GridCoverageRendererUtilities.affine(input, this.interpolation, this.finalWorldToGrid, bkgValues, useInputSampleDimensions, this.gridCoverageFactory, localHints);
        if (DEBUG && gc != null && gc.getRenderedImage() != null) {
            GridCoverageRenderer.writeRenderedImage(gc.getRenderedImage(), "postAffine");
        }
        return gc;
    }

    public RenderedImage renderImage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, Interpolation interpolation, Color background, int tileSizeX, int tileSizeY) throws FactoryException, TransformException, NoninvertibleTransformException {
        GridCoverage2D coverage = this.renderCoverage(gridCoverage, symbolizer, interpolation, background, tileSizeX, tileSizeY);
        return this.getImageFromParentCoverage(coverage);
    }

    private GridCoverage2D renderCoverage(GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, Interpolation interpolation, Color background, int tileSizeX, int tileSizeY) throws FactoryException {
        Hints oldHints = this.hints.clone();
        this.setupTilingHints(tileSizeX, tileSizeY);
        this.setupInterpolationHints(interpolation);
        try {
            GridCoverage2D gridCoverage2D = this.renderCoverage(gridCoverage, symbolizer, GridCoverageRendererUtilities.colorToArray(background));
            return gridCoverage2D;
        }
        catch (Exception e) {
            throw new FactoryException(e);
        }
        finally {
            this.hints = oldHints;
        }
    }

    private RenderedImage getImageFromParentCoverage(GridCoverage2D parentCoverage) {
        if (parentCoverage == null) {
            return null;
        }
        RenderedImage ri = parentCoverage.getRenderedImage();
        if (ri != null) {
            PlanarImage pi = PlanarImage.wrapRenderedImage((RenderedImage)ri);
            pi.setProperty(PARENT_COVERAGE_PROPERTY, (Object)parentCoverage);
            ri = pi;
        }
        return ri;
    }

    private void setupTilingHints(int tileSizeX, int tileSizeY) {
        if (tileSizeX > 0 && tileSizeY > 0) {
            ImageLayout2 layout = new ImageLayout2();
            layout.setTileGridXOffset(0).setTileGridYOffset(0).setTileHeight(tileSizeY).setTileWidth(tileSizeX);
            this.hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        }
    }

    private void setupInterpolationHints(Interpolation interpolation) {
        if (interpolation != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering using interpolation " + interpolation);
            }
            this.interpolation = interpolation;
            this.hints.add(new RenderingHints(JAI.KEY_INTERPOLATION, this.interpolation));
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rendering using interpolation " + interpolation);
            }
            this.setInterpolationHints();
        }
    }

    public RenderedImage renderImage(GridCoverage2DReader reader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer, Interpolation interpolation, Color background, int tileSizeX, int tileSizeY) throws FactoryException, TransformException, NoninvertibleTransformException, IOException {
        this.setupTilingHints(tileSizeX, tileSizeY);
        this.setupInterpolationHints(interpolation);
        return this.renderImage(reader, readParams, symbolizer, interpolation, background);
    }

    private RenderedImage renderImage(GridCoverage2DReader reader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer, Interpolation interpolation, Color background) throws FactoryException, IOException, TransformException {
        ArrayList<GridCoverage2D> coverages;
        CoordinateReferenceSystem sourceCRS = reader.getCoordinateReferenceSystem();
        CoordinateReferenceSystem targetCRS = this.destinationEnvelope.getCoordinateReferenceSystem();
        RasterSymbolizer finalSymbolizer = symbolizer;
        if (symbolizer != null && GridCoverageRenderer.isBandsSelectionApplicable((GridCoverageReader)reader, symbolizer)) {
            readParams = this.applyBandsSelectionParameter((GridCoverageReader)reader, readParams, symbolizer);
            finalSymbolizer = GridCoverageRenderer.setupSymbolizerForBandsSelection(symbolizer);
        }
        ProjectionHandler handler = null;
        GridCoverageReaderHelper rh = new GridCoverageReaderHelper(reader, this.destinationSize, ReferencedEnvelope.reference((org.opengis.geometry.Envelope)this.destinationEnvelope), interpolation, this.hints);
        if (GridCoverageReaderHelper.isReprojectingReader(reader)) {
            GridCoverage2D coverage = rh.readCoverage(readParams);
            coverages = new ArrayList<GridCoverage2D>();
            coverages.add(coverage);
        } else {
            if (this.advancedProjectionHandlingEnabled && (handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)rh.getReadEnvelope(), (CoordinateReferenceSystem)sourceCRS, (boolean)this.wrapEnabled)) instanceof WrappingProjectionHandler) {
                ((WrappingProjectionHandler)handler).setDatelineWrappingCheckEnabled(false);
            }
            coverages = rh.readCoverages(readParams, handler, this.gridCoverageFactory);
        }
        this.logCoverages("read", coverages);
        double[] bgValues = GridCoverageRendererUtilities.colorToArray(background);
        if (!coverages.isEmpty() && coverages.get(0) != null) {
            ColorModel cm = ((GridCoverage2D)coverages.get(0)).getRenderedImage().getColorModel();
            if (cm instanceof IndexColorModel && background != null) {
                IndexColorModel icm = (IndexColorModel)cm;
                int idx = ColorUtilities.findColorIndex((Color)background, (IndexColorModel)icm);
                if (idx < 0) {
                    for (int i = 0; i < coverages.size(); ++i) {
                        GridCoverage2D coverage = (GridCoverage2D)coverages.get(i);
                        ImageWorker iw = new ImageWorker(coverage.getRenderedImage());
                        iw.forceComponentColorModel();
                        GridCoverage2D expandedCoverage = this.gridCoverageFactory.create((CharSequence)coverage.getName(), iw.getRenderedImage(), coverage.getGridGeometry(), null, (GridCoverage[])new GridCoverage2D[]{coverage}, coverage.getProperties());
                        coverages.set(i, expandedCoverage);
                    }
                }
            } else {
                bgValues = GridCoverageRendererUtilities.colorToArray(background);
            }
        }
        coverages = GridCoverageRendererUtilities.forceToValidBounds(coverages, handler, bgValues, this.destinationCRS, this.hints);
        this.logCoverages("cropped", coverages);
        Hints warpAffineHints = coverages.isEmpty() ? this.hints : this.getReprojectionHints(this.hints, (GridCoverage2D)coverages.get(0));
        List<GridCoverage2D> reprojectedCoverages = GridCoverageRendererUtilities.reproject(coverages, this.destinationCRS, interpolation, this.destinationEnvelope, bgValues, this.gridCoverageFactory, warpAffineHints);
        this.logCoverages("reprojected", reprojectedCoverages);
        List<GridCoverage2D> displacedCoverages = GridCoverageRendererUtilities.displace(reprojectedCoverages, handler, this.destinationEnvelope, sourceCRS, targetCRS, this.gridCoverageFactory);
        GridCoverageRendererUtilities.removeNotIntersecting(displacedCoverages, this.destinationEnvelope);
        this.logCoverages("displaced", displacedCoverages);
        ArrayList<GridCoverage2D> symbolizedCoverages = new ArrayList<GridCoverage2D>();
        if (finalSymbolizer != null) {
            for (GridCoverage2D displaced : displacedCoverages) {
                GridCoverage2D symbolized = this.symbolize(displaced, finalSymbolizer, bgValues, warpAffineHints);
                if (symbolized == null) continue;
                symbolizedCoverages.add(symbolized);
            }
        } else if (!coverages.isEmpty() && !CRS.equalsIgnoreMetadata((Object)((GridCoverage2D)coverages.get(0)).getCoordinateReferenceSystem2D(), (Object)this.destinationCRS)) {
            for (GridCoverage2D displaced : displacedCoverages) {
                GridCoverage2D affined = this.affine(displaced, bgValues, symbolizer, warpAffineHints);
                if (affined == null) continue;
                symbolizedCoverages.add(affined);
            }
        } else {
            symbolizedCoverages.addAll(displacedCoverages);
        }
        this.logCoverages("symbolized", symbolizedCoverages);
        GridCoverage2D mosaicked = GridCoverageRendererUtilities.mosaicSorted(symbolizedCoverages, this.destinationEnvelope, bgValues, this.hints);
        if (mosaicked == null) {
            return null;
        }
        GridCoverage2D cropped = this.crop(mosaicked, this.destinationEnvelope, false, bgValues);
        return this.getImageFromParentCoverage(cropped);
    }

    private Hints getReprojectionHints(Hints hints, GridCoverage2D gridCoverage2D) {
        double scaleY;
        if (gridCoverage2D == null) {
            return hints;
        }
        GridGeometry2D sourceGG = gridCoverage2D.getGridGeometry();
        GridEnvelope2D targetGR = sourceGG.getGridRange2D();
        GridGeometry2D targetGG = new GridGeometry2D((GridEnvelope)targetGR, (org.opengis.geometry.Envelope)this.destinationEnvelope);
        MathTransform targetMT = targetGG.getGridToCRS(PixelOrientation.UPPER_LEFT);
        if (!(targetMT instanceof AffineTransform2D)) {
            LOGGER.log(Level.FINE, "Cannot check if oversampling is happening, the grid to CRS transformation is not an Affine2D: {0}", targetMT);
            return hints;
        }
        AffineTransform2D targetAT = (AffineTransform2D)targetMT;
        double scaleX = Math.abs(targetAT.getScaleX() / this.finalGridToWorld.getScaleX());
        double scale = Math.max(scaleX, scaleY = Math.abs(targetAT.getScaleY() / this.finalGridToWorld.getScaleY()));
        if (scale <= 1.0) {
            return hints;
        }
        Hints result = new Hints((RenderingHints)hints);
        result.put((Object)Hints.RESAMPLE_TOLERANCE, (Object)0.0);
        return result;
    }

    private void logCoverages(String name, List<GridCoverage2D> coverages) {
        if (LOGGER.isLoggable(Level.FINE)) {
            String message = "GridCoverageRenderer coverages: " + name + "\n" + coverages == null ? "none" : coverages.stream().map(c -> c.toString()).collect(Collectors.joining(","));
            LOGGER.log(Level.FINE, message);
        }
    }

    public void paint(Graphics2D graphics, GridCoverage2D gridCoverage, RasterSymbolizer symbolizer) throws Exception {
        this.paint(graphics, gridCoverage, symbolizer, null);
    }

    public void paint(Graphics2D graphics, GridCoverage2D gridCoverage, RasterSymbolizer symbolizer, double[] bkgValues) throws Exception {
        if (graphics == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"graphics"));
        }
        if (gridCoverage == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"gridCoverage"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Drawing coverage " + gridCoverage.toString());
        }
        RenderedImage finalImage = this.renderImage(gridCoverage, symbolizer, bkgValues);
        this.paintImage(graphics, finalImage, symbolizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics, GridCoverage2DReader gridCoverageReader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer, Interpolation interpolation, Color background) throws Exception {
        if (graphics == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"graphics"));
        }
        if (gridCoverageReader == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"gridCoverageReader"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Drawing reader " + gridCoverageReader.toString());
        }
        this.setupInterpolationHints(interpolation);
        RenderedImage finalImage = this.renderImage(gridCoverageReader, readParams, symbolizer, interpolation, background);
        if (finalImage != null) {
            try {
                this.paintImage(graphics, finalImage, symbolizer);
            }
            finally {
                if (finalImage instanceof PlanarImage) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)finalImage));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintImage(Graphics2D graphics, RenderedImage inputImage, RasterSymbolizer symbolizer) {
        RenderingHints oldHints = graphics.getRenderingHints();
        graphics.setRenderingHints((Map<?, ?>)this.hints);
        if (inputImage == null) {
            return;
        }
        RenderedImage transparentImage = new ImageWorker(inputImage).prepareForRendering().getRenderedImage();
        try {
            boolean multiply;
            if (DEBUG) {
                GridCoverageRenderer.writeRenderedImage(transparentImage, "final");
            }
            boolean bl = multiply = symbolizer.getShadedRelief() != null && symbolizer.getShadedRelief().isBrightnessOnly();
            if (multiply) {
                graphics.setComposite(BlendComposite.getInstance(BlendComposite.BlendingMode.MULTIPLY, 1.0f));
                transparentImage = Compositing.forceToRGB(transparentImage, true);
            } else {
                graphics.setComposite(AlphaComposite.getInstance(3));
            }
            graphics.drawRenderedImage(transparentImage, IDENTITY);
        }
        catch (Throwable t) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
                }
                if (t instanceof IllegalArgumentException) {
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(transparentImage, "preWORKAROUND1");
                    }
                    RenderedImage componentImage = new ImageWorker(transparentImage).forceComponentColorModel(true).getRenderedImage();
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(componentImage, "WORKAROUND1");
                    }
                    graphics.drawRenderedImage(componentImage, IDENTITY);
                } else if (t instanceof ImagingOpException) {
                    BufferedImage buf;
                    BufferedImage bufferedImage = buf = transparentImage.getColorModel().hasAlpha() ? new BufferedImage(transparentImage.getWidth(), transparentImage.getHeight(), 6) : new BufferedImage(transparentImage.getWidth(), transparentImage.getHeight(), 5);
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(buf, "preWORKAROUND2");
                    }
                    Graphics2D g = (Graphics2D)buf.getGraphics();
                    int translationX = transparentImage.getMinX();
                    int translationY = transparentImage.getMinY();
                    g.drawRenderedImage(transparentImage, AffineTransform.getTranslateInstance(-translationX, -translationY));
                    g.dispose();
                    if (DEBUG) {
                        GridCoverageRenderer.writeRenderedImage(buf, "WORKAROUND2");
                    }
                    IDENTITY.concatenate(AffineTransform.getTranslateInstance(translationX, translationY));
                    graphics.drawImage(buf, IDENTITY, null);
                    buf.flush();
                    buf = null;
                } else if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to renderer this raster, no workaround found", t);
                }
            }
            catch (Throwable t1) {
                LOGGER.log(Level.WARNING, t1.getLocalizedMessage(), t1);
            }
            finally {
                graphics.setRenderingHints(oldHints);
            }
        }
    }

    private GeneralParameterValue[] applyBandsSelectionParameter(GridCoverageReader reader, GeneralParameterValue[] readParams, RasterSymbolizer symbolizer) {
        int[] bandIndices = ChannelSelectionUpdateStyleVisitor.getBandIndicesFromSelectionChannels(symbolizer);
        Parameter bandIndicesParam = (Parameter)AbstractGridFormat.BANDS.createValue();
        bandIndicesParam.setValue((Object)bandIndices);
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (readParams != null) {
            paramList.addAll(Arrays.asList(readParams));
        }
        paramList.add(bandIndicesParam);
        return paramList.toArray(new GeneralParameterValue[paramList.size()]);
    }

    public static RasterSymbolizer setupSymbolizerForBandsSelection(RasterSymbolizer symbolizer) {
        ChannelSelection selection = symbolizer.getChannelSelection();
        SelectedChannelType[] originalChannels = selection.getRGBChannels();
        if (originalChannels == null && selection.getGrayChannel() != null) {
            originalChannels = new SelectedChannelType[]{selection.getGrayChannel()};
        }
        if (originalChannels != null) {
            int i = 0;
            SelectedChannelType[] channels = new SelectedChannelType[originalChannels.length];
            for (SelectedChannelType originalChannel : originalChannels) {
                SelectedChannelTypeImpl channel = new SelectedChannelTypeImpl();
                channel.setChannelName(Integer.toString(i + 1));
                channel.setContrastEnhancement((ContrastEnhancement)originalChannel.getContrastEnhancement());
                channels[i] = channel;
                ++i;
            }
            ChannelSelectionUpdateStyleVisitor channelsUpdateVisitor = new ChannelSelectionUpdateStyleVisitor(channels);
            symbolizer.accept((StyleVisitor)channelsUpdateVisitor);
            return (RasterSymbolizer)channelsUpdateVisitor.getCopy();
        }
        return symbolizer;
    }

    public static boolean isBandsSelectionApplicable(GridCoverageReader reader, RasterSymbolizer symbolizer) {
        int[] bandIndices = ChannelSelectionUpdateStyleVisitor.getBandIndicesFromSelectionChannels(symbolizer);
        return reader.getFormat() != null && reader.getFormat().getReadParameters().getDescriptor().descriptors().contains(AbstractGridFormat.BANDS) && bandIndices != null;
    }

    private GridCoverage2D lookForCompositing(GridCoverage2D source) {
        Object compositing = source.getProperty(KEY_COMPOSITING);
        if (compositing != null && compositing instanceof Compositing) {
            return ((Compositing)compositing).composeGridCoverage(source, CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints));
        }
        return source;
    }

    static {
        if (DEBUG) {
            File tempDir = new File(System.getProperty("user.home"), "gt-renderer");
            if (!tempDir.exists()) {
                if (!tempDir.mkdir()) {
                    LOGGER.severe("Unable to create debug dir, exiting application!!!");
                }
                DEBUG = false;
                DUMP_DIRECTORY = null;
            } else {
                DUMP_DIRECTORY = tempDir.getAbsolutePath();
                LOGGER.info("Rendering debug dir " + DUMP_DIRECTORY);
            }
        }
        PADDING = new Hints.Key(Integer.class);
    }
}

