/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import org.geotools.data.DataSourceException;
import org.geotools.data.PrjFileReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.files.FileReader;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.referencing.FactoryException;

class ShapefileSetManager
implements FileReader {
    ShpFiles shpFiles;
    ShapefileDataStore store;

    public ShapefileSetManager(ShpFiles shpFiles, ShapefileDataStore store) {
        this.shpFiles = shpFiles;
        this.store = store;
    }

    protected ShapefileReader openShapeReader(GeometryFactory gf, boolean onlyRandomAccess) throws IOException {
        try {
            return new ShapefileReader(this.shpFiles, true, this.store.isMemoryMapped(), gf, onlyRandomAccess);
        }
        catch (ShapefileException se) {
            throw new DataSourceException("Error creating ShapefileReader", (Throwable)((Object)se));
        }
    }

    protected DbaseFileReader openDbfReader(boolean indexed) throws IOException {
        if (this.shpFiles.get(ShpFileType.DBF) == null) {
            return null;
        }
        if (this.shpFiles.isLocal() && !this.shpFiles.exists(ShpFileType.DBF)) {
            return null;
        }
        try {
            if (indexed) {
                return new IndexedDbaseFileReader(this.shpFiles, this.store.isMemoryMapped(), this.store.getCharset(), this.store.getTimeZone());
            }
            return new DbaseFileReader(this.shpFiles, this.store.isMemoryMapped(), this.store.getCharset(), this.store.getTimeZone());
        }
        catch (IOException e) {
            return null;
        }
    }

    protected PrjFileReader openPrjReader() throws IOException, FactoryException {
        if (this.shpFiles.get(ShpFileType.PRJ) == null) {
            return null;
        }
        if (this.shpFiles.isLocal() && !this.shpFiles.exists(ShpFileType.PRJ)) {
            return null;
        }
        try {
            return new PrjFileReader(this.shpFiles.getReadChannel(ShpFileType.PRJ, this));
        }
        catch (IOException e) {
            return null;
        }
    }

    protected IndexFile openIndexFile() throws IOException {
        if (this.shpFiles.get(ShpFileType.SHX) == null) {
            return null;
        }
        if (this.shpFiles.isLocal() && !this.shpFiles.exists(ShpFileType.SHX)) {
            return null;
        }
        try {
            return new IndexFile(this.shpFiles, this.store.isMemoryMapped());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }
}

