/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.lang.reflect.Array;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;

public class SQLArrayConverterFactory
implements ConverterFactory {
    public static final SQLArrayToJavaConverter ARRAY_TO_JAVA_CONVERTER = new SQLArrayToJavaConverter();

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (target.isArray() && java.sql.Array.class.isAssignableFrom(source)) {
            return ARRAY_TO_JAVA_CONVERTER;
        }
        return null;
    }

    static class SQLArrayToJavaConverter
    implements Converter {
        SQLArrayToJavaConverter() {
        }

        public Object convert(Object source, Class target) throws Exception {
            java.sql.Array sqlArray = (java.sql.Array)source;
            Object array = sqlArray.getArray();
            int length = Array.getLength(array);
            Class<?> componentType = target.getComponentType();
            Object result = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Object original = Array.get(array, i);
                if (original == null) {
                    Array.set(result, i, null);
                    continue;
                }
                Object converted = Converters.convert((Object)original, componentType);
                if (converted == null) {
                    throw new RuntimeException("Failed to convert " + original + " to " + componentType);
                }
                Array.set(result, i, converted);
            }
            return result;
        }
    }
}

