/**
 */
package net.opengis.gml311;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * GML base schema for GML 3
 * 			Components to support the GML encoding model.
 * 			The abstract Schematron rules can be used by any schema that includes gmlBase.
 * 			
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * Top level GML schema
 * 			
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * Basic support for tracking moving objects and objects with changing state.
 * 			
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * 
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * GML Coverage schema.
 * 			
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * How to encode coordinate reference system definitions. Builds on referenceSystems.xsd to encode the data needed to define coordinate reference systems, including the specific subtypes of coordinate reference systems. 
 * 		This schema encodes the Coordinate Reference System (SC_) package of the extended UML Model for OGC Abstract Specification Topic 2: Spatial Referencing by Coordinates, with the exception of the abstract "SC_CRS" class. The "SC_CRS" class is encoded in referenceSystems.xsd, to eliminate the (circular) references from coordinateOperations.xsd to coordinateReferenceSystems.xsd. That UML model is adapted from ISO 19111 - Spatial referencing by coordinates, as described in Annex C of Topic 2. 
 * 		Caution: The CRS package in GML 3.1 and GML 3.1.1 is preliminary, and is expected to undergo some modifications that are not backward compatible during the development of GML 3.2 (ISO 19136). The GML 3.2 package will implement the model described in the revised version of ISO 19111. 
 * 		
 * 		GML is an OGC Standard.
 * 		Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
 * 		To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * Observation schema for GML 3.1
 * 			
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * 
 * 			Default Style schema for GML 3.1.1
 * 			
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * The Temporal Reference Systems schema for GML 3.1 provides constructs for handling various styles of temporal reference system. 
 *     This schema reflects a partial implementation of the model described in ISO 19108:2002.
 *     
 *     GML is an OGC Standard.
 *     Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
 *     To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * 
 *     Generic simpleContent components for use in GML
 *     
 *     GML is an OGC Standard.
 *     Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
 *     To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 *     
 * This schema document provides attribute declarations and
 * attribute group, complex type and simple type definitions which can be used in
 * the construction of user schemas to define the structure of particular linking
 * constructs, e.g.
 * 
 * <xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema"
 *            xmlns:xl="http://www.w3.org/1999/xlink">
 * 
 *  <xs:import namespace="http://www.w3.org/1999/xlink"
 *             location="http://www.w3.org/1999/xlink.xsd">
 * 
 *  <xs:element name="mySimple">
 *   <xs:complexType>
 *    ...
 *    <xs:attributeGroup ref="xl:simpleAttrs"/>
 *    ...
 *   </xs:complexType>
 *  </xs:element>
 *  ...
 * </xs:schema>
 * 
 *    <div xmlns="http://www.w3.org/1999/xhtml">
 *     <h1>About the XML namespace</h1>
 * 
 *     <div class="bodytext">
 *      <p>
 *       This schema document describes the XML namespace, in a form
 *       suitable for import by other schema documents.
 *      </p>
 *      <p>
 *       See <a href="http://www.w3.org/XML/1998/namespace.html">
 *       http://www.w3.org/XML/1998/namespace.html</a> and
 *       <a href="http://www.w3.org/TR/REC-xml">
 *       http://www.w3.org/TR/REC-xml</a> for information 
 *       about this namespace.
 *      </p>
 *      <p>
 *       Note that local names in this namespace are intended to be
 *       defined only by the World Wide Web Consortium or its subgroups.
 *       The names currently defined in this namespace are listed below.
 *       They should not be used with conflicting semantics by any Working
 *       Group, specification, or document instance.
 *      </p>
 *      <p>   
 *       See further below in this document for more information about <a href="#usage">how to refer to this schema document from your own
 *       XSD schema documents</a> and about <a href="#nsversioning">the
 *       namespace-versioning policy governing this schema document</a>.
 *      </p>
 *     </div>
 *    </div>
 *   
 * 
 *    <div xmlns="http://www.w3.org/1999/xhtml">
 *    
 *     <h3>Father (in any context at all)</h3> 
 * 
 *     <div class="bodytext">
 *      <p>
 *       denotes Jon Bosak, the chair of 
 *       the original XML Working Group.  This name is reserved by 
 *       the following decision of the W3C XML Plenary and 
 *       XML Coordination groups:
 *      </p>
 *      <blockquote>
 *        <p>
 * 	In appreciation for his vision, leadership and
 * 	dedication the W3C XML Plenary on this 10th day of
 * 	February, 2000, reserves for Jon Bosak in perpetuity
 * 	the XML name "xml:Father".
 *        </p>
 *      </blockquote>
 *     </div>
 *    </div>
 *   
 * 
 *    <div id="usage" xml:id="usage" xmlns="http://www.w3.org/1999/xhtml">
 *     <h2>
 *       <a name="usage">About this schema document</a>
 *     </h2>
 * 
 *     <div class="bodytext">
 *      <p>
 *       This schema defines attributes and an attribute group suitable
 *       for use by schemas wishing to allow <code>xml:base</code>,
 *       <code>xml:lang</code>, <code>xml:space</code> or
 *       <code>xml:id</code> attributes on elements they define.
 *      </p>
 *      <p>
 *       To enable this, such a schema must import this schema for
 *       the XML namespace, e.g. as follows:
 *      </p>
 *      <pre>
 *           &lt;schema . . .&gt;
 *            . . .
 *            &lt;import namespace="http://www.w3.org/XML/1998/namespace"
 *                       schemaLocation="http://www.w3.org/2001/xml.xsd"/&gt;
 *      </pre>
 *      <p>
 *       or
 *      </p>
 *      <pre>
 *            &lt;import namespace="http://www.w3.org/XML/1998/namespace"
 *                       schemaLocation="http://www.w3.org/2009/01/xml.xsd"/&gt;
 *      </pre>
 *      <p>
 *       Subsequently, qualified reference to any of the attributes or the
 *       group defined below will have the desired effect, e.g.
 *      </p>
 *      <pre>
 *           &lt;type . . .&gt;
 *            . . .
 *            &lt;attributeGroup ref="xml:specialAttrs"/&gt;
 *      </pre>
 *      <p>
 *       will define a type which will schema-validate an instance element
 *       with any of those attributes.
 *      </p>
 *     </div>
 *    </div>
 *   
 * 
 *    <div id="nsversioning" xml:id="nsversioning" xmlns="http://www.w3.org/1999/xhtml">
 *     <h2>
 *       <a name="nsversioning">Versioning policy for this schema document</a>
 *     </h2>
 *     <div class="bodytext">
 *      <p>
 *       In keeping with the XML Schema WG's standard versioning
 *       policy, this schema document will persist at
 *       <a href="http://www.w3.org/2009/01/xml.xsd">
 *        http://www.w3.org/2009/01/xml.xsd</a>.
 *      </p>
 *      <p>
 *       At the date of issue it can also be found at
 *       <a href="http://www.w3.org/2001/xml.xsd">
 *        http://www.w3.org/2001/xml.xsd</a>.
 *      </p>
 *      <p>
 *       The schema document at that URI may however change in the future,
 *       in order to remain compatible with the latest version of XML
 *       Schema itself, or with the XML namespace itself.  In other words,
 *       if the XML Schema or XML namespaces change, the version of this
 *       document at <a href="http://www.w3.org/2001/xml.xsd">
 *        http://www.w3.org/2001/xml.xsd 
 *       </a> 
 *       will change accordingly; the version at 
 *       <a href="http://www.w3.org/2009/01/xml.xsd">
 *        http://www.w3.org/2009/01/xml.xsd 
 *       </a> 
 *       will not change.
 *      </p>
 *      <p>
 *       Previous dated (and unchanging) versions of this schema 
 *       document are at:
 *      </p>
 *      <ul>
 *       <li>
 *           <a href="http://www.w3.org/2009/01/xml.xsd">
 * 	http://www.w3.org/2009/01/xml.xsd</a>
 *         </li>
 *       <li>
 *           <a href="http://www.w3.org/2007/08/xml.xsd">
 * 	http://www.w3.org/2007/08/xml.xsd</a>
 *         </li>
 *       <li>
 *           <a href="http://www.w3.org/2004/10/xml.xsd">
 * 	http://www.w3.org/2004/10/xml.xsd</a>
 *         </li>
 *       <li>
 *           <a href="http://www.w3.org/2001/03/xml.xsd">
 * 	http://www.w3.org/2001/03/xml.xsd</a>
 *         </li>
 *      </ul>
 *     </div>
 *    </div>
 *   
 * <!-- end-model-doc -->
 * @see net.opengis.gml311.Gml311Factory
 * @model kind="package"
 *        annotation="urn:opengis:specification:gml:schema-xsd:gmlBase:3.1.1 appinfo='\n\t\t\t<sch:title xmlns:sch=\"http://www.ascc.net/xml/schematron\">Schematron validation</sch:title>\n\t\t\t<sch:ns prefix=\"gml\" uri=\"http://www.opengis.net/gml\" xmlns:sch=\"http://www.ascc.net/xml/schematron\"/>\n\t\t\t<sch:ns prefix=\"xlink\" uri=\"http://www.w3.org/1999/xlink\" xmlns:sch=\"http://www.ascc.net/xml/schematron\"/>\n\t\t\t<sch:pattern name=\"Check either href or content not both\" xmlns:sch=\"http://www.ascc.net/xml/schematron\">\n\t\t\t\t<sch:rule abstract=\"true\" id=\"hrefOrContent\">\n\t\t\t\t\t<sch:report test=\"@xlink:href and (*|text())\">Property element may not carry both a reference to an object and contain an object.</sch:report>\n\t\t\t\t\t<sch:assert test=\"@xlink:href | (*|text())\">Property element must either carry a reference to an object or contain an object.</sch:assert>\n\t\t\t\t</sch:rule>\n\t\t\t</sch:pattern>\n\t\t'"
 *        annotation="urn:opengis:specification:gml:schema-xsd:gml:3.1.1 appinfo='gml.xsd'"
 *        annotation="urn:opengis:specification:gml:schema-xsd:dynamicFeature:3.1.1 appinfo=''"
 *        annotation="urn:opengis:specification:gml:schema-xsd:topology:3.1.1 appinfo='topology.xsd'"
 *        annotation="urn:opengis:specification:gml:schema-xsd:coverage:3.1.1 appinfo='coverage.xsd'"
 *        annotation="urn:opengis:specification:gml:schema-xsd:coordinateReferenceSystems:3.1.1 appinfo=''"
 *        annotation="urn:opengis:specification:gml:schema-xsd:observation:3.1.1 appinfo='observation.xsd'"
 *        annotation="urn:opengis:specification:gml:schema-defaultStyle:v3.1.0 appinfo='defaultStyle.xsd'"
 *        annotation="urn:opengis:specification:gml:schema-xsd:temporalReferenceSystems:3.1.1 appinfo=''"
 *        annotation="urn:opengis:specification:gml:schema-xsd:basicTypes:3.1.1 appinfo='basicTypes.xsd'"
 * @generated
 */
public interface Gml311Package extends EPackage {
    /**
     * The package name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNAME = "gml311";

    /**
     * The package namespace URI.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_URI = "http://www.opengis.net/gml";

    /**
     * The package namespace name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_PREFIX = "gml311";

    /**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    Gml311Package eINSTANCE = net.opengis.gml311.impl.Gml311PackageImpl.init();

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractPositionalAccuracyTypeImpl <em>Abstract Positional Accuracy Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractPositionalAccuracyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractPositionalAccuracyType()
     * @generated
     */
    int ABSTRACT_POSITIONAL_ACCURACY_TYPE = 27;

    /**
     * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION = 0;

    /**
     * The number of structural features of the '<em>Abstract Positional Accuracy Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT = 1;

    /**
     * The number of operations of the '<em>Abstract Positional Accuracy Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbsoluteExternalPositionalAccuracyTypeImpl <em>Absolute External Positional Accuracy Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbsoluteExternalPositionalAccuracyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbsoluteExternalPositionalAccuracyType()
     * @generated
     */
    int ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE = 0;

    /**
     * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION;

    /**
     * The feature id for the '<em><b>Result</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__RESULT = ABSTRACT_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Absolute External Positional Accuracy Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT = ABSTRACT_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Absolute External Positional Accuracy Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT = ABSTRACT_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGMLTypeImpl <em>Abstract GML Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGMLTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGMLType()
     * @generated
     */
    int ABSTRACT_GML_TYPE = 23;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GML_TYPE__META_DATA_PROPERTY = 0;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GML_TYPE__DESCRIPTION = 1;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GML_TYPE__NAME_GROUP = 2;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GML_TYPE__NAME = 3;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GML_TYPE__ID = 4;

    /**
     * The number of structural features of the '<em>Abstract GML Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GML_TYPE_FEATURE_COUNT = 5;

    /**
     * The number of operations of the '<em>Abstract GML Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GML_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractFeatureTypeImpl <em>Abstract Feature Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractFeatureTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractFeatureType()
     * @generated
     */
    int ABSTRACT_FEATURE_TYPE = 13;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_TYPE__BOUNDED_BY = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_TYPE__LOCATION_GROUP = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_TYPE__LOCATION = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Abstract Feature Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Abstract Feature Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractCoverageTypeImpl <em>Abstract Coverage Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractCoverageTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractCoverageType()
     * @generated
     */
    int ABSTRACT_COVERAGE_TYPE = 6;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_FEATURE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__NAME_GROUP = ABSTRACT_FEATURE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__NAME = ABSTRACT_FEATURE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__ID = ABSTRACT_FEATURE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__LOCATION = ABSTRACT_FEATURE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Range Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__RANGE_SET = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE__DIMENSION = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the '<em>Abstract Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of operations of the '<em>Abstract Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractContinuousCoverageTypeImpl <em>Abstract Continuous Coverage Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractContinuousCoverageTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractContinuousCoverageType()
     * @generated
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE = 1;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_COVERAGE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_COVERAGE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__NAME_GROUP = ABSTRACT_COVERAGE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__NAME = ABSTRACT_COVERAGE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__ID = ABSTRACT_COVERAGE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_COVERAGE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_COVERAGE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__LOCATION = ABSTRACT_COVERAGE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_COVERAGE_TYPE__DOMAIN_SET_GROUP;

    /**
     * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_COVERAGE_TYPE__DOMAIN_SET;

    /**
     * The feature id for the '<em><b>Range Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__RANGE_SET = ABSTRACT_COVERAGE_TYPE__RANGE_SET;

    /**
     * The feature id for the '<em><b>Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__DIMENSION = ABSTRACT_COVERAGE_TYPE__DIMENSION;

    /**
     * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__COVERAGE_FUNCTION = ABSTRACT_COVERAGE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract Continuous Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_COVERAGE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract Continuous Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CONTINUOUS_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_COVERAGE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DefinitionTypeImpl <em>Definition Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DefinitionTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDefinitionType()
     * @generated
     */
    int DEFINITION_TYPE = 118;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The number of structural features of the '<em>Definition Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Definition Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractCoordinateOperationBaseTypeImpl <em>Abstract Coordinate Operation Base Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractCoordinateOperationBaseTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractCoordinateOperationBaseType()
     * @generated
     */
    int ABSTRACT_COORDINATE_OPERATION_BASE_TYPE = 2;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Coordinate Operation Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__COORDINATE_OPERATION_NAME = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract Coordinate Operation Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract Coordinate Operation Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractCoordinateOperationTypeImpl <em>Abstract Coordinate Operation Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractCoordinateOperationTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractCoordinateOperationType()
     * @generated
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE = 3;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__NAME = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__ID = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Coordinate Operation Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_NAME = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE__COORDINATE_OPERATION_NAME;

    /**
     * The feature id for the '<em><b>Coordinate Operation ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_ID = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__REMARKS = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Operation Version</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__OPERATION_VERSION = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__VALID_AREA = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__SCOPE = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Positional Accuracy Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__POSITIONAL_ACCURACY_GROUP = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Positional Accuracy</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__POSITIONAL_ACCURACY = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT + 6;

    /**
     * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__SOURCE_CRS = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT + 7;

    /**
     * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE__TARGET_CRS = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT + 8;

    /**
     * The number of structural features of the '<em>Abstract Coordinate Operation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_FEATURE_COUNT + 9;

    /**
     * The number of operations of the '<em>Abstract Coordinate Operation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_OPERATION_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_OPERATION_BASE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractCoordinateSystemBaseTypeImpl <em>Abstract Coordinate System Base Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractCoordinateSystemBaseTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractCoordinateSystemBaseType()
     * @generated
     */
    int ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE = 4;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Cs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__CS_NAME = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract Coordinate System Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract Coordinate System Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractCoordinateSystemTypeImpl <em>Abstract Coordinate System Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractCoordinateSystemTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractCoordinateSystemType()
     * @generated
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE = 5;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Cs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_NAME = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE__CS_NAME;

    /**
     * The feature id for the '<em><b>Cs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_ID = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Uses Axis</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE__USES_AXIS = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Abstract Coordinate System Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Abstract Coordinate System Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_BASE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractCurveSegmentTypeImpl <em>Abstract Curve Segment Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractCurveSegmentTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractCurveSegmentType()
     * @generated
     */
    int ABSTRACT_CURVE_SEGMENT_TYPE = 7;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR = 0;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END = 1;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START = 2;

    /**
     * The number of structural features of the '<em>Abstract Curve Segment Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>Abstract Curve Segment Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGeometryTypeImpl <em>Abstract Geometry Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGeometryTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGeometryType()
     * @generated
     */
    int ABSTRACT_GEOMETRY_TYPE = 22;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE__GID = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE__SRS_NAME = ABSTRACT_GML_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE__UOM_LABELS = ABSTRACT_GML_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of structural features of the '<em>Abstract Geometry Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 5;

    /**
     * The number of operations of the '<em>Abstract Geometry Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGeometricPrimitiveTypeImpl <em>Abstract Geometric Primitive Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGeometricPrimitiveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGeometricPrimitiveType()
     * @generated
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE = 21;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME_GROUP = ABSTRACT_GEOMETRY_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME = ABSTRACT_GEOMETRY_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__ID = ABSTRACT_GEOMETRY_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__GID = ABSTRACT_GEOMETRY_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_NAME = ABSTRACT_GEOMETRY_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRY_TYPE__UOM_LABELS;

    /**
     * The number of structural features of the '<em>Abstract Geometric Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Geometric Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractCurveTypeImpl <em>Abstract Curve Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractCurveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractCurveType()
     * @generated
     */
    int ABSTRACT_CURVE_TYPE = 8;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE__NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE__ID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE__GID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__UOM_LABELS;

    /**
     * The number of structural features of the '<em>Abstract Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_CURVE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractDatumBaseTypeImpl <em>Abstract Datum Base Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractDatumBaseTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractDatumBaseType()
     * @generated
     */
    int ABSTRACT_DATUM_BASE_TYPE = 9;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_BASE_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_BASE_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_BASE_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_BASE_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_BASE_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Datum Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_BASE_TYPE__DATUM_NAME = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract Datum Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_BASE_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract Datum Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_BASE_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractDatumTypeImpl <em>Abstract Datum Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractDatumTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractDatumType()
     * @generated
     */
    int ABSTRACT_DATUM_TYPE = 10;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__META_DATA_PROPERTY = ABSTRACT_DATUM_BASE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__DESCRIPTION = ABSTRACT_DATUM_BASE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__NAME_GROUP = ABSTRACT_DATUM_BASE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__NAME = ABSTRACT_DATUM_BASE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__ID = ABSTRACT_DATUM_BASE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Datum Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__DATUM_NAME = ABSTRACT_DATUM_BASE_TYPE__DATUM_NAME;

    /**
     * The feature id for the '<em><b>Datum ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__DATUM_ID = ABSTRACT_DATUM_BASE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__REMARKS = ABSTRACT_DATUM_BASE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Anchor Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__ANCHOR_POINT = ABSTRACT_DATUM_BASE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__REALIZATION_EPOCH = ABSTRACT_DATUM_BASE_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__VALID_AREA = ABSTRACT_DATUM_BASE_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE__SCOPE = ABSTRACT_DATUM_BASE_TYPE_FEATURE_COUNT + 5;

    /**
     * The number of structural features of the '<em>Abstract Datum Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE_FEATURE_COUNT = ABSTRACT_DATUM_BASE_TYPE_FEATURE_COUNT + 6;

    /**
     * The number of operations of the '<em>Abstract Datum Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DATUM_TYPE_OPERATION_COUNT = ABSTRACT_DATUM_BASE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractDiscreteCoverageTypeImpl <em>Abstract Discrete Coverage Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractDiscreteCoverageTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractDiscreteCoverageType()
     * @generated
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE = 11;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_COVERAGE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_COVERAGE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME_GROUP = ABSTRACT_COVERAGE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME = ABSTRACT_COVERAGE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__ID = ABSTRACT_COVERAGE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_COVERAGE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_COVERAGE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION = ABSTRACT_COVERAGE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_COVERAGE_TYPE__DOMAIN_SET_GROUP;

    /**
     * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_COVERAGE_TYPE__DOMAIN_SET;

    /**
     * The feature id for the '<em><b>Range Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__RANGE_SET = ABSTRACT_COVERAGE_TYPE__RANGE_SET;

    /**
     * The feature id for the '<em><b>Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__DIMENSION = ABSTRACT_COVERAGE_TYPE__DIMENSION;

    /**
     * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE__COVERAGE_FUNCTION = ABSTRACT_COVERAGE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract Discrete Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_COVERAGE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract Discrete Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_DISCRETE_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_COVERAGE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractFeatureCollectionTypeImpl <em>Abstract Feature Collection Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractFeatureCollectionTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractFeatureCollectionType()
     * @generated
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE = 12;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE__DESCRIPTION = ABSTRACT_FEATURE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE__NAME_GROUP = ABSTRACT_FEATURE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE__NAME = ABSTRACT_FEATURE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE__ID = ABSTRACT_FEATURE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE__LOCATION = ABSTRACT_FEATURE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Feature Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE__FEATURE_MEMBER = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Feature Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE__FEATURE_MEMBERS = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Abstract Feature Collection Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Abstract Feature Collection Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_FEATURE_COLLECTION_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGeneralConversionTypeImpl <em>Abstract General Conversion Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGeneralConversionTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGeneralConversionType()
     * @generated
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE = 14;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_OPERATION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__ID = ABSTRACT_COORDINATE_OPERATION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Coordinate Operation Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__COORDINATE_OPERATION_NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_NAME;

    /**
     * The feature id for the '<em><b>Coordinate Operation ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__COORDINATE_OPERATION_ID = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__REMARKS = ABSTRACT_COORDINATE_OPERATION_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Operation Version</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__OPERATION_VERSION = ABSTRACT_COORDINATE_OPERATION_TYPE__OPERATION_VERSION;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__VALID_AREA = ABSTRACT_COORDINATE_OPERATION_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__SCOPE = ABSTRACT_COORDINATE_OPERATION_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Positional Accuracy Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__POSITIONAL_ACCURACY_GROUP = ABSTRACT_COORDINATE_OPERATION_TYPE__POSITIONAL_ACCURACY_GROUP;

    /**
     * The feature id for the '<em><b>Positional Accuracy</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__POSITIONAL_ACCURACY = ABSTRACT_COORDINATE_OPERATION_TYPE__POSITIONAL_ACCURACY;

    /**
     * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__SOURCE_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__SOURCE_CRS;

    /**
     * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE__TARGET_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__TARGET_CRS;

    /**
     * The number of structural features of the '<em>Abstract General Conversion Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract General Conversion Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_CONVERSION_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractReferenceSystemBaseTypeImpl <em>Abstract Reference System Base Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractReferenceSystemBaseTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractReferenceSystemBaseType()
     * @generated
     */
    int ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE = 28;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__SRS_NAME = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract Reference System Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract Reference System Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractReferenceSystemTypeImpl <em>Abstract Reference System Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractReferenceSystemTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractReferenceSystemType()
     * @generated
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE = 29;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE__META_DATA_PROPERTY = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE__DESCRIPTION = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME_GROUP = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE__ID = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_NAME = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Srs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_ID = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE__REMARKS = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE__VALID_AREA = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE__SCOPE = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the '<em>Abstract Reference System Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of operations of the '<em>Abstract Reference System Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT = ABSTRACT_REFERENCE_SYSTEM_BASE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGeneralDerivedCRSTypeImpl <em>Abstract General Derived CRS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGeneralDerivedCRSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGeneralDerivedCRSType()
     * @generated
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE = 15;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_REFERENCE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DESCRIPTION = ABSTRACT_REFERENCE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__NAME_GROUP = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__SRS_NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Srs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__SRS_ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__REMARKS = ABSTRACT_REFERENCE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__VALID_AREA = ABSTRACT_REFERENCE_SYSTEM_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__SCOPE = ABSTRACT_REFERENCE_SYSTEM_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Base CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__BASE_CRS = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Defined By Conversion</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DEFINED_BY_CONVERSION = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Abstract General Derived CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Abstract General Derived CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_DERIVED_CRS_TYPE_OPERATION_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGeneralOperationParameterRefTypeImpl <em>Abstract General Operation Parameter Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGeneralOperationParameterRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGeneralOperationParameterRefType()
     * @generated
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE = 16;

    /**
     * The feature id for the '<em><b>General Operation Parameter Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE__GENERAL_OPERATION_PARAMETER_GROUP = 0;

    /**
     * The feature id for the '<em><b>General Operation Parameter</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE__GENERAL_OPERATION_PARAMETER = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Abstract General Operation Parameter Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Abstract General Operation Parameter Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGeneralOperationParameterTypeImpl <em>Abstract General Operation Parameter Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGeneralOperationParameterTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGeneralOperationParameterType()
     * @generated
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE = 17;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Minimum Occurs</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__MINIMUM_OCCURS = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract General Operation Parameter Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract General Operation Parameter Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGeneralParameterValueTypeImpl <em>Abstract General Parameter Value Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGeneralParameterValueTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGeneralParameterValueType()
     * @generated
     */
    int ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE = 18;

    /**
     * The number of structural features of the '<em>Abstract General Parameter Value Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT = 0;

    /**
     * The number of operations of the '<em>Abstract General Parameter Value Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGeneralTransformationTypeImpl <em>Abstract General Transformation Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGeneralTransformationTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGeneralTransformationType()
     * @generated
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE = 19;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_OPERATION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__ID = ABSTRACT_COORDINATE_OPERATION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Coordinate Operation Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__COORDINATE_OPERATION_NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_NAME;

    /**
     * The feature id for the '<em><b>Coordinate Operation ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__COORDINATE_OPERATION_ID = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__REMARKS = ABSTRACT_COORDINATE_OPERATION_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Operation Version</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__OPERATION_VERSION = ABSTRACT_COORDINATE_OPERATION_TYPE__OPERATION_VERSION;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__VALID_AREA = ABSTRACT_COORDINATE_OPERATION_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__SCOPE = ABSTRACT_COORDINATE_OPERATION_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Positional Accuracy Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__POSITIONAL_ACCURACY_GROUP = ABSTRACT_COORDINATE_OPERATION_TYPE__POSITIONAL_ACCURACY_GROUP;

    /**
     * The feature id for the '<em><b>Positional Accuracy</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__POSITIONAL_ACCURACY = ABSTRACT_COORDINATE_OPERATION_TYPE__POSITIONAL_ACCURACY;

    /**
     * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__SOURCE_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__SOURCE_CRS;

    /**
     * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__TARGET_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__TARGET_CRS;

    /**
     * The number of structural features of the '<em>Abstract General Transformation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract General Transformation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GENERAL_TRANSFORMATION_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGeometricAggregateTypeImpl <em>Abstract Geometric Aggregate Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGeometricAggregateTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGeometricAggregateType()
     * @generated
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE = 20;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME_GROUP = ABSTRACT_GEOMETRY_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME = ABSTRACT_GEOMETRY_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID = ABSTRACT_GEOMETRY_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__GID = ABSTRACT_GEOMETRY_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME = ABSTRACT_GEOMETRY_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRY_TYPE__UOM_LABELS;

    /**
     * The number of structural features of the '<em>Abstract Geometric Aggregate Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Geometric Aggregate Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractSurfacePatchTypeImpl <em>Abstract Surface Patch Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractSurfacePatchTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractSurfacePatchType()
     * @generated
     */
    int ABSTRACT_SURFACE_PATCH_TYPE = 34;

    /**
     * The number of structural features of the '<em>Abstract Surface Patch Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT = 0;

    /**
     * The number of operations of the '<em>Abstract Surface Patch Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_PATCH_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractParametricCurveSurfaceTypeImpl <em>Abstract Parametric Curve Surface Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractParametricCurveSurfaceTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractParametricCurveSurfaceType()
     * @generated
     */
    int ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE = 26;

    /**
     * The number of structural features of the '<em>Abstract Parametric Curve Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Parametric Curve Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_PATCH_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractGriddedSurfaceTypeImpl <em>Abstract Gridded Surface Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractGriddedSurfaceTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractGriddedSurfaceType()
     * @generated
     */
    int ABSTRACT_GRIDDED_SURFACE_TYPE = 24;

    /**
     * The feature id for the '<em><b>Row</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GRIDDED_SURFACE_TYPE__ROW = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Rows</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Columns</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GRIDDED_SURFACE_TYPE__COLUMNS = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Abstract Gridded Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Abstract Gridded Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_GRIDDED_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractMetaDataTypeImpl <em>Abstract Meta Data Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractMetaDataTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractMetaDataType()
     * @generated
     */
    int ABSTRACT_META_DATA_TYPE = 25;

    /**
     * The feature id for the '<em><b>Mixed</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_META_DATA_TYPE__MIXED = 0;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_META_DATA_TYPE__ID = 1;

    /**
     * The number of structural features of the '<em>Abstract Meta Data Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_META_DATA_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Abstract Meta Data Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_META_DATA_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractRingPropertyTypeImpl <em>Abstract Ring Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractRingPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractRingPropertyType()
     * @generated
     */
    int ABSTRACT_RING_PROPERTY_TYPE = 30;

    /**
     * The feature id for the '<em><b>Ring Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_PROPERTY_TYPE__RING_GROUP = 0;

    /**
     * The feature id for the '<em><b>Ring</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_PROPERTY_TYPE__RING = 1;

    /**
     * The number of structural features of the '<em>Abstract Ring Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_PROPERTY_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Abstract Ring Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractRingTypeImpl <em>Abstract Ring Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractRingTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractRingType()
     * @generated
     */
    int ABSTRACT_RING_TYPE = 31;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE__DESCRIPTION = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE__NAME_GROUP = ABSTRACT_GEOMETRY_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE__NAME = ABSTRACT_GEOMETRY_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE__ID = ABSTRACT_GEOMETRY_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE__GID = ABSTRACT_GEOMETRY_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE__SRS_NAME = ABSTRACT_GEOMETRY_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE__UOM_LABELS = ABSTRACT_GEOMETRY_TYPE__UOM_LABELS;

    /**
     * The number of structural features of the '<em>Abstract Ring Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Ring Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_RING_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractSolidTypeImpl <em>Abstract Solid Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractSolidTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractSolidType()
     * @generated
     */
    int ABSTRACT_SOLID_TYPE = 32;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE__NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE__ID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE__GID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__UOM_LABELS;

    /**
     * The number of structural features of the '<em>Abstract Solid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Solid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SOLID_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractStyleTypeImpl <em>Abstract Style Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractStyleTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractStyleType()
     * @generated
     */
    int ABSTRACT_STYLE_TYPE = 33;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_STYLE_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_STYLE_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_STYLE_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_STYLE_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_STYLE_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The number of structural features of the '<em>Abstract Style Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_STYLE_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Style Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_STYLE_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractSurfaceTypeImpl <em>Abstract Surface Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractSurfaceTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractSurfaceType()
     * @generated
     */
    int ABSTRACT_SURFACE_TYPE = 35;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE__NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE__ID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE__GID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__UOM_LABELS;

    /**
     * The number of structural features of the '<em>Abstract Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractTimeObjectTypeImpl <em>Abstract Time Object Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractTimeObjectTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractTimeObjectType()
     * @generated
     */
    int ABSTRACT_TIME_OBJECT_TYPE = 38;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_OBJECT_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_OBJECT_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_OBJECT_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_OBJECT_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_OBJECT_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The number of structural features of the '<em>Abstract Time Object Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_OBJECT_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Time Object Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_OBJECT_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractTimeComplexTypeImpl <em>Abstract Time Complex Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractTimeComplexTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractTimeComplexType()
     * @generated
     */
    int ABSTRACT_TIME_COMPLEX_TYPE = 36;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_COMPLEX_TYPE__META_DATA_PROPERTY = ABSTRACT_TIME_OBJECT_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_COMPLEX_TYPE__DESCRIPTION = ABSTRACT_TIME_OBJECT_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_COMPLEX_TYPE__NAME_GROUP = ABSTRACT_TIME_OBJECT_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_COMPLEX_TYPE__NAME = ABSTRACT_TIME_OBJECT_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_COMPLEX_TYPE__ID = ABSTRACT_TIME_OBJECT_TYPE__ID;

    /**
     * The number of structural features of the '<em>Abstract Time Complex Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_COMPLEX_TYPE_FEATURE_COUNT = ABSTRACT_TIME_OBJECT_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Time Complex Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_COMPLEX_TYPE_OPERATION_COUNT = ABSTRACT_TIME_OBJECT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractTimePrimitiveTypeImpl <em>Abstract Time Primitive Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractTimePrimitiveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractTimePrimitiveType()
     * @generated
     */
    int ABSTRACT_TIME_PRIMITIVE_TYPE = 39;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_PRIMITIVE_TYPE__META_DATA_PROPERTY = ABSTRACT_TIME_OBJECT_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_PRIMITIVE_TYPE__DESCRIPTION = ABSTRACT_TIME_OBJECT_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_PRIMITIVE_TYPE__NAME_GROUP = ABSTRACT_TIME_OBJECT_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_PRIMITIVE_TYPE__NAME = ABSTRACT_TIME_OBJECT_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_PRIMITIVE_TYPE__ID = ABSTRACT_TIME_OBJECT_TYPE__ID;

    /**
     * The feature id for the '<em><b>Related Time</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_PRIMITIVE_TYPE__RELATED_TIME = ABSTRACT_TIME_OBJECT_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract Time Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_PRIMITIVE_TYPE_FEATURE_COUNT = ABSTRACT_TIME_OBJECT_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract Time Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_PRIMITIVE_TYPE_OPERATION_COUNT = ABSTRACT_TIME_OBJECT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractTimeGeometricPrimitiveTypeImpl <em>Abstract Time Geometric Primitive Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractTimeGeometricPrimitiveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractTimeGeometricPrimitiveType()
     * @generated
     */
    int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE = 37;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY = ABSTRACT_TIME_PRIMITIVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION = ABSTRACT_TIME_PRIMITIVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__NAME_GROUP = ABSTRACT_TIME_PRIMITIVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__NAME = ABSTRACT_TIME_PRIMITIVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__ID = ABSTRACT_TIME_PRIMITIVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Related Time</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__RELATED_TIME = ABSTRACT_TIME_PRIMITIVE_TYPE__RELATED_TIME;

    /**
     * The feature id for the '<em><b>Frame</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__FRAME = ABSTRACT_TIME_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract Time Geometric Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT = ABSTRACT_TIME_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract Time Geometric Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT = ABSTRACT_TIME_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractTimeReferenceSystemTypeImpl <em>Abstract Time Reference System Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractTimeReferenceSystemTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractTimeReferenceSystemType()
     * @generated
     */
    int ABSTRACT_TIME_REFERENCE_SYSTEM_TYPE = 40;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_REFERENCE_SYSTEM_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_REFERENCE_SYSTEM_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_REFERENCE_SYSTEM_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_REFERENCE_SYSTEM_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_REFERENCE_SYSTEM_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Domain Of Validity</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_REFERENCE_SYSTEM_TYPE__DOMAIN_OF_VALIDITY = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract Time Reference System Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract Time Reference System Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractTimeSliceTypeImpl <em>Abstract Time Slice Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractTimeSliceTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractTimeSliceType()
     * @generated
     */
    int ABSTRACT_TIME_SLICE_TYPE = 41;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_SLICE_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_SLICE_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_SLICE_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_SLICE_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_SLICE_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_SLICE_TYPE__VALID_TIME = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Data Source</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_SLICE_TYPE__DATA_SOURCE = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Abstract Time Slice Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Abstract Time Slice Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_SLICE_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractTimeTopologyPrimitiveTypeImpl <em>Abstract Time Topology Primitive Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractTimeTopologyPrimitiveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractTimeTopologyPrimitiveType()
     * @generated
     */
    int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE = 42;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__META_DATA_PROPERTY = ABSTRACT_TIME_PRIMITIVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__DESCRIPTION = ABSTRACT_TIME_PRIMITIVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__NAME_GROUP = ABSTRACT_TIME_PRIMITIVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__NAME = ABSTRACT_TIME_PRIMITIVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__ID = ABSTRACT_TIME_PRIMITIVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Related Time</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__RELATED_TIME = ABSTRACT_TIME_PRIMITIVE_TYPE__RELATED_TIME;

    /**
     * The feature id for the '<em><b>Complex</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__COMPLEX = ABSTRACT_TIME_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Abstract Time Topology Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE_FEATURE_COUNT = ABSTRACT_TIME_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Abstract Time Topology Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE_OPERATION_COUNT = ABSTRACT_TIME_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractTopologyTypeImpl <em>Abstract Topology Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractTopologyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractTopologyType()
     * @generated
     */
    int ABSTRACT_TOPOLOGY_TYPE = 43;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPOLOGY_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPOLOGY_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPOLOGY_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPOLOGY_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPOLOGY_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The number of structural features of the '<em>Abstract Topology Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPOLOGY_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Abstract Topology Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPOLOGY_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AbstractTopoPrimitiveTypeImpl <em>Abstract Topo Primitive Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AbstractTopoPrimitiveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAbstractTopoPrimitiveType()
     * @generated
     */
    int ABSTRACT_TOPO_PRIMITIVE_TYPE = 44;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPO_PRIMITIVE_TYPE__META_DATA_PROPERTY = ABSTRACT_TOPOLOGY_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION = ABSTRACT_TOPOLOGY_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME_GROUP = ABSTRACT_TOPOLOGY_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME = ABSTRACT_TOPOLOGY_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPO_PRIMITIVE_TYPE__ID = ABSTRACT_TOPOLOGY_TYPE__ID;

    /**
     * The feature id for the '<em><b>Isolated</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPO_PRIMITIVE_TYPE__ISOLATED = ABSTRACT_TOPOLOGY_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Container</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPO_PRIMITIVE_TYPE__CONTAINER = ABSTRACT_TOPOLOGY_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Abstract Topo Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT = ABSTRACT_TOPOLOGY_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Abstract Topo Primitive Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ABSTRACT_TOPO_PRIMITIVE_TYPE_OPERATION_COUNT = ABSTRACT_TOPOLOGY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AffinePlacementTypeImpl <em>Affine Placement Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AffinePlacementTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAffinePlacementType()
     * @generated
     */
    int AFFINE_PLACEMENT_TYPE = 45;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AFFINE_PLACEMENT_TYPE__LOCATION = 0;

    /**
     * The feature id for the '<em><b>Ref Direction</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AFFINE_PLACEMENT_TYPE__REF_DIRECTION = 1;

    /**
     * The feature id for the '<em><b>In Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AFFINE_PLACEMENT_TYPE__IN_DIMENSION = 2;

    /**
     * The feature id for the '<em><b>Out Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AFFINE_PLACEMENT_TYPE__OUT_DIMENSION = 3;

    /**
     * The number of structural features of the '<em>Affine Placement Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AFFINE_PLACEMENT_TYPE_FEATURE_COUNT = 4;

    /**
     * The number of operations of the '<em>Affine Placement Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AFFINE_PLACEMENT_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AngleChoiceTypeImpl <em>Angle Choice Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AngleChoiceTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAngleChoiceType()
     * @generated
     */
    int ANGLE_CHOICE_TYPE = 46;

    /**
     * The feature id for the '<em><b>Angle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ANGLE_CHOICE_TYPE__ANGLE = 0;

    /**
     * The feature id for the '<em><b>Dms Angle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ANGLE_CHOICE_TYPE__DMS_ANGLE = 1;

    /**
     * The number of structural features of the '<em>Angle Choice Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ANGLE_CHOICE_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Angle Choice Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ANGLE_CHOICE_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MeasureTypeImpl <em>Measure Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MeasureTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMeasureType()
     * @generated
     */
    int MEASURE_TYPE = 216;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_TYPE__UOM = 1;

    /**
     * The number of structural features of the '<em>Measure Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Measure Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AngleTypeImpl <em>Angle Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AngleTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAngleType()
     * @generated
     */
    int ANGLE_TYPE = 47;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ANGLE_TYPE__VALUE = MEASURE_TYPE__VALUE;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ANGLE_TYPE__UOM = MEASURE_TYPE__UOM;

    /**
     * The number of structural features of the '<em>Angle Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ANGLE_TYPE_FEATURE_COUNT = MEASURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Angle Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ANGLE_TYPE_OPERATION_COUNT = MEASURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ArcStringByBulgeTypeImpl <em>Arc String By Bulge Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ArcStringByBulgeTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getArcStringByBulgeType()
     * @generated
     */
    int ARC_STRING_BY_BULGE_TYPE = 50;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Bulge</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__BULGE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

    /**
     * The feature id for the '<em><b>Normal</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__NORMAL = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 8;

    /**
     * The feature id for the '<em><b>Num Arc</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE__NUM_ARC = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 9;

    /**
     * The number of structural features of the '<em>Arc String By Bulge Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 10;

    /**
     * The number of operations of the '<em>Arc String By Bulge Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_BY_BULGE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ArcByBulgeTypeImpl <em>Arc By Bulge Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ArcByBulgeTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getArcByBulgeType()
     * @generated
     */
    int ARC_BY_BULGE_TYPE = 48;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__NUM_DERIVATIVE_INTERIOR = ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_END = ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_START = ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__GROUP = ARC_STRING_BY_BULGE_TYPE__GROUP;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__POS = ARC_STRING_BY_BULGE_TYPE__POS;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__POINT_PROPERTY = ARC_STRING_BY_BULGE_TYPE__POINT_PROPERTY;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__POINT_REP = ARC_STRING_BY_BULGE_TYPE__POINT_REP;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__POS_LIST = ARC_STRING_BY_BULGE_TYPE__POS_LIST;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__COORDINATES = ARC_STRING_BY_BULGE_TYPE__COORDINATES;

    /**
     * The feature id for the '<em><b>Bulge</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__BULGE = ARC_STRING_BY_BULGE_TYPE__BULGE;

    /**
     * The feature id for the '<em><b>Normal</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__NORMAL = ARC_STRING_BY_BULGE_TYPE__NORMAL;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__INTERPOLATION = ARC_STRING_BY_BULGE_TYPE__INTERPOLATION;

    /**
     * The feature id for the '<em><b>Num Arc</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE__NUM_ARC = ARC_STRING_BY_BULGE_TYPE__NUM_ARC;

    /**
     * The number of structural features of the '<em>Arc By Bulge Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE_FEATURE_COUNT = ARC_STRING_BY_BULGE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Arc By Bulge Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_BULGE_TYPE_OPERATION_COUNT = ARC_STRING_BY_BULGE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ArcByCenterPointTypeImpl <em>Arc By Center Point Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ArcByCenterPointTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getArcByCenterPointType()
     * @generated
     */
    int ARC_BY_CENTER_POINT_TYPE = 49;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Radius</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__RADIUS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Start Angle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__START_ANGLE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

    /**
     * The feature id for the '<em><b>End Angle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__END_ANGLE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 8;

    /**
     * The feature id for the '<em><b>Num Arc</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE__NUM_ARC = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 9;

    /**
     * The number of structural features of the '<em>Arc By Center Point Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 10;

    /**
     * The number of operations of the '<em>Arc By Center Point Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_BY_CENTER_POINT_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ArcStringTypeImpl <em>Arc String Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ArcStringTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getArcStringType()
     * @generated
     */
    int ARC_STRING_TYPE = 51;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

    /**
     * The feature id for the '<em><b>Num Arc</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE__NUM_ARC = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

    /**
     * The number of structural features of the '<em>Arc String Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 8;

    /**
     * The number of operations of the '<em>Arc String Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_STRING_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ArcTypeImpl <em>Arc Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ArcTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getArcType()
     * @generated
     */
    int ARC_TYPE = 52;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__NUM_DERIVATIVE_INTERIOR = ARC_STRING_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__NUM_DERIVATIVES_AT_END = ARC_STRING_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__NUM_DERIVATIVES_AT_START = ARC_STRING_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__GROUP = ARC_STRING_TYPE__GROUP;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__POS = ARC_STRING_TYPE__POS;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__POINT_PROPERTY = ARC_STRING_TYPE__POINT_PROPERTY;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__POINT_REP = ARC_STRING_TYPE__POINT_REP;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__POS_LIST = ARC_STRING_TYPE__POS_LIST;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__COORDINATES = ARC_STRING_TYPE__COORDINATES;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__INTERPOLATION = ARC_STRING_TYPE__INTERPOLATION;

    /**
     * The feature id for the '<em><b>Num Arc</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE__NUM_ARC = ARC_STRING_TYPE__NUM_ARC;

    /**
     * The number of structural features of the '<em>Arc Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE_FEATURE_COUNT = ARC_STRING_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Arc Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARC_TYPE_OPERATION_COUNT = ARC_STRING_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AreaTypeImpl <em>Area Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AreaTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAreaType()
     * @generated
     */
    int AREA_TYPE = 53;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AREA_TYPE__VALUE = MEASURE_TYPE__VALUE;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AREA_TYPE__UOM = MEASURE_TYPE__UOM;

    /**
     * The number of structural features of the '<em>Area Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AREA_TYPE_FEATURE_COUNT = MEASURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Area Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AREA_TYPE_OPERATION_COUNT = MEASURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ArrayAssociationTypeImpl <em>Array Association Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ArrayAssociationTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getArrayAssociationType()
     * @generated
     */
    int ARRAY_ASSOCIATION_TYPE = 54;

    /**
     * The feature id for the '<em><b>Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_ASSOCIATION_TYPE__OBJECT_GROUP = 0;

    /**
     * The feature id for the '<em><b>Object</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_ASSOCIATION_TYPE__OBJECT = 1;

    /**
     * The number of structural features of the '<em>Array Association Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_ASSOCIATION_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Array Association Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_ASSOCIATION_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ArrayTypeImpl <em>Array Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ArrayTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getArrayType()
     * @generated
     */
    int ARRAY_TYPE = 55;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The feature id for the '<em><b>Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_TYPE__MEMBERS = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Array Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Array Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARRAY_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.AssociationTypeImpl <em>Association Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.AssociationTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getAssociationType()
     * @generated
     */
    int ASSOCIATION_TYPE = 56;

    /**
     * The feature id for the '<em><b>Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE__OBJECT_GROUP = 0;

    /**
     * The feature id for the '<em><b>Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE__OBJECT = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Association Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Association Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.BagTypeImpl <em>Bag Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.BagTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getBagType()
     * @generated
     */
    int BAG_TYPE = 57;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BAG_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BAG_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BAG_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BAG_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BAG_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The feature id for the '<em><b>Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BAG_TYPE__MEMBER = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BAG_TYPE__MEMBERS = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Bag Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BAG_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Bag Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BAG_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.BaseStyleDescriptorTypeImpl <em>Base Style Descriptor Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.BaseStyleDescriptorTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getBaseStyleDescriptorType()
     * @generated
     */
    int BASE_STYLE_DESCRIPTOR_TYPE = 58;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The feature id for the '<em><b>Spatial Resolution</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__SPATIAL_RESOLUTION = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Style Variation</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__STYLE_VARIATION = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Animate</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Animate Motion</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE_MOTION = ABSTRACT_GML_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Animate Color</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE_COLOR = ABSTRACT_GML_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Set</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE__SET = ABSTRACT_GML_TYPE_FEATURE_COUNT + 5;

    /**
     * The number of structural features of the '<em>Base Style Descriptor Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 6;

    /**
     * The number of operations of the '<em>Base Style Descriptor Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_STYLE_DESCRIPTOR_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.UnitDefinitionTypeImpl <em>Unit Definition Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.UnitDefinitionTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getUnitDefinitionType()
     * @generated
     */
    int UNIT_DEFINITION_TYPE = 371;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_DEFINITION_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_DEFINITION_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_DEFINITION_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_DEFINITION_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_DEFINITION_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Quantity Type</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_DEFINITION_TYPE__QUANTITY_TYPE = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Catalog Symbol</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_DEFINITION_TYPE__CATALOG_SYMBOL = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Unit Definition Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_DEFINITION_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Unit Definition Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_DEFINITION_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.BaseUnitTypeImpl <em>Base Unit Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.BaseUnitTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getBaseUnitType()
     * @generated
     */
    int BASE_UNIT_TYPE = 59;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_UNIT_TYPE__META_DATA_PROPERTY = UNIT_DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_UNIT_TYPE__DESCRIPTION = UNIT_DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_UNIT_TYPE__NAME_GROUP = UNIT_DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_UNIT_TYPE__NAME = UNIT_DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_UNIT_TYPE__ID = UNIT_DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Quantity Type</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_UNIT_TYPE__QUANTITY_TYPE = UNIT_DEFINITION_TYPE__QUANTITY_TYPE;

    /**
     * The feature id for the '<em><b>Catalog Symbol</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_UNIT_TYPE__CATALOG_SYMBOL = UNIT_DEFINITION_TYPE__CATALOG_SYMBOL;

    /**
     * The feature id for the '<em><b>Units System</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_UNIT_TYPE__UNITS_SYSTEM = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Base Unit Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_UNIT_TYPE_FEATURE_COUNT = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Base Unit Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BASE_UNIT_TYPE_OPERATION_COUNT = UNIT_DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.BSplineTypeImpl <em>BSpline Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.BSplineTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getBSplineType()
     * @generated
     */
    int BSPLINE_TYPE = 64;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Degree</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__DEGREE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

    /**
     * The feature id for the '<em><b>Knot</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__KNOT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 8;

    /**
     * The feature id for the '<em><b>Is Polynomial</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__IS_POLYNOMIAL = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 9;

    /**
     * The feature id for the '<em><b>Knot Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE__KNOT_TYPE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 10;

    /**
     * The number of structural features of the '<em>BSpline Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 11;

    /**
     * The number of operations of the '<em>BSpline Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BSPLINE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.BezierTypeImpl <em>Bezier Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.BezierTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getBezierType()
     * @generated
     */
    int BEZIER_TYPE = 60;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__NUM_DERIVATIVE_INTERIOR = BSPLINE_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__NUM_DERIVATIVES_AT_END = BSPLINE_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__NUM_DERIVATIVES_AT_START = BSPLINE_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__GROUP = BSPLINE_TYPE__GROUP;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__POS = BSPLINE_TYPE__POS;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__POINT_PROPERTY = BSPLINE_TYPE__POINT_PROPERTY;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__POINT_REP = BSPLINE_TYPE__POINT_REP;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__POS_LIST = BSPLINE_TYPE__POS_LIST;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__COORDINATES = BSPLINE_TYPE__COORDINATES;

    /**
     * The feature id for the '<em><b>Degree</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__DEGREE = BSPLINE_TYPE__DEGREE;

    /**
     * The feature id for the '<em><b>Knot</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__KNOT = BSPLINE_TYPE__KNOT;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__INTERPOLATION = BSPLINE_TYPE__INTERPOLATION;

    /**
     * The feature id for the '<em><b>Is Polynomial</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__IS_POLYNOMIAL = BSPLINE_TYPE__IS_POLYNOMIAL;

    /**
     * The feature id for the '<em><b>Knot Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE__KNOT_TYPE = BSPLINE_TYPE__KNOT_TYPE;

    /**
     * The number of structural features of the '<em>Bezier Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE_FEATURE_COUNT = BSPLINE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Bezier Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BEZIER_TYPE_OPERATION_COUNT = BSPLINE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ValuePropertyTypeImpl <em>Value Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ValuePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getValuePropertyType()
     * @generated
     */
    int VALUE_PROPERTY_TYPE = 377;

    /**
     * The feature id for the '<em><b>Boolean</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__BOOLEAN = 0;

    /**
     * The feature id for the '<em><b>Category</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__CATEGORY = 1;

    /**
     * The feature id for the '<em><b>Quantity</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__QUANTITY = 2;

    /**
     * The feature id for the '<em><b>Count</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__COUNT = 3;

    /**
     * The feature id for the '<em><b>Boolean List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__BOOLEAN_LIST = 4;

    /**
     * The feature id for the '<em><b>Category List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__CATEGORY_LIST = 5;

    /**
     * The feature id for the '<em><b>Quantity List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__QUANTITY_LIST = 6;

    /**
     * The feature id for the '<em><b>Count List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__COUNT_LIST = 7;

    /**
     * The feature id for the '<em><b>Category Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__CATEGORY_EXTENT = 8;

    /**
     * The feature id for the '<em><b>Quantity Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__QUANTITY_EXTENT = 9;

    /**
     * The feature id for the '<em><b>Count Extent</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__COUNT_EXTENT = 10;

    /**
     * The feature id for the '<em><b>Composite Value Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__COMPOSITE_VALUE_GROUP = 11;

    /**
     * The feature id for the '<em><b>Composite Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__COMPOSITE_VALUE = 12;

    /**
     * The feature id for the '<em><b>Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__OBJECT_GROUP = 13;

    /**
     * The feature id for the '<em><b>Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__OBJECT = 14;

    /**
     * The feature id for the '<em><b>Null</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__NULL = 15;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__ACTUATE = 16;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__ARCROLE = 17;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__HREF = 18;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__REMOTE_SCHEMA = 19;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__ROLE = 20;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__SHOW = 21;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__TITLE = 22;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE__TYPE = 23;

    /**
     * The number of structural features of the '<em>Value Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE_FEATURE_COUNT = 24;

    /**
     * The number of operations of the '<em>Value Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int VALUE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.BooleanPropertyTypeImpl <em>Boolean Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.BooleanPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getBooleanPropertyType()
     * @generated
     */
    int BOOLEAN_PROPERTY_TYPE = 61;

    /**
     * The feature id for the '<em><b>Boolean</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__BOOLEAN = VALUE_PROPERTY_TYPE__BOOLEAN;

    /**
     * The feature id for the '<em><b>Category</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__CATEGORY = VALUE_PROPERTY_TYPE__CATEGORY;

    /**
     * The feature id for the '<em><b>Quantity</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__QUANTITY = VALUE_PROPERTY_TYPE__QUANTITY;

    /**
     * The feature id for the '<em><b>Count</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__COUNT = VALUE_PROPERTY_TYPE__COUNT;

    /**
     * The feature id for the '<em><b>Boolean List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__BOOLEAN_LIST = VALUE_PROPERTY_TYPE__BOOLEAN_LIST;

    /**
     * The feature id for the '<em><b>Category List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__CATEGORY_LIST = VALUE_PROPERTY_TYPE__CATEGORY_LIST;

    /**
     * The feature id for the '<em><b>Quantity List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__QUANTITY_LIST = VALUE_PROPERTY_TYPE__QUANTITY_LIST;

    /**
     * The feature id for the '<em><b>Count List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__COUNT_LIST = VALUE_PROPERTY_TYPE__COUNT_LIST;

    /**
     * The feature id for the '<em><b>Category Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__CATEGORY_EXTENT = VALUE_PROPERTY_TYPE__CATEGORY_EXTENT;

    /**
     * The feature id for the '<em><b>Quantity Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__QUANTITY_EXTENT = VALUE_PROPERTY_TYPE__QUANTITY_EXTENT;

    /**
     * The feature id for the '<em><b>Count Extent</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__COUNT_EXTENT = VALUE_PROPERTY_TYPE__COUNT_EXTENT;

    /**
     * The feature id for the '<em><b>Composite Value Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__COMPOSITE_VALUE_GROUP = VALUE_PROPERTY_TYPE__COMPOSITE_VALUE_GROUP;

    /**
     * The feature id for the '<em><b>Composite Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__COMPOSITE_VALUE = VALUE_PROPERTY_TYPE__COMPOSITE_VALUE;

    /**
     * The feature id for the '<em><b>Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__OBJECT_GROUP = VALUE_PROPERTY_TYPE__OBJECT_GROUP;

    /**
     * The feature id for the '<em><b>Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__OBJECT = VALUE_PROPERTY_TYPE__OBJECT;

    /**
     * The feature id for the '<em><b>Null</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__NULL = VALUE_PROPERTY_TYPE__NULL;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__ACTUATE = VALUE_PROPERTY_TYPE__ACTUATE;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__ARCROLE = VALUE_PROPERTY_TYPE__ARCROLE;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__HREF = VALUE_PROPERTY_TYPE__HREF;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__REMOTE_SCHEMA = VALUE_PROPERTY_TYPE__REMOTE_SCHEMA;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__ROLE = VALUE_PROPERTY_TYPE__ROLE;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__SHOW = VALUE_PROPERTY_TYPE__SHOW;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__TITLE = VALUE_PROPERTY_TYPE__TITLE;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE__TYPE = VALUE_PROPERTY_TYPE__TYPE;

    /**
     * The number of structural features of the '<em>Boolean Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE_FEATURE_COUNT = VALUE_PROPERTY_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Boolean Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOOLEAN_PROPERTY_TYPE_OPERATION_COUNT = VALUE_PROPERTY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.BoundedFeatureTypeImpl <em>Bounded Feature Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.BoundedFeatureTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getBoundedFeatureType()
     * @generated
     */
    int BOUNDED_FEATURE_TYPE = 62;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDED_FEATURE_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDED_FEATURE_TYPE__DESCRIPTION = ABSTRACT_FEATURE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDED_FEATURE_TYPE__NAME_GROUP = ABSTRACT_FEATURE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDED_FEATURE_TYPE__NAME = ABSTRACT_FEATURE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDED_FEATURE_TYPE__ID = ABSTRACT_FEATURE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDED_FEATURE_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDED_FEATURE_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDED_FEATURE_TYPE__LOCATION = ABSTRACT_FEATURE_TYPE__LOCATION;

    /**
     * The number of structural features of the '<em>Bounded Feature Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDED_FEATURE_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Bounded Feature Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDED_FEATURE_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.BoundingShapeTypeImpl <em>Bounding Shape Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.BoundingShapeTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getBoundingShapeType()
     * @generated
     */
    int BOUNDING_SHAPE_TYPE = 63;

    /**
     * The feature id for the '<em><b>Envelope Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDING_SHAPE_TYPE__ENVELOPE_GROUP = 0;

    /**
     * The feature id for the '<em><b>Envelope</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDING_SHAPE_TYPE__ENVELOPE = 1;

    /**
     * The feature id for the '<em><b>Null</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDING_SHAPE_TYPE__NULL = 2;

    /**
     * The number of structural features of the '<em>Bounding Shape Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDING_SHAPE_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>Bounding Shape Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int BOUNDING_SHAPE_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CartesianCSRefTypeImpl <em>Cartesian CS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CartesianCSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCartesianCSRefType()
     * @generated
     */
    int CARTESIAN_CS_REF_TYPE = 65;

    /**
     * The feature id for the '<em><b>Cartesian CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE__CARTESIAN_CS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Cartesian CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Cartesian CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CartesianCSTypeImpl <em>Cartesian CS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CartesianCSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCartesianCSType()
     * @generated
     */
    int CARTESIAN_CS_TYPE = 66;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Cs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE__CS_NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_NAME;

    /**
     * The feature id for the '<em><b>Cs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE__CS_ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Uses Axis</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE__USES_AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__USES_AXIS;

    /**
     * The number of structural features of the '<em>Cartesian CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Cartesian CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CARTESIAN_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CodeOrNullListTypeImpl <em>Code Or Null List Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CodeOrNullListTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCodeOrNullListType()
     * @generated
     */
    int CODE_OR_NULL_LIST_TYPE = 73;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_OR_NULL_LIST_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Code Space</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_OR_NULL_LIST_TYPE__CODE_SPACE = 1;

    /**
     * The number of structural features of the '<em>Code Or Null List Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_OR_NULL_LIST_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Code Or Null List Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_OR_NULL_LIST_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CategoryExtentTypeImpl <em>Category Extent Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CategoryExtentTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCategoryExtentType()
     * @generated
     */
    int CATEGORY_EXTENT_TYPE = 67;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_EXTENT_TYPE__VALUE = CODE_OR_NULL_LIST_TYPE__VALUE;

    /**
     * The feature id for the '<em><b>Code Space</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_EXTENT_TYPE__CODE_SPACE = CODE_OR_NULL_LIST_TYPE__CODE_SPACE;

    /**
     * The number of structural features of the '<em>Category Extent Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_EXTENT_TYPE_FEATURE_COUNT = CODE_OR_NULL_LIST_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Category Extent Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_EXTENT_TYPE_OPERATION_COUNT = CODE_OR_NULL_LIST_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CategoryPropertyTypeImpl <em>Category Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CategoryPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCategoryPropertyType()
     * @generated
     */
    int CATEGORY_PROPERTY_TYPE = 68;

    /**
     * The feature id for the '<em><b>Boolean</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__BOOLEAN = VALUE_PROPERTY_TYPE__BOOLEAN;

    /**
     * The feature id for the '<em><b>Category</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__CATEGORY = VALUE_PROPERTY_TYPE__CATEGORY;

    /**
     * The feature id for the '<em><b>Quantity</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__QUANTITY = VALUE_PROPERTY_TYPE__QUANTITY;

    /**
     * The feature id for the '<em><b>Count</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__COUNT = VALUE_PROPERTY_TYPE__COUNT;

    /**
     * The feature id for the '<em><b>Boolean List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__BOOLEAN_LIST = VALUE_PROPERTY_TYPE__BOOLEAN_LIST;

    /**
     * The feature id for the '<em><b>Category List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__CATEGORY_LIST = VALUE_PROPERTY_TYPE__CATEGORY_LIST;

    /**
     * The feature id for the '<em><b>Quantity List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__QUANTITY_LIST = VALUE_PROPERTY_TYPE__QUANTITY_LIST;

    /**
     * The feature id for the '<em><b>Count List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__COUNT_LIST = VALUE_PROPERTY_TYPE__COUNT_LIST;

    /**
     * The feature id for the '<em><b>Category Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__CATEGORY_EXTENT = VALUE_PROPERTY_TYPE__CATEGORY_EXTENT;

    /**
     * The feature id for the '<em><b>Quantity Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__QUANTITY_EXTENT = VALUE_PROPERTY_TYPE__QUANTITY_EXTENT;

    /**
     * The feature id for the '<em><b>Count Extent</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__COUNT_EXTENT = VALUE_PROPERTY_TYPE__COUNT_EXTENT;

    /**
     * The feature id for the '<em><b>Composite Value Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__COMPOSITE_VALUE_GROUP = VALUE_PROPERTY_TYPE__COMPOSITE_VALUE_GROUP;

    /**
     * The feature id for the '<em><b>Composite Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__COMPOSITE_VALUE = VALUE_PROPERTY_TYPE__COMPOSITE_VALUE;

    /**
     * The feature id for the '<em><b>Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__OBJECT_GROUP = VALUE_PROPERTY_TYPE__OBJECT_GROUP;

    /**
     * The feature id for the '<em><b>Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__OBJECT = VALUE_PROPERTY_TYPE__OBJECT;

    /**
     * The feature id for the '<em><b>Null</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__NULL = VALUE_PROPERTY_TYPE__NULL;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__ACTUATE = VALUE_PROPERTY_TYPE__ACTUATE;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__ARCROLE = VALUE_PROPERTY_TYPE__ARCROLE;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__HREF = VALUE_PROPERTY_TYPE__HREF;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__REMOTE_SCHEMA = VALUE_PROPERTY_TYPE__REMOTE_SCHEMA;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__ROLE = VALUE_PROPERTY_TYPE__ROLE;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__SHOW = VALUE_PROPERTY_TYPE__SHOW;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__TITLE = VALUE_PROPERTY_TYPE__TITLE;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE__TYPE = VALUE_PROPERTY_TYPE__TYPE;

    /**
     * The number of structural features of the '<em>Category Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE_FEATURE_COUNT = VALUE_PROPERTY_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Category Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CATEGORY_PROPERTY_TYPE_OPERATION_COUNT = VALUE_PROPERTY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CircleByCenterPointTypeImpl <em>Circle By Center Point Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CircleByCenterPointTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCircleByCenterPointType()
     * @generated
     */
    int CIRCLE_BY_CENTER_POINT_TYPE = 69;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__NUM_DERIVATIVE_INTERIOR = ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_END = ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_START = ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__POS = ARC_BY_CENTER_POINT_TYPE__POS;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__POINT_PROPERTY = ARC_BY_CENTER_POINT_TYPE__POINT_PROPERTY;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__POINT_REP = ARC_BY_CENTER_POINT_TYPE__POINT_REP;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__POS_LIST = ARC_BY_CENTER_POINT_TYPE__POS_LIST;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__COORDINATES = ARC_BY_CENTER_POINT_TYPE__COORDINATES;

    /**
     * The feature id for the '<em><b>Radius</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__RADIUS = ARC_BY_CENTER_POINT_TYPE__RADIUS;

    /**
     * The feature id for the '<em><b>Start Angle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__START_ANGLE = ARC_BY_CENTER_POINT_TYPE__START_ANGLE;

    /**
     * The feature id for the '<em><b>End Angle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__END_ANGLE = ARC_BY_CENTER_POINT_TYPE__END_ANGLE;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__INTERPOLATION = ARC_BY_CENTER_POINT_TYPE__INTERPOLATION;

    /**
     * The feature id for the '<em><b>Num Arc</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE__NUM_ARC = ARC_BY_CENTER_POINT_TYPE__NUM_ARC;

    /**
     * The number of structural features of the '<em>Circle By Center Point Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE_FEATURE_COUNT = ARC_BY_CENTER_POINT_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Circle By Center Point Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_BY_CENTER_POINT_TYPE_OPERATION_COUNT = ARC_BY_CENTER_POINT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CircleTypeImpl <em>Circle Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CircleTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCircleType()
     * @generated
     */
    int CIRCLE_TYPE = 70;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__NUM_DERIVATIVE_INTERIOR = ARC_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__NUM_DERIVATIVES_AT_END = ARC_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__NUM_DERIVATIVES_AT_START = ARC_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__GROUP = ARC_TYPE__GROUP;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__POS = ARC_TYPE__POS;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__POINT_PROPERTY = ARC_TYPE__POINT_PROPERTY;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__POINT_REP = ARC_TYPE__POINT_REP;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__POS_LIST = ARC_TYPE__POS_LIST;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__COORDINATES = ARC_TYPE__COORDINATES;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__INTERPOLATION = ARC_TYPE__INTERPOLATION;

    /**
     * The feature id for the '<em><b>Num Arc</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE__NUM_ARC = ARC_TYPE__NUM_ARC;

    /**
     * The number of structural features of the '<em>Circle Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE_FEATURE_COUNT = ARC_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Circle Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CIRCLE_TYPE_OPERATION_COUNT = ARC_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ClothoidTypeImpl <em>Clothoid Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ClothoidTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getClothoidType()
     * @generated
     */
    int CLOTHOID_TYPE = 71;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLOTHOID_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLOTHOID_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLOTHOID_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Ref Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLOTHOID_TYPE__REF_LOCATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Scale Factor</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLOTHOID_TYPE__SCALE_FACTOR = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Start Parameter</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLOTHOID_TYPE__START_PARAMETER = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>End Parameter</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLOTHOID_TYPE__END_PARAMETER = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the '<em>Clothoid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLOTHOID_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of operations of the '<em>Clothoid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CLOTHOID_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CodeListTypeImpl <em>Code List Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CodeListTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCodeListType()
     * @generated
     */
    int CODE_LIST_TYPE = 72;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_LIST_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Code Space</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_LIST_TYPE__CODE_SPACE = 1;

    /**
     * The number of structural features of the '<em>Code List Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_LIST_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Code List Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_LIST_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CodeTypeImpl <em>Code Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CodeTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCodeType()
     * @generated
     */
    int CODE_TYPE = 74;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Code Space</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_TYPE__CODE_SPACE = 1;

    /**
     * The number of structural features of the '<em>Code Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Code Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CODE_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CompositeCurvePropertyTypeImpl <em>Composite Curve Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CompositeCurvePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCompositeCurvePropertyType()
     * @generated
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE = 75;

    /**
     * The feature id for the '<em><b>Composite Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE__COMPOSITE_CURVE = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Composite Curve Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Composite Curve Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CompositeCurveTypeImpl <em>Composite Curve Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CompositeCurveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCompositeCurveType()
     * @generated
     */
    int COMPOSITE_CURVE_TYPE = 76;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__META_DATA_PROPERTY = ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__DESCRIPTION = ABSTRACT_CURVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__NAME_GROUP = ABSTRACT_CURVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__NAME = ABSTRACT_CURVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__ID = ABSTRACT_CURVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__AXIS_LABELS = ABSTRACT_CURVE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__GID = ABSTRACT_CURVE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__SRS_DIMENSION = ABSTRACT_CURVE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__SRS_NAME = ABSTRACT_CURVE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__UOM_LABELS = ABSTRACT_CURVE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Curve Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE__CURVE_MEMBER = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Composite Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Composite Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_CURVE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CompositeSolidPropertyTypeImpl <em>Composite Solid Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CompositeSolidPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCompositeSolidPropertyType()
     * @generated
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE = 77;

    /**
     * The feature id for the '<em><b>Composite Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE__COMPOSITE_SOLID = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Composite Solid Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Composite Solid Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CompositeSolidTypeImpl <em>Composite Solid Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CompositeSolidTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCompositeSolidType()
     * @generated
     */
    int COMPOSITE_SOLID_TYPE = 78;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__META_DATA_PROPERTY = ABSTRACT_SOLID_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__DESCRIPTION = ABSTRACT_SOLID_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__NAME_GROUP = ABSTRACT_SOLID_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__NAME = ABSTRACT_SOLID_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__ID = ABSTRACT_SOLID_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__AXIS_LABELS = ABSTRACT_SOLID_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__GID = ABSTRACT_SOLID_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__SRS_DIMENSION = ABSTRACT_SOLID_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__SRS_NAME = ABSTRACT_SOLID_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__UOM_LABELS = ABSTRACT_SOLID_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Solid Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE__SOLID_MEMBER = ABSTRACT_SOLID_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Composite Solid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE_FEATURE_COUNT = ABSTRACT_SOLID_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Composite Solid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SOLID_TYPE_OPERATION_COUNT = ABSTRACT_SOLID_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CompositeSurfacePropertyTypeImpl <em>Composite Surface Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CompositeSurfacePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCompositeSurfacePropertyType()
     * @generated
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE = 79;

    /**
     * The feature id for the '<em><b>Composite Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE__COMPOSITE_SURFACE = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Composite Surface Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Composite Surface Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CompositeSurfaceTypeImpl <em>Composite Surface Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CompositeSurfaceTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCompositeSurfaceType()
     * @generated
     */
    int COMPOSITE_SURFACE_TYPE = 80;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__META_DATA_PROPERTY = ABSTRACT_SURFACE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__DESCRIPTION = ABSTRACT_SURFACE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__NAME_GROUP = ABSTRACT_SURFACE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__NAME = ABSTRACT_SURFACE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__ID = ABSTRACT_SURFACE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__AXIS_LABELS = ABSTRACT_SURFACE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__GID = ABSTRACT_SURFACE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__SRS_DIMENSION = ABSTRACT_SURFACE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__SRS_NAME = ABSTRACT_SURFACE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__UOM_LABELS = ABSTRACT_SURFACE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Surface Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE__SURFACE_MEMBER = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Composite Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Composite Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CompositeValueTypeImpl <em>Composite Value Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CompositeValueTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCompositeValueType()
     * @generated
     */
    int COMPOSITE_VALUE_TYPE = 81;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_VALUE_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_VALUE_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_VALUE_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_VALUE_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_VALUE_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The feature id for the '<em><b>Value Component</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_VALUE_TYPE__VALUE_COMPONENT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Value Components</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_VALUE_TYPE__VALUE_COMPONENTS = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Composite Value Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_VALUE_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Composite Value Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOSITE_VALUE_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CompoundCRSRefTypeImpl <em>Compound CRS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CompoundCRSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCompoundCRSRefType()
     * @generated
     */
    int COMPOUND_CRS_REF_TYPE = 82;

    /**
     * The feature id for the '<em><b>Compound CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE__COMPOUND_CRS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Compound CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Compound CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CompoundCRSTypeImpl <em>Compound CRS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CompoundCRSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCompoundCRSType()
     * @generated
     */
    int COMPOUND_CRS_TYPE = 83;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_REFERENCE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__DESCRIPTION = ABSTRACT_REFERENCE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__NAME_GROUP = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__SRS_NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Srs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__SRS_ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__REMARKS = ABSTRACT_REFERENCE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__VALID_AREA = ABSTRACT_REFERENCE_SYSTEM_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__SCOPE = ABSTRACT_REFERENCE_SYSTEM_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Includes CRS</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE__INCLUDES_CRS = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Compound CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE_FEATURE_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Compound CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPOUND_CRS_TYPE_OPERATION_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ConcatenatedOperationRefTypeImpl <em>Concatenated Operation Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ConcatenatedOperationRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getConcatenatedOperationRefType()
     * @generated
     */
    int CONCATENATED_OPERATION_REF_TYPE = 84;

    /**
     * The feature id for the '<em><b>Concatenated Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE__CONCATENATED_OPERATION = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Concatenated Operation Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Concatenated Operation Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ConcatenatedOperationTypeImpl <em>Concatenated Operation Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ConcatenatedOperationTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getConcatenatedOperationType()
     * @generated
     */
    int CONCATENATED_OPERATION_TYPE = 85;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_OPERATION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__ID = ABSTRACT_COORDINATE_OPERATION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Coordinate Operation Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__COORDINATE_OPERATION_NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_NAME;

    /**
     * The feature id for the '<em><b>Coordinate Operation ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__COORDINATE_OPERATION_ID = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__REMARKS = ABSTRACT_COORDINATE_OPERATION_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Operation Version</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__OPERATION_VERSION = ABSTRACT_COORDINATE_OPERATION_TYPE__OPERATION_VERSION;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__VALID_AREA = ABSTRACT_COORDINATE_OPERATION_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__SCOPE = ABSTRACT_COORDINATE_OPERATION_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Positional Accuracy Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__POSITIONAL_ACCURACY_GROUP = ABSTRACT_COORDINATE_OPERATION_TYPE__POSITIONAL_ACCURACY_GROUP;

    /**
     * The feature id for the '<em><b>Positional Accuracy</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__POSITIONAL_ACCURACY = ABSTRACT_COORDINATE_OPERATION_TYPE__POSITIONAL_ACCURACY;

    /**
     * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__SOURCE_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__SOURCE_CRS;

    /**
     * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__TARGET_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__TARGET_CRS;

    /**
     * The feature id for the '<em><b>Uses Single Operation</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE__USES_SINGLE_OPERATION = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Concatenated Operation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Concatenated Operation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONCATENATED_OPERATION_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ConeTypeImpl <em>Cone Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ConeTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getConeType()
     * @generated
     */
    int CONE_TYPE = 86;

    /**
     * The feature id for the '<em><b>Row</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONE_TYPE__ROW = ABSTRACT_GRIDDED_SURFACE_TYPE__ROW;

    /**
     * The feature id for the '<em><b>Rows</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONE_TYPE__ROWS = ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS;

    /**
     * The feature id for the '<em><b>Columns</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONE_TYPE__COLUMNS = ABSTRACT_GRIDDED_SURFACE_TYPE__COLUMNS;

    /**
     * The feature id for the '<em><b>Horizontal Curve Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONE_TYPE__HORIZONTAL_CURVE_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Vertical Curve Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONE_TYPE__VERTICAL_CURVE_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Cone Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONE_TYPE_FEATURE_COUNT = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Cone Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONE_TYPE_OPERATION_COUNT = ABSTRACT_GRIDDED_SURFACE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ContainerPropertyTypeImpl <em>Container Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ContainerPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getContainerPropertyType()
     * @generated
     */
    int CONTAINER_PROPERTY_TYPE = 87;

    /**
     * The feature id for the '<em><b>Face</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE__FACE = 0;

    /**
     * The feature id for the '<em><b>Topo Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE__TOPO_SOLID = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Container Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Container Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTAINER_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ControlPointTypeImpl <em>Control Point Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ControlPointTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getControlPointType()
     * @generated
     */
    int CONTROL_POINT_TYPE = 88;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTROL_POINT_TYPE__POS_LIST = 0;

    /**
     * The feature id for the '<em><b>Geometric Position Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTROL_POINT_TYPE__GEOMETRIC_POSITION_GROUP = 1;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTROL_POINT_TYPE__POS = 2;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTROL_POINT_TYPE__POINT_PROPERTY = 3;

    /**
     * The number of structural features of the '<em>Control Point Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTROL_POINT_TYPE_FEATURE_COUNT = 4;

    /**
     * The number of operations of the '<em>Control Point Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTROL_POINT_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ConventionalUnitTypeImpl <em>Conventional Unit Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ConventionalUnitTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getConventionalUnitType()
     * @generated
     */
    int CONVENTIONAL_UNIT_TYPE = 89;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE__META_DATA_PROPERTY = UNIT_DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE__DESCRIPTION = UNIT_DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE__NAME_GROUP = UNIT_DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE__NAME = UNIT_DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE__ID = UNIT_DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Quantity Type</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE__QUANTITY_TYPE = UNIT_DEFINITION_TYPE__QUANTITY_TYPE;

    /**
     * The feature id for the '<em><b>Catalog Symbol</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE__CATALOG_SYMBOL = UNIT_DEFINITION_TYPE__CATALOG_SYMBOL;

    /**
     * The feature id for the '<em><b>Conversion To Preferred Unit</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE__CONVERSION_TO_PREFERRED_UNIT = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Rough Conversion To Preferred Unit</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE__ROUGH_CONVERSION_TO_PREFERRED_UNIT = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Derivation Unit Term</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE__DERIVATION_UNIT_TERM = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Conventional Unit Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE_FEATURE_COUNT = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Conventional Unit Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVENTIONAL_UNIT_TYPE_OPERATION_COUNT = UNIT_DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ConversionRefTypeImpl <em>Conversion Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ConversionRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getConversionRefType()
     * @generated
     */
    int CONVERSION_REF_TYPE = 90;

    /**
     * The feature id for the '<em><b>Conversion</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE__CONVERSION = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Conversion Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Conversion Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.UnitOfMeasureTypeImpl <em>Unit Of Measure Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.UnitOfMeasureTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getUnitOfMeasureType()
     * @generated
     */
    int UNIT_OF_MEASURE_TYPE = 372;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_OF_MEASURE_TYPE__UOM = 0;

    /**
     * The number of structural features of the '<em>Unit Of Measure Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_OF_MEASURE_TYPE_FEATURE_COUNT = 1;

    /**
     * The number of operations of the '<em>Unit Of Measure Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int UNIT_OF_MEASURE_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ConversionToPreferredUnitTypeImpl <em>Conversion To Preferred Unit Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ConversionToPreferredUnitTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getConversionToPreferredUnitType()
     * @generated
     */
    int CONVERSION_TO_PREFERRED_UNIT_TYPE = 91;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TO_PREFERRED_UNIT_TYPE__UOM = UNIT_OF_MEASURE_TYPE__UOM;

    /**
     * The feature id for the '<em><b>Factor</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TO_PREFERRED_UNIT_TYPE__FACTOR = UNIT_OF_MEASURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Formula</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TO_PREFERRED_UNIT_TYPE__FORMULA = UNIT_OF_MEASURE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Conversion To Preferred Unit Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TO_PREFERRED_UNIT_TYPE_FEATURE_COUNT = UNIT_OF_MEASURE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Conversion To Preferred Unit Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TO_PREFERRED_UNIT_TYPE_OPERATION_COUNT = UNIT_OF_MEASURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ConversionTypeImpl <em>Conversion Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ConversionTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getConversionType()
     * @generated
     */
    int CONVERSION_TYPE = 92;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__META_DATA_PROPERTY = ABSTRACT_GENERAL_CONVERSION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__DESCRIPTION = ABSTRACT_GENERAL_CONVERSION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__NAME_GROUP = ABSTRACT_GENERAL_CONVERSION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__NAME = ABSTRACT_GENERAL_CONVERSION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__ID = ABSTRACT_GENERAL_CONVERSION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Coordinate Operation Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__COORDINATE_OPERATION_NAME = ABSTRACT_GENERAL_CONVERSION_TYPE__COORDINATE_OPERATION_NAME;

    /**
     * The feature id for the '<em><b>Coordinate Operation ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__COORDINATE_OPERATION_ID = ABSTRACT_GENERAL_CONVERSION_TYPE__COORDINATE_OPERATION_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__REMARKS = ABSTRACT_GENERAL_CONVERSION_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Operation Version</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__OPERATION_VERSION = ABSTRACT_GENERAL_CONVERSION_TYPE__OPERATION_VERSION;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__VALID_AREA = ABSTRACT_GENERAL_CONVERSION_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__SCOPE = ABSTRACT_GENERAL_CONVERSION_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Positional Accuracy Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__POSITIONAL_ACCURACY_GROUP = ABSTRACT_GENERAL_CONVERSION_TYPE__POSITIONAL_ACCURACY_GROUP;

    /**
     * The feature id for the '<em><b>Positional Accuracy</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__POSITIONAL_ACCURACY = ABSTRACT_GENERAL_CONVERSION_TYPE__POSITIONAL_ACCURACY;

    /**
     * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__SOURCE_CRS = ABSTRACT_GENERAL_CONVERSION_TYPE__SOURCE_CRS;

    /**
     * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__TARGET_CRS = ABSTRACT_GENERAL_CONVERSION_TYPE__TARGET_CRS;

    /**
     * The feature id for the '<em><b>Uses Method</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__USES_METHOD = ABSTRACT_GENERAL_CONVERSION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Uses Value</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE__USES_VALUE = ABSTRACT_GENERAL_CONVERSION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Conversion Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_CONVERSION_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Conversion Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONVERSION_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_CONVERSION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CoordinateOperationRefTypeImpl <em>Coordinate Operation Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CoordinateOperationRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCoordinateOperationRefType()
     * @generated
     */
    int COORDINATE_OPERATION_REF_TYPE = 93;

    /**
     * The feature id for the '<em><b>Coordinate Operation Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE__COORDINATE_OPERATION_GROUP = 0;

    /**
     * The feature id for the '<em><b>Coordinate Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE__COORDINATE_OPERATION = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Coordinate Operation Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Coordinate Operation Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_OPERATION_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CoordinateReferenceSystemRefTypeImpl <em>Coordinate Reference System Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CoordinateReferenceSystemRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCoordinateReferenceSystemRefType()
     * @generated
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE = 94;

    /**
     * The feature id for the '<em><b>Coordinate Reference System Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE__COORDINATE_REFERENCE_SYSTEM_GROUP = 0;

    /**
     * The feature id for the '<em><b>Coordinate Reference System</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE__COORDINATE_REFERENCE_SYSTEM = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Coordinate Reference System Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Coordinate Reference System Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_REFERENCE_SYSTEM_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CoordinatesTypeImpl <em>Coordinates Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CoordinatesTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCoordinatesType()
     * @generated
     */
    int COORDINATES_TYPE = 95;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATES_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Cs</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATES_TYPE__CS = 1;

    /**
     * The feature id for the '<em><b>Decimal</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATES_TYPE__DECIMAL = 2;

    /**
     * The feature id for the '<em><b>Ts</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATES_TYPE__TS = 3;

    /**
     * The number of structural features of the '<em>Coordinates Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATES_TYPE_FEATURE_COUNT = 4;

    /**
     * The number of operations of the '<em>Coordinates Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATES_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CoordinateSystemAxisBaseTypeImpl <em>Coordinate System Axis Base Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CoordinateSystemAxisBaseTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCoordinateSystemAxisBaseType()
     * @generated
     */
    int COORDINATE_SYSTEM_AXIS_BASE_TYPE = 96;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_BASE_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_BASE_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_BASE_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_BASE_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_BASE_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The number of structural features of the '<em>Coordinate System Axis Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_BASE_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Coordinate System Axis Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_BASE_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CoordinateSystemAxisRefTypeImpl <em>Coordinate System Axis Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CoordinateSystemAxisRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCoordinateSystemAxisRefType()
     * @generated
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE = 97;

    /**
     * The feature id for the '<em><b>Coordinate System Axis</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE__COORDINATE_SYSTEM_AXIS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Coordinate System Axis Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Coordinate System Axis Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CoordinateSystemAxisTypeImpl <em>Coordinate System Axis Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CoordinateSystemAxisTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCoordinateSystemAxisType()
     * @generated
     */
    int COORDINATE_SYSTEM_AXIS_TYPE = 98;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE__META_DATA_PROPERTY = COORDINATE_SYSTEM_AXIS_BASE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE__DESCRIPTION = COORDINATE_SYSTEM_AXIS_BASE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE__NAME_GROUP = COORDINATE_SYSTEM_AXIS_BASE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE__NAME = COORDINATE_SYSTEM_AXIS_BASE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE__ID = COORDINATE_SYSTEM_AXIS_BASE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE__AXIS_ID = COORDINATE_SYSTEM_AXIS_BASE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE__REMARKS = COORDINATE_SYSTEM_AXIS_BASE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Axis Abbrev</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE__AXIS_ABBREV = COORDINATE_SYSTEM_AXIS_BASE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Axis Direction</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE__AXIS_DIRECTION = COORDINATE_SYSTEM_AXIS_BASE_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE__UOM = COORDINATE_SYSTEM_AXIS_BASE_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of structural features of the '<em>Coordinate System Axis Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE_FEATURE_COUNT = COORDINATE_SYSTEM_AXIS_BASE_TYPE_FEATURE_COUNT + 5;

    /**
     * The number of operations of the '<em>Coordinate System Axis Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_AXIS_TYPE_OPERATION_COUNT = COORDINATE_SYSTEM_AXIS_BASE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CoordinateSystemRefTypeImpl <em>Coordinate System Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CoordinateSystemRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCoordinateSystemRefType()
     * @generated
     */
    int COORDINATE_SYSTEM_REF_TYPE = 99;

    /**
     * The feature id for the '<em><b>Coordinate System Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE__COORDINATE_SYSTEM_GROUP = 0;

    /**
     * The feature id for the '<em><b>Coordinate System</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE__COORDINATE_SYSTEM = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Coordinate System Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Coordinate System Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORDINATE_SYSTEM_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CoordTypeImpl <em>Coord Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CoordTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCoordType()
     * @generated
     */
    int COORD_TYPE = 100;

    /**
     * The feature id for the '<em><b>X</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORD_TYPE__X = 0;

    /**
     * The feature id for the '<em><b>Y</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORD_TYPE__Y = 1;

    /**
     * The feature id for the '<em><b>Z</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORD_TYPE__Z = 2;

    /**
     * The number of structural features of the '<em>Coord Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORD_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>Coord Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COORD_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CountPropertyTypeImpl <em>Count Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CountPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCountPropertyType()
     * @generated
     */
    int COUNT_PROPERTY_TYPE = 101;

    /**
     * The feature id for the '<em><b>Boolean</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__BOOLEAN = VALUE_PROPERTY_TYPE__BOOLEAN;

    /**
     * The feature id for the '<em><b>Category</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__CATEGORY = VALUE_PROPERTY_TYPE__CATEGORY;

    /**
     * The feature id for the '<em><b>Quantity</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__QUANTITY = VALUE_PROPERTY_TYPE__QUANTITY;

    /**
     * The feature id for the '<em><b>Count</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__COUNT = VALUE_PROPERTY_TYPE__COUNT;

    /**
     * The feature id for the '<em><b>Boolean List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__BOOLEAN_LIST = VALUE_PROPERTY_TYPE__BOOLEAN_LIST;

    /**
     * The feature id for the '<em><b>Category List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__CATEGORY_LIST = VALUE_PROPERTY_TYPE__CATEGORY_LIST;

    /**
     * The feature id for the '<em><b>Quantity List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__QUANTITY_LIST = VALUE_PROPERTY_TYPE__QUANTITY_LIST;

    /**
     * The feature id for the '<em><b>Count List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__COUNT_LIST = VALUE_PROPERTY_TYPE__COUNT_LIST;

    /**
     * The feature id for the '<em><b>Category Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__CATEGORY_EXTENT = VALUE_PROPERTY_TYPE__CATEGORY_EXTENT;

    /**
     * The feature id for the '<em><b>Quantity Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__QUANTITY_EXTENT = VALUE_PROPERTY_TYPE__QUANTITY_EXTENT;

    /**
     * The feature id for the '<em><b>Count Extent</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__COUNT_EXTENT = VALUE_PROPERTY_TYPE__COUNT_EXTENT;

    /**
     * The feature id for the '<em><b>Composite Value Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__COMPOSITE_VALUE_GROUP = VALUE_PROPERTY_TYPE__COMPOSITE_VALUE_GROUP;

    /**
     * The feature id for the '<em><b>Composite Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__COMPOSITE_VALUE = VALUE_PROPERTY_TYPE__COMPOSITE_VALUE;

    /**
     * The feature id for the '<em><b>Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__OBJECT_GROUP = VALUE_PROPERTY_TYPE__OBJECT_GROUP;

    /**
     * The feature id for the '<em><b>Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__OBJECT = VALUE_PROPERTY_TYPE__OBJECT;

    /**
     * The feature id for the '<em><b>Null</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__NULL = VALUE_PROPERTY_TYPE__NULL;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__ACTUATE = VALUE_PROPERTY_TYPE__ACTUATE;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__ARCROLE = VALUE_PROPERTY_TYPE__ARCROLE;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__HREF = VALUE_PROPERTY_TYPE__HREF;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__REMOTE_SCHEMA = VALUE_PROPERTY_TYPE__REMOTE_SCHEMA;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__ROLE = VALUE_PROPERTY_TYPE__ROLE;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__SHOW = VALUE_PROPERTY_TYPE__SHOW;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__TITLE = VALUE_PROPERTY_TYPE__TITLE;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE__TYPE = VALUE_PROPERTY_TYPE__TYPE;

    /**
     * The number of structural features of the '<em>Count Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE_FEATURE_COUNT = VALUE_PROPERTY_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Count Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COUNT_PROPERTY_TYPE_OPERATION_COUNT = VALUE_PROPERTY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CovarianceElementTypeImpl <em>Covariance Element Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CovarianceElementTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCovarianceElementType()
     * @generated
     */
    int COVARIANCE_ELEMENT_TYPE = 102;

    /**
     * The feature id for the '<em><b>Row Index</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVARIANCE_ELEMENT_TYPE__ROW_INDEX = 0;

    /**
     * The feature id for the '<em><b>Column Index</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVARIANCE_ELEMENT_TYPE__COLUMN_INDEX = 1;

    /**
     * The feature id for the '<em><b>Covariance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVARIANCE_ELEMENT_TYPE__COVARIANCE = 2;

    /**
     * The number of structural features of the '<em>Covariance Element Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVARIANCE_ELEMENT_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>Covariance Element Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVARIANCE_ELEMENT_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CovarianceMatrixTypeImpl <em>Covariance Matrix Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CovarianceMatrixTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCovarianceMatrixType()
     * @generated
     */
    int COVARIANCE_MATRIX_TYPE = 103;

    /**
     * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVARIANCE_MATRIX_TYPE__MEASURE_DESCRIPTION = ABSTRACT_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION;

    /**
     * The feature id for the '<em><b>Unit Of Measure</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVARIANCE_MATRIX_TYPE__UNIT_OF_MEASURE = ABSTRACT_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Includes Element</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVARIANCE_MATRIX_TYPE__INCLUDES_ELEMENT = ABSTRACT_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Covariance Matrix Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVARIANCE_MATRIX_TYPE_FEATURE_COUNT = ABSTRACT_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Covariance Matrix Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVARIANCE_MATRIX_TYPE_OPERATION_COUNT = ABSTRACT_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CoverageFunctionTypeImpl <em>Coverage Function Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CoverageFunctionTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCoverageFunctionType()
     * @generated
     */
    int COVERAGE_FUNCTION_TYPE = 104;

    /**
     * The feature id for the '<em><b>Mapping Rule</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVERAGE_FUNCTION_TYPE__MAPPING_RULE = 0;

    /**
     * The feature id for the '<em><b>Grid Function Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVERAGE_FUNCTION_TYPE__GRID_FUNCTION_GROUP = 1;

    /**
     * The feature id for the '<em><b>Grid Function</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVERAGE_FUNCTION_TYPE__GRID_FUNCTION = 2;

    /**
     * The number of structural features of the '<em>Coverage Function Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVERAGE_FUNCTION_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>Coverage Function Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COVERAGE_FUNCTION_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CRSRefTypeImpl <em>CRS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CRSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCRSRefType()
     * @generated
     */
    int CRS_REF_TYPE = 105;

    /**
     * The feature id for the '<em><b>CRS Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE__CRS_GROUP = 0;

    /**
     * The feature id for the '<em><b>CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE__CRS = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CRS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CubicSplineTypeImpl <em>Cubic Spline Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CubicSplineTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCubicSplineType()
     * @generated
     */
    int CUBIC_SPLINE_TYPE = 106;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Vector At Start</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__VECTOR_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

    /**
     * The feature id for the '<em><b>Vector At End</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__VECTOR_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

    /**
     * The feature id for the '<em><b>Degree</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__DEGREE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 8;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 9;

    /**
     * The number of structural features of the '<em>Cubic Spline Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 10;

    /**
     * The number of operations of the '<em>Cubic Spline Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CUBIC_SPLINE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CurveArrayPropertyTypeImpl <em>Curve Array Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CurveArrayPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCurveArrayPropertyType()
     * @generated
     */
    int CURVE_ARRAY_PROPERTY_TYPE = 107;

    /**
     * The feature id for the '<em><b>Curve Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_ARRAY_PROPERTY_TYPE__CURVE_GROUP = 0;

    /**
     * The feature id for the '<em><b>Curve</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_ARRAY_PROPERTY_TYPE__CURVE = 1;

    /**
     * The number of structural features of the '<em>Curve Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Curve Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CurvePropertyTypeImpl <em>Curve Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CurvePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCurvePropertyType()
     * @generated
     */
    int CURVE_PROPERTY_TYPE = 108;

    /**
     * The feature id for the '<em><b>Curve Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE__CURVE_GROUP = 0;

    /**
     * The feature id for the '<em><b>Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE__CURVE = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Curve Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Curve Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CurveSegmentArrayPropertyTypeImpl <em>Curve Segment Array Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CurveSegmentArrayPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCurveSegmentArrayPropertyType()
     * @generated
     */
    int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE = 109;

    /**
     * The feature id for the '<em><b>Curve Segment Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE__CURVE_SEGMENT_GROUP = 0;

    /**
     * The feature id for the '<em><b>Curve Segment</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE__CURVE_SEGMENT = 1;

    /**
     * The number of structural features of the '<em>Curve Segment Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Curve Segment Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CurveTypeImpl <em>Curve Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CurveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCurveType()
     * @generated
     */
    int CURVE_TYPE = 110;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__META_DATA_PROPERTY = ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__DESCRIPTION = ABSTRACT_CURVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__NAME_GROUP = ABSTRACT_CURVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__NAME = ABSTRACT_CURVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__ID = ABSTRACT_CURVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__AXIS_LABELS = ABSTRACT_CURVE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__GID = ABSTRACT_CURVE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__SRS_DIMENSION = ABSTRACT_CURVE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__SRS_NAME = ABSTRACT_CURVE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__UOM_LABELS = ABSTRACT_CURVE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Segments</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE__SEGMENTS = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CURVE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CylinderTypeImpl <em>Cylinder Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CylinderTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCylinderType()
     * @generated
     */
    int CYLINDER_TYPE = 111;

    /**
     * The feature id for the '<em><b>Row</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDER_TYPE__ROW = ABSTRACT_GRIDDED_SURFACE_TYPE__ROW;

    /**
     * The feature id for the '<em><b>Rows</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDER_TYPE__ROWS = ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS;

    /**
     * The feature id for the '<em><b>Columns</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDER_TYPE__COLUMNS = ABSTRACT_GRIDDED_SURFACE_TYPE__COLUMNS;

    /**
     * The feature id for the '<em><b>Horizontal Curve Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDER_TYPE__HORIZONTAL_CURVE_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Vertical Curve Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDER_TYPE__VERTICAL_CURVE_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Cylinder Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDER_TYPE_FEATURE_COUNT = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Cylinder Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDER_TYPE_OPERATION_COUNT = ABSTRACT_GRIDDED_SURFACE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CylindricalCSRefTypeImpl <em>Cylindrical CS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CylindricalCSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCylindricalCSRefType()
     * @generated
     */
    int CYLINDRICAL_CS_REF_TYPE = 112;

    /**
     * The feature id for the '<em><b>Cylindrical CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE__CYLINDRICAL_CS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Cylindrical CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Cylindrical CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.CylindricalCSTypeImpl <em>Cylindrical CS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.CylindricalCSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getCylindricalCSType()
     * @generated
     */
    int CYLINDRICAL_CS_TYPE = 113;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Cs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE__CS_NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_NAME;

    /**
     * The feature id for the '<em><b>Cs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE__CS_ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Uses Axis</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE__USES_AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__USES_AXIS;

    /**
     * The number of structural features of the '<em>Cylindrical CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Cylindrical CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CYLINDRICAL_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DataBlockTypeImpl <em>Data Block Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DataBlockTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDataBlockType()
     * @generated
     */
    int DATA_BLOCK_TYPE = 114;

    /**
     * The feature id for the '<em><b>Range Parameters</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATA_BLOCK_TYPE__RANGE_PARAMETERS = 0;

    /**
     * The feature id for the '<em><b>Tuple List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATA_BLOCK_TYPE__TUPLE_LIST = 1;

    /**
     * The feature id for the '<em><b>Double Or Null Tuple List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATA_BLOCK_TYPE__DOUBLE_OR_NULL_TUPLE_LIST = 2;

    /**
     * The number of structural features of the '<em>Data Block Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATA_BLOCK_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>Data Block Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATA_BLOCK_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DatumRefTypeImpl <em>Datum Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DatumRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDatumRefType()
     * @generated
     */
    int DATUM_REF_TYPE = 115;

    /**
     * The feature id for the '<em><b>Datum Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE__DATUM_GROUP = 0;

    /**
     * The feature id for the '<em><b>Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE__DATUM = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Datum Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Datum Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DATUM_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DefaultStylePropertyTypeImpl <em>Default Style Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DefaultStylePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDefaultStylePropertyType()
     * @generated
     */
    int DEFAULT_STYLE_PROPERTY_TYPE = 116;

    /**
     * The feature id for the '<em><b>Style Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__STYLE_GROUP = 0;

    /**
     * The feature id for the '<em><b>Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__STYLE = 1;

    /**
     * The feature id for the '<em><b>About</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__ABOUT = 2;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__ACTUATE = 3;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__ARCROLE = 4;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__HREF = 5;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__ROLE = 7;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__SHOW = 8;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__TITLE = 9;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE__TYPE = 10;

    /**
     * The number of structural features of the '<em>Default Style Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE_FEATURE_COUNT = 11;

    /**
     * The number of operations of the '<em>Default Style Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFAULT_STYLE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DefinitionProxyTypeImpl <em>Definition Proxy Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DefinitionProxyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDefinitionProxyType()
     * @generated
     */
    int DEFINITION_PROXY_TYPE = 117;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_PROXY_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_PROXY_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_PROXY_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_PROXY_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_PROXY_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Definition Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_PROXY_TYPE__DEFINITION_REF = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Definition Proxy Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_PROXY_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Definition Proxy Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEFINITION_PROXY_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DegreesTypeImpl <em>Degrees Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DegreesTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDegreesType()
     * @generated
     */
    int DEGREES_TYPE = 119;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEGREES_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Direction</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEGREES_TYPE__DIRECTION = 1;

    /**
     * The number of structural features of the '<em>Degrees Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEGREES_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Degrees Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEGREES_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DerivationUnitTermTypeImpl <em>Derivation Unit Term Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DerivationUnitTermTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDerivationUnitTermType()
     * @generated
     */
    int DERIVATION_UNIT_TERM_TYPE = 120;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVATION_UNIT_TERM_TYPE__UOM = UNIT_OF_MEASURE_TYPE__UOM;

    /**
     * The feature id for the '<em><b>Exponent</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVATION_UNIT_TERM_TYPE__EXPONENT = UNIT_OF_MEASURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Derivation Unit Term Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVATION_UNIT_TERM_TYPE_FEATURE_COUNT = UNIT_OF_MEASURE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Derivation Unit Term Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVATION_UNIT_TERM_TYPE_OPERATION_COUNT = UNIT_OF_MEASURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DerivedCRSRefTypeImpl <em>Derived CRS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DerivedCRSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDerivedCRSRefType()
     * @generated
     */
    int DERIVED_CRS_REF_TYPE = 121;

    /**
     * The feature id for the '<em><b>Derived CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE__DERIVED_CRS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Derived CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Derived CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DerivedCRSTypeImpl <em>Derived CRS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DerivedCRSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDerivedCRSType()
     * @generated
     */
    int DERIVED_CRS_TYPE = 122;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__DESCRIPTION = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__NAME_GROUP = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__NAME = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__ID = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__ID;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__SRS_NAME = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Srs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__SRS_ID = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__SRS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__REMARKS = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__VALID_AREA = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__SCOPE = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Base CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__BASE_CRS = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__BASE_CRS;

    /**
     * The feature id for the '<em><b>Defined By Conversion</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__DEFINED_BY_CONVERSION = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DEFINED_BY_CONVERSION;

    /**
     * The feature id for the '<em><b>Derived CRS Type</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__DERIVED_CRS_TYPE = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Uses CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE__USES_CS = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Derived CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Derived CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DerivedCRSTypeTypeImpl <em>Derived CRS Type Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DerivedCRSTypeTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDerivedCRSTypeType()
     * @generated
     */
    int DERIVED_CRS_TYPE_TYPE = 123;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE_TYPE__VALUE = CODE_TYPE__VALUE;

    /**
     * The feature id for the '<em><b>Code Space</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE_TYPE__CODE_SPACE = CODE_TYPE__CODE_SPACE;

    /**
     * The number of structural features of the '<em>Derived CRS Type Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE_TYPE_FEATURE_COUNT = CODE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Derived CRS Type Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_CRS_TYPE_TYPE_OPERATION_COUNT = CODE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DerivedUnitTypeImpl <em>Derived Unit Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DerivedUnitTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDerivedUnitType()
     * @generated
     */
    int DERIVED_UNIT_TYPE = 124;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_UNIT_TYPE__META_DATA_PROPERTY = UNIT_DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_UNIT_TYPE__DESCRIPTION = UNIT_DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_UNIT_TYPE__NAME_GROUP = UNIT_DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_UNIT_TYPE__NAME = UNIT_DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_UNIT_TYPE__ID = UNIT_DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Quantity Type</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_UNIT_TYPE__QUANTITY_TYPE = UNIT_DEFINITION_TYPE__QUANTITY_TYPE;

    /**
     * The feature id for the '<em><b>Catalog Symbol</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_UNIT_TYPE__CATALOG_SYMBOL = UNIT_DEFINITION_TYPE__CATALOG_SYMBOL;

    /**
     * The feature id for the '<em><b>Derivation Unit Term</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_UNIT_TYPE__DERIVATION_UNIT_TERM = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Derived Unit Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_UNIT_TYPE_FEATURE_COUNT = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Derived Unit Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DERIVED_UNIT_TYPE_OPERATION_COUNT = UNIT_DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DictionaryEntryTypeImpl <em>Dictionary Entry Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DictionaryEntryTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDictionaryEntryType()
     * @generated
     */
    int DICTIONARY_ENTRY_TYPE = 125;

    /**
     * The feature id for the '<em><b>Definition Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE__DEFINITION_GROUP = 0;

    /**
     * The feature id for the '<em><b>Definition</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE__DEFINITION = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Dictionary Entry Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Dictionary Entry Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_ENTRY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DictionaryTypeImpl <em>Dictionary Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DictionaryTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDictionaryType()
     * @generated
     */
    int DICTIONARY_TYPE = 126;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE__GROUP = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Dictionary Entry Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE__DICTIONARY_ENTRY_GROUP = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Dictionary Entry</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE__DICTIONARY_ENTRY = DEFINITION_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Indirect Entry</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE__INDIRECT_ENTRY = DEFINITION_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the '<em>Dictionary Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of operations of the '<em>Dictionary Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DICTIONARY_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DirectedEdgePropertyTypeImpl <em>Directed Edge Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DirectedEdgePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDirectedEdgePropertyType()
     * @generated
     */
    int DIRECTED_EDGE_PROPERTY_TYPE = 127;

    /**
     * The feature id for the '<em><b>Edge</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE__EDGE = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Orientation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE__ORIENTATION = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Directed Edge Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Directed Edge Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_EDGE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DirectedFacePropertyTypeImpl <em>Directed Face Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DirectedFacePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDirectedFacePropertyType()
     * @generated
     */
    int DIRECTED_FACE_PROPERTY_TYPE = 128;

    /**
     * The feature id for the '<em><b>Face</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE__FACE = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Orientation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE__ORIENTATION = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Directed Face Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Directed Face Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_FACE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DirectedNodePropertyTypeImpl <em>Directed Node Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DirectedNodePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDirectedNodePropertyType()
     * @generated
     */
    int DIRECTED_NODE_PROPERTY_TYPE = 129;

    /**
     * The feature id for the '<em><b>Node</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE__NODE = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Orientation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE__ORIENTATION = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Directed Node Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Directed Node Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_NODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ObservationTypeImpl <em>Observation Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ObservationTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getObservationType()
     * @generated
     */
    int OBSERVATION_TYPE = 244;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__DESCRIPTION = ABSTRACT_FEATURE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__NAME_GROUP = ABSTRACT_FEATURE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__NAME = ABSTRACT_FEATURE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__ID = ABSTRACT_FEATURE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__LOCATION = ABSTRACT_FEATURE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__VALID_TIME = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Using</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__USING = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Target Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__TARGET_GROUP = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Target</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__TARGET = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Result Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE__RESULT_OF = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of structural features of the '<em>Observation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 5;

    /**
     * The number of operations of the '<em>Observation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBSERVATION_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DirectedObservationTypeImpl <em>Directed Observation Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DirectedObservationTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDirectedObservationType()
     * @generated
     */
    int DIRECTED_OBSERVATION_TYPE = 131;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__META_DATA_PROPERTY = OBSERVATION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__DESCRIPTION = OBSERVATION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__NAME_GROUP = OBSERVATION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__NAME = OBSERVATION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__ID = OBSERVATION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__BOUNDED_BY = OBSERVATION_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__LOCATION_GROUP = OBSERVATION_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__LOCATION = OBSERVATION_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__VALID_TIME = OBSERVATION_TYPE__VALID_TIME;

    /**
     * The feature id for the '<em><b>Using</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__USING = OBSERVATION_TYPE__USING;

    /**
     * The feature id for the '<em><b>Target Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__TARGET_GROUP = OBSERVATION_TYPE__TARGET_GROUP;

    /**
     * The feature id for the '<em><b>Target</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__TARGET = OBSERVATION_TYPE__TARGET;

    /**
     * The feature id for the '<em><b>Result Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__RESULT_OF = OBSERVATION_TYPE__RESULT_OF;

    /**
     * The feature id for the '<em><b>Direction</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE__DIRECTION = OBSERVATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Directed Observation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE_FEATURE_COUNT = OBSERVATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Directed Observation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_TYPE_OPERATION_COUNT = OBSERVATION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DirectedObservationAtDistanceTypeImpl <em>Directed Observation At Distance Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DirectedObservationAtDistanceTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDirectedObservationAtDistanceType()
     * @generated
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE = 130;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__META_DATA_PROPERTY = DIRECTED_OBSERVATION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__DESCRIPTION = DIRECTED_OBSERVATION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__NAME_GROUP = DIRECTED_OBSERVATION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__NAME = DIRECTED_OBSERVATION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__ID = DIRECTED_OBSERVATION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__BOUNDED_BY = DIRECTED_OBSERVATION_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__LOCATION_GROUP = DIRECTED_OBSERVATION_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__LOCATION = DIRECTED_OBSERVATION_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__VALID_TIME = DIRECTED_OBSERVATION_TYPE__VALID_TIME;

    /**
     * The feature id for the '<em><b>Using</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__USING = DIRECTED_OBSERVATION_TYPE__USING;

    /**
     * The feature id for the '<em><b>Target Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__TARGET_GROUP = DIRECTED_OBSERVATION_TYPE__TARGET_GROUP;

    /**
     * The feature id for the '<em><b>Target</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__TARGET = DIRECTED_OBSERVATION_TYPE__TARGET;

    /**
     * The feature id for the '<em><b>Result Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__RESULT_OF = DIRECTED_OBSERVATION_TYPE__RESULT_OF;

    /**
     * The feature id for the '<em><b>Direction</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__DIRECTION = DIRECTED_OBSERVATION_TYPE__DIRECTION;

    /**
     * The feature id for the '<em><b>Distance</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__DISTANCE = DIRECTED_OBSERVATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Directed Observation At Distance Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE_FEATURE_COUNT = DIRECTED_OBSERVATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Directed Observation At Distance Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE_OPERATION_COUNT = DIRECTED_OBSERVATION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DirectedTopoSolidPropertyTypeImpl <em>Directed Topo Solid Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DirectedTopoSolidPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDirectedTopoSolidPropertyType()
     * @generated
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE = 132;

    /**
     * The feature id for the '<em><b>Topo Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__TOPO_SOLID = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Orientation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__ORIENTATION = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Directed Topo Solid Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Directed Topo Solid Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTED_TOPO_SOLID_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DirectionPropertyTypeImpl <em>Direction Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DirectionPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDirectionPropertyType()
     * @generated
     */
    int DIRECTION_PROPERTY_TYPE = 133;

    /**
     * The feature id for the '<em><b>Direction Vector</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__DIRECTION_VECTOR = 0;

    /**
     * The feature id for the '<em><b>Compass Point</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__COMPASS_POINT = 1;

    /**
     * The feature id for the '<em><b>Direction Keyword</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__DIRECTION_KEYWORD = 2;

    /**
     * The feature id for the '<em><b>Direction String</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__DIRECTION_STRING = 3;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__ACTUATE = 4;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__ARCROLE = 5;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__HREF = 6;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__ROLE = 8;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__SHOW = 9;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__TITLE = 10;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE__TYPE = 11;

    /**
     * The number of structural features of the '<em>Direction Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE_FEATURE_COUNT = 12;

    /**
     * The number of operations of the '<em>Direction Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DirectionVectorTypeImpl <em>Direction Vector Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DirectionVectorTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDirectionVectorType()
     * @generated
     */
    int DIRECTION_VECTOR_TYPE = 134;

    /**
     * The feature id for the '<em><b>Vector</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_VECTOR_TYPE__VECTOR = 0;

    /**
     * The feature id for the '<em><b>Horizontal Angle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_VECTOR_TYPE__HORIZONTAL_ANGLE = 1;

    /**
     * The feature id for the '<em><b>Vertical Angle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_VECTOR_TYPE__VERTICAL_ANGLE = 2;

    /**
     * The number of structural features of the '<em>Direction Vector Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_VECTOR_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>Direction Vector Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECTION_VECTOR_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DirectPositionListTypeImpl <em>Direct Position List Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DirectPositionListTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDirectPositionListType()
     * @generated
     */
    int DIRECT_POSITION_LIST_TYPE = 135;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_LIST_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_LIST_TYPE__AXIS_LABELS = 1;

    /**
     * The feature id for the '<em><b>Count</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_LIST_TYPE__COUNT = 2;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_LIST_TYPE__SRS_DIMENSION = 3;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_LIST_TYPE__SRS_NAME = 4;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_LIST_TYPE__UOM_LABELS = 5;

    /**
     * The number of structural features of the '<em>Direct Position List Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_LIST_TYPE_FEATURE_COUNT = 6;

    /**
     * The number of operations of the '<em>Direct Position List Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_LIST_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DirectPositionTypeImpl <em>Direct Position Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DirectPositionTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDirectPositionType()
     * @generated
     */
    int DIRECT_POSITION_TYPE = 136;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_TYPE__AXIS_LABELS = 1;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_TYPE__SRS_DIMENSION = 2;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_TYPE__SRS_NAME = 3;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_TYPE__UOM_LABELS = 4;

    /**
     * The number of structural features of the '<em>Direct Position Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_TYPE_FEATURE_COUNT = 5;

    /**
     * The number of operations of the '<em>Direct Position Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DIRECT_POSITION_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DMSAngleTypeImpl <em>DMS Angle Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DMSAngleTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDMSAngleType()
     * @generated
     */
    int DMS_ANGLE_TYPE = 137;

    /**
     * The feature id for the '<em><b>Degrees</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DMS_ANGLE_TYPE__DEGREES = 0;

    /**
     * The feature id for the '<em><b>Decimal Minutes</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DMS_ANGLE_TYPE__DECIMAL_MINUTES = 1;

    /**
     * The feature id for the '<em><b>Minutes</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DMS_ANGLE_TYPE__MINUTES = 2;

    /**
     * The feature id for the '<em><b>Seconds</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DMS_ANGLE_TYPE__SECONDS = 3;

    /**
     * The number of structural features of the '<em>DMS Angle Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DMS_ANGLE_TYPE_FEATURE_COUNT = 4;

    /**
     * The number of operations of the '<em>DMS Angle Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DMS_ANGLE_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DocumentRootImpl <em>Document Root</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DocumentRootImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDocumentRoot()
     * @generated
     */
    int DOCUMENT_ROOT = 138;

    /**
     * The feature id for the '<em><b>Mixed</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MIXED = 0;

    /**
     * The feature id for the '<em><b>XMLNS Prefix Map</b></em>' map.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__XMLNS_PREFIX_MAP = 1;

    /**
     * The feature id for the '<em><b>XSI Schema Location</b></em>' map.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = 2;

    /**
     * The feature id for the '<em><b>Association</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ASSOCIATION = 3;

    /**
     * The feature id for the '<em><b>Continuous Coverage</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CONTINUOUS_COVERAGE = 4;

    /**
     * The feature id for the '<em><b>Coverage</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COVERAGE = 5;

    /**
     * The feature id for the '<em><b>Feature</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__FEATURE = 6;

    /**
     * The feature id for the '<em><b>GML</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GML = 7;

    /**
     * The feature id for the '<em><b>Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OBJECT = 8;

    /**
     * The feature id for the '<em><b>Coordinate Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATE_OPERATION = 9;

    /**
     * The feature id for the '<em><b>Definition</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DEFINITION = 10;

    /**
     * The feature id for the '<em><b>Coordinate Reference System</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATE_REFERENCE_SYSTEM = 11;

    /**
     * The feature id for the '<em><b>CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CRS = 12;

    /**
     * The feature id for the '<em><b>Reference System</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__REFERENCE_SYSTEM = 13;

    /**
     * The feature id for the '<em><b>Coordinate System</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATE_SYSTEM = 14;

    /**
     * The feature id for the '<em><b>Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CURVE = 15;

    /**
     * The feature id for the '<em><b>Geometric Primitive</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOMETRIC_PRIMITIVE = 16;

    /**
     * The feature id for the '<em><b>Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOMETRY = 17;

    /**
     * The feature id for the '<em><b>Curve Segment</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CURVE_SEGMENT = 18;

    /**
     * The feature id for the '<em><b>Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DATUM = 19;

    /**
     * The feature id for the '<em><b>Discrete Coverage</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DISCRETE_COVERAGE = 20;

    /**
     * The feature id for the '<em><b>Feature Collection</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__FEATURE_COLLECTION = 21;

    /**
     * The feature id for the '<em><b>General Conversion</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GENERAL_CONVERSION = 22;

    /**
     * The feature id for the '<em><b>Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OPERATION = 23;

    /**
     * The feature id for the '<em><b>Single Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SINGLE_OPERATION = 24;

    /**
     * The feature id for the '<em><b>General Derived CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GENERAL_DERIVED_CRS = 25;

    /**
     * The feature id for the '<em><b>General Operation Parameter</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GENERAL_OPERATION_PARAMETER = 26;

    /**
     * The feature id for the '<em><b>General Parameter Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GENERAL_PARAMETER_VALUE = 27;

    /**
     * The feature id for the '<em><b>General Transformation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GENERAL_TRANSFORMATION = 28;

    /**
     * The feature id for the '<em><b>Geometric Aggregate</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOMETRIC_AGGREGATE = 29;

    /**
     * The feature id for the '<em><b>Gridded Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GRIDDED_SURFACE = 30;

    /**
     * The feature id for the '<em><b>Parametric Curve Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PARAMETRIC_CURVE_SURFACE = 31;

    /**
     * The feature id for the '<em><b>Surface Patch</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SURFACE_PATCH = 32;

    /**
     * The feature id for the '<em><b>Implicit Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__IMPLICIT_GEOMETRY = 33;

    /**
     * The feature id for the '<em><b>Meta Data</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__META_DATA = 34;

    /**
     * The feature id for the '<em><b>Positional Accuracy</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POSITIONAL_ACCURACY = 35;

    /**
     * The feature id for the '<em><b>Reference</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__REFERENCE = 36;

    /**
     * The feature id for the '<em><b>Ring</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RING = 37;

    /**
     * The feature id for the '<em><b>Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SOLID = 38;

    /**
     * The feature id for the '<em><b>Strict Association</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__STRICT_ASSOCIATION = 39;

    /**
     * The feature id for the '<em><b>Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__STYLE = 40;

    /**
     * The feature id for the '<em><b>Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SURFACE = 41;

    /**
     * The feature id for the '<em><b>Time Complex</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_COMPLEX = 42;

    /**
     * The feature id for the '<em><b>Time Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_OBJECT = 43;

    /**
     * The feature id for the '<em><b>Time Geometric Primitive</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_GEOMETRIC_PRIMITIVE = 44;

    /**
     * The feature id for the '<em><b>Time Primitive</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_PRIMITIVE = 45;

    /**
     * The feature id for the '<em><b>Time Reference System</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_REFERENCE_SYSTEM = 46;

    /**
     * The feature id for the '<em><b>Time Slice</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_SLICE = 47;

    /**
     * The feature id for the '<em><b>Time Topology Primitive</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_TOPOLOGY_PRIMITIVE = 48;

    /**
     * The feature id for the '<em><b>Topology</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPOLOGY = 49;

    /**
     * The feature id for the '<em><b>Topo Primitive</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_PRIMITIVE = 50;

    /**
     * The feature id for the '<em><b>Absolute External Positional Accuracy</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY = 51;

    /**
     * The feature id for the '<em><b>Abstract General Operation Parameter Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ABSTRACT_GENERAL_OPERATION_PARAMETER_REF = 52;

    /**
     * The feature id for the '<em><b>Affine Placement</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__AFFINE_PLACEMENT = 53;

    /**
     * The feature id for the '<em><b>Anchor Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ANCHOR_POINT = 54;

    /**
     * The feature id for the '<em><b>Angle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ANGLE = 55;

    /**
     * The feature id for the '<em><b>Arc</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ARC = 56;

    /**
     * The feature id for the '<em><b>Arc String</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ARC_STRING = 57;

    /**
     * The feature id for the '<em><b>Arc By Bulge</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ARC_BY_BULGE = 58;

    /**
     * The feature id for the '<em><b>Arc String By Bulge</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ARC_STRING_BY_BULGE = 59;

    /**
     * The feature id for the '<em><b>Arc By Center Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ARC_BY_CENTER_POINT = 60;

    /**
     * The feature id for the '<em><b>Array</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ARRAY = 61;

    /**
     * The feature id for the '<em><b>Axis Abbrev</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__AXIS_ABBREV = 62;

    /**
     * The feature id for the '<em><b>Axis Direction</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__AXIS_DIRECTION = 63;

    /**
     * The feature id for the '<em><b>Axis ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__AXIS_ID = 64;

    /**
     * The feature id for the '<em><b>Bag</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BAG = 65;

    /**
     * The feature id for the '<em><b>Base CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BASE_CRS = 66;

    /**
     * The feature id for the '<em><b>Base Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BASE_CURVE = 67;

    /**
     * The feature id for the '<em><b>Base Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BASE_SURFACE = 68;

    /**
     * The feature id for the '<em><b>Base Unit</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BASE_UNIT = 69;

    /**
     * The feature id for the '<em><b>Unit Definition</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__UNIT_DEFINITION = 70;

    /**
     * The feature id for the '<em><b>Bezier</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BEZIER = 71;

    /**
     * The feature id for the '<em><b>BSpline</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BSPLINE = 72;

    /**
     * The feature id for the '<em><b>Boolean</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BOOLEAN = 73;

    /**
     * The feature id for the '<em><b>Boolean List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BOOLEAN_LIST = 74;

    /**
     * The feature id for the '<em><b>Boolean Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BOOLEAN_VALUE = 75;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BOUNDED_BY = 76;

    /**
     * The feature id for the '<em><b>Bounding Box</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BOUNDING_BOX = 77;

    /**
     * The feature id for the '<em><b>Bounding Polygon</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__BOUNDING_POLYGON = 78;

    /**
     * The feature id for the '<em><b>Cartesian CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CARTESIAN_CS = 79;

    /**
     * The feature id for the '<em><b>Cartesian CS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CARTESIAN_CS_REF = 80;

    /**
     * The feature id for the '<em><b>Catalog Symbol</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CATALOG_SYMBOL = 81;

    /**
     * The feature id for the '<em><b>Category</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CATEGORY = 82;

    /**
     * The feature id for the '<em><b>Category Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CATEGORY_EXTENT = 83;

    /**
     * The feature id for the '<em><b>Category List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CATEGORY_LIST = 84;

    /**
     * The feature id for the '<em><b>Center Line Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CENTER_LINE_OF = 85;

    /**
     * The feature id for the '<em><b>Center Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CENTER_OF = 86;

    /**
     * The feature id for the '<em><b>Circle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CIRCLE = 87;

    /**
     * The feature id for the '<em><b>Circle By Center Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CIRCLE_BY_CENTER_POINT = 88;

    /**
     * The feature id for the '<em><b>Clothoid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CLOTHOID = 89;

    /**
     * The feature id for the '<em><b>Column Index</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COLUMN_INDEX = 90;

    /**
     * The feature id for the '<em><b>Compass Point</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COMPASS_POINT = 91;

    /**
     * The feature id for the '<em><b>Composite Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COMPOSITE_CURVE = 92;

    /**
     * The feature id for the '<em><b>Composite Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COMPOSITE_SOLID = 93;

    /**
     * The feature id for the '<em><b>Composite Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COMPOSITE_SURFACE = 94;

    /**
     * The feature id for the '<em><b>Composite Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COMPOSITE_VALUE = 95;

    /**
     * The feature id for the '<em><b>Compound CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COMPOUND_CRS = 96;

    /**
     * The feature id for the '<em><b>Compound CRS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COMPOUND_CRS_REF = 97;

    /**
     * The feature id for the '<em><b>Concatenated Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CONCATENATED_OPERATION = 98;

    /**
     * The feature id for the '<em><b>Concatenated Operation Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CONCATENATED_OPERATION_REF = 99;

    /**
     * The feature id for the '<em><b>Cone</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CONE = 100;

    /**
     * The feature id for the '<em><b>Container</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CONTAINER = 101;

    /**
     * The feature id for the '<em><b>Conventional Unit</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CONVENTIONAL_UNIT = 102;

    /**
     * The feature id for the '<em><b>Conversion</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CONVERSION = 103;

    /**
     * The feature id for the '<em><b>Conversion Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CONVERSION_REF = 104;

    /**
     * The feature id for the '<em><b>Conversion To Preferred Unit</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CONVERSION_TO_PREFERRED_UNIT = 105;

    /**
     * The feature id for the '<em><b>Coord</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORD = 106;

    /**
     * The feature id for the '<em><b>Coordinate Operation ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATE_OPERATION_ID = 107;

    /**
     * The feature id for the '<em><b>Coordinate Operation Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATE_OPERATION_NAME = 108;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__NAME = 109;

    /**
     * The feature id for the '<em><b>Coordinate Operation Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATE_OPERATION_REF = 110;

    /**
     * The feature id for the '<em><b>Coordinate Reference System Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATE_REFERENCE_SYSTEM_REF = 111;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATES = 112;

    /**
     * The feature id for the '<em><b>Coordinate System Axis</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATE_SYSTEM_AXIS = 113;

    /**
     * The feature id for the '<em><b>Coordinate System Axis Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATE_SYSTEM_AXIS_REF = 114;

    /**
     * The feature id for the '<em><b>Coordinate System Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COORDINATE_SYSTEM_REF = 115;

    /**
     * The feature id for the '<em><b>Count</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COUNT = 116;

    /**
     * The feature id for the '<em><b>Count Extent</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COUNT_EXTENT = 117;

    /**
     * The feature id for the '<em><b>Count List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COUNT_LIST = 118;

    /**
     * The feature id for the '<em><b>Covariance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COVARIANCE = 119;

    /**
     * The feature id for the '<em><b>Covariance Matrix</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COVARIANCE_MATRIX = 120;

    /**
     * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__COVERAGE_FUNCTION = 121;

    /**
     * The feature id for the '<em><b>Crs Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CRS_REF = 122;

    /**
     * The feature id for the '<em><b>Cs ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CS_ID = 123;

    /**
     * The feature id for the '<em><b>Cs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CS_NAME = 124;

    /**
     * The feature id for the '<em><b>Cubic Spline</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CUBIC_SPLINE = 125;

    /**
     * The feature id for the '<em><b>Curve1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CURVE1 = 126;

    /**
     * The feature id for the '<em><b>Curve Array Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CURVE_ARRAY_PROPERTY = 127;

    /**
     * The feature id for the '<em><b>Curve Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CURVE_MEMBER = 128;

    /**
     * The feature id for the '<em><b>Curve Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CURVE_MEMBERS = 129;

    /**
     * The feature id for the '<em><b>Curve Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CURVE_PROPERTY = 130;

    /**
     * The feature id for the '<em><b>Cylinder</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CYLINDER = 131;

    /**
     * The feature id for the '<em><b>Cylindrical CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CYLINDRICAL_CS = 132;

    /**
     * The feature id for the '<em><b>Cylindrical CS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__CYLINDRICAL_CS_REF = 133;

    /**
     * The feature id for the '<em><b>Data Block</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DATA_BLOCK = 134;

    /**
     * The feature id for the '<em><b>Data Source</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DATA_SOURCE = 135;

    /**
     * The feature id for the '<em><b>Datum ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DATUM_ID = 136;

    /**
     * The feature id for the '<em><b>Datum Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DATUM_NAME = 137;

    /**
     * The feature id for the '<em><b>Datum Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DATUM_REF = 138;

    /**
     * The feature id for the '<em><b>Decimal Minutes</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DECIMAL_MINUTES = 139;

    /**
     * The feature id for the '<em><b>Default Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DEFAULT_STYLE = 140;

    /**
     * The feature id for the '<em><b>Defined By Conversion</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DEFINED_BY_CONVERSION = 141;

    /**
     * The feature id for the '<em><b>Definition Collection</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DEFINITION_COLLECTION = 142;

    /**
     * The feature id for the '<em><b>Definition Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DEFINITION_MEMBER = 143;

    /**
     * The feature id for the '<em><b>Dictionary Entry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DICTIONARY_ENTRY = 144;

    /**
     * The feature id for the '<em><b>Definition Proxy</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DEFINITION_PROXY = 145;

    /**
     * The feature id for the '<em><b>Definition Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DEFINITION_REF = 146;

    /**
     * The feature id for the '<em><b>Degrees</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DEGREES = 147;

    /**
     * The feature id for the '<em><b>Derivation Unit Term</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DERIVATION_UNIT_TERM = 148;

    /**
     * The feature id for the '<em><b>Derived CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DERIVED_CRS = 149;

    /**
     * The feature id for the '<em><b>Derived CRS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DERIVED_CRS_REF = 150;

    /**
     * The feature id for the '<em><b>Derived CRS Type</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DERIVED_CRS_TYPE = 151;

    /**
     * The feature id for the '<em><b>Derived Unit</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DERIVED_UNIT = 152;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DESCRIPTION = 153;

    /**
     * The feature id for the '<em><b>Dictionary</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DICTIONARY = 154;

    /**
     * The feature id for the '<em><b>Directed Edge</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DIRECTED_EDGE = 155;

    /**
     * The feature id for the '<em><b>Directed Face</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DIRECTED_FACE = 156;

    /**
     * The feature id for the '<em><b>Directed Node</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DIRECTED_NODE = 157;

    /**
     * The feature id for the '<em><b>Directed Observation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DIRECTED_OBSERVATION = 158;

    /**
     * The feature id for the '<em><b>Observation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OBSERVATION = 159;

    /**
     * The feature id for the '<em><b>Directed Observation At Distance</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DIRECTED_OBSERVATION_AT_DISTANCE = 160;

    /**
     * The feature id for the '<em><b>Directed Topo Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DIRECTED_TOPO_SOLID = 161;

    /**
     * The feature id for the '<em><b>Direction</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DIRECTION = 162;

    /**
     * The feature id for the '<em><b>Direction Vector</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DIRECTION_VECTOR = 163;

    /**
     * The feature id for the '<em><b>Dms Angle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DMS_ANGLE = 164;

    /**
     * The feature id for the '<em><b>Dms Angle Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DMS_ANGLE_VALUE = 165;

    /**
     * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DOMAIN_SET = 166;

    /**
     * The feature id for the '<em><b>Double Or Null Tuple List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DOUBLE_OR_NULL_TUPLE_LIST = 167;

    /**
     * The feature id for the '<em><b>Duration</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__DURATION = 168;

    /**
     * The feature id for the '<em><b>Edge</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__EDGE = 169;

    /**
     * The feature id for the '<em><b>Edge Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__EDGE_OF = 170;

    /**
     * The feature id for the '<em><b>Ellipsoid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ELLIPSOID = 171;

    /**
     * The feature id for the '<em><b>Ellipsoidal CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ELLIPSOIDAL_CS = 172;

    /**
     * The feature id for the '<em><b>Ellipsoidal CS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ELLIPSOIDAL_CS_REF = 173;

    /**
     * The feature id for the '<em><b>Ellipsoid ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ELLIPSOID_ID = 174;

    /**
     * The feature id for the '<em><b>Ellipsoid Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ELLIPSOID_NAME = 175;

    /**
     * The feature id for the '<em><b>Ellipsoid Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ELLIPSOID_REF = 176;

    /**
     * The feature id for the '<em><b>Engineering CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ENGINEERING_CRS = 177;

    /**
     * The feature id for the '<em><b>Engineering CRS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ENGINEERING_CRS_REF = 178;

    /**
     * The feature id for the '<em><b>Engineering Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ENGINEERING_DATUM = 179;

    /**
     * The feature id for the '<em><b>Engineering Datum Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ENGINEERING_DATUM_REF = 180;

    /**
     * The feature id for the '<em><b>Envelope</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ENVELOPE = 181;

    /**
     * The feature id for the '<em><b>Envelope With Time Period</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ENVELOPE_WITH_TIME_PERIOD = 182;

    /**
     * The feature id for the '<em><b>Extent Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__EXTENT_OF = 183;

    /**
     * The feature id for the '<em><b>Exterior</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__EXTERIOR = 184;

    /**
     * The feature id for the '<em><b>Face</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__FACE = 185;

    /**
     * The feature id for the '<em><b>Feature Collection1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__FEATURE_COLLECTION1 = 186;

    /**
     * The feature id for the '<em><b>Feature Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__FEATURE_MEMBER = 187;

    /**
     * The feature id for the '<em><b>Feature Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__FEATURE_MEMBERS = 188;

    /**
     * The feature id for the '<em><b>Feature Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__FEATURE_PROPERTY = 189;

    /**
     * The feature id for the '<em><b>Feature Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__FEATURE_STYLE = 190;

    /**
     * The feature id for the '<em><b>Feature Style1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__FEATURE_STYLE1 = 191;

    /**
     * The feature id for the '<em><b>File</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__FILE = 192;

    /**
     * The feature id for the '<em><b>General Conversion Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GENERAL_CONVERSION_REF = 193;

    /**
     * The feature id for the '<em><b>General Transformation Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GENERAL_TRANSFORMATION_REF = 194;

    /**
     * The feature id for the '<em><b>Generic Meta Data</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GENERIC_META_DATA = 195;

    /**
     * The feature id for the '<em><b>Geocentric CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOCENTRIC_CRS = 196;

    /**
     * The feature id for the '<em><b>Geocentric CRS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOCENTRIC_CRS_REF = 197;

    /**
     * The feature id for the '<em><b>Geodesic</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEODESIC = 198;

    /**
     * The feature id for the '<em><b>Geodesic String</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEODESIC_STRING = 199;

    /**
     * The feature id for the '<em><b>Geodetic Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEODETIC_DATUM = 200;

    /**
     * The feature id for the '<em><b>Geodetic Datum Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEODETIC_DATUM_REF = 201;

    /**
     * The feature id for the '<em><b>Geographic CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOGRAPHIC_CRS = 202;

    /**
     * The feature id for the '<em><b>Geographic CRS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOGRAPHIC_CRS_REF = 203;

    /**
     * The feature id for the '<em><b>Geometric Complex</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOMETRIC_COMPLEX = 204;

    /**
     * The feature id for the '<em><b>Geometry Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOMETRY_MEMBER = 205;

    /**
     * The feature id for the '<em><b>Geometry Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOMETRY_MEMBERS = 206;

    /**
     * The feature id for the '<em><b>Geometry Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOMETRY_STYLE = 207;

    /**
     * The feature id for the '<em><b>Geometry Style1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GEOMETRY_STYLE1 = 208;

    /**
     * The feature id for the '<em><b>Graph Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GRAPH_STYLE = 209;

    /**
     * The feature id for the '<em><b>Graph Style1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GRAPH_STYLE1 = 210;

    /**
     * The feature id for the '<em><b>Greenwich Longitude</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GREENWICH_LONGITUDE = 211;

    /**
     * The feature id for the '<em><b>Grid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GRID = 212;

    /**
     * The feature id for the '<em><b>Grid Coverage</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GRID_COVERAGE = 213;

    /**
     * The feature id for the '<em><b>Grid Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GRID_DOMAIN = 214;

    /**
     * The feature id for the '<em><b>Grid Function</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GRID_FUNCTION = 215;

    /**
     * The feature id for the '<em><b>Group ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GROUP_ID = 216;

    /**
     * The feature id for the '<em><b>Group Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__GROUP_NAME = 217;

    /**
     * The feature id for the '<em><b>History</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__HISTORY = 218;

    /**
     * The feature id for the '<em><b>Image CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__IMAGE_CRS = 219;

    /**
     * The feature id for the '<em><b>Image CRS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__IMAGE_CRS_REF = 220;

    /**
     * The feature id for the '<em><b>Image Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__IMAGE_DATUM = 221;

    /**
     * The feature id for the '<em><b>Image Datum Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__IMAGE_DATUM_REF = 222;

    /**
     * The feature id for the '<em><b>Includes CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INCLUDES_CRS = 223;

    /**
     * The feature id for the '<em><b>Includes Element</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INCLUDES_ELEMENT = 224;

    /**
     * The feature id for the '<em><b>Includes Parameter</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INCLUDES_PARAMETER = 225;

    /**
     * The feature id for the '<em><b>Includes Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INCLUDES_VALUE = 226;

    /**
     * The feature id for the '<em><b>Index Map</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INDEX_MAP = 227;

    /**
     * The feature id for the '<em><b>Indirect Entry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INDIRECT_ENTRY = 228;

    /**
     * The feature id for the '<em><b>Inner Boundary Is</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INNER_BOUNDARY_IS = 229;

    /**
     * The feature id for the '<em><b>Interior</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INTERIOR = 230;

    /**
     * The feature id for the '<em><b>Integer Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INTEGER_VALUE = 231;

    /**
     * The feature id for the '<em><b>Integer Value List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INTEGER_VALUE_LIST = 232;

    /**
     * The feature id for the '<em><b>Inverse Flattening</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__INVERSE_FLATTENING = 233;

    /**
     * The feature id for the '<em><b>Isolated</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ISOLATED = 234;

    /**
     * The feature id for the '<em><b>Is Sphere</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__IS_SPHERE = 235;

    /**
     * The feature id for the '<em><b>Label Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LABEL_STYLE = 236;

    /**
     * The feature id for the '<em><b>Label Style1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LABEL_STYLE1 = 237;

    /**
     * The feature id for the '<em><b>Linear CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LINEAR_CS = 238;

    /**
     * The feature id for the '<em><b>Linear CS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LINEAR_CS_REF = 239;

    /**
     * The feature id for the '<em><b>Linear Ring</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LINEAR_RING = 240;

    /**
     * The feature id for the '<em><b>Line String</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LINE_STRING = 241;

    /**
     * The feature id for the '<em><b>Line String Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LINE_STRING_MEMBER = 242;

    /**
     * The feature id for the '<em><b>Line String Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LINE_STRING_PROPERTY = 243;

    /**
     * The feature id for the '<em><b>Line String Segment</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LINE_STRING_SEGMENT = 244;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LOCATION = 245;

    /**
     * The feature id for the '<em><b>Location Key Word</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LOCATION_KEY_WORD = 246;

    /**
     * The feature id for the '<em><b>Location String</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__LOCATION_STRING = 247;

    /**
     * The feature id for the '<em><b>Mapping Rule</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MAPPING_RULE = 248;

    /**
     * The feature id for the '<em><b>Maximal Complex</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MAXIMAL_COMPLEX = 249;

    /**
     * The feature id for the '<em><b>Maximum Occurs</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MAXIMUM_OCCURS = 250;

    /**
     * The feature id for the '<em><b>Measure</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MEASURE = 251;

    /**
     * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MEASURE_DESCRIPTION = 252;

    /**
     * The feature id for the '<em><b>Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MEMBER = 253;

    /**
     * The feature id for the '<em><b>Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MEMBERS = 254;

    /**
     * The feature id for the '<em><b>Meridian ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MERIDIAN_ID = 255;

    /**
     * The feature id for the '<em><b>Meridian Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MERIDIAN_NAME = 256;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__META_DATA_PROPERTY = 257;

    /**
     * The feature id for the '<em><b>Method Formula</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__METHOD_FORMULA = 258;

    /**
     * The feature id for the '<em><b>Method ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__METHOD_ID = 259;

    /**
     * The feature id for the '<em><b>Method Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__METHOD_NAME = 260;

    /**
     * The feature id for the '<em><b>Minimum Occurs</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MINIMUM_OCCURS = 261;

    /**
     * The feature id for the '<em><b>Minutes</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MINUTES = 262;

    /**
     * The feature id for the '<em><b>Modified Coordinate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MODIFIED_COORDINATE = 263;

    /**
     * The feature id for the '<em><b>Moving Object Status</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MOVING_OBJECT_STATUS = 264;

    /**
     * The feature id for the '<em><b>Multi Center Line Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_CENTER_LINE_OF = 265;

    /**
     * The feature id for the '<em><b>Multi Center Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_CENTER_OF = 266;

    /**
     * The feature id for the '<em><b>Multi Coverage</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_COVERAGE = 267;

    /**
     * The feature id for the '<em><b>Multi Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_CURVE = 268;

    /**
     * The feature id for the '<em><b>Multi Curve Coverage</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_CURVE_COVERAGE = 269;

    /**
     * The feature id for the '<em><b>Multi Curve Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_CURVE_DOMAIN = 270;

    /**
     * The feature id for the '<em><b>Multi Curve Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_CURVE_PROPERTY = 271;

    /**
     * The feature id for the '<em><b>Multi Edge Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_EDGE_OF = 272;

    /**
     * The feature id for the '<em><b>Multi Extent Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_EXTENT_OF = 273;

    /**
     * The feature id for the '<em><b>Multi Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_GEOMETRY = 274;

    /**
     * The feature id for the '<em><b>Multi Geometry Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_GEOMETRY_PROPERTY = 275;

    /**
     * The feature id for the '<em><b>Multi Line String</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_LINE_STRING = 276;

    /**
     * The feature id for the '<em><b>Multi Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_LOCATION = 277;

    /**
     * The feature id for the '<em><b>Multi Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_POINT = 278;

    /**
     * The feature id for the '<em><b>Multi Point Coverage</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_POINT_COVERAGE = 279;

    /**
     * The feature id for the '<em><b>Multi Point Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_POINT_DOMAIN = 280;

    /**
     * The feature id for the '<em><b>Multi Point Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_POINT_PROPERTY = 281;

    /**
     * The feature id for the '<em><b>Multi Polygon</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_POLYGON = 282;

    /**
     * The feature id for the '<em><b>Multi Position</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_POSITION = 283;

    /**
     * The feature id for the '<em><b>Multi Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_SOLID = 284;

    /**
     * The feature id for the '<em><b>Multi Solid Coverage</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_SOLID_COVERAGE = 285;

    /**
     * The feature id for the '<em><b>Multi Solid Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_SOLID_DOMAIN = 286;

    /**
     * The feature id for the '<em><b>Multi Solid Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_SOLID_PROPERTY = 287;

    /**
     * The feature id for the '<em><b>Multi Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_SURFACE = 288;

    /**
     * The feature id for the '<em><b>Multi Surface Coverage</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_SURFACE_COVERAGE = 289;

    /**
     * The feature id for the '<em><b>Multi Surface Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_SURFACE_DOMAIN = 290;

    /**
     * The feature id for the '<em><b>Multi Surface Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__MULTI_SURFACE_PROPERTY = 291;

    /**
     * The feature id for the '<em><b>Node</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__NODE = 292;

    /**
     * The feature id for the '<em><b>Null</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__NULL = 293;

    /**
     * The feature id for the '<em><b>Oblique Cartesian CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OBLIQUE_CARTESIAN_CS = 294;

    /**
     * The feature id for the '<em><b>Oblique Cartesian CS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OBLIQUE_CARTESIAN_CS_REF = 295;

    /**
     * The feature id for the '<em><b>Offset Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OFFSET_CURVE = 296;

    /**
     * The feature id for the '<em><b>Operation Method</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OPERATION_METHOD = 297;

    /**
     * The feature id for the '<em><b>Operation Method Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OPERATION_METHOD_REF = 298;

    /**
     * The feature id for the '<em><b>Operation Parameter</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OPERATION_PARAMETER = 299;

    /**
     * The feature id for the '<em><b>Operation Parameter Group</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OPERATION_PARAMETER_GROUP = 300;

    /**
     * The feature id for the '<em><b>Operation Parameter Group Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OPERATION_PARAMETER_GROUP_REF = 301;

    /**
     * The feature id for the '<em><b>Operation Parameter Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OPERATION_PARAMETER_REF = 302;

    /**
     * The feature id for the '<em><b>Operation Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OPERATION_REF = 303;

    /**
     * The feature id for the '<em><b>Operation Version</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OPERATION_VERSION = 304;

    /**
     * The feature id for the '<em><b>Orientable Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ORIENTABLE_CURVE = 305;

    /**
     * The feature id for the '<em><b>Orientable Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ORIENTABLE_SURFACE = 306;

    /**
     * The feature id for the '<em><b>Origin</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ORIGIN = 307;

    /**
     * The feature id for the '<em><b>Outer Boundary Is</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__OUTER_BOUNDARY_IS = 308;

    /**
     * The feature id for the '<em><b>Parameter ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PARAMETER_ID = 309;

    /**
     * The feature id for the '<em><b>Parameter Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PARAMETER_NAME = 310;

    /**
     * The feature id for the '<em><b>Parameter Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PARAMETER_VALUE = 311;

    /**
     * The feature id for the '<em><b>Parameter Value Group</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PARAMETER_VALUE_GROUP = 312;

    /**
     * The feature id for the '<em><b>Pass Through Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PASS_THROUGH_OPERATION = 313;

    /**
     * The feature id for the '<em><b>Pass Through Operation Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PASS_THROUGH_OPERATION_REF = 314;

    /**
     * The feature id for the '<em><b>Patches</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PATCHES = 315;

    /**
     * The feature id for the '<em><b>Pixel In Cell</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PIXEL_IN_CELL = 316;

    /**
     * The feature id for the '<em><b>Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POINT = 317;

    /**
     * The feature id for the '<em><b>Point Array Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POINT_ARRAY_PROPERTY = 318;

    /**
     * The feature id for the '<em><b>Point Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POINT_MEMBER = 319;

    /**
     * The feature id for the '<em><b>Point Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POINT_MEMBERS = 320;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POINT_PROPERTY = 321;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POINT_REP = 322;

    /**
     * The feature id for the '<em><b>Polar CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POLAR_CS = 323;

    /**
     * The feature id for the '<em><b>Polar CS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POLAR_CS_REF = 324;

    /**
     * The feature id for the '<em><b>Polygon</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POLYGON = 325;

    /**
     * The feature id for the '<em><b>Polygon Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POLYGON_MEMBER = 326;

    /**
     * The feature id for the '<em><b>Polygon Patch</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POLYGON_PATCH = 327;

    /**
     * The feature id for the '<em><b>Polygon Patches</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POLYGON_PATCHES = 328;

    /**
     * The feature id for the '<em><b>Polygon Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POLYGON_PROPERTY = 329;

    /**
     * The feature id for the '<em><b>Polyhedral Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POLYHEDRAL_SURFACE = 330;

    /**
     * The feature id for the '<em><b>Surface1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SURFACE1 = 331;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POS = 332;

    /**
     * The feature id for the '<em><b>Position</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POSITION = 333;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__POS_LIST = 334;

    /**
     * The feature id for the '<em><b>Prime Meridian</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PRIME_MERIDIAN = 335;

    /**
     * The feature id for the '<em><b>Prime Meridian Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PRIME_MERIDIAN_REF = 336;

    /**
     * The feature id for the '<em><b>Priority Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PRIORITY_LOCATION = 337;

    /**
     * The feature id for the '<em><b>Projected CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PROJECTED_CRS = 338;

    /**
     * The feature id for the '<em><b>Projected CRS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__PROJECTED_CRS_REF = 339;

    /**
     * The feature id for the '<em><b>Quantity</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__QUANTITY = 340;

    /**
     * The feature id for the '<em><b>Quantity Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__QUANTITY_EXTENT = 341;

    /**
     * The feature id for the '<em><b>Quantity List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__QUANTITY_LIST = 342;

    /**
     * The feature id for the '<em><b>Quantity Type</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__QUANTITY_TYPE = 343;

    /**
     * The feature id for the '<em><b>Range Parameters</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RANGE_PARAMETERS = 344;

    /**
     * The feature id for the '<em><b>Range Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RANGE_SET = 345;

    /**
     * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__REALIZATION_EPOCH = 346;

    /**
     * The feature id for the '<em><b>Rectangle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RECTANGLE = 347;

    /**
     * The feature id for the '<em><b>Rectified Grid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RECTIFIED_GRID = 348;

    /**
     * The feature id for the '<em><b>Rectified Grid Coverage</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RECTIFIED_GRID_COVERAGE = 349;

    /**
     * The feature id for the '<em><b>Rectified Grid Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RECTIFIED_GRID_DOMAIN = 350;

    /**
     * The feature id for the '<em><b>Reference System Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__REFERENCE_SYSTEM_REF = 351;

    /**
     * The feature id for the '<em><b>Relative Internal Positional Accuracy</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RELATIVE_INTERNAL_POSITIONAL_ACCURACY = 352;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__REMARKS = 353;

    /**
     * The feature id for the '<em><b>Result</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RESULT = 354;

    /**
     * The feature id for the '<em><b>Result Of</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RESULT_OF = 355;

    /**
     * The feature id for the '<em><b>Ring1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__RING1 = 356;

    /**
     * The feature id for the '<em><b>Rough Conversion To Preferred Unit</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ROUGH_CONVERSION_TO_PREFERRED_UNIT = 357;

    /**
     * The feature id for the '<em><b>Row Index</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ROW_INDEX = 358;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SCOPE = 359;

    /**
     * The feature id for the '<em><b>Second Defining Parameter</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SECOND_DEFINING_PARAMETER = 360;

    /**
     * The feature id for the '<em><b>Seconds</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SECONDS = 361;

    /**
     * The feature id for the '<em><b>Segments</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SEGMENTS = 362;

    /**
     * The feature id for the '<em><b>Semi Major Axis</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SEMI_MAJOR_AXIS = 363;

    /**
     * The feature id for the '<em><b>Semi Minor Axis</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SEMI_MINOR_AXIS = 364;

    /**
     * The feature id for the '<em><b>Single Operation Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SINGLE_OPERATION_REF = 365;

    /**
     * The feature id for the '<em><b>Solid1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SOLID1 = 366;

    /**
     * The feature id for the '<em><b>Solid Array Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SOLID_ARRAY_PROPERTY = 367;

    /**
     * The feature id for the '<em><b>Solid Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SOLID_MEMBER = 368;

    /**
     * The feature id for the '<em><b>Solid Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SOLID_MEMBERS = 369;

    /**
     * The feature id for the '<em><b>Solid Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SOLID_PROPERTY = 370;

    /**
     * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SOURCE_CRS = 371;

    /**
     * The feature id for the '<em><b>Source Dimensions</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SOURCE_DIMENSIONS = 372;

    /**
     * The feature id for the '<em><b>Sphere</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SPHERE = 373;

    /**
     * The feature id for the '<em><b>Spherical CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SPHERICAL_CS = 374;

    /**
     * The feature id for the '<em><b>Spherical CS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SPHERICAL_CS_REF = 375;

    /**
     * The feature id for the '<em><b>Srs ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SRS_ID = 376;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SRS_NAME = 377;

    /**
     * The feature id for the '<em><b>Status</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__STATUS = 378;

    /**
     * The feature id for the '<em><b>String Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__STRING_VALUE = 379;

    /**
     * The feature id for the '<em><b>Style1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__STYLE1 = 380;

    /**
     * The feature id for the '<em><b>Sub Complex</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SUB_COMPLEX = 381;

    /**
     * The feature id for the '<em><b>Subject</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SUBJECT = 382;

    /**
     * The feature id for the '<em><b>Target</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TARGET = 383;

    /**
     * The feature id for the '<em><b>Super Complex</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SUPER_COMPLEX = 384;

    /**
     * The feature id for the '<em><b>Surface Array Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SURFACE_ARRAY_PROPERTY = 385;

    /**
     * The feature id for the '<em><b>Surface Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SURFACE_MEMBER = 386;

    /**
     * The feature id for the '<em><b>Surface Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SURFACE_MEMBERS = 387;

    /**
     * The feature id for the '<em><b>Surface Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SURFACE_PROPERTY = 388;

    /**
     * The feature id for the '<em><b>Symbol</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__SYMBOL = 389;

    /**
     * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TARGET_CRS = 390;

    /**
     * The feature id for the '<em><b>Target Dimensions</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TARGET_DIMENSIONS = 391;

    /**
     * The feature id for the '<em><b>Temporal CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TEMPORAL_CRS = 392;

    /**
     * The feature id for the '<em><b>Temporal CRS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TEMPORAL_CRS_REF = 393;

    /**
     * The feature id for the '<em><b>Temporal CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TEMPORAL_CS = 394;

    /**
     * The feature id for the '<em><b>Temporal CS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TEMPORAL_CS_REF = 395;

    /**
     * The feature id for the '<em><b>Temporal Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TEMPORAL_DATUM = 396;

    /**
     * The feature id for the '<em><b>Temporal Datum Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TEMPORAL_DATUM_REF = 397;

    /**
     * The feature id for the '<em><b>Temporal Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TEMPORAL_EXTENT = 398;

    /**
     * The feature id for the '<em><b>Time Calendar</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_CALENDAR = 399;

    /**
     * The feature id for the '<em><b>Time Calendar Era</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_CALENDAR_ERA = 400;

    /**
     * The feature id for the '<em><b>Time Clock</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_CLOCK = 401;

    /**
     * The feature id for the '<em><b>Time Coordinate System</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_COORDINATE_SYSTEM = 402;

    /**
     * The feature id for the '<em><b>Time Edge</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_EDGE = 403;

    /**
     * The feature id for the '<em><b>Time Instant</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_INSTANT = 404;

    /**
     * The feature id for the '<em><b>Time Interval</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_INTERVAL = 405;

    /**
     * The feature id for the '<em><b>Time Node</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_NODE = 406;

    /**
     * The feature id for the '<em><b>Time Ordinal Era</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_ORDINAL_ERA = 407;

    /**
     * The feature id for the '<em><b>Time Ordinal Reference System</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_ORDINAL_REFERENCE_SYSTEM = 408;

    /**
     * The feature id for the '<em><b>Time Period</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_PERIOD = 409;

    /**
     * The feature id for the '<em><b>Time Position</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_POSITION = 410;

    /**
     * The feature id for the '<em><b>Time Topology Complex</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIME_TOPOLOGY_COMPLEX = 411;

    /**
     * The feature id for the '<em><b>Tin</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TIN = 412;

    /**
     * The feature id for the '<em><b>Triangulated Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TRIANGULATED_SURFACE = 413;

    /**
     * The feature id for the '<em><b>Topo Complex</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_COMPLEX = 414;

    /**
     * The feature id for the '<em><b>Topo Complex Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_COMPLEX_PROPERTY = 415;

    /**
     * The feature id for the '<em><b>Topo Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_CURVE = 416;

    /**
     * The feature id for the '<em><b>Topo Curve Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_CURVE_PROPERTY = 417;

    /**
     * The feature id for the '<em><b>Topology Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPOLOGY_STYLE = 418;

    /**
     * The feature id for the '<em><b>Topology Style1</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPOLOGY_STYLE1 = 419;

    /**
     * The feature id for the '<em><b>Topo Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_POINT = 420;

    /**
     * The feature id for the '<em><b>Topo Point Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_POINT_PROPERTY = 421;

    /**
     * The feature id for the '<em><b>Topo Primitive Member</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_PRIMITIVE_MEMBER = 422;

    /**
     * The feature id for the '<em><b>Topo Primitive Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_PRIMITIVE_MEMBERS = 423;

    /**
     * The feature id for the '<em><b>Topo Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_SOLID = 424;

    /**
     * The feature id for the '<em><b>Topo Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_SURFACE = 425;

    /**
     * The feature id for the '<em><b>Topo Surface Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_SURFACE_PROPERTY = 426;

    /**
     * The feature id for the '<em><b>Topo Volume</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_VOLUME = 427;

    /**
     * The feature id for the '<em><b>Topo Volume Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TOPO_VOLUME_PROPERTY = 428;

    /**
     * The feature id for the '<em><b>Track</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TRACK = 429;

    /**
     * The feature id for the '<em><b>Transformation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TRANSFORMATION = 430;

    /**
     * The feature id for the '<em><b>Transformation Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TRANSFORMATION_REF = 431;

    /**
     * The feature id for the '<em><b>Triangle</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TRIANGLE = 432;

    /**
     * The feature id for the '<em><b>Triangle Patches</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TRIANGLE_PATCHES = 433;

    /**
     * The feature id for the '<em><b>Tuple List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TUPLE_LIST = 434;

    /**
     * The feature id for the '<em><b>Unit Of Measure</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__UNIT_OF_MEASURE = 435;

    /**
     * The feature id for the '<em><b>User Defined CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USER_DEFINED_CS = 436;

    /**
     * The feature id for the '<em><b>User Defined CS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USER_DEFINED_CS_REF = 437;

    /**
     * The feature id for the '<em><b>Uses Axis</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_AXIS = 438;

    /**
     * The feature id for the '<em><b>Uses Cartesian CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_CARTESIAN_CS = 439;

    /**
     * The feature id for the '<em><b>Uses CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_CS = 440;

    /**
     * The feature id for the '<em><b>Uses Ellipsoid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_ELLIPSOID = 441;

    /**
     * The feature id for the '<em><b>Uses Ellipsoidal CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_ELLIPSOIDAL_CS = 442;

    /**
     * The feature id for the '<em><b>Uses Engineering Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_ENGINEERING_DATUM = 443;

    /**
     * The feature id for the '<em><b>Uses Geodetic Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_GEODETIC_DATUM = 444;

    /**
     * The feature id for the '<em><b>Uses Image Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_IMAGE_DATUM = 445;

    /**
     * The feature id for the '<em><b>Uses Method</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_METHOD = 446;

    /**
     * The feature id for the '<em><b>Uses Oblique Cartesian CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_OBLIQUE_CARTESIAN_CS = 447;

    /**
     * The feature id for the '<em><b>Uses Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_OPERATION = 448;

    /**
     * The feature id for the '<em><b>Uses Parameter</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_PARAMETER = 449;

    /**
     * The feature id for the '<em><b>Uses Prime Meridian</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_PRIME_MERIDIAN = 450;

    /**
     * The feature id for the '<em><b>Uses Single Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_SINGLE_OPERATION = 451;

    /**
     * The feature id for the '<em><b>Uses Spherical CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_SPHERICAL_CS = 452;

    /**
     * The feature id for the '<em><b>Uses Temporal CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_TEMPORAL_CS = 453;

    /**
     * The feature id for the '<em><b>Uses Temporal Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_TEMPORAL_DATUM = 454;

    /**
     * The feature id for the '<em><b>Uses Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_VALUE = 455;

    /**
     * The feature id for the '<em><b>Uses Vertical CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_VERTICAL_CS = 456;

    /**
     * The feature id for the '<em><b>Uses Vertical Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USES_VERTICAL_DATUM = 457;

    /**
     * The feature id for the '<em><b>Using</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__USING = 458;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALID_AREA = 459;

    /**
     * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALID_TIME = 460;

    /**
     * The feature id for the '<em><b>Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALUE = 461;

    /**
     * The feature id for the '<em><b>Value Array</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALUE_ARRAY = 462;

    /**
     * The feature id for the '<em><b>Value Component</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALUE_COMPONENT = 463;

    /**
     * The feature id for the '<em><b>Value Components</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALUE_COMPONENTS = 464;

    /**
     * The feature id for the '<em><b>Value File</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALUE_FILE = 465;

    /**
     * The feature id for the '<em><b>Value List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALUE_LIST = 466;

    /**
     * The feature id for the '<em><b>Value Of Parameter</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALUE_OF_PARAMETER = 467;

    /**
     * The feature id for the '<em><b>Value Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALUE_PROPERTY = 468;

    /**
     * The feature id for the '<em><b>Values Of Group</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VALUES_OF_GROUP = 469;

    /**
     * The feature id for the '<em><b>Vector</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VECTOR = 470;

    /**
     * The feature id for the '<em><b>Version</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VERSION = 471;

    /**
     * The feature id for the '<em><b>Vertical CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VERTICAL_CRS = 472;

    /**
     * The feature id for the '<em><b>Vertical CRS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VERTICAL_CRS_REF = 473;

    /**
     * The feature id for the '<em><b>Vertical CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VERTICAL_CS = 474;

    /**
     * The feature id for the '<em><b>Vertical CS Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VERTICAL_CS_REF = 475;

    /**
     * The feature id for the '<em><b>Vertical Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VERTICAL_DATUM = 476;

    /**
     * The feature id for the '<em><b>Vertical Datum Ref</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VERTICAL_DATUM_REF = 477;

    /**
     * The feature id for the '<em><b>Vertical Datum Type</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VERTICAL_DATUM_TYPE = 478;

    /**
     * The feature id for the '<em><b>Vertical Extent</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__VERTICAL_EXTENT = 479;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__ID = 480;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__REMOTE_SCHEMA = 481;

    /**
     * The feature id for the '<em><b>Transform</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__TRANSFORM = 482;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT__UOM = 483;

    /**
     * The number of structural features of the '<em>Document Root</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT_FEATURE_COUNT = 484;

    /**
     * The number of operations of the '<em>Document Root</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOCUMENT_ROOT_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DomainSetTypeImpl <em>Domain Set Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DomainSetTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDomainSetType()
     * @generated
     */
    int DOMAIN_SET_TYPE = 139;

    /**
     * The feature id for the '<em><b>Geometry Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__GEOMETRY_GROUP = 0;

    /**
     * The feature id for the '<em><b>Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__GEOMETRY = 1;

    /**
     * The feature id for the '<em><b>Time Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__TIME_OBJECT_GROUP = 2;

    /**
     * The feature id for the '<em><b>Time Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__TIME_OBJECT = 3;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__ACTUATE = 4;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__ARCROLE = 5;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__HREF = 6;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__REMOTE_SCHEMA = 7;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__ROLE = 8;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__SHOW = 9;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__TITLE = 10;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE__TYPE = 11;

    /**
     * The number of structural features of the '<em>Domain Set Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE_FEATURE_COUNT = 12;

    /**
     * The number of operations of the '<em>Domain Set Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DOMAIN_SET_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.FeatureCollectionTypeImpl <em>Feature Collection Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.FeatureCollectionTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getFeatureCollectionType()
     * @generated
     */
    int FEATURE_COLLECTION_TYPE = 157;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_COLLECTION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE__DESCRIPTION = ABSTRACT_FEATURE_COLLECTION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE__NAME_GROUP = ABSTRACT_FEATURE_COLLECTION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE__NAME = ABSTRACT_FEATURE_COLLECTION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE__ID = ABSTRACT_FEATURE_COLLECTION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_COLLECTION_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_COLLECTION_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE__LOCATION = ABSTRACT_FEATURE_COLLECTION_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Feature Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE__FEATURE_MEMBER = ABSTRACT_FEATURE_COLLECTION_TYPE__FEATURE_MEMBER;

    /**
     * The feature id for the '<em><b>Feature Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE__FEATURE_MEMBERS = ABSTRACT_FEATURE_COLLECTION_TYPE__FEATURE_MEMBERS;

    /**
     * The number of structural features of the '<em>Feature Collection Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_COLLECTION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Feature Collection Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_COLLECTION_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_COLLECTION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DynamicFeatureCollectionTypeImpl <em>Dynamic Feature Collection Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DynamicFeatureCollectionTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDynamicFeatureCollectionType()
     * @generated
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE = 140;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__META_DATA_PROPERTY = FEATURE_COLLECTION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__DESCRIPTION = FEATURE_COLLECTION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__NAME_GROUP = FEATURE_COLLECTION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__NAME = FEATURE_COLLECTION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__ID = FEATURE_COLLECTION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__BOUNDED_BY = FEATURE_COLLECTION_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__LOCATION_GROUP = FEATURE_COLLECTION_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__LOCATION = FEATURE_COLLECTION_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Feature Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__FEATURE_MEMBER = FEATURE_COLLECTION_TYPE__FEATURE_MEMBER;

    /**
     * The feature id for the '<em><b>Feature Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__FEATURE_MEMBERS = FEATURE_COLLECTION_TYPE__FEATURE_MEMBERS;

    /**
     * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__VALID_TIME = FEATURE_COLLECTION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>History Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__HISTORY_GROUP = FEATURE_COLLECTION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>History</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__HISTORY = FEATURE_COLLECTION_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Data Source</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE__DATA_SOURCE = FEATURE_COLLECTION_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the '<em>Dynamic Feature Collection Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE_FEATURE_COUNT = FEATURE_COLLECTION_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of operations of the '<em>Dynamic Feature Collection Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_COLLECTION_TYPE_OPERATION_COUNT = FEATURE_COLLECTION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.DynamicFeatureTypeImpl <em>Dynamic Feature Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.DynamicFeatureTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getDynamicFeatureType()
     * @generated
     */
    int DYNAMIC_FEATURE_TYPE = 141;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__DESCRIPTION = ABSTRACT_FEATURE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__NAME_GROUP = ABSTRACT_FEATURE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__NAME = ABSTRACT_FEATURE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__ID = ABSTRACT_FEATURE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__LOCATION = ABSTRACT_FEATURE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__VALID_TIME = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>History Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__HISTORY_GROUP = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>History</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__HISTORY = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Data Source</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE__DATA_SOURCE = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the '<em>Dynamic Feature Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of operations of the '<em>Dynamic Feature Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DYNAMIC_FEATURE_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EdgeTypeImpl <em>Edge Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EdgeTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEdgeType()
     * @generated
     */
    int EDGE_TYPE = 142;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE__META_DATA_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE__DESCRIPTION = ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE__NAME_GROUP = ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE__NAME = ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE__ID = ABSTRACT_TOPO_PRIMITIVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Isolated</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE__ISOLATED = ABSTRACT_TOPO_PRIMITIVE_TYPE__ISOLATED;

    /**
     * The feature id for the '<em><b>Container</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE__CONTAINER = ABSTRACT_TOPO_PRIMITIVE_TYPE__CONTAINER;

    /**
     * The feature id for the '<em><b>Directed Node</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE__DIRECTED_NODE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Directed Face</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE__DIRECTED_FACE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Curve Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE__CURVE_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Edge Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE_FEATURE_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Edge Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EDGE_TYPE_OPERATION_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EllipsoidalCSRefTypeImpl <em>Ellipsoidal CS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EllipsoidalCSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEllipsoidalCSRefType()
     * @generated
     */
    int ELLIPSOIDAL_CS_REF_TYPE = 143;

    /**
     * The feature id for the '<em><b>Ellipsoidal CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE__ELLIPSOIDAL_CS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Ellipsoidal CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Ellipsoidal CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EllipsoidalCSTypeImpl <em>Ellipsoidal CS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EllipsoidalCSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEllipsoidalCSType()
     * @generated
     */
    int ELLIPSOIDAL_CS_TYPE = 144;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Cs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE__CS_NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_NAME;

    /**
     * The feature id for the '<em><b>Cs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE__CS_ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Uses Axis</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE__USES_AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__USES_AXIS;

    /**
     * The number of structural features of the '<em>Ellipsoidal CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Ellipsoidal CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOIDAL_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EllipsoidBaseTypeImpl <em>Ellipsoid Base Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EllipsoidBaseTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEllipsoidBaseType()
     * @generated
     */
    int ELLIPSOID_BASE_TYPE = 145;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_BASE_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_BASE_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_BASE_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_BASE_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_BASE_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Ellipsoid Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_BASE_TYPE__ELLIPSOID_NAME = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Ellipsoid Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_BASE_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Ellipsoid Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_BASE_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EllipsoidRefTypeImpl <em>Ellipsoid Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EllipsoidRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEllipsoidRefType()
     * @generated
     */
    int ELLIPSOID_REF_TYPE = 146;

    /**
     * The feature id for the '<em><b>Ellipsoid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE__ELLIPSOID = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Ellipsoid Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Ellipsoid Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EllipsoidTypeImpl <em>Ellipsoid Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EllipsoidTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEllipsoidType()
     * @generated
     */
    int ELLIPSOID_TYPE = 147;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE__META_DATA_PROPERTY = ELLIPSOID_BASE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE__DESCRIPTION = ELLIPSOID_BASE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE__NAME_GROUP = ELLIPSOID_BASE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE__NAME = ELLIPSOID_BASE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE__ID = ELLIPSOID_BASE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Ellipsoid Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE__ELLIPSOID_NAME = ELLIPSOID_BASE_TYPE__ELLIPSOID_NAME;

    /**
     * The feature id for the '<em><b>Ellipsoid ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE__ELLIPSOID_ID = ELLIPSOID_BASE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE__REMARKS = ELLIPSOID_BASE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Semi Major Axis</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE__SEMI_MAJOR_AXIS = ELLIPSOID_BASE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Second Defining Parameter</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE__SECOND_DEFINING_PARAMETER = ELLIPSOID_BASE_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the '<em>Ellipsoid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE_FEATURE_COUNT = ELLIPSOID_BASE_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of operations of the '<em>Ellipsoid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ELLIPSOID_TYPE_OPERATION_COUNT = ELLIPSOID_BASE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EngineeringCRSRefTypeImpl <em>Engineering CRS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EngineeringCRSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEngineeringCRSRefType()
     * @generated
     */
    int ENGINEERING_CRS_REF_TYPE = 148;

    /**
     * The feature id for the '<em><b>Engineering CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE__ENGINEERING_CRS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Engineering CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Engineering CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EngineeringCRSTypeImpl <em>Engineering CRS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EngineeringCRSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEngineeringCRSType()
     * @generated
     */
    int ENGINEERING_CRS_TYPE = 149;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_REFERENCE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__DESCRIPTION = ABSTRACT_REFERENCE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__NAME_GROUP = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__SRS_NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Srs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__SRS_ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__REMARKS = ABSTRACT_REFERENCE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__VALID_AREA = ABSTRACT_REFERENCE_SYSTEM_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__SCOPE = ABSTRACT_REFERENCE_SYSTEM_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Uses CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__USES_CS = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Uses Engineering Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE__USES_ENGINEERING_DATUM = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Engineering CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE_FEATURE_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Engineering CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_CRS_TYPE_OPERATION_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EngineeringDatumRefTypeImpl <em>Engineering Datum Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EngineeringDatumRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEngineeringDatumRefType()
     * @generated
     */
    int ENGINEERING_DATUM_REF_TYPE = 150;

    /**
     * The feature id for the '<em><b>Engineering Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE__ENGINEERING_DATUM = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Engineering Datum Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Engineering Datum Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EngineeringDatumTypeImpl <em>Engineering Datum Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EngineeringDatumTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEngineeringDatumType()
     * @generated
     */
    int ENGINEERING_DATUM_TYPE = 151;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__META_DATA_PROPERTY = ABSTRACT_DATUM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__DESCRIPTION = ABSTRACT_DATUM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__NAME_GROUP = ABSTRACT_DATUM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__NAME = ABSTRACT_DATUM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__ID = ABSTRACT_DATUM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Datum Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__DATUM_NAME = ABSTRACT_DATUM_TYPE__DATUM_NAME;

    /**
     * The feature id for the '<em><b>Datum ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__DATUM_ID = ABSTRACT_DATUM_TYPE__DATUM_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__REMARKS = ABSTRACT_DATUM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Anchor Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__ANCHOR_POINT = ABSTRACT_DATUM_TYPE__ANCHOR_POINT;

    /**
     * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__REALIZATION_EPOCH = ABSTRACT_DATUM_TYPE__REALIZATION_EPOCH;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__VALID_AREA = ABSTRACT_DATUM_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE__SCOPE = ABSTRACT_DATUM_TYPE__SCOPE;

    /**
     * The number of structural features of the '<em>Engineering Datum Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE_FEATURE_COUNT = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Engineering Datum Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENGINEERING_DATUM_TYPE_OPERATION_COUNT = ABSTRACT_DATUM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EnvelopeTypeImpl <em>Envelope Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EnvelopeTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEnvelopeType()
     * @generated
     */
    int ENVELOPE_TYPE = 152;

    /**
     * The feature id for the '<em><b>Lower Corner</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE__LOWER_CORNER = 0;

    /**
     * The feature id for the '<em><b>Upper Corner</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE__UPPER_CORNER = 1;

    /**
     * The feature id for the '<em><b>Coord</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE__COORD = 2;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE__POS = 3;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE__COORDINATES = 4;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE__AXIS_LABELS = 5;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE__SRS_DIMENSION = 6;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE__SRS_NAME = 7;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE__UOM_LABELS = 8;

    /**
     * The number of structural features of the '<em>Envelope Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Envelope Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.EnvelopeWithTimePeriodTypeImpl <em>Envelope With Time Period Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.EnvelopeWithTimePeriodTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getEnvelopeWithTimePeriodType()
     * @generated
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE = 153;

    /**
     * The feature id for the '<em><b>Lower Corner</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__LOWER_CORNER = ENVELOPE_TYPE__LOWER_CORNER;

    /**
     * The feature id for the '<em><b>Upper Corner</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__UPPER_CORNER = ENVELOPE_TYPE__UPPER_CORNER;

    /**
     * The feature id for the '<em><b>Coord</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__COORD = ENVELOPE_TYPE__COORD;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__POS = ENVELOPE_TYPE__POS;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__COORDINATES = ENVELOPE_TYPE__COORDINATES;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__AXIS_LABELS = ENVELOPE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__SRS_DIMENSION = ENVELOPE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__SRS_NAME = ENVELOPE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__UOM_LABELS = ENVELOPE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Time Position</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__TIME_POSITION = ENVELOPE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Frame</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE__FRAME = ENVELOPE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Envelope With Time Period Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE_FEATURE_COUNT = ENVELOPE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Envelope With Time Period Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ENVELOPE_WITH_TIME_PERIOD_TYPE_OPERATION_COUNT = ENVELOPE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ExtentTypeImpl <em>Extent Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ExtentTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getExtentType()
     * @generated
     */
    int EXTENT_TYPE = 154;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENT_TYPE__DESCRIPTION = 0;

    /**
     * The feature id for the '<em><b>Bounding Box</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENT_TYPE__BOUNDING_BOX = 1;

    /**
     * The feature id for the '<em><b>Bounding Polygon</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENT_TYPE__BOUNDING_POLYGON = 2;

    /**
     * The feature id for the '<em><b>Vertical Extent</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENT_TYPE__VERTICAL_EXTENT = 3;

    /**
     * The feature id for the '<em><b>Temporal Extent</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENT_TYPE__TEMPORAL_EXTENT = 4;

    /**
     * The number of structural features of the '<em>Extent Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENT_TYPE_FEATURE_COUNT = 5;

    /**
     * The number of operations of the '<em>Extent Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENT_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.FaceTypeImpl <em>Face Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.FaceTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getFaceType()
     * @generated
     */
    int FACE_TYPE = 155;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE__META_DATA_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE__DESCRIPTION = ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE__NAME_GROUP = ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE__NAME = ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE__ID = ABSTRACT_TOPO_PRIMITIVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Isolated</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE__ISOLATED = ABSTRACT_TOPO_PRIMITIVE_TYPE__ISOLATED;

    /**
     * The feature id for the '<em><b>Container</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE__CONTAINER = ABSTRACT_TOPO_PRIMITIVE_TYPE__CONTAINER;

    /**
     * The feature id for the '<em><b>Directed Edge</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE__DIRECTED_EDGE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Directed Topo Solid</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE__DIRECTED_TOPO_SOLID = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Surface Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE__SURFACE_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Face Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE_FEATURE_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Face Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FACE_TYPE_OPERATION_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.FeatureArrayPropertyTypeImpl <em>Feature Array Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.FeatureArrayPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getFeatureArrayPropertyType()
     * @generated
     */
    int FEATURE_ARRAY_PROPERTY_TYPE = 156;

    /**
     * The feature id for the '<em><b>Feature Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_ARRAY_PROPERTY_TYPE__FEATURE_GROUP = 0;

    /**
     * The feature id for the '<em><b>Feature</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_ARRAY_PROPERTY_TYPE__FEATURE = 1;

    /**
     * The number of structural features of the '<em>Feature Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Feature Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.FeaturePropertyTypeImpl <em>Feature Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.FeaturePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getFeaturePropertyType()
     * @generated
     */
    int FEATURE_PROPERTY_TYPE = 158;

    /**
     * The feature id for the '<em><b>Feature Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE__FEATURE_GROUP = 0;

    /**
     * The feature id for the '<em><b>Feature</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE__FEATURE = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Feature Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Feature Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.FeatureStylePropertyTypeImpl <em>Feature Style Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.FeatureStylePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getFeatureStylePropertyType()
     * @generated
     */
    int FEATURE_STYLE_PROPERTY_TYPE = 159;

    /**
     * The feature id for the '<em><b>Feature Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE__FEATURE_STYLE = 0;

    /**
     * The feature id for the '<em><b>About</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE__ABOUT = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Feature Style Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Feature Style Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.FeatureStyleTypeImpl <em>Feature Style Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.FeatureStyleTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getFeatureStyleType()
     * @generated
     */
    int FEATURE_STYLE_TYPE = 160;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__NAME_GROUP = ABSTRACT_GML_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__ID = ABSTRACT_GML_TYPE__ID;

    /**
     * The feature id for the '<em><b>Feature Constraint</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__FEATURE_CONSTRAINT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Geometry Style</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__GEOMETRY_STYLE = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Topology Style</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__TOPOLOGY_STYLE = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Label Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__LABEL_STYLE = ABSTRACT_GML_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Base Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__BASE_TYPE = ABSTRACT_GML_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Feature Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__FEATURE_TYPE = ABSTRACT_GML_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Query Grammar</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE__QUERY_GRAMMAR = ABSTRACT_GML_TYPE_FEATURE_COUNT + 6;

    /**
     * The number of structural features of the '<em>Feature Style Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 7;

    /**
     * The number of operations of the '<em>Feature Style Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_STYLE_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.FileTypeImpl <em>File Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.FileTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getFileType()
     * @generated
     */
    int FILE_TYPE = 161;

    /**
     * The feature id for the '<em><b>Range Parameters</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FILE_TYPE__RANGE_PARAMETERS = 0;

    /**
     * The feature id for the '<em><b>File Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FILE_TYPE__FILE_NAME = 1;

    /**
     * The feature id for the '<em><b>File Structure</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FILE_TYPE__FILE_STRUCTURE = 2;

    /**
     * The feature id for the '<em><b>Mime Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FILE_TYPE__MIME_TYPE = 3;

    /**
     * The feature id for the '<em><b>Compression</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FILE_TYPE__COMPRESSION = 4;

    /**
     * The number of structural features of the '<em>File Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FILE_TYPE_FEATURE_COUNT = 5;

    /**
     * The number of operations of the '<em>File Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FILE_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.FormulaTypeImpl <em>Formula Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.FormulaTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getFormulaType()
     * @generated
     */
    int FORMULA_TYPE = 162;

    /**
     * The feature id for the '<em><b>A</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FORMULA_TYPE__A = 0;

    /**
     * The feature id for the '<em><b>B</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FORMULA_TYPE__B = 1;

    /**
     * The feature id for the '<em><b>C</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FORMULA_TYPE__C = 2;

    /**
     * The feature id for the '<em><b>D</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FORMULA_TYPE__D = 3;

    /**
     * The number of structural features of the '<em>Formula Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FORMULA_TYPE_FEATURE_COUNT = 4;

    /**
     * The number of operations of the '<em>Formula Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FORMULA_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeneralConversionRefTypeImpl <em>General Conversion Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeneralConversionRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeneralConversionRefType()
     * @generated
     */
    int GENERAL_CONVERSION_REF_TYPE = 163;

    /**
     * The feature id for the '<em><b>General Conversion Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE__GENERAL_CONVERSION_GROUP = 0;

    /**
     * The feature id for the '<em><b>General Conversion</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE__GENERAL_CONVERSION = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>General Conversion Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>General Conversion Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_CONVERSION_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeneralTransformationRefTypeImpl <em>General Transformation Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeneralTransformationRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeneralTransformationRefType()
     * @generated
     */
    int GENERAL_TRANSFORMATION_REF_TYPE = 164;

    /**
     * The feature id for the '<em><b>General Transformation Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE__GENERAL_TRANSFORMATION_GROUP = 0;

    /**
     * The feature id for the '<em><b>General Transformation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE__GENERAL_TRANSFORMATION = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>General Transformation Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>General Transformation Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERAL_TRANSFORMATION_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GenericMetaDataTypeImpl <em>Generic Meta Data Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GenericMetaDataTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGenericMetaDataType()
     * @generated
     */
    int GENERIC_META_DATA_TYPE = 165;

    /**
     * The feature id for the '<em><b>Mixed</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERIC_META_DATA_TYPE__MIXED = ABSTRACT_META_DATA_TYPE__MIXED;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERIC_META_DATA_TYPE__ID = ABSTRACT_META_DATA_TYPE__ID;

    /**
     * The feature id for the '<em><b>Any</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERIC_META_DATA_TYPE__ANY = ABSTRACT_META_DATA_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Generic Meta Data Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERIC_META_DATA_TYPE_FEATURE_COUNT = ABSTRACT_META_DATA_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Generic Meta Data Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GENERIC_META_DATA_TYPE_OPERATION_COUNT = ABSTRACT_META_DATA_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeocentricCRSRefTypeImpl <em>Geocentric CRS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeocentricCRSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeocentricCRSRefType()
     * @generated
     */
    int GEOCENTRIC_CRS_REF_TYPE = 166;

    /**
     * The feature id for the '<em><b>Geocentric CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE__GEOCENTRIC_CRS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Geocentric CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Geocentric CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeocentricCRSTypeImpl <em>Geocentric CRS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeocentricCRSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeocentricCRSType()
     * @generated
     */
    int GEOCENTRIC_CRS_TYPE = 167;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_REFERENCE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__DESCRIPTION = ABSTRACT_REFERENCE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__NAME_GROUP = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__SRS_NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Srs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__SRS_ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__REMARKS = ABSTRACT_REFERENCE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__VALID_AREA = ABSTRACT_REFERENCE_SYSTEM_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__SCOPE = ABSTRACT_REFERENCE_SYSTEM_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Uses Cartesian CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__USES_CARTESIAN_CS = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Uses Spherical CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__USES_SPHERICAL_CS = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Uses Geodetic Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE__USES_GEODETIC_DATUM = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Geocentric CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE_FEATURE_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Geocentric CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOCENTRIC_CRS_TYPE_OPERATION_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeodesicStringTypeImpl <em>Geodesic String Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeodesicStringTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeodesicStringType()
     * @generated
     */
    int GEODESIC_STRING_TYPE = 168;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_STRING_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_STRING_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_STRING_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_STRING_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Geometric Position Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_STRING_TYPE__GEOMETRIC_POSITION_GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_STRING_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_STRING_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_STRING_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of structural features of the '<em>Geodesic String Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_STRING_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

    /**
     * The number of operations of the '<em>Geodesic String Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_STRING_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeodesicTypeImpl <em>Geodesic Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeodesicTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeodesicType()
     * @generated
     */
    int GEODESIC_TYPE = 169;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_TYPE__NUM_DERIVATIVE_INTERIOR = GEODESIC_STRING_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_TYPE__NUM_DERIVATIVES_AT_END = GEODESIC_STRING_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_TYPE__NUM_DERIVATIVES_AT_START = GEODESIC_STRING_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_TYPE__POS_LIST = GEODESIC_STRING_TYPE__POS_LIST;

    /**
     * The feature id for the '<em><b>Geometric Position Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_TYPE__GEOMETRIC_POSITION_GROUP = GEODESIC_STRING_TYPE__GEOMETRIC_POSITION_GROUP;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_TYPE__POS = GEODESIC_STRING_TYPE__POS;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_TYPE__POINT_PROPERTY = GEODESIC_STRING_TYPE__POINT_PROPERTY;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_TYPE__INTERPOLATION = GEODESIC_STRING_TYPE__INTERPOLATION;

    /**
     * The number of structural features of the '<em>Geodesic Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_TYPE_FEATURE_COUNT = GEODESIC_STRING_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Geodesic Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODESIC_TYPE_OPERATION_COUNT = GEODESIC_STRING_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeodeticDatumRefTypeImpl <em>Geodetic Datum Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeodeticDatumRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeodeticDatumRefType()
     * @generated
     */
    int GEODETIC_DATUM_REF_TYPE = 170;

    /**
     * The feature id for the '<em><b>Geodetic Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE__GEODETIC_DATUM = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Geodetic Datum Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Geodetic Datum Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeodeticDatumTypeImpl <em>Geodetic Datum Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeodeticDatumTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeodeticDatumType()
     * @generated
     */
    int GEODETIC_DATUM_TYPE = 171;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__META_DATA_PROPERTY = ABSTRACT_DATUM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__DESCRIPTION = ABSTRACT_DATUM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__NAME_GROUP = ABSTRACT_DATUM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__NAME = ABSTRACT_DATUM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__ID = ABSTRACT_DATUM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Datum Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__DATUM_NAME = ABSTRACT_DATUM_TYPE__DATUM_NAME;

    /**
     * The feature id for the '<em><b>Datum ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__DATUM_ID = ABSTRACT_DATUM_TYPE__DATUM_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__REMARKS = ABSTRACT_DATUM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Anchor Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__ANCHOR_POINT = ABSTRACT_DATUM_TYPE__ANCHOR_POINT;

    /**
     * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__REALIZATION_EPOCH = ABSTRACT_DATUM_TYPE__REALIZATION_EPOCH;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__VALID_AREA = ABSTRACT_DATUM_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__SCOPE = ABSTRACT_DATUM_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Uses Prime Meridian</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__USES_PRIME_MERIDIAN = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Uses Ellipsoid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE__USES_ELLIPSOID = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Geodetic Datum Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE_FEATURE_COUNT = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Geodetic Datum Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEODETIC_DATUM_TYPE_OPERATION_COUNT = ABSTRACT_DATUM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeographicCRSRefTypeImpl <em>Geographic CRS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeographicCRSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeographicCRSRefType()
     * @generated
     */
    int GEOGRAPHIC_CRS_REF_TYPE = 172;

    /**
     * The feature id for the '<em><b>Geographic CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE__GEOGRAPHIC_CRS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Geographic CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Geographic CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeographicCRSTypeImpl <em>Geographic CRS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeographicCRSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeographicCRSType()
     * @generated
     */
    int GEOGRAPHIC_CRS_TYPE = 173;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_REFERENCE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__DESCRIPTION = ABSTRACT_REFERENCE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__NAME_GROUP = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__SRS_NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Srs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__SRS_ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__REMARKS = ABSTRACT_REFERENCE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__VALID_AREA = ABSTRACT_REFERENCE_SYSTEM_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__SCOPE = ABSTRACT_REFERENCE_SYSTEM_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Uses Ellipsoidal CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__USES_ELLIPSOIDAL_CS = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Uses Geodetic Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE__USES_GEODETIC_DATUM = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Geographic CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE_FEATURE_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Geographic CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOGRAPHIC_CRS_TYPE_OPERATION_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeometricComplexPropertyTypeImpl <em>Geometric Complex Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeometricComplexPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeometricComplexPropertyType()
     * @generated
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE = 174;

    /**
     * The feature id for the '<em><b>Geometric Complex</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__GEOMETRIC_COMPLEX = 0;

    /**
     * The feature id for the '<em><b>Composite Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__COMPOSITE_CURVE = 1;

    /**
     * The feature id for the '<em><b>Composite Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__COMPOSITE_SURFACE = 2;

    /**
     * The feature id for the '<em><b>Composite Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__COMPOSITE_SOLID = 3;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__ACTUATE = 4;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__ARCROLE = 5;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__HREF = 6;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__ROLE = 8;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__SHOW = 9;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__TITLE = 10;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE__TYPE = 11;

    /**
     * The number of structural features of the '<em>Geometric Complex Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE_FEATURE_COUNT = 12;

    /**
     * The number of operations of the '<em>Geometric Complex Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeometricComplexTypeImpl <em>Geometric Complex Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeometricComplexTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeometricComplexType()
     * @generated
     */
    int GEOMETRIC_COMPLEX_TYPE = 175;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__DESCRIPTION = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__NAME_GROUP = ABSTRACT_GEOMETRY_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__NAME = ABSTRACT_GEOMETRY_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__ID = ABSTRACT_GEOMETRY_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__GID = ABSTRACT_GEOMETRY_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__SRS_NAME = ABSTRACT_GEOMETRY_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__UOM_LABELS = ABSTRACT_GEOMETRY_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Element</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE__ELEMENT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Geometric Complex Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Geometric Complex Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_COMPLEX_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeometricPrimitivePropertyTypeImpl <em>Geometric Primitive Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeometricPrimitivePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeometricPrimitivePropertyType()
     * @generated
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE = 176;

    /**
     * The feature id for the '<em><b>Geometric Primitive Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__GEOMETRIC_PRIMITIVE_GROUP = 0;

    /**
     * The feature id for the '<em><b>Geometric Primitive</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__GEOMETRIC_PRIMITIVE = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Geometric Primitive Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Geometric Primitive Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeometryArrayPropertyTypeImpl <em>Geometry Array Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeometryArrayPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeometryArrayPropertyType()
     * @generated
     */
    int GEOMETRY_ARRAY_PROPERTY_TYPE = 177;

    /**
     * The feature id for the '<em><b>Geometry Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_ARRAY_PROPERTY_TYPE__GEOMETRY_GROUP = 0;

    /**
     * The feature id for the '<em><b>Geometry</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_ARRAY_PROPERTY_TYPE__GEOMETRY = 1;

    /**
     * The number of structural features of the '<em>Geometry Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Geometry Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeometryPropertyTypeImpl <em>Geometry Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeometryPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeometryPropertyType()
     * @generated
     */
    int GEOMETRY_PROPERTY_TYPE = 178;

    /**
     * The feature id for the '<em><b>Geometry Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE__GEOMETRY_GROUP = 0;

    /**
     * The feature id for the '<em><b>Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE__GEOMETRY = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Geometry Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Geometry Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeometryStylePropertyTypeImpl <em>Geometry Style Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeometryStylePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeometryStylePropertyType()
     * @generated
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE = 179;

    /**
     * The feature id for the '<em><b>Geometry Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE__GEOMETRY_STYLE = 0;

    /**
     * The feature id for the '<em><b>About</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE__ABOUT = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Geometry Style Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Geometry Style Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GeometryStyleTypeImpl <em>Geometry Style Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GeometryStyleTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGeometryStyleType()
     * @generated
     */
    int GEOMETRY_STYLE_TYPE = 180;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__META_DATA_PROPERTY = BASE_STYLE_DESCRIPTOR_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__DESCRIPTION = BASE_STYLE_DESCRIPTOR_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__NAME_GROUP = BASE_STYLE_DESCRIPTOR_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__NAME = BASE_STYLE_DESCRIPTOR_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__ID = BASE_STYLE_DESCRIPTOR_TYPE__ID;

    /**
     * The feature id for the '<em><b>Spatial Resolution</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__SPATIAL_RESOLUTION = BASE_STYLE_DESCRIPTOR_TYPE__SPATIAL_RESOLUTION;

    /**
     * The feature id for the '<em><b>Style Variation</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__STYLE_VARIATION = BASE_STYLE_DESCRIPTOR_TYPE__STYLE_VARIATION;

    /**
     * The feature id for the '<em><b>Animate</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__ANIMATE = BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE;

    /**
     * The feature id for the '<em><b>Animate Motion</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__ANIMATE_MOTION = BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE_MOTION;

    /**
     * The feature id for the '<em><b>Animate Color</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__ANIMATE_COLOR = BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE_COLOR;

    /**
     * The feature id for the '<em><b>Set</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__SET = BASE_STYLE_DESCRIPTOR_TYPE__SET;

    /**
     * The feature id for the '<em><b>Symbol</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__SYMBOL = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Style</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__STYLE = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Label Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__LABEL_STYLE = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Geometry Property</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__GEOMETRY_PROPERTY = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Geometry Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE__GEOMETRY_TYPE = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of structural features of the '<em>Geometry Style Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE_FEATURE_COUNT = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 5;

    /**
     * The number of operations of the '<em>Geometry Style Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GEOMETRY_STYLE_TYPE_OPERATION_COUNT = BASE_STYLE_DESCRIPTOR_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GraphStylePropertyTypeImpl <em>Graph Style Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GraphStylePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGraphStylePropertyType()
     * @generated
     */
    int GRAPH_STYLE_PROPERTY_TYPE = 181;

    /**
     * The feature id for the '<em><b>Graph Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE__GRAPH_STYLE = 0;

    /**
     * The feature id for the '<em><b>About</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE__ABOUT = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Graph Style Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Graph Style Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GraphStyleTypeImpl <em>Graph Style Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GraphStyleTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGraphStyleType()
     * @generated
     */
    int GRAPH_STYLE_TYPE = 182;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__META_DATA_PROPERTY = BASE_STYLE_DESCRIPTOR_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__DESCRIPTION = BASE_STYLE_DESCRIPTOR_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__NAME_GROUP = BASE_STYLE_DESCRIPTOR_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__NAME = BASE_STYLE_DESCRIPTOR_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__ID = BASE_STYLE_DESCRIPTOR_TYPE__ID;

    /**
     * The feature id for the '<em><b>Spatial Resolution</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__SPATIAL_RESOLUTION = BASE_STYLE_DESCRIPTOR_TYPE__SPATIAL_RESOLUTION;

    /**
     * The feature id for the '<em><b>Style Variation</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__STYLE_VARIATION = BASE_STYLE_DESCRIPTOR_TYPE__STYLE_VARIATION;

    /**
     * The feature id for the '<em><b>Animate</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__ANIMATE = BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE;

    /**
     * The feature id for the '<em><b>Animate Motion</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__ANIMATE_MOTION = BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE_MOTION;

    /**
     * The feature id for the '<em><b>Animate Color</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__ANIMATE_COLOR = BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE_COLOR;

    /**
     * The feature id for the '<em><b>Set</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__SET = BASE_STYLE_DESCRIPTOR_TYPE__SET;

    /**
     * The feature id for the '<em><b>Planar</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__PLANAR = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Directed</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__DIRECTED = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Grid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__GRID = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Min Distance</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__MIN_DISTANCE = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Min Angle</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__MIN_ANGLE = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Graph Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__GRAPH_TYPE = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Drawing Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__DRAWING_TYPE = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 6;

    /**
     * The feature id for the '<em><b>Line Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__LINE_TYPE = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 7;

    /**
     * The feature id for the '<em><b>Aesthetic Criteria</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE__AESTHETIC_CRITERIA = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 8;

    /**
     * The number of structural features of the '<em>Graph Style Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE_FEATURE_COUNT = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 9;

    /**
     * The number of operations of the '<em>Graph Style Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRAPH_STYLE_TYPE_OPERATION_COUNT = BASE_STYLE_DESCRIPTOR_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GridCoverageTypeImpl <em>Grid Coverage Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GridCoverageTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGridCoverageType()
     * @generated
     */
    int GRID_COVERAGE_TYPE = 183;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_DISCRETE_COVERAGE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_DISCRETE_COVERAGE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__NAME_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__NAME = ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__ID = ABSTRACT_DISCRETE_COVERAGE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_DISCRETE_COVERAGE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__LOCATION = ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET_GROUP;

    /**
     * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET;

    /**
     * The feature id for the '<em><b>Range Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__RANGE_SET = ABSTRACT_DISCRETE_COVERAGE_TYPE__RANGE_SET;

    /**
     * The feature id for the '<em><b>Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__DIMENSION = ABSTRACT_DISCRETE_COVERAGE_TYPE__DIMENSION;

    /**
     * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__COVERAGE_FUNCTION = ABSTRACT_DISCRETE_COVERAGE_TYPE__COVERAGE_FUNCTION;

    /**
     * The feature id for the '<em><b>Grid Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE__GRID_DOMAIN = ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Grid Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Grid Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_DISCRETE_COVERAGE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GridDomainTypeImpl <em>Grid Domain Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GridDomainTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGridDomainType()
     * @generated
     */
    int GRID_DOMAIN_TYPE = 184;

    /**
     * The feature id for the '<em><b>Geometry Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__GEOMETRY_GROUP = DOMAIN_SET_TYPE__GEOMETRY_GROUP;

    /**
     * The feature id for the '<em><b>Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__GEOMETRY = DOMAIN_SET_TYPE__GEOMETRY;

    /**
     * The feature id for the '<em><b>Time Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__TIME_OBJECT_GROUP = DOMAIN_SET_TYPE__TIME_OBJECT_GROUP;

    /**
     * The feature id for the '<em><b>Time Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__TIME_OBJECT = DOMAIN_SET_TYPE__TIME_OBJECT;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__ACTUATE = DOMAIN_SET_TYPE__ACTUATE;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__ARCROLE = DOMAIN_SET_TYPE__ARCROLE;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__HREF = DOMAIN_SET_TYPE__HREF;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__REMOTE_SCHEMA = DOMAIN_SET_TYPE__REMOTE_SCHEMA;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__ROLE = DOMAIN_SET_TYPE__ROLE;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__SHOW = DOMAIN_SET_TYPE__SHOW;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__TITLE = DOMAIN_SET_TYPE__TITLE;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__TYPE = DOMAIN_SET_TYPE__TYPE;

    /**
     * The feature id for the '<em><b>Grid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE__GRID = DOMAIN_SET_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Grid Domain Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE_FEATURE_COUNT = DOMAIN_SET_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Grid Domain Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_DOMAIN_TYPE_OPERATION_COUNT = DOMAIN_SET_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GridEnvelopeTypeImpl <em>Grid Envelope Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GridEnvelopeTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGridEnvelopeType()
     * @generated
     */
    int GRID_ENVELOPE_TYPE = 185;

    /**
     * The feature id for the '<em><b>Low</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_ENVELOPE_TYPE__LOW = 0;

    /**
     * The feature id for the '<em><b>High</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_ENVELOPE_TYPE__HIGH = 1;

    /**
     * The number of structural features of the '<em>Grid Envelope Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_ENVELOPE_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Grid Envelope Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_ENVELOPE_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GridFunctionTypeImpl <em>Grid Function Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GridFunctionTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGridFunctionType()
     * @generated
     */
    int GRID_FUNCTION_TYPE = 186;

    /**
     * The feature id for the '<em><b>Sequence Rule</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_FUNCTION_TYPE__SEQUENCE_RULE = 0;

    /**
     * The feature id for the '<em><b>Start Point</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_FUNCTION_TYPE__START_POINT = 1;

    /**
     * The number of structural features of the '<em>Grid Function Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_FUNCTION_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Grid Function Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_FUNCTION_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GridLengthTypeImpl <em>Grid Length Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GridLengthTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGridLengthType()
     * @generated
     */
    int GRID_LENGTH_TYPE = 187;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_LENGTH_TYPE__VALUE = MEASURE_TYPE__VALUE;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_LENGTH_TYPE__UOM = MEASURE_TYPE__UOM;

    /**
     * The number of structural features of the '<em>Grid Length Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_LENGTH_TYPE_FEATURE_COUNT = MEASURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Grid Length Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_LENGTH_TYPE_OPERATION_COUNT = MEASURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GridLimitsTypeImpl <em>Grid Limits Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GridLimitsTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGridLimitsType()
     * @generated
     */
    int GRID_LIMITS_TYPE = 188;

    /**
     * The feature id for the '<em><b>Grid Envelope</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_LIMITS_TYPE__GRID_ENVELOPE = 0;

    /**
     * The number of structural features of the '<em>Grid Limits Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_LIMITS_TYPE_FEATURE_COUNT = 1;

    /**
     * The number of operations of the '<em>Grid Limits Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_LIMITS_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.GridTypeImpl <em>Grid Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.GridTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getGridType()
     * @generated
     */
    int GRID_TYPE = 189;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__DESCRIPTION = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__NAME_GROUP = ABSTRACT_GEOMETRY_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__NAME = ABSTRACT_GEOMETRY_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__ID = ABSTRACT_GEOMETRY_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__GID = ABSTRACT_GEOMETRY_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__SRS_NAME = ABSTRACT_GEOMETRY_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__UOM_LABELS = ABSTRACT_GEOMETRY_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Limits</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__LIMITS = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Axis Name</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__AXIS_NAME = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE__DIMENSION = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Grid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Grid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GRID_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.HistoryPropertyTypeImpl <em>History Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.HistoryPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getHistoryPropertyType()
     * @generated
     */
    int HISTORY_PROPERTY_TYPE = 190;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int HISTORY_PROPERTY_TYPE__GROUP = 0;

    /**
     * The feature id for the '<em><b>Time Slice Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int HISTORY_PROPERTY_TYPE__TIME_SLICE_GROUP = 1;

    /**
     * The feature id for the '<em><b>Time Slice</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int HISTORY_PROPERTY_TYPE__TIME_SLICE = 2;

    /**
     * The number of structural features of the '<em>History Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int HISTORY_PROPERTY_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>History Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int HISTORY_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.IdentifierTypeImpl <em>Identifier Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.IdentifierTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getIdentifierType()
     * @generated
     */
    int IDENTIFIER_TYPE = 191;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IDENTIFIER_TYPE__NAME_GROUP = 0;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IDENTIFIER_TYPE__NAME = 1;

    /**
     * The feature id for the '<em><b>Version</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IDENTIFIER_TYPE__VERSION = 2;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IDENTIFIER_TYPE__REMARKS = 3;

    /**
     * The number of structural features of the '<em>Identifier Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IDENTIFIER_TYPE_FEATURE_COUNT = 4;

    /**
     * The number of operations of the '<em>Identifier Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IDENTIFIER_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ImageCRSRefTypeImpl <em>Image CRS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ImageCRSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getImageCRSRefType()
     * @generated
     */
    int IMAGE_CRS_REF_TYPE = 192;

    /**
     * The feature id for the '<em><b>Image CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE__IMAGE_CRS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Image CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Image CRS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ImageCRSTypeImpl <em>Image CRS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ImageCRSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getImageCRSType()
     * @generated
     */
    int IMAGE_CRS_TYPE = 193;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_REFERENCE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__DESCRIPTION = ABSTRACT_REFERENCE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__NAME_GROUP = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__SRS_NAME = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Srs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__SRS_ID = ABSTRACT_REFERENCE_SYSTEM_TYPE__SRS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__REMARKS = ABSTRACT_REFERENCE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__VALID_AREA = ABSTRACT_REFERENCE_SYSTEM_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__SCOPE = ABSTRACT_REFERENCE_SYSTEM_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Uses Cartesian CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__USES_CARTESIAN_CS = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Uses Oblique Cartesian CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__USES_OBLIQUE_CARTESIAN_CS = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Uses Image Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE__USES_IMAGE_DATUM = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Image CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE_FEATURE_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Image CRS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_CRS_TYPE_OPERATION_COUNT = ABSTRACT_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ImageDatumRefTypeImpl <em>Image Datum Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ImageDatumRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getImageDatumRefType()
     * @generated
     */
    int IMAGE_DATUM_REF_TYPE = 194;

    /**
     * The feature id for the '<em><b>Image Datum</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE__IMAGE_DATUM = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Image Datum Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Image Datum Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ImageDatumTypeImpl <em>Image Datum Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ImageDatumTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getImageDatumType()
     * @generated
     */
    int IMAGE_DATUM_TYPE = 195;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__META_DATA_PROPERTY = ABSTRACT_DATUM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__DESCRIPTION = ABSTRACT_DATUM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__NAME_GROUP = ABSTRACT_DATUM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__NAME = ABSTRACT_DATUM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__ID = ABSTRACT_DATUM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Datum Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__DATUM_NAME = ABSTRACT_DATUM_TYPE__DATUM_NAME;

    /**
     * The feature id for the '<em><b>Datum ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__DATUM_ID = ABSTRACT_DATUM_TYPE__DATUM_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__REMARKS = ABSTRACT_DATUM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Anchor Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__ANCHOR_POINT = ABSTRACT_DATUM_TYPE__ANCHOR_POINT;

    /**
     * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__REALIZATION_EPOCH = ABSTRACT_DATUM_TYPE__REALIZATION_EPOCH;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__VALID_AREA = ABSTRACT_DATUM_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__SCOPE = ABSTRACT_DATUM_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Pixel In Cell</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE__PIXEL_IN_CELL = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Image Datum Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE_FEATURE_COUNT = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Image Datum Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int IMAGE_DATUM_TYPE_OPERATION_COUNT = ABSTRACT_DATUM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.IndexMapTypeImpl <em>Index Map Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.IndexMapTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getIndexMapType()
     * @generated
     */
    int INDEX_MAP_TYPE = 196;

    /**
     * The feature id for the '<em><b>Sequence Rule</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INDEX_MAP_TYPE__SEQUENCE_RULE = GRID_FUNCTION_TYPE__SEQUENCE_RULE;

    /**
     * The feature id for the '<em><b>Start Point</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INDEX_MAP_TYPE__START_POINT = GRID_FUNCTION_TYPE__START_POINT;

    /**
     * The feature id for the '<em><b>Look Up Table</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INDEX_MAP_TYPE__LOOK_UP_TABLE = GRID_FUNCTION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Index Map Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INDEX_MAP_TYPE_FEATURE_COUNT = GRID_FUNCTION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Index Map Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INDEX_MAP_TYPE_OPERATION_COUNT = GRID_FUNCTION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.IndirectEntryTypeImpl <em>Indirect Entry Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.IndirectEntryTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getIndirectEntryType()
     * @generated
     */
    int INDIRECT_ENTRY_TYPE = 197;

    /**
     * The feature id for the '<em><b>Definition Proxy</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INDIRECT_ENTRY_TYPE__DEFINITION_PROXY = 0;

    /**
     * The number of structural features of the '<em>Indirect Entry Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INDIRECT_ENTRY_TYPE_FEATURE_COUNT = 1;

    /**
     * The number of operations of the '<em>Indirect Entry Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int INDIRECT_ENTRY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.IsolatedPropertyTypeImpl <em>Isolated Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.IsolatedPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getIsolatedPropertyType()
     * @generated
     */
    int ISOLATED_PROPERTY_TYPE = 198;

    /**
     * The feature id for the '<em><b>Node</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE__NODE = 0;

    /**
     * The feature id for the '<em><b>Edge</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE__EDGE = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Isolated Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Isolated Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ISOLATED_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.KnotPropertyTypeImpl <em>Knot Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.KnotPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getKnotPropertyType()
     * @generated
     */
    int KNOT_PROPERTY_TYPE = 199;

    /**
     * The feature id for the '<em><b>Knot</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int KNOT_PROPERTY_TYPE__KNOT = 0;

    /**
     * The number of structural features of the '<em>Knot Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int KNOT_PROPERTY_TYPE_FEATURE_COUNT = 1;

    /**
     * The number of operations of the '<em>Knot Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int KNOT_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.KnotTypeImpl <em>Knot Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.KnotTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getKnotType()
     * @generated
     */
    int KNOT_TYPE = 200;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int KNOT_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int KNOT_TYPE__MULTIPLICITY = 1;

    /**
     * The feature id for the '<em><b>Weight</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int KNOT_TYPE__WEIGHT = 2;

    /**
     * The number of structural features of the '<em>Knot Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int KNOT_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>Knot Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int KNOT_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LabelStylePropertyTypeImpl <em>Label Style Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LabelStylePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLabelStylePropertyType()
     * @generated
     */
    int LABEL_STYLE_PROPERTY_TYPE = 201;

    /**
     * The feature id for the '<em><b>Label Style</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE__LABEL_STYLE = 0;

    /**
     * The feature id for the '<em><b>About</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE__ABOUT = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Label Style Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Label Style Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LabelStyleTypeImpl <em>Label Style Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LabelStyleTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLabelStyleType()
     * @generated
     */
    int LABEL_STYLE_TYPE = 202;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__META_DATA_PROPERTY = BASE_STYLE_DESCRIPTOR_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__DESCRIPTION = BASE_STYLE_DESCRIPTOR_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__NAME_GROUP = BASE_STYLE_DESCRIPTOR_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__NAME = BASE_STYLE_DESCRIPTOR_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__ID = BASE_STYLE_DESCRIPTOR_TYPE__ID;

    /**
     * The feature id for the '<em><b>Spatial Resolution</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__SPATIAL_RESOLUTION = BASE_STYLE_DESCRIPTOR_TYPE__SPATIAL_RESOLUTION;

    /**
     * The feature id for the '<em><b>Style Variation</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__STYLE_VARIATION = BASE_STYLE_DESCRIPTOR_TYPE__STYLE_VARIATION;

    /**
     * The feature id for the '<em><b>Animate</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__ANIMATE = BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE;

    /**
     * The feature id for the '<em><b>Animate Motion</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__ANIMATE_MOTION = BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE_MOTION;

    /**
     * The feature id for the '<em><b>Animate Color</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__ANIMATE_COLOR = BASE_STYLE_DESCRIPTOR_TYPE__ANIMATE_COLOR;

    /**
     * The feature id for the '<em><b>Set</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__SET = BASE_STYLE_DESCRIPTOR_TYPE__SET;

    /**
     * The feature id for the '<em><b>Style</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__STYLE = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Label</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE__LABEL = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Label Style Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE_FEATURE_COUNT = BASE_STYLE_DESCRIPTOR_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Label Style Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_STYLE_TYPE_OPERATION_COUNT = BASE_STYLE_DESCRIPTOR_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LabelTypeImpl <em>Label Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LabelTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLabelType()
     * @generated
     */
    int LABEL_TYPE = 203;

    /**
     * The feature id for the '<em><b>Mixed</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_TYPE__MIXED = 0;

    /**
     * The feature id for the '<em><b>Label Expression</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_TYPE__LABEL_EXPRESSION = 1;

    /**
     * The feature id for the '<em><b>Transform</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_TYPE__TRANSFORM = 2;

    /**
     * The number of structural features of the '<em>Label Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>Label Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LABEL_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LengthTypeImpl <em>Length Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LengthTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLengthType()
     * @generated
     */
    int LENGTH_TYPE = 204;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LENGTH_TYPE__VALUE = MEASURE_TYPE__VALUE;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LENGTH_TYPE__UOM = MEASURE_TYPE__UOM;

    /**
     * The number of structural features of the '<em>Length Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LENGTH_TYPE_FEATURE_COUNT = MEASURE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Length Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LENGTH_TYPE_OPERATION_COUNT = MEASURE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LinearCSRefTypeImpl <em>Linear CS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LinearCSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLinearCSRefType()
     * @generated
     */
    int LINEAR_CS_REF_TYPE = 205;

    /**
     * The feature id for the '<em><b>Linear CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE__LINEAR_CS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Linear CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Linear CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LinearCSTypeImpl <em>Linear CS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LinearCSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLinearCSType()
     * @generated
     */
    int LINEAR_CS_TYPE = 206;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Cs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE__CS_NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_NAME;

    /**
     * The feature id for the '<em><b>Cs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE__CS_ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Uses Axis</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE__USES_AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__USES_AXIS;

    /**
     * The number of structural features of the '<em>Linear CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Linear CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LinearRingPropertyTypeImpl <em>Linear Ring Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LinearRingPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLinearRingPropertyType()
     * @generated
     */
    int LINEAR_RING_PROPERTY_TYPE = 207;

    /**
     * The feature id for the '<em><b>Linear Ring</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_PROPERTY_TYPE__LINEAR_RING = 0;

    /**
     * The number of structural features of the '<em>Linear Ring Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_PROPERTY_TYPE_FEATURE_COUNT = 1;

    /**
     * The number of operations of the '<em>Linear Ring Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LinearRingTypeImpl <em>Linear Ring Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LinearRingTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLinearRingType()
     * @generated
     */
    int LINEAR_RING_TYPE = 208;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__META_DATA_PROPERTY = ABSTRACT_RING_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__DESCRIPTION = ABSTRACT_RING_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__NAME_GROUP = ABSTRACT_RING_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__NAME = ABSTRACT_RING_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__ID = ABSTRACT_RING_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__AXIS_LABELS = ABSTRACT_RING_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__GID = ABSTRACT_RING_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__SRS_DIMENSION = ABSTRACT_RING_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__SRS_NAME = ABSTRACT_RING_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__UOM_LABELS = ABSTRACT_RING_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__GROUP = ABSTRACT_RING_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__POS = ABSTRACT_RING_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__POINT_PROPERTY = ABSTRACT_RING_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__POINT_REP = ABSTRACT_RING_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__POS_LIST = ABSTRACT_RING_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__COORDINATES = ABSTRACT_RING_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Coord</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE__COORD = ABSTRACT_RING_TYPE_FEATURE_COUNT + 6;

    /**
     * The number of structural features of the '<em>Linear Ring Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE_FEATURE_COUNT = ABSTRACT_RING_TYPE_FEATURE_COUNT + 7;

    /**
     * The number of operations of the '<em>Linear Ring Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINEAR_RING_TYPE_OPERATION_COUNT = ABSTRACT_RING_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LineStringPropertyTypeImpl <em>Line String Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LineStringPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLineStringPropertyType()
     * @generated
     */
    int LINE_STRING_PROPERTY_TYPE = 209;

    /**
     * The feature id for the '<em><b>Line String</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE__LINE_STRING = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Line String Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Line String Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LineStringSegmentArrayPropertyTypeImpl <em>Line String Segment Array Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LineStringSegmentArrayPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLineStringSegmentArrayPropertyType()
     * @generated
     */
    int LINE_STRING_SEGMENT_ARRAY_PROPERTY_TYPE = 210;

    /**
     * The feature id for the '<em><b>Line String Segment</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_ARRAY_PROPERTY_TYPE__LINE_STRING_SEGMENT = 0;

    /**
     * The number of structural features of the '<em>Line String Segment Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 1;

    /**
     * The number of operations of the '<em>Line String Segment Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LineStringSegmentTypeImpl <em>Line String Segment Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LineStringSegmentTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLineStringSegmentType()
     * @generated
     */
    int LINE_STRING_SEGMENT_TYPE = 211;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE__GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

    /**
     * The number of structural features of the '<em>Line String Segment Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

    /**
     * The number of operations of the '<em>Line String Segment Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_SEGMENT_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LineStringTypeImpl <em>Line String Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LineStringTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLineStringType()
     * @generated
     */
    int LINE_STRING_TYPE = 212;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__META_DATA_PROPERTY = ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__DESCRIPTION = ABSTRACT_CURVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__NAME_GROUP = ABSTRACT_CURVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__NAME = ABSTRACT_CURVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__ID = ABSTRACT_CURVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__AXIS_LABELS = ABSTRACT_CURVE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__GID = ABSTRACT_CURVE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__SRS_DIMENSION = ABSTRACT_CURVE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__SRS_NAME = ABSTRACT_CURVE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__UOM_LABELS = ABSTRACT_CURVE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__GROUP = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__POS = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__POINT_REP = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Coord</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__COORD = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Pos List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__POS_LIST = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE__COORDINATES = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 6;

    /**
     * The number of structural features of the '<em>Line String Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 7;

    /**
     * The number of operations of the '<em>Line String Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LINE_STRING_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.LocationPropertyTypeImpl <em>Location Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.LocationPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getLocationPropertyType()
     * @generated
     */
    int LOCATION_PROPERTY_TYPE = 213;

    /**
     * The feature id for the '<em><b>Geometry Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__GEOMETRY_GROUP = 0;

    /**
     * The feature id for the '<em><b>Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__GEOMETRY = 1;

    /**
     * The feature id for the '<em><b>Location Key Word</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__LOCATION_KEY_WORD = 2;

    /**
     * The feature id for the '<em><b>Location String</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__LOCATION_STRING = 3;

    /**
     * The feature id for the '<em><b>Null</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__NULL = 4;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__ACTUATE = 5;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__ARCROLE = 6;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__HREF = 7;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__REMOTE_SCHEMA = 8;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__ROLE = 9;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__SHOW = 10;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__TITLE = 11;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE__TYPE = 12;

    /**
     * The number of structural features of the '<em>Location Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE_FEATURE_COUNT = 13;

    /**
     * The number of operations of the '<em>Location Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int LOCATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MeasureListTypeImpl <em>Measure List Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MeasureListTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMeasureListType()
     * @generated
     */
    int MEASURE_LIST_TYPE = 214;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_LIST_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_LIST_TYPE__UOM = 1;

    /**
     * The number of structural features of the '<em>Measure List Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_LIST_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Measure List Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_LIST_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MeasureOrNullListTypeImpl <em>Measure Or Null List Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MeasureOrNullListTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMeasureOrNullListType()
     * @generated
     */
    int MEASURE_OR_NULL_LIST_TYPE = 215;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_OR_NULL_LIST_TYPE__VALUE = 0;

    /**
     * The feature id for the '<em><b>Uom</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_OR_NULL_LIST_TYPE__UOM = 1;

    /**
     * The number of structural features of the '<em>Measure Or Null List Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_OR_NULL_LIST_TYPE_FEATURE_COUNT = 2;

    /**
     * The number of operations of the '<em>Measure Or Null List Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MEASURE_OR_NULL_LIST_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MetaDataPropertyTypeImpl <em>Meta Data Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MetaDataPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMetaDataPropertyType()
     * @generated
     */
    int META_DATA_PROPERTY_TYPE = 217;

    /**
     * The feature id for the '<em><b>Any</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE__ANY = 0;

    /**
     * The feature id for the '<em><b>About</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE__ABOUT = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Meta Data Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Meta Data Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int META_DATA_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MovingObjectStatusTypeImpl <em>Moving Object Status Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MovingObjectStatusTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMovingObjectStatusType()
     * @generated
     */
    int MOVING_OBJECT_STATUS_TYPE = 218;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__META_DATA_PROPERTY = ABSTRACT_TIME_SLICE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__DESCRIPTION = ABSTRACT_TIME_SLICE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__NAME_GROUP = ABSTRACT_TIME_SLICE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__NAME = ABSTRACT_TIME_SLICE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__ID = ABSTRACT_TIME_SLICE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__VALID_TIME = ABSTRACT_TIME_SLICE_TYPE__VALID_TIME;

    /**
     * The feature id for the '<em><b>Data Source</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__DATA_SOURCE = ABSTRACT_TIME_SLICE_TYPE__DATA_SOURCE;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__LOCATION_GROUP = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__LOCATION = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Speed</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__SPEED = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Bearing</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__BEARING = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Acceleration</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__ACCELERATION = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Elevation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__ELEVATION = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Status</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE__STATUS = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 6;

    /**
     * The number of structural features of the '<em>Moving Object Status Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE_FEATURE_COUNT = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 7;

    /**
     * The number of operations of the '<em>Moving Object Status Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MOVING_OBJECT_STATUS_TYPE_OPERATION_COUNT = ABSTRACT_TIME_SLICE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiCurveCoverageTypeImpl <em>Multi Curve Coverage Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiCurveCoverageTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiCurveCoverageType()
     * @generated
     */
    int MULTI_CURVE_COVERAGE_TYPE = 219;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_DISCRETE_COVERAGE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_DISCRETE_COVERAGE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__NAME_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__NAME = ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__ID = ABSTRACT_DISCRETE_COVERAGE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_DISCRETE_COVERAGE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__LOCATION = ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET_GROUP;

    /**
     * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET;

    /**
     * The feature id for the '<em><b>Range Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__RANGE_SET = ABSTRACT_DISCRETE_COVERAGE_TYPE__RANGE_SET;

    /**
     * The feature id for the '<em><b>Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__DIMENSION = ABSTRACT_DISCRETE_COVERAGE_TYPE__DIMENSION;

    /**
     * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__COVERAGE_FUNCTION = ABSTRACT_DISCRETE_COVERAGE_TYPE__COVERAGE_FUNCTION;

    /**
     * The feature id for the '<em><b>Multi Curve Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE__MULTI_CURVE_DOMAIN = ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Multi Curve Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Multi Curve Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_DISCRETE_COVERAGE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiCurveDomainTypeImpl <em>Multi Curve Domain Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiCurveDomainTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiCurveDomainType()
     * @generated
     */
    int MULTI_CURVE_DOMAIN_TYPE = 220;

    /**
     * The feature id for the '<em><b>Geometry Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__GEOMETRY_GROUP = DOMAIN_SET_TYPE__GEOMETRY_GROUP;

    /**
     * The feature id for the '<em><b>Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__GEOMETRY = DOMAIN_SET_TYPE__GEOMETRY;

    /**
     * The feature id for the '<em><b>Time Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__TIME_OBJECT_GROUP = DOMAIN_SET_TYPE__TIME_OBJECT_GROUP;

    /**
     * The feature id for the '<em><b>Time Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__TIME_OBJECT = DOMAIN_SET_TYPE__TIME_OBJECT;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__ACTUATE = DOMAIN_SET_TYPE__ACTUATE;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__ARCROLE = DOMAIN_SET_TYPE__ARCROLE;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__HREF = DOMAIN_SET_TYPE__HREF;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__REMOTE_SCHEMA = DOMAIN_SET_TYPE__REMOTE_SCHEMA;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__ROLE = DOMAIN_SET_TYPE__ROLE;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__SHOW = DOMAIN_SET_TYPE__SHOW;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__TITLE = DOMAIN_SET_TYPE__TITLE;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__TYPE = DOMAIN_SET_TYPE__TYPE;

    /**
     * The feature id for the '<em><b>Multi Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE__MULTI_CURVE = DOMAIN_SET_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Multi Curve Domain Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE_FEATURE_COUNT = DOMAIN_SET_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Multi Curve Domain Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_DOMAIN_TYPE_OPERATION_COUNT = DOMAIN_SET_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiCurvePropertyTypeImpl <em>Multi Curve Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiCurvePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiCurvePropertyType()
     * @generated
     */
    int MULTI_CURVE_PROPERTY_TYPE = 221;

    /**
     * The feature id for the '<em><b>Multi Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE__MULTI_CURVE = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Multi Curve Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Multi Curve Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiCurveTypeImpl <em>Multi Curve Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiCurveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiCurveType()
     * @generated
     */
    int MULTI_CURVE_TYPE = 222;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__GID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Curve Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__CURVE_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Curve Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE__CURVE_MEMBERS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Multi Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Multi Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_CURVE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiGeometryPropertyTypeImpl <em>Multi Geometry Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiGeometryPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiGeometryPropertyType()
     * @generated
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE = 223;

    /**
     * The feature id for the '<em><b>Geometric Aggregate Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE__GEOMETRIC_AGGREGATE_GROUP = 0;

    /**
     * The feature id for the '<em><b>Geometric Aggregate</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE__GEOMETRIC_AGGREGATE = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Multi Geometry Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Multi Geometry Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiGeometryTypeImpl <em>Multi Geometry Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiGeometryTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiGeometryType()
     * @generated
     */
    int MULTI_GEOMETRY_TYPE = 224;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__GID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Geometry Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__GEOMETRY_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Geometry Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE__GEOMETRY_MEMBERS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Multi Geometry Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Multi Geometry Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_GEOMETRY_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiLineStringPropertyTypeImpl <em>Multi Line String Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiLineStringPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiLineStringPropertyType()
     * @generated
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE = 225;

    /**
     * The feature id for the '<em><b>Multi Line String</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE__MULTI_LINE_STRING = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Multi Line String Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Multi Line String Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiLineStringTypeImpl <em>Multi Line String Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiLineStringTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiLineStringType()
     * @generated
     */
    int MULTI_LINE_STRING_TYPE = 226;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__GID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Line String Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE__LINE_STRING_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Multi Line String Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Multi Line String Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_LINE_STRING_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiPointCoverageTypeImpl <em>Multi Point Coverage Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiPointCoverageTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiPointCoverageType()
     * @generated
     */
    int MULTI_POINT_COVERAGE_TYPE = 227;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_DISCRETE_COVERAGE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_DISCRETE_COVERAGE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__NAME_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__NAME = ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__ID = ABSTRACT_DISCRETE_COVERAGE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_DISCRETE_COVERAGE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__LOCATION = ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET_GROUP;

    /**
     * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET;

    /**
     * The feature id for the '<em><b>Range Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__RANGE_SET = ABSTRACT_DISCRETE_COVERAGE_TYPE__RANGE_SET;

    /**
     * The feature id for the '<em><b>Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__DIMENSION = ABSTRACT_DISCRETE_COVERAGE_TYPE__DIMENSION;

    /**
     * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__COVERAGE_FUNCTION = ABSTRACT_DISCRETE_COVERAGE_TYPE__COVERAGE_FUNCTION;

    /**
     * The feature id for the '<em><b>Multi Point Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE__MULTI_POINT_DOMAIN = ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Multi Point Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Multi Point Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_DISCRETE_COVERAGE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiPointDomainTypeImpl <em>Multi Point Domain Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiPointDomainTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiPointDomainType()
     * @generated
     */
    int MULTI_POINT_DOMAIN_TYPE = 228;

    /**
     * The feature id for the '<em><b>Geometry Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__GEOMETRY_GROUP = DOMAIN_SET_TYPE__GEOMETRY_GROUP;

    /**
     * The feature id for the '<em><b>Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__GEOMETRY = DOMAIN_SET_TYPE__GEOMETRY;

    /**
     * The feature id for the '<em><b>Time Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__TIME_OBJECT_GROUP = DOMAIN_SET_TYPE__TIME_OBJECT_GROUP;

    /**
     * The feature id for the '<em><b>Time Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__TIME_OBJECT = DOMAIN_SET_TYPE__TIME_OBJECT;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__ACTUATE = DOMAIN_SET_TYPE__ACTUATE;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__ARCROLE = DOMAIN_SET_TYPE__ARCROLE;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__HREF = DOMAIN_SET_TYPE__HREF;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__REMOTE_SCHEMA = DOMAIN_SET_TYPE__REMOTE_SCHEMA;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__ROLE = DOMAIN_SET_TYPE__ROLE;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__SHOW = DOMAIN_SET_TYPE__SHOW;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__TITLE = DOMAIN_SET_TYPE__TITLE;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__TYPE = DOMAIN_SET_TYPE__TYPE;

    /**
     * The feature id for the '<em><b>Multi Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE__MULTI_POINT = DOMAIN_SET_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Multi Point Domain Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE_FEATURE_COUNT = DOMAIN_SET_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Multi Point Domain Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_DOMAIN_TYPE_OPERATION_COUNT = DOMAIN_SET_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiPointPropertyTypeImpl <em>Multi Point Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiPointPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiPointPropertyType()
     * @generated
     */
    int MULTI_POINT_PROPERTY_TYPE = 229;

    /**
     * The feature id for the '<em><b>Multi Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE__MULTI_POINT = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Multi Point Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Multi Point Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiPointTypeImpl <em>Multi Point Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiPointTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiPointType()
     * @generated
     */
    int MULTI_POINT_TYPE = 230;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__GID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Point Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__POINT_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Point Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE__POINT_MEMBERS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Multi Point Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Multi Point Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POINT_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiPolygonPropertyTypeImpl <em>Multi Polygon Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiPolygonPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiPolygonPropertyType()
     * @generated
     */
    int MULTI_POLYGON_PROPERTY_TYPE = 231;

    /**
     * The feature id for the '<em><b>Multi Polygon</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE__MULTI_POLYGON = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Multi Polygon Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Multi Polygon Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiPolygonTypeImpl <em>Multi Polygon Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiPolygonTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiPolygonType()
     * @generated
     */
    int MULTI_POLYGON_TYPE = 232;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__GID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Polygon Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE__POLYGON_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Multi Polygon Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Multi Polygon Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_POLYGON_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiSolidCoverageTypeImpl <em>Multi Solid Coverage Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiSolidCoverageTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiSolidCoverageType()
     * @generated
     */
    int MULTI_SOLID_COVERAGE_TYPE = 233;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_DISCRETE_COVERAGE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_DISCRETE_COVERAGE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__NAME_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__NAME = ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__ID = ABSTRACT_DISCRETE_COVERAGE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_DISCRETE_COVERAGE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__LOCATION = ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET_GROUP;

    /**
     * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET;

    /**
     * The feature id for the '<em><b>Range Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__RANGE_SET = ABSTRACT_DISCRETE_COVERAGE_TYPE__RANGE_SET;

    /**
     * The feature id for the '<em><b>Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__DIMENSION = ABSTRACT_DISCRETE_COVERAGE_TYPE__DIMENSION;

    /**
     * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__COVERAGE_FUNCTION = ABSTRACT_DISCRETE_COVERAGE_TYPE__COVERAGE_FUNCTION;

    /**
     * The feature id for the '<em><b>Multi Solid Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE__MULTI_SOLID_DOMAIN = ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Multi Solid Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Multi Solid Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_DISCRETE_COVERAGE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiSolidDomainTypeImpl <em>Multi Solid Domain Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiSolidDomainTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiSolidDomainType()
     * @generated
     */
    int MULTI_SOLID_DOMAIN_TYPE = 234;

    /**
     * The feature id for the '<em><b>Geometry Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__GEOMETRY_GROUP = DOMAIN_SET_TYPE__GEOMETRY_GROUP;

    /**
     * The feature id for the '<em><b>Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__GEOMETRY = DOMAIN_SET_TYPE__GEOMETRY;

    /**
     * The feature id for the '<em><b>Time Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__TIME_OBJECT_GROUP = DOMAIN_SET_TYPE__TIME_OBJECT_GROUP;

    /**
     * The feature id for the '<em><b>Time Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__TIME_OBJECT = DOMAIN_SET_TYPE__TIME_OBJECT;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__ACTUATE = DOMAIN_SET_TYPE__ACTUATE;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__ARCROLE = DOMAIN_SET_TYPE__ARCROLE;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__HREF = DOMAIN_SET_TYPE__HREF;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__REMOTE_SCHEMA = DOMAIN_SET_TYPE__REMOTE_SCHEMA;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__ROLE = DOMAIN_SET_TYPE__ROLE;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__SHOW = DOMAIN_SET_TYPE__SHOW;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__TITLE = DOMAIN_SET_TYPE__TITLE;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__TYPE = DOMAIN_SET_TYPE__TYPE;

    /**
     * The feature id for the '<em><b>Multi Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE__MULTI_SOLID = DOMAIN_SET_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Multi Solid Domain Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE_FEATURE_COUNT = DOMAIN_SET_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Multi Solid Domain Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_DOMAIN_TYPE_OPERATION_COUNT = DOMAIN_SET_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiSolidPropertyTypeImpl <em>Multi Solid Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiSolidPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiSolidPropertyType()
     * @generated
     */
    int MULTI_SOLID_PROPERTY_TYPE = 235;

    /**
     * The feature id for the '<em><b>Multi Solid</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE__MULTI_SOLID = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Multi Solid Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Multi Solid Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiSolidTypeImpl <em>Multi Solid Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiSolidTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiSolidType()
     * @generated
     */
    int MULTI_SOLID_TYPE = 236;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__GID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Solid Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__SOLID_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Solid Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE__SOLID_MEMBERS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Multi Solid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Multi Solid Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SOLID_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiSurfaceCoverageTypeImpl <em>Multi Surface Coverage Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiSurfaceCoverageTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiSurfaceCoverageType()
     * @generated
     */
    int MULTI_SURFACE_COVERAGE_TYPE = 237;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_DISCRETE_COVERAGE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_DISCRETE_COVERAGE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__NAME_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__NAME = ABSTRACT_DISCRETE_COVERAGE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__ID = ABSTRACT_DISCRETE_COVERAGE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_DISCRETE_COVERAGE_TYPE__BOUNDED_BY;

    /**
     * The feature id for the '<em><b>Location Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION_GROUP;

    /**
     * The feature id for the '<em><b>Location</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__LOCATION = ABSTRACT_DISCRETE_COVERAGE_TYPE__LOCATION;

    /**
     * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET_GROUP;

    /**
     * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_DISCRETE_COVERAGE_TYPE__DOMAIN_SET;

    /**
     * The feature id for the '<em><b>Range Set</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__RANGE_SET = ABSTRACT_DISCRETE_COVERAGE_TYPE__RANGE_SET;

    /**
     * The feature id for the '<em><b>Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__DIMENSION = ABSTRACT_DISCRETE_COVERAGE_TYPE__DIMENSION;

    /**
     * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__COVERAGE_FUNCTION = ABSTRACT_DISCRETE_COVERAGE_TYPE__COVERAGE_FUNCTION;

    /**
     * The feature id for the '<em><b>Multi Surface Domain</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE__MULTI_SURFACE_DOMAIN = ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Multi Surface Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_DISCRETE_COVERAGE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Multi Surface Coverage Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_DISCRETE_COVERAGE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiSurfaceDomainTypeImpl <em>Multi Surface Domain Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiSurfaceDomainTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiSurfaceDomainType()
     * @generated
     */
    int MULTI_SURFACE_DOMAIN_TYPE = 238;

    /**
     * The feature id for the '<em><b>Geometry Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__GEOMETRY_GROUP = DOMAIN_SET_TYPE__GEOMETRY_GROUP;

    /**
     * The feature id for the '<em><b>Geometry</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__GEOMETRY = DOMAIN_SET_TYPE__GEOMETRY;

    /**
     * The feature id for the '<em><b>Time Object Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__TIME_OBJECT_GROUP = DOMAIN_SET_TYPE__TIME_OBJECT_GROUP;

    /**
     * The feature id for the '<em><b>Time Object</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__TIME_OBJECT = DOMAIN_SET_TYPE__TIME_OBJECT;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__ACTUATE = DOMAIN_SET_TYPE__ACTUATE;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__ARCROLE = DOMAIN_SET_TYPE__ARCROLE;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__HREF = DOMAIN_SET_TYPE__HREF;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__REMOTE_SCHEMA = DOMAIN_SET_TYPE__REMOTE_SCHEMA;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__ROLE = DOMAIN_SET_TYPE__ROLE;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__SHOW = DOMAIN_SET_TYPE__SHOW;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__TITLE = DOMAIN_SET_TYPE__TITLE;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__TYPE = DOMAIN_SET_TYPE__TYPE;

    /**
     * The feature id for the '<em><b>Multi Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE__MULTI_SURFACE = DOMAIN_SET_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Multi Surface Domain Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE_FEATURE_COUNT = DOMAIN_SET_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Multi Surface Domain Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_DOMAIN_TYPE_OPERATION_COUNT = DOMAIN_SET_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiSurfacePropertyTypeImpl <em>Multi Surface Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiSurfacePropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiSurfacePropertyType()
     * @generated
     */
    int MULTI_SURFACE_PROPERTY_TYPE = 239;

    /**
     * The feature id for the '<em><b>Multi Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE__MULTI_SURFACE = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Multi Surface Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Multi Surface Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.MultiSurfaceTypeImpl <em>Multi Surface Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.MultiSurfaceTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getMultiSurfaceType()
     * @generated
     */
    int MULTI_SURFACE_TYPE = 240;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__GID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Surface Member</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__SURFACE_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Surface Members</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE__SURFACE_MEMBERS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Multi Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Multi Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MULTI_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.NodeTypeImpl <em>Node Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.NodeTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getNodeType()
     * @generated
     */
    int NODE_TYPE = 241;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE__META_DATA_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE__DESCRIPTION = ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE__NAME_GROUP = ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE__NAME = ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE__ID = ABSTRACT_TOPO_PRIMITIVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Isolated</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE__ISOLATED = ABSTRACT_TOPO_PRIMITIVE_TYPE__ISOLATED;

    /**
     * The feature id for the '<em><b>Container</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE__CONTAINER = ABSTRACT_TOPO_PRIMITIVE_TYPE__CONTAINER;

    /**
     * The feature id for the '<em><b>Directed Edge</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE__DIRECTED_EDGE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Point Property</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE__POINT_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Node Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE_FEATURE_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Node Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NODE_TYPE_OPERATION_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ObliqueCartesianCSRefTypeImpl <em>Oblique Cartesian CS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ObliqueCartesianCSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getObliqueCartesianCSRefType()
     * @generated
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE = 242;

    /**
     * The feature id for the '<em><b>Oblique Cartesian CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE__OBLIQUE_CARTESIAN_CS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Oblique Cartesian CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Oblique Cartesian CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ObliqueCartesianCSTypeImpl <em>Oblique Cartesian CS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ObliqueCartesianCSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getObliqueCartesianCSType()
     * @generated
     */
    int OBLIQUE_CARTESIAN_CS_TYPE = 243;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Cs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE__CS_NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_NAME;

    /**
     * The feature id for the '<em><b>Cs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE__CS_ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Uses Axis</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE__USES_AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__USES_AXIS;

    /**
     * The number of structural features of the '<em>Oblique Cartesian CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Oblique Cartesian CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OBLIQUE_CARTESIAN_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OffsetCurveTypeImpl <em>Offset Curve Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OffsetCurveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOffsetCurveType()
     * @generated
     */
    int OFFSET_CURVE_TYPE = 245;

    /**
     * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OFFSET_CURVE_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

    /**
     * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OFFSET_CURVE_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

    /**
     * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OFFSET_CURVE_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

    /**
     * The feature id for the '<em><b>Offset Base</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OFFSET_CURVE_TYPE__OFFSET_BASE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Distance</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OFFSET_CURVE_TYPE__DISTANCE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Ref Direction</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OFFSET_CURVE_TYPE__REF_DIRECTION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Offset Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OFFSET_CURVE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Offset Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OFFSET_CURVE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OperationMethodBaseTypeImpl <em>Operation Method Base Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OperationMethodBaseTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOperationMethodBaseType()
     * @generated
     */
    int OPERATION_METHOD_BASE_TYPE = 246;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_BASE_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_BASE_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_BASE_TYPE__NAME_GROUP = DEFINITION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_BASE_TYPE__NAME = DEFINITION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_BASE_TYPE__ID = DEFINITION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Method Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_BASE_TYPE__METHOD_NAME = DEFINITION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Operation Method Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_BASE_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Operation Method Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_BASE_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OperationMethodRefTypeImpl <em>Operation Method Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OperationMethodRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOperationMethodRefType()
     * @generated
     */
    int OPERATION_METHOD_REF_TYPE = 247;

    /**
     * The feature id for the '<em><b>Operation Method</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE__OPERATION_METHOD = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Operation Method Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Operation Method Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OperationMethodTypeImpl <em>Operation Method Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OperationMethodTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOperationMethodType()
     * @generated
     */
    int OPERATION_METHOD_TYPE = 248;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__META_DATA_PROPERTY = OPERATION_METHOD_BASE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__DESCRIPTION = OPERATION_METHOD_BASE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__NAME_GROUP = OPERATION_METHOD_BASE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__NAME = OPERATION_METHOD_BASE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__ID = OPERATION_METHOD_BASE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Method Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__METHOD_NAME = OPERATION_METHOD_BASE_TYPE__METHOD_NAME;

    /**
     * The feature id for the '<em><b>Method ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__METHOD_ID = OPERATION_METHOD_BASE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__REMARKS = OPERATION_METHOD_BASE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Method Formula</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__METHOD_FORMULA = OPERATION_METHOD_BASE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Source Dimensions</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__SOURCE_DIMENSIONS = OPERATION_METHOD_BASE_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Target Dimensions</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__TARGET_DIMENSIONS = OPERATION_METHOD_BASE_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Uses Parameter</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE__USES_PARAMETER = OPERATION_METHOD_BASE_TYPE_FEATURE_COUNT + 5;

    /**
     * The number of structural features of the '<em>Operation Method Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE_FEATURE_COUNT = OPERATION_METHOD_BASE_TYPE_FEATURE_COUNT + 6;

    /**
     * The number of operations of the '<em>Operation Method Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_METHOD_TYPE_OPERATION_COUNT = OPERATION_METHOD_BASE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OperationParameterBaseTypeImpl <em>Operation Parameter Base Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OperationParameterBaseTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOperationParameterBaseType()
     * @generated
     */
    int OPERATION_PARAMETER_BASE_TYPE = 249;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_BASE_TYPE__META_DATA_PROPERTY = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_BASE_TYPE__DESCRIPTION = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_BASE_TYPE__NAME_GROUP = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_BASE_TYPE__NAME = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_BASE_TYPE__ID = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__ID;

    /**
     * The feature id for the '<em><b>Minimum Occurs</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_BASE_TYPE__MINIMUM_OCCURS = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__MINIMUM_OCCURS;

    /**
     * The feature id for the '<em><b>Parameter Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_BASE_TYPE__PARAMETER_NAME = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Operation Parameter Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_BASE_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Operation Parameter Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_BASE_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OperationParameterGroupBaseTypeImpl <em>Operation Parameter Group Base Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OperationParameterGroupBaseTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOperationParameterGroupBaseType()
     * @generated
     */
    int OPERATION_PARAMETER_GROUP_BASE_TYPE = 250;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_BASE_TYPE__META_DATA_PROPERTY = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_BASE_TYPE__DESCRIPTION = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_BASE_TYPE__NAME_GROUP = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_BASE_TYPE__NAME = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_BASE_TYPE__ID = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__ID;

    /**
     * The feature id for the '<em><b>Minimum Occurs</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_BASE_TYPE__MINIMUM_OCCURS = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__MINIMUM_OCCURS;

    /**
     * The feature id for the '<em><b>Group Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_BASE_TYPE__GROUP_NAME = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Operation Parameter Group Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_BASE_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Operation Parameter Group Base Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_BASE_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OperationParameterGroupRefTypeImpl <em>Operation Parameter Group Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OperationParameterGroupRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOperationParameterGroupRefType()
     * @generated
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE = 251;

    /**
     * The feature id for the '<em><b>Operation Parameter Group</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE__OPERATION_PARAMETER_GROUP = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Operation Parameter Group Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Operation Parameter Group Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OperationParameterGroupTypeImpl <em>Operation Parameter Group Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OperationParameterGroupTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOperationParameterGroupType()
     * @generated
     */
    int OPERATION_PARAMETER_GROUP_TYPE = 252;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__META_DATA_PROPERTY = OPERATION_PARAMETER_GROUP_BASE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__DESCRIPTION = OPERATION_PARAMETER_GROUP_BASE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__NAME_GROUP = OPERATION_PARAMETER_GROUP_BASE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__NAME = OPERATION_PARAMETER_GROUP_BASE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__ID = OPERATION_PARAMETER_GROUP_BASE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Minimum Occurs</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__MINIMUM_OCCURS = OPERATION_PARAMETER_GROUP_BASE_TYPE__MINIMUM_OCCURS;

    /**
     * The feature id for the '<em><b>Group Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__GROUP_NAME = OPERATION_PARAMETER_GROUP_BASE_TYPE__GROUP_NAME;

    /**
     * The feature id for the '<em><b>Group ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__GROUP_ID = OPERATION_PARAMETER_GROUP_BASE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__REMARKS = OPERATION_PARAMETER_GROUP_BASE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Maximum Occurs</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__MAXIMUM_OCCURS = OPERATION_PARAMETER_GROUP_BASE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Includes Parameter</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE__INCLUDES_PARAMETER = OPERATION_PARAMETER_GROUP_BASE_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the '<em>Operation Parameter Group Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE_FEATURE_COUNT = OPERATION_PARAMETER_GROUP_BASE_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of operations of the '<em>Operation Parameter Group Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_GROUP_TYPE_OPERATION_COUNT = OPERATION_PARAMETER_GROUP_BASE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OperationParameterRefTypeImpl <em>Operation Parameter Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OperationParameterRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOperationParameterRefType()
     * @generated
     */
    int OPERATION_PARAMETER_REF_TYPE = 253;

    /**
     * The feature id for the '<em><b>Operation Parameter</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE__OPERATION_PARAMETER = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Operation Parameter Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Operation Parameter Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OperationParameterTypeImpl <em>Operation Parameter Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OperationParameterTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOperationParameterType()
     * @generated
     */
    int OPERATION_PARAMETER_TYPE = 254;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE__META_DATA_PROPERTY = OPERATION_PARAMETER_BASE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE__DESCRIPTION = OPERATION_PARAMETER_BASE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE__NAME_GROUP = OPERATION_PARAMETER_BASE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE__NAME = OPERATION_PARAMETER_BASE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE__ID = OPERATION_PARAMETER_BASE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Minimum Occurs</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE__MINIMUM_OCCURS = OPERATION_PARAMETER_BASE_TYPE__MINIMUM_OCCURS;

    /**
     * The feature id for the '<em><b>Parameter Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE__PARAMETER_NAME = OPERATION_PARAMETER_BASE_TYPE__PARAMETER_NAME;

    /**
     * The feature id for the '<em><b>Parameter ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE__PARAMETER_ID = OPERATION_PARAMETER_BASE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE__REMARKS = OPERATION_PARAMETER_BASE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Operation Parameter Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE_FEATURE_COUNT = OPERATION_PARAMETER_BASE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Operation Parameter Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_PARAMETER_TYPE_OPERATION_COUNT = OPERATION_PARAMETER_BASE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OperationRefTypeImpl <em>Operation Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OperationRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOperationRefType()
     * @generated
     */
    int OPERATION_REF_TYPE = 255;

    /**
     * The feature id for the '<em><b>Operation Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE__OPERATION_GROUP = 0;

    /**
     * The feature id for the '<em><b>Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE__OPERATION = 1;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE__ACTUATE = 2;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE__ARCROLE = 3;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE__HREF = 4;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE__REMOTE_SCHEMA = 5;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE__ROLE = 6;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE__SHOW = 7;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE__TITLE = 8;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE__TYPE = 9;

    /**
     * The number of structural features of the '<em>Operation Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE_FEATURE_COUNT = 10;

    /**
     * The number of operations of the '<em>Operation Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OPERATION_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OrientableCurveTypeImpl <em>Orientable Curve Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OrientableCurveTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOrientableCurveType()
     * @generated
     */
    int ORIENTABLE_CURVE_TYPE = 256;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__META_DATA_PROPERTY = ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__DESCRIPTION = ABSTRACT_CURVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__NAME_GROUP = ABSTRACT_CURVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__NAME = ABSTRACT_CURVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__ID = ABSTRACT_CURVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__AXIS_LABELS = ABSTRACT_CURVE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__GID = ABSTRACT_CURVE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__SRS_DIMENSION = ABSTRACT_CURVE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__SRS_NAME = ABSTRACT_CURVE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__UOM_LABELS = ABSTRACT_CURVE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Base Curve</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__BASE_CURVE = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Orientation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE__ORIENTATION = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Orientable Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Orientable Curve Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_CURVE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.OrientableSurfaceTypeImpl <em>Orientable Surface Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.OrientableSurfaceTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getOrientableSurfaceType()
     * @generated
     */
    int ORIENTABLE_SURFACE_TYPE = 257;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__META_DATA_PROPERTY = ABSTRACT_SURFACE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__DESCRIPTION = ABSTRACT_SURFACE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__NAME_GROUP = ABSTRACT_SURFACE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__NAME = ABSTRACT_SURFACE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__ID = ABSTRACT_SURFACE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__AXIS_LABELS = ABSTRACT_SURFACE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__GID = ABSTRACT_SURFACE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__SRS_DIMENSION = ABSTRACT_SURFACE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__SRS_NAME = ABSTRACT_SURFACE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__UOM_LABELS = ABSTRACT_SURFACE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Base Surface</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__BASE_SURFACE = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Orientation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE__ORIENTATION = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Orientable Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Orientable Surface Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ORIENTABLE_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ParameterValueGroupTypeImpl <em>Parameter Value Group Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ParameterValueGroupTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getParameterValueGroupType()
     * @generated
     */
    int PARAMETER_VALUE_GROUP_TYPE = 258;

    /**
     * The feature id for the '<em><b>Includes Value</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_GROUP_TYPE__INCLUDES_VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Values Of Group</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_GROUP_TYPE__VALUES_OF_GROUP = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Parameter Value Group Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_GROUP_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Parameter Value Group Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_GROUP_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.ParameterValueTypeImpl <em>Parameter Value Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.ParameterValueTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getParameterValueType()
     * @generated
     */
    int PARAMETER_VALUE_TYPE = 259;

    /**
     * The feature id for the '<em><b>Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE__VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Dms Angle Value</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE__DMS_ANGLE_VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>String Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE__STRING_VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Integer Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE__INTEGER_VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Boolean Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE__BOOLEAN_VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 4;

    /**
     * The feature id for the '<em><b>Value List</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE__VALUE_LIST = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Integer Value List</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE__INTEGER_VALUE_LIST = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 6;

    /**
     * The feature id for the '<em><b>Value File</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE__VALUE_FILE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 7;

    /**
     * The feature id for the '<em><b>Value Of Parameter</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE__VALUE_OF_PARAMETER = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 8;

    /**
     * The number of structural features of the '<em>Parameter Value Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 9;

    /**
     * The number of operations of the '<em>Parameter Value Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PARAMETER_VALUE_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PassThroughOperationRefTypeImpl <em>Pass Through Operation Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PassThroughOperationRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPassThroughOperationRefType()
     * @generated
     */
    int PASS_THROUGH_OPERATION_REF_TYPE = 260;

    /**
     * The feature id for the '<em><b>Pass Through Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE__PASS_THROUGH_OPERATION = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Pass Through Operation Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Pass Through Operation Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PassThroughOperationTypeImpl <em>Pass Through Operation Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PassThroughOperationTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPassThroughOperationType()
     * @generated
     */
    int PASS_THROUGH_OPERATION_TYPE = 261;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_OPERATION_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__ID = ABSTRACT_COORDINATE_OPERATION_TYPE__ID;

    /**
     * The feature id for the '<em><b>Coordinate Operation Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__COORDINATE_OPERATION_NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_NAME;

    /**
     * The feature id for the '<em><b>Coordinate Operation ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__COORDINATE_OPERATION_ID = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__REMARKS = ABSTRACT_COORDINATE_OPERATION_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Operation Version</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__OPERATION_VERSION = ABSTRACT_COORDINATE_OPERATION_TYPE__OPERATION_VERSION;

    /**
     * The feature id for the '<em><b>Valid Area</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__VALID_AREA = ABSTRACT_COORDINATE_OPERATION_TYPE__VALID_AREA;

    /**
     * The feature id for the '<em><b>Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__SCOPE = ABSTRACT_COORDINATE_OPERATION_TYPE__SCOPE;

    /**
     * The feature id for the '<em><b>Positional Accuracy Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__POSITIONAL_ACCURACY_GROUP = ABSTRACT_COORDINATE_OPERATION_TYPE__POSITIONAL_ACCURACY_GROUP;

    /**
     * The feature id for the '<em><b>Positional Accuracy</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__POSITIONAL_ACCURACY = ABSTRACT_COORDINATE_OPERATION_TYPE__POSITIONAL_ACCURACY;

    /**
     * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__SOURCE_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__SOURCE_CRS;

    /**
     * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__TARGET_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__TARGET_CRS;

    /**
     * The feature id for the '<em><b>Modified Coordinate</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__MODIFIED_COORDINATE = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Uses Operation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE__USES_OPERATION = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the '<em>Pass Through Operation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of operations of the '<em>Pass Through Operation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PASS_THROUGH_OPERATION_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PixelInCellTypeImpl <em>Pixel In Cell Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PixelInCellTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPixelInCellType()
     * @generated
     */
    int PIXEL_IN_CELL_TYPE = 262;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PIXEL_IN_CELL_TYPE__VALUE = CODE_TYPE__VALUE;

    /**
     * The feature id for the '<em><b>Code Space</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PIXEL_IN_CELL_TYPE__CODE_SPACE = CODE_TYPE__CODE_SPACE;

    /**
     * The number of structural features of the '<em>Pixel In Cell Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PIXEL_IN_CELL_TYPE_FEATURE_COUNT = CODE_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Pixel In Cell Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int PIXEL_IN_CELL_TYPE_OPERATION_COUNT = CODE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PointArrayPropertyTypeImpl <em>Point Array Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PointArrayPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPointArrayPropertyType()
     * @generated
     */
    int POINT_ARRAY_PROPERTY_TYPE = 263;

    /**
     * The feature id for the '<em><b>Point</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_ARRAY_PROPERTY_TYPE__POINT = 0;

    /**
     * The number of structural features of the '<em>Point Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 1;

    /**
     * The number of operations of the '<em>Point Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PointPropertyTypeImpl <em>Point Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PointPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPointPropertyType()
     * @generated
     */
    int POINT_PROPERTY_TYPE = 264;

    /**
     * The feature id for the '<em><b>Point</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE__POINT = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Point Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Point Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PointTypeImpl <em>Point Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PointTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPointType()
     * @generated
     */
    int POINT_TYPE = 265;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__NAME_GROUP = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__ID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__GID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Pos</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__POS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__COORDINATES = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Coord</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE__COORD = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the '<em>Point Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 3;

    /**
     * The number of operations of the '<em>Point Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POINT_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PolarCSRefTypeImpl <em>Polar CS Ref Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PolarCSRefTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPolarCSRefType()
     * @generated
     */
    int POLAR_CS_REF_TYPE = 266;

    /**
     * The feature id for the '<em><b>Polar CS</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE__POLAR_CS = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Polar CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Polar CS Ref Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_REF_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PolarCSTypeImpl <em>Polar CS Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PolarCSTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPolarCSType()
     * @generated
     */
    int POLAR_CS_TYPE = 267;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE__NAME_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

    /**
     * The feature id for the '<em><b>Cs Name</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE__CS_NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_NAME;

    /**
     * The feature id for the '<em><b>Cs ID</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE__CS_ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__CS_ID;

    /**
     * The feature id for the '<em><b>Remarks</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

    /**
     * The feature id for the '<em><b>Uses Axis</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE__USES_AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__USES_AXIS;

    /**
     * The number of structural features of the '<em>Polar CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of operations of the '<em>Polar CS Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLAR_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.SurfacePatchArrayPropertyTypeImpl <em>Surface Patch Array Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.SurfacePatchArrayPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getSurfacePatchArrayPropertyType()
     * @generated
     */
    int SURFACE_PATCH_ARRAY_PROPERTY_TYPE = 311;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SURFACE_PATCH_ARRAY_PROPERTY_TYPE__GROUP = 0;

    /**
     * The feature id for the '<em><b>Surface Patch Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SURFACE_PATCH_ARRAY_PROPERTY_TYPE__SURFACE_PATCH_GROUP = 1;

    /**
     * The feature id for the '<em><b>Surface Patch</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SURFACE_PATCH_ARRAY_PROPERTY_TYPE__SURFACE_PATCH = 2;

    /**
     * The number of structural features of the '<em>Surface Patch Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SURFACE_PATCH_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 3;

    /**
     * The number of operations of the '<em>Surface Patch Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SURFACE_PATCH_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PolygonPatchArrayPropertyTypeImpl <em>Polygon Patch Array Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PolygonPatchArrayPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPolygonPatchArrayPropertyType()
     * @generated
     */
    int POLYGON_PATCH_ARRAY_PROPERTY_TYPE = 268;

    /**
     * The feature id for the '<em><b>Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_ARRAY_PROPERTY_TYPE__GROUP = SURFACE_PATCH_ARRAY_PROPERTY_TYPE__GROUP;

    /**
     * The feature id for the '<em><b>Surface Patch Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_ARRAY_PROPERTY_TYPE__SURFACE_PATCH_GROUP = SURFACE_PATCH_ARRAY_PROPERTY_TYPE__SURFACE_PATCH_GROUP;

    /**
     * The feature id for the '<em><b>Surface Patch</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_ARRAY_PROPERTY_TYPE__SURFACE_PATCH = SURFACE_PATCH_ARRAY_PROPERTY_TYPE__SURFACE_PATCH;

    /**
     * The feature id for the '<em><b>Polygon Patch</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_ARRAY_PROPERTY_TYPE__POLYGON_PATCH = SURFACE_PATCH_ARRAY_PROPERTY_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the '<em>Polygon Patch Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = SURFACE_PATCH_ARRAY_PROPERTY_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of operations of the '<em>Polygon Patch Array Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = SURFACE_PATCH_ARRAY_PROPERTY_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PolygonPatchTypeImpl <em>Polygon Patch Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PolygonPatchTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPolygonPatchType()
     * @generated
     */
    int POLYGON_PATCH_TYPE = 269;

    /**
     * The feature id for the '<em><b>Exterior Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_TYPE__EXTERIOR_GROUP = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Exterior</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_TYPE__EXTERIOR = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Interior Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_TYPE__INTERIOR_GROUP = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Interior</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_TYPE__INTERIOR = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Interpolation</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_TYPE__INTERPOLATION = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 4;

    /**
     * The number of structural features of the '<em>Polygon Patch Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 5;

    /**
     * The number of operations of the '<em>Polygon Patch Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PATCH_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_PATCH_TYPE_OPERATION_COUNT + 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PolygonPropertyTypeImpl <em>Polygon Property Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PolygonPropertyTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPolygonPropertyType()
     * @generated
     */
    int POLYGON_PROPERTY_TYPE = 270;

    /**
     * The feature id for the '<em><b>Polygon</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE__POLYGON = 0;

    /**
     * The feature id for the '<em><b>Actuate</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE__ACTUATE = 1;

    /**
     * The feature id for the '<em><b>Arcrole</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE__ARCROLE = 2;

    /**
     * The feature id for the '<em><b>Href</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE__HREF = 3;

    /**
     * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE__REMOTE_SCHEMA = 4;

    /**
     * The feature id for the '<em><b>Role</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE__ROLE = 5;

    /**
     * The feature id for the '<em><b>Show</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE__SHOW = 6;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE__TITLE = 7;

    /**
     * The feature id for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE__TYPE = 8;

    /**
     * The number of structural features of the '<em>Polygon Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE_FEATURE_COUNT = 9;

    /**
     * The number of operations of the '<em>Polygon Property Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_PROPERTY_TYPE_OPERATION_COUNT = 0;

    /**
     * The meta object id for the '{@link net.opengis.gml311.impl.PolygonTypeImpl <em>Polygon Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see net.opengis.gml311.impl.PolygonTypeImpl
     * @see net.opengis.gml311.impl.Gml311PackageImpl#getPolygonType()
     * @generated
     */
    int POLYGON_TYPE = 271;

    /**
     * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_TYPE__META_DATA_PROPERTY = ABSTRACT_SURFACE_TYPE__META_DATA_PROPERTY;

    /**
     * The feature id for the '<em><b>Description</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_TYPE__DESCRIPTION = ABSTRACT_SURFACE_TYPE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Name Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_TYPE__NAME_GROUP = ABSTRACT_SURFACE_TYPE__NAME_GROUP;

    /**
     * The feature id for the '<em><b>Name</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_TYPE__NAME = ABSTRACT_SURFACE_TYPE__NAME;

    /**
     * The feature id for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_TYPE__ID = ABSTRACT_SURFACE_TYPE__ID;

    /**
     * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_TYPE__AXIS_LABELS = ABSTRACT_SURFACE_TYPE__AXIS_LABELS;

    /**
     * The feature id for the '<em><b>Gid</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_TYPE__GID = ABSTRACT_SURFACE_TYPE__GID;

    /**
     * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_TYPE__SRS_DIMENSION = ABSTRACT_SURFACE_TYPE__SRS_DIMENSION;

    /**
     * The feature id for the '<em><b>Srs Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_TYPE__SRS_NAME = ABSTRACT_SURFACE_TYPE__SRS_NAME;

    /**
     * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int POLYGON_TYPE__UOM_LABELS = ABSTRACT_SURFACE_TYPE__UOM_LABELS;

    /**
     * The feature id for the '<em><b>Exterior Group</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
  