/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.v22.bindings;

import javax.xml.namespace.QName;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.Geometries;
import org.geotools.kml.v22.KML;
import org.geotools.kml.v22.SchemaRegistry;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.geotools.xs.XS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Schema;

public class SchemaTypeBinding
extends AbstractComplexBinding {
    private SchemaRegistry schemaRegistry;

    public SchemaTypeBinding(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public QName getTarget() {
        return KML.SchemaType;
    }

    public Class getType() {
        return SimpleFeatureType.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        String featureTypeName = null;
        String featureTypeId = null;
        if (node.hasAttribute("id")) {
            featureTypeId = (String)node.getAttributeValue("id");
        }
        featureTypeName = node.hasAttribute("name") ? (String)node.getAttributeValue("name") : (featureTypeId != null ? featureTypeId : "feature");
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(featureTypeName);
        for (Node n : node.getChildren("SimpleField")) {
            String name = (String)n.getAttributeValue("name");
            String typeName = (String)n.getAttributeValue("type");
            if (name == null || typeName == null) continue;
            tb.add(name, this.mapTypeName(typeName));
        }
        SimpleFeatureType featureType = tb.buildFeatureType();
        this.schemaRegistry.add(featureTypeName, featureType);
        if (featureTypeId != null) {
            this.schemaRegistry.add(featureTypeId, featureType);
        }
        return featureType;
    }

    private Class mapTypeName(String typeName) {
        AttributeType type;
        NameImpl name;
        Schema xsTypeMappingProfile = XS.getInstance().getTypeMappingProfile();
        if (xsTypeMappingProfile.containsKey((Object)(name = new NameImpl("http://www.w3.org/2001/XMLSchema", typeName))) && (type = (AttributeType)xsTypeMappingProfile.get((Object)name)).getBinding() != null) {
            return type.getBinding();
        }
        Geometries g = Geometries.getForName((String)typeName);
        if (g != null) {
            return g.getBinding();
        }
        return String.class;
    }
}

