/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.kml.Folder;

public class FolderStack
implements Iterable<Folder> {
    private final List<Folder> stack = new ArrayList<Folder>();

    public void push(Folder folder) {
        this.stack.add(folder);
    }

    private boolean elementsExist() {
        return !this.stack.isEmpty();
    }

    public Folder pop() {
        return this.elementsExist() ? this.stack.remove(this.lastElementIndex()) : null;
    }

    private int lastElementIndex() {
        return this.stack.size() - 1;
    }

    public Folder peek() {
        return this.elementsExist() ? this.stack.get(this.lastElementIndex()) : null;
    }

    @Override
    public Iterator<Folder> iterator() {
        return this.stack.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Folder folder : this) {
            String trimmedName;
            String name = folder.getName();
            if (name == null || (trimmedName = name.trim()).length() <= 0) continue;
            sb.append(sb.length() > 0 ? " -> " + trimmedName : trimmedName);
        }
        return sb.toString();
    }

    public List<Folder> asList() {
        return new ArrayList<Folder>(this.stack);
    }
}

