/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ConcurrentIdentityHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentHashMap<Identity<K>, V> wrapped = new ConcurrentHashMap();

    @Override
    public V putIfAbsent(K key, V value) {
        return this.wrapped.putIfAbsent(Identity.of(key), value);
    }

    @Override
    public V get(Object key) {
        return this.wrapped.get(Identity.of(key));
    }

    @Override
    public V put(K key, V value) {
        return this.wrapped.put(Identity.of(key), value);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(Identity.of(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public V remove(Object key) {
        return this.wrapped.remove(Identity.of(key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.wrapped.remove(Identity.of(key), value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.wrapped.replace(Identity.of(key), oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.wrapped.replace(Identity.of(key), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.wrapped.put(Identity.of(e.getKey()), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private final Iterator<Identity<K>> underlying;
                    {
                        this.underlying = ((ConcurrentHashMap.KeySetView)ConcurrentIdentityHashMap.this.wrapped.keySet()).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.underlying.hasNext();
                    }

                    @Override
                    public K next() {
                        return this.underlying.next().get();
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return ConcurrentIdentityHashMap.this.containsKey(o);
            }

            @Override
            public int size() {
                return ConcurrentIdentityHashMap.this.wrapped.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return this.wrapped.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<Identity<K>, V>> underlying;
                    {
                        this.underlying = ConcurrentIdentityHashMap.this.wrapped.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.underlying.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Map.Entry entry = this.underlying.next();
                        return new AbstractMap.SimpleEntry(entry.getKey().get(), entry.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return ConcurrentIdentityHashMap.this.wrapped.size();
            }
        };
    }

    private static final class Identity<K> {
        private final K key;

        private static <K> Identity<K> of(K key) {
            return new Identity<K>(key);
        }

        private Identity(K key) {
            this.key = key;
        }

        public K get() {
            return this.key;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Identity) {
                return this.key == ((Identity)other).key;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.key);
        }
    }
}

