/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.hibernatespatial.HBSpatialExtension;
import org.hibernatespatial.cfg.GeometryFactoryHelper;
import org.hibernatespatial.mgeom.MGeometryFactory;
import org.locationtech.jts.geom.Geometry;

public abstract class AbstractDBGeometryType
implements UserType,
ParameterizedType,
Serializable {
    private MGeometryFactory geomFactory = null;

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return ((Geometry)x).equalsExact((Geometry)y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Object geomObj = rs.getObject(names[0]);
        return this.convert2JTS(geomObj);
    }

    public abstract Geometry convert2JTS(Object var1);

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, this.sqlTypes()[0]);
        } else {
            Geometry jtsGeom = (Geometry)value;
            Object dbGeom = this.conv2DBGeometry(jtsGeom, st.getConnection());
            st.setObject(index, dbGeom);
        }
    }

    public abstract Object conv2DBGeometry(Geometry var1, Connection var2);

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class returnedClass() {
        return Geometry.class;
    }

    public abstract int[] sqlTypes();

    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            this.geomFactory = GeometryFactoryHelper.createGeometryFactory(parameters);
        }
    }

    public MGeometryFactory getGeometryFactory() {
        return this.geomFactory == null ? HBSpatialExtension.getDefaultGeomFactory() : this.geomFactory;
    }
}

