/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.criterion;

import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.TypedValue;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernatespatial.SpatialDialect;
import org.hibernatespatial.SpatialFunction;
import org.hibernatespatial.criterion.ExpressionUtil;
import org.locationtech.jts.geom.Geometry;

public class DWithinExpression
implements Criterion {
    private final String propertyName;
    private final Geometry geometry;
    private final double distance;

    public DWithinExpression(String propertyName, Geometry geometry, double distance) {
        this.propertyName = propertyName;
        this.geometry = geometry;
        this.distance = distance;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String column = ExpressionUtil.findColumn(this.propertyName, criteria, criteriaQuery);
        SpatialDialect spatialDialect = ExpressionUtil.getSpatialDialect(criteriaQuery, SpatialFunction.dwithin);
        return spatialDialect.getDWithinSQL(column);
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new TypedValue[]{criteriaQuery.getTypedValue(criteria, this.propertyName, (Object)this.geometry), new TypedValue((Type)StandardBasicTypes.DOUBLE, (Object)this.distance, EntityMode.POJO)};
    }
}

