/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernatespatial.SpatialDialect;
import org.locationtech.jts.geom.Geometry;

public class SpatialRelateExpression
implements Criterion {
    private String propertyName = null;
    private Geometry value = null;
    private int spatialRelation = -1;
    private static final long serialVersionUID = 1L;

    public SpatialRelateExpression(String propertyName, Geometry value, int spatialRelation) {
        this.propertyName = propertyName;
        this.spatialRelation = spatialRelation;
        this.value = value;
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new TypedValue[]{criteriaQuery.getTypedValue(criteria, this.propertyName, (Object)this.value)};
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        SessionFactoryImplementor factory = criteriaQuery.getFactory();
        String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        Dialect dialect = factory.getDialect();
        if (dialect instanceof SpatialDialect) {
            SpatialDialect seDialect = (SpatialDialect)dialect;
            return seDialect.getSpatialRelateSQL(columns[0], this.spatialRelation);
        }
        throw new IllegalStateException("Dialect must be spatially enabled dialect");
    }
}

