/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.helper;

import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;
import org.hibernatespatial.helper.FinderException;
import org.hibernatespatial.helper.FinderStrategy;
import org.locationtech.jts.geom.Geometry;

public class GeometryPropertyFinder
implements FinderStrategy<String, ClassMetadata> {
    @Override
    public String find(ClassMetadata metadata) throws FinderException {
        for (String prop : metadata.getPropertyNames()) {
            Type type = metadata.getPropertyType(prop);
            if (!Geometry.class.isAssignableFrom(type.getReturnedClass())) continue;
            return prop;
        }
        throw new FinderException("Could not find a Geometry-valued property in " + metadata.getEntityName());
    }
}

