/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import org.hibernatespatial.pojo.NamingStrategy;

public class SimpleNamingStrategy
implements NamingStrategy {
    @Override
    public String createClassName(String base) {
        String cleaned = this.toJavaName(base);
        cleaned = cleaned.toLowerCase();
        return this.capitalize(cleaned);
    }

    @Override
    public String createGetterName(String fieldName) {
        return "get" + this.capitalize(fieldName);
    }

    @Override
    public String createPropertyName(String base) {
        String cleaned = this.toJavaName(base);
        cleaned = cleaned.toLowerCase();
        return cleaned;
    }

    @Override
    public String createSetterName(String fieldName) {
        return "set" + this.capitalize(fieldName);
    }

    private String toJavaName(String name) {
        StringBuilder stb = new StringBuilder();
        char[] namechars = name.toCharArray();
        if (!Character.isJavaIdentifierStart(namechars[0])) {
            stb.append("__");
        } else {
            stb.append(namechars[0]);
        }
        for (int i = 1; i < namechars.length; ++i) {
            if (!Character.isJavaIdentifierPart(namechars[i])) {
                stb.append("__");
                continue;
            }
            stb.append(namechars[i]);
        }
        return stb.toString();
    }

    private String capitalize(String s) {
        char[] ca = s.toCharArray();
        ca[0] = Character.toUpperCase(ca[0]);
        return new String(ca);
    }

    private String uncapitalize(String s) {
        char[] ca = s.toCharArray();
        ca[0] = Character.toLowerCase(ca[0]);
        return new String(ca);
    }
}

