/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.wasm.ir.UtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmOp;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J)\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilder;", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "expression", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "(Ljava/util/List;)V", "getExpression", "()Ljava/util/List;", "value", "", "numberOfNestedBlocks", "getNumberOfNestedBlocks", "()I", "setNumberOfNestedBlocks", "(I)V", "buildInstr", "", "op", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "immediates", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "wasm.ir"})
public final class WasmIrExpressionBuilder
extends WasmExpressionBuilder {
    @NotNull
    private final List<WasmInstr> expression;
    private int numberOfNestedBlocks;

    public WasmIrExpressionBuilder(@NotNull List<WasmInstr> expression2) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        this.expression = expression2;
    }

    @NotNull
    public final List<WasmInstr> getExpression() {
        return this.expression;
    }

    @Override
    public void buildInstr(@NotNull WasmOp op, WasmImmediate ... immediates) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)immediates, (String)"immediates");
        WasmInstr nextInstr = new WasmInstr(op, ArraysKt.toList((Object[])immediates));
        List<WasmInstr> foldedInstrs = UtilsKt.foldWasmInstructions((WasmInstr)CollectionsKt.lastOrNull(this.expression), nextInstr);
        if (foldedInstrs == null) {
            ((Collection)this.expression).add(nextInstr);
        } else {
            CollectionsKt.removeLastOrNull(this.expression);
            CollectionsKt.addAll((Collection)this.expression, (Iterable)foldedInstrs);
        }
    }

    @Override
    public int getNumberOfNestedBlocks() {
        return this.numberOfNestedBlocks;
    }

    @Override
    public void setNumberOfNestedBlocks(int value2) {
        boolean bl;
        boolean bl2 = bl = value2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "end without matching block";
            throw new AssertionError((Object)string2);
        }
        this.numberOfNestedBlocks = value2;
    }
}

