/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/SuspendInFunInterfaceChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class SuspendInFunInterfaceChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        PsiElement psiElement;
        KtModifierList ktModifierList;
        KtNamedFunction ktFunction;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration2 instanceof KtClass)) {
            return;
        }
        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isFun()) {
            return;
        }
        PsiElement psiElement2 = ((KtClass)declaration2).getFunKeyword();
        if (psiElement2 == null) {
            return;
        }
        PsiElement funKeyword = psiElement2;
        FunctionDescriptor functionDescriptor = SamConversionResolverImplKt.getSingleAbstractMethodOrNull((ClassDescriptor)descriptor2);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor abstractMember = functionDescriptor;
        if (!abstractMember.isSuspend()) {
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.SuspendFunctionsInFunInterfaces) && context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getUseIR()).booleanValue()) {
            return;
        }
        Object object = abstractMember.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"abstractMember.source");
        PsiElement psiElement3 = PsiSourceElementKt.getPsi((SourceElement)object);
        KtNamedFunction ktNamedFunction = ktFunction = psiElement3 instanceof KtNamedFunction ? (KtNamedFunction)psiElement3 : null;
        Object reportOn = object = ktNamedFunction == null ? funKeyword : ((ktModifierList = ktNamedFunction.getModifierList()) == null ? funKeyword : ((psiElement = ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD)) == null ? funKeyword : psiElement));
        context2.getTrace().report(Errors.FUN_INTERFACE_WITH_SUSPEND_FUNCTION.on((PsiElement)reportOn));
    }
}

