/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.jodconverter.document.DocumentFormatRegistry;
import org.jodconverter.filter.DefaultFilterChain;
import org.jodconverter.filter.Filter;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.job.AbstractConversionJob;
import org.jodconverter.job.AbstractConversionJobWithSourceFormatUnspecified;
import org.jodconverter.job.AbstractConverter;
import org.jodconverter.job.AbstractSourceDocumentSpecs;
import org.jodconverter.job.AbstractTargetDocumentSpecs;
import org.jodconverter.job.SourceDocumentSpecs;
import org.jodconverter.job.TargetDocumentSpecs;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.task.LocalConversionTask;
import org.jodconverter.task.OfficeTask;

public class LocalConverter
extends AbstractConverter {
    private Map<String, Object> loadProperties;
    private FilterChain filterChain;
    private final Map<String, Object> storeProperties;

    public static Builder builder() {
        return new Builder();
    }

    public static LocalConverter make() {
        return LocalConverter.builder().build();
    }

    public static LocalConverter make(OfficeManager officeManager) {
        return ((Builder)LocalConverter.builder().officeManager(officeManager)).build();
    }

    private LocalConverter(OfficeManager officeManager, DocumentFormatRegistry formatRegistry, Map<String, Object> loadProperties, FilterChain filterChain, Map<String, Object> storeProperties) {
        super(officeManager, formatRegistry);
        this.loadProperties = loadProperties;
        this.filterChain = filterChain;
        this.storeProperties = storeProperties;
    }

    protected AbstractConversionJobWithSourceFormatUnspecified convert(AbstractSourceDocumentSpecs source) {
        return new LocalConversionJobWithSourceFormatUnspecified(source);
    }

    LocalConverter setLoadProperties(Map<String, Object> loadProperties) {
        if (this.loadProperties == null) {
            this.loadProperties = new HashMap<String, Object>();
        }
        this.loadProperties.clear();
        this.loadProperties.putAll(loadProperties);
        return this;
    }

    LocalConverter setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
        return this;
    }

    public static final class Builder
    extends AbstractConverter.AbstractConverterBuilder<Builder> {
        private Map<String, Object> loadProperties;
        private FilterChain filterChain;
        private Map<String, Object> storeProperties;

        private Builder() {
        }

        public LocalConverter build() {
            return new LocalConverter(this.officeManager, this.formatRegistry, this.loadProperties, this.filterChain, this.storeProperties);
        }

        public Builder loadProperties(Map<String, Object> properties) {
            this.loadProperties = properties;
            return this;
        }

        public Builder filterChain(Filter ... filters) {
            Validate.notEmpty((Object[])filters);
            this.filterChain = new DefaultFilterChain(filters);
            return this;
        }

        public Builder filterChain(FilterChain filterChain) {
            Validate.notNull((Object)filterChain);
            this.filterChain = filterChain;
            return this;
        }

        public Builder storeProperties(Map<String, Object> properties) {
            this.storeProperties = properties;
            return this;
        }
    }

    private class LocalConversionJob
    extends AbstractConversionJob {
        private LocalConversionJob(AbstractSourceDocumentSpecs source, AbstractTargetDocumentSpecs target) {
            super(source, target);
        }

        public void doExecute() throws OfficeException {
            LocalConversionTask task = new LocalConversionTask((SourceDocumentSpecs)this.source, (TargetDocumentSpecs)this.target, LocalConverter.this.loadProperties, LocalConverter.this.filterChain, LocalConverter.this.storeProperties);
            LocalConverter.this.officeManager.execute((OfficeTask)task);
        }
    }

    private class LocalConversionJobWithSourceFormatUnspecified
    extends AbstractConversionJobWithSourceFormatUnspecified {
        private LocalConversionJobWithSourceFormatUnspecified(AbstractSourceDocumentSpecs source) {
            super(source, LocalConverter.this.officeManager, LocalConverter.this.formatRegistry);
        }

        protected AbstractConversionJob to(AbstractTargetDocumentSpecs target) {
            return new LocalConversionJob(this.source, target);
        }
    }
}

