/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.UnoRuntime;
import java.awt.Dimension;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.filter.text.AbstractTextContentInserterFilter;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicInserterFilter
extends AbstractTextContentInserterFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphicInserterFilter.class);
    private final String imagePath;

    /*
     * Exception decompiling
     */
    private static Dimension getImageSize(File image) throws OfficeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int pixelsToMillimeters(int pixels) {
        return Math.round((float)pixels * 0.26458332f);
    }

    public GraphicInserterFilter(String imagePath, int horizontalPosition, int verticalPosition) throws OfficeException {
        super(GraphicInserterFilter.getImageSize(new File(imagePath)), horizontalPosition, verticalPosition);
        this.imagePath = imagePath;
    }

    public GraphicInserterFilter(String imagePath, int width, int height, int horizontalPosition, int verticalPosition) {
        super(new Dimension(width, height), horizontalPosition, verticalPosition);
        this.imagePath = imagePath;
    }

    public GraphicInserterFilter(String imagePath, int width, int height, Map<String, Object> shapeProperties) {
        super(new Dimension(width, height), shapeProperties);
        this.imagePath = imagePath;
    }

    public GraphicInserterFilter(String imagePath, Map<String, Object> shapeProperties) throws OfficeException {
        super(GraphicInserterFilter.getImageSize(new File(imagePath)), shapeProperties);
        this.imagePath = imagePath;
    }

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws Exception {
        XTextDocument docText = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)document);
        XMultiServiceFactory docServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)docText);
        Object graphicShape = docServiceFactory.createInstance("com.sun.star.drawing.GraphicObjectShape");
        XShape shape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)graphicShape);
        shape.setSize(GraphicInserterFilter.toOfficeSize(this.getRectSize()));
        String uuid = UUID.randomUUID().toString();
        XNameContainer bitmapContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)docServiceFactory.createInstance("com.sun.star.drawing.BitmapTable"));
        File sourceFile = new File(this.imagePath);
        String strUrl = LocalOfficeUtils.toUrl(sourceFile);
        LOGGER.debug("Embedding image to the bitmap container '{}'", (Object)strUrl);
        bitmapContainer.insertByName(uuid, (Object)strUrl);
        XPropertySet propSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)graphicShape);
        propSet.setPropertyValue("GraphicURL", bitmapContainer.getByName(uuid));
        for (Map.Entry<String, Object> entry : this.getShapeProperties().entrySet()) {
            propSet.setPropertyValue(entry.getKey(), entry.getValue());
        }
        XText text = docText.getText();
        XTextCursor textCursor = text.createTextCursor();
        this.applyAnchorPageNoFix(docText, textCursor);
        XTextContent textContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)graphicShape);
        LOGGER.debug("Inserting image into the document");
        text.insertTextContent((XTextRange)textCursor, textContent, false);
        chain.doFilter(context, document);
    }
}

