/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter.text;

import com.sun.star.lang.XComponent;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XReplaceDescriptor;
import com.sun.star.util.XReplaceable;
import com.sun.star.util.XSearchDescriptor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.jodconverter.filter.Filter;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextReplacerFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextReplacerFilter.class);
    private final String[] searchList;
    private final String[] replacementList;

    public TextReplacerFilter(String[] searchList, String[] replacementList) {
        Validate.notEmpty((Object[])searchList, (String)"Search list is empty", (Object[])new Object[0]);
        Validate.notEmpty((Object[])replacementList, (String)"Replacement list is empty", (Object[])new Object[0]);
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        Validate.isTrue((searchLength == replacementLength ? 1 : 0) != 0, (String)"search array length [%d]\u00a0and replacement array length\u00a0[%d] don't match", (Object[])new Object[]{searchLength, replacementLength});
        this.searchList = (String[])ArrayUtils.clone((Object[])searchList);
        this.replacementList = (String[])ArrayUtils.clone((Object[])replacementList);
    }

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws OfficeException {
        XReplaceable replaceable = (XReplaceable)UnoRuntime.queryInterface(XReplaceable.class, (Object)document);
        XReplaceDescriptor replaceDescr = replaceable.createReplaceDescriptor();
        LOGGER.debug("Changing all occurrences of ...");
        for (int i = 0; i < this.searchList.length; ++i) {
            LOGGER.debug("{} -> {}", (Object)this.searchList[i], (Object)this.replacementList[i]);
            replaceDescr.setSearchString(this.searchList[i]);
            replaceDescr.setReplaceString(this.replacementList[i]);
            replaceable.replaceAll((XSearchDescriptor)replaceDescr);
        }
        chain.doFilter(context, document);
    }
}

