/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.avro;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureUtils;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureUtils$RichBuilder$;
import org.locationtech.geomesa.features.avro.FieldNameEncoder;
import org.locationtech.geomesa.features.avro.FieldNameEncoder$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class AvroSimpleFeatureUtils$
implements LazyLogging {
    public static AvroSimpleFeatureUtils$ MODULE$;
    private final String FEATURE_ID_AVRO_FIELD_NAME;
    private final String AVRO_SIMPLE_FEATURE_VERSION;
    private final String AVRO_SIMPLE_FEATURE_USERDATA;
    private final int VERSION;
    private final String AVRO_NAMESPACE;
    private final List<Class<? super Object>> primitiveTypes;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new AvroSimpleFeatureUtils$();
    }

    private Logger logger$lzycompute() {
        AvroSimpleFeatureUtils$ avroSimpleFeatureUtils$ = this;
        synchronized (avroSimpleFeatureUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String FEATURE_ID_AVRO_FIELD_NAME() {
        return this.FEATURE_ID_AVRO_FIELD_NAME;
    }

    public String AVRO_SIMPLE_FEATURE_VERSION() {
        return this.AVRO_SIMPLE_FEATURE_VERSION;
    }

    public String AVRO_SIMPLE_FEATURE_USERDATA() {
        return this.AVRO_SIMPLE_FEATURE_USERDATA;
    }

    public int VERSION() {
        return this.VERSION;
    }

    public String AVRO_NAMESPACE() {
        return this.AVRO_NAMESPACE;
    }

    public SchemaBuilder.FieldTypeBuilder<SchemaBuilder.ArrayDefault<Schema>> RichBuilder(SchemaBuilder.FieldTypeBuilder<SchemaBuilder.ArrayDefault<Schema>> builder) {
        return builder;
    }

    public Schema generateSchema(SimpleFeatureType sft, boolean withUserData, boolean withFeatureId, String namespace) {
        FieldNameEncoder nameEncoder = new FieldNameEncoder(this.VERSION(), FieldNameEncoder$.MODULE$.$lessinit$greater$default$2());
        SchemaBuilder.FieldAssembler initialAssembler = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)nameEncoder.encode(sft.getTypeName())).namespace(namespace)).fields().name(this.AVRO_SIMPLE_FEATURE_VERSION()).type().intType().noDefault();
        SchemaBuilder.FieldAssembler withFid = withFeatureId ? initialAssembler.name(this.FEATURE_ID_AVRO_FIELD_NAME()).type().stringType().noDefault() : initialAssembler;
        SchemaBuilder.FieldAssembler withFields = (SchemaBuilder.FieldAssembler)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(sft.getAttributeDescriptors()).foldLeft((Object)withFid, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SchemaBuilder.FieldAssembler assembler = (SchemaBuilder.FieldAssembler)tuple2._1();
            AttributeDescriptor ad = (AttributeDescriptor)tuple2._2();
            SchemaBuilder.FieldAssembler<Schema> fieldAssembler = MODULE$.addField((SchemaBuilder.FieldAssembler<Schema>)assembler, nameEncoder.encode(ad.getLocalName()), ad.getType().getBinding(), ad.isNillable());
            return fieldAssembler;
        });
        SchemaBuilder.FieldAssembler fullSchema = withUserData ? ((SchemaBuilder.FieldDefault)AvroSimpleFeatureUtils$RichBuilder$.MODULE$.simpleTypeUnion$extension(this.RichBuilder((SchemaBuilder.FieldTypeBuilder<SchemaBuilder.ArrayDefault<Schema>>)AvroSimpleFeatureUtils$RichBuilder$.MODULE$.simpleTypeUnion$extension(this.RichBuilder((SchemaBuilder.FieldTypeBuilder<SchemaBuilder.ArrayDefault<Schema>>)withFields.name(this.AVRO_SIMPLE_FEATURE_USERDATA()).type().array().items().record("userDataItem").fields().name("key").type()), "key").noDefault().name("value").type()), "value").noDefault().endRecord()).noDefault() : withFields;
        return (Schema)fullSchema.endRecord();
    }

    public String generateSchema$default$4() {
        return this.AVRO_NAMESPACE();
    }

    public SchemaBuilder.FieldAssembler<Schema> addField(SchemaBuilder.FieldAssembler<Schema> assembler, String name, Class<?> ct, boolean nillable) {
        SchemaBuilder.FieldAssembler fieldAssembler;
        SchemaBuilder.FieldTypeBuilder baseType = nillable ? assembler.name(name).type().nullable() : assembler.name(name).type();
        Class<?> clazz = ct;
        if (String.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.stringType().noDefault();
        } else if (Integer.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.intType().noDefault();
        } else if (Long.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.longType().noDefault();
        } else if (Double.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.doubleType().noDefault();
        } else if (Float.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.floatType().noDefault();
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.booleanType().noDefault();
        } else if (UUID.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.bytesType().noDefault();
        } else if (Date.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.longType().noDefault();
        } else if (Geometry.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.bytesType().noDefault();
        } else if (java.util.List.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.bytesType().noDefault();
        } else if (Map.class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.bytesType().noDefault();
        } else if (byte[].class.isAssignableFrom(clazz)) {
            fieldAssembler = baseType.bytesType().noDefault();
        } else {
            throw new MatchError(clazz);
        }
        return fieldAssembler;
    }

    public List<Class<? super Object>> primitiveTypes() {
        return this.primitiveTypes;
    }

    public scala.collection.immutable.Map<String, AvroSimpleFeatureUtils.Binding> createTypeMap(SimpleFeatureType sft, FieldNameEncoder nameEncoder) {
        return ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(sft.getAttributeDescriptors()).map((Function1 & Serializable & scala.Serializable)ad -> {
            Class binding = ad.getType().getBinding();
            Function1 & Serializable & scala.Serializable converter = MODULE$.primitiveTypes().contains((Object)binding) ? (Function1 & Serializable & scala.Serializable)value -> value : (UUID.class.isAssignableFrom(binding) ? (Function1 & Serializable & scala.Serializable)value -> MODULE$.encodeUUID((UUID)value) : (Date.class.isAssignableFrom(binding) ? (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToLong((long)AvroSimpleFeatureUtils$.$anonfun$createTypeMap$4(value)) : (Geometry.class.isAssignableFrom(binding) ? (Function1 & Serializable & scala.Serializable)value -> ByteBuffer.wrap(WKBUtils$.MODULE$.write((Geometry)value)) : (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad)) ? (Function1 & Serializable & scala.Serializable)value -> MODULE$.encodeList((java.util.List)value, RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad))) : (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad)) ? (Function1 & Serializable & scala.Serializable)value -> {
                Tuple2 tuple2 = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getMapTypes$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Class keyclass = (Class)tuple2._1();
                Class valueclass = (Class)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)keyclass, (Object)valueclass);
                Tuple2 tuple23 = tuple22;
                Class keyclass2 = (Class)tuple23._1();
                Class valueclass2 = (Class)tuple23._2();
                return MODULE$.encodeMap((Map)value, keyclass2, valueclass2);
            } : (byte[].class.isAssignableFrom(binding) ? (Function1 & Serializable & scala.Serializable)value -> ByteBuffer.wrap((byte[])value) : (Function1 & Serializable & scala.Serializable)value -> (String)FastConverter$.MODULE$.convert(value, String.class)))))));
            return new Tuple2((Object)nameEncoder.encode(ad.getLocalName()), (Object)new AvroSimpleFeatureUtils.Binding(ad.getType().getBinding(), (Function1<Object, Object>)converter));
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public ByteBuffer encodeUUID(UUID uuid) {
        return (ByteBuffer)ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).flip();
    }

    public UUID decodeUUID(ByteBuffer bb) {
        return new UUID(bb.getLong(), bb.getLong());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteBuffer encodeList(java.util.List<?> list, Class<?> binding) {
        Option size = Option$.MODULE$.apply(list).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()));
        boolean bl = false;
        Some some = null;
        Option option = size;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int s = BoxesRunTime.unboxToInt((Object)some.value());
            if (s == 0) {
                return this.encodeEmptyCollection();
            }
        }
        if (bl) {
            int s = BoxesRunTime.unboxToInt((Object)some.value());
            return this.encodeNonEmptyList(list, s, binding);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        return this.encodeNullCollection();
    }

    /*
     * WARNING - void declaration
     */
    public java.util.List<?> decodeList(ByteBuffer bb) {
        java.util.List list;
        int size = bb.getInt();
        if (size < 0) {
            list = null;
        } else if (size == 0) {
            list = Collections.emptyList();
        } else {
            void var3_3;
            ArrayList list2 = new ArrayList(size);
            String label = this.getString(bb);
            Function0<Object> readMethod = this.getReadMethod(label, bb);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), size - 1).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> list2.add(readMethod.apply()));
            list = var3_3;
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteBuffer encodeMap(Map<?, ?> map, Class<?> keyBinding, Class<?> valueBinding) {
        Option size = Option$.MODULE$.apply(map).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()));
        boolean bl = false;
        Some some = null;
        Option option = size;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int s = BoxesRunTime.unboxToInt((Object)some.value());
            if (s == 0) {
                return this.encodeEmptyCollection();
            }
        }
        if (bl) {
            int s = BoxesRunTime.unboxToInt((Object)some.value());
            return this.encodeNonEmptyMap(map, s, keyBinding, valueBinding);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        return this.encodeNullCollection();
    }

    /*
     * WARNING - void declaration
     */
    public Map<?, ?> decodeMap(ByteBuffer bb) {
        Map map;
        int size = bb.getInt();
        if (size < 0) {
            map = null;
        } else if (size == 0) {
            map = Collections.emptyMap();
        } else {
            void var3_3;
            HashMap map2 = new HashMap(size);
            String keyType = this.getString(bb);
            String valueType = this.getString(bb);
            Function0<Object> keyReadMethod = this.getReadMethod(keyType, bb);
            Function0<Object> valueReadMethod = this.getReadMethod(valueType, bb);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), size - 1).foreach((Function1 & Serializable & scala.Serializable)x$5 -> AvroSimpleFeatureUtils$.$anonfun$decodeMap$1(keyReadMethod, valueReadMethod, map2, BoxesRunTime.unboxToInt((Object)x$5)));
            map = var3_3;
        }
        return map;
    }

    public SimpleFeatureType schemaToSft(Schema schema, String sftName, Option<String> geomAttr, Option<String> dateAttr) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(sftName);
        geomAttr.foreach((Function1 & Serializable & scala.Serializable)ga -> {
            AvroSimpleFeatureUtils$.$anonfun$schemaToSft$1(builder, ga);
            return BoxedUnit.UNIT;
        });
        dateAttr.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            builder.add(x$6, Date.class);
            return BoxedUnit.UNIT;
        });
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(schema.getFields()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            AvroSimpleFeatureUtils$.MODULE$.addSchemaToBuilder(builder, x$7, AvroSimpleFeatureUtils$.MODULE$.addSchemaToBuilder$default$3());
            return BoxedUnit.UNIT;
        });
        return builder.buildFeatureType();
    }

    public void addSchemaToBuilder(SimpleFeatureTypeBuilder builder, Schema.Field field, Option<Schema.Type> typeOverride) {
        Schema.Type type = (Schema.Type)typeOverride.getOrElse((Function0 & Serializable & scala.Serializable)() -> field.schema().getType());
        if (Schema.Type.STRING.equals(type)) {
            builder.add(field.name(), String.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Schema.Type.BOOLEAN.equals(type)) {
            builder.add(field.name(), Boolean.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Schema.Type.INT.equals(type)) {
            builder.add(field.name(), Integer.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Schema.Type.DOUBLE.equals(type)) {
            builder.add(field.name(), Double.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Schema.Type.LONG.equals(type)) {
            builder.add(field.name(), Long.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Schema.Type.FLOAT.equals(type)) {
            builder.add(field.name(), Float.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Schema.Type.BYTES.equals(type)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Avro schema requested BYTES, which is not yet supported");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (Schema.Type.UNION.equals(type)) {
            ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(field.schema().getTypes()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getType(), Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AvroSimpleFeatureUtils$.$anonfun$addSchemaToBuilder$3(x$9))).foreach((Function1 & Serializable & scala.Serializable)t -> {
                AvroSimpleFeatureUtils$.MODULE$.addSchemaToBuilder(builder, field, (Option<Schema.Type>)Option$.MODULE$.apply((Object)t));
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Schema.Type.MAP.equals(type)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Avro schema requested MAP, which is not yet supported");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (Schema.Type.RECORD.equals(type)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Avro schema requested RECORD, which is not yet supported");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (Schema.Type.ENUM.equals(type)) {
            builder.add(field.name(), String.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Schema.Type.ARRAY.equals(type)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Avro schema requested ARRAY, which is not yet supported");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else if (Schema.Type.FIXED.equals(type)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Avro schema requested FIXED, which is not yet supported");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else if (Schema.Type.NULL.equals(type)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Avro schema requested NULL, which is not yet supported");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Avro schema requested unknown type {}", new Object[]{field.schema().getType()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit;
        }
    }

    public Option<Schema.Type> addSchemaToBuilder$default$3() {
        return None$.MODULE$;
    }

    private ByteBuffer encodeNullCollection() {
        return (ByteBuffer)ByteBuffer.allocate(4).putInt(-1).flip();
    }

    private ByteBuffer encodeEmptyCollection() {
        return (ByteBuffer)ByteBuffer.allocate(4).putInt(0).flip();
    }

    private ByteBuffer encodeNonEmptyList(java.util.List<?> list, int size, Class<?> binding) {
        String label = binding.getSimpleName();
        Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> tuple2 = this.getWriteMethod(label);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytesPerItem = tuple2._1$mcI$sp();
        Function2 putMethod = (Function2)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesPerItem), (Object)putMethod);
        Tuple2 tuple23 = tuple22;
        int bytesPerItem2 = tuple23._1$mcI$sp();
        Function2 putMethod2 = (Function2)tuple23._2();
        int totalBytes = this.getTotalBytes(bytesPerItem2, size, JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(list.iterator()), binding.getSimpleName());
        byte[] labelBytes = label.getBytes(StandardCharsets.UTF_8);
        ByteBuffer bb = ByteBuffer.allocate(8 + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(labelBytes)).size() + totalBytes);
        bb.putInt(size);
        this.putString(bb, label);
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(list).foreach((Function1 & Serializable & scala.Serializable)v -> {
            putMethod2.apply((Object)bb, v);
            return BoxedUnit.UNIT;
        });
        bb.flip();
        return bb;
    }

    private ByteBuffer encodeNonEmptyMap(Map<?, ?> map, int size, Class<?> keyBinding, Class<?> valueBinding) {
        String keyLabel = keyBinding.getSimpleName();
        String valueLabel = valueBinding.getSimpleName();
        Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> tuple2 = this.getWriteMethod(keyLabel);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytesPerKeyItem = tuple2._1$mcI$sp();
        Function2 keyPutMethod = (Function2)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesPerKeyItem), (Object)keyPutMethod);
        Tuple2 tuple23 = tuple22;
        int bytesPerKeyItem2 = tuple23._1$mcI$sp();
        Function2 keyPutMethod2 = (Function2)tuple23._2();
        Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> tuple24 = this.getWriteMethod(valueLabel);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        int bytesPerValueItem = tuple24._1$mcI$sp();
        Function2 valuePutMethod = (Function2)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesPerValueItem), (Object)valuePutMethod);
        Tuple2 tuple26 = tuple25;
        int bytesPerValueItem2 = tuple26._1$mcI$sp();
        Function2 valuePutMethod2 = (Function2)tuple26._2();
        int totalKeyBytes = this.getTotalBytes(bytesPerKeyItem2, size, JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).keysIterator(), keyLabel);
        int totalValueBytes = this.getTotalBytes(bytesPerValueItem2, size, JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).valuesIterator(), valueLabel);
        byte[] keyLabelBytes = keyLabel.getBytes(StandardCharsets.UTF_8);
        byte[] valueLabelBytes = valueLabel.getBytes(StandardCharsets.UTF_8);
        int totalBytes = 12 + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(keyLabelBytes)).size() + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(valueLabelBytes)).size() + totalKeyBytes + totalValueBytes;
        ByteBuffer bb = ByteBuffer.allocate(totalBytes);
        bb.putInt(size);
        this.putString(bb, keyLabel);
        this.putString(bb, valueLabel);
        JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AvroSimpleFeatureUtils$.$anonfun$encodeNonEmptyMap$1(keyPutMethod2, bb, valuePutMethod2, x0$1);
            return BoxedUnit.UNIT;
        });
        bb.flip();
        return bb;
    }

    private Tuple2<Object, Function2<ByteBuffer, Object, BoxedUnit>> getWriteMethod(String label) {
        Tuple2 tuple2;
        String string = label.toLowerCase(Locale.US);
        if ("string".equals(string)) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                AvroSimpleFeatureUtils$.MODULE$.putString(bb, (String)v);
                return BoxedUnit.UNIT;
            });
        } else {
            boolean bl = "int".equals(string) ? true : "integer".equals(string);
            if (bl) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                    bb.putInt(BoxesRunTime.unboxToInt((Object)v));
                    return BoxedUnit.UNIT;
                });
            } else if ("double".equals(string)) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                    bb.putDouble(BoxesRunTime.unboxToDouble((Object)v));
                    return BoxedUnit.UNIT;
                });
            } else if ("long".equals(string)) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                    bb.putLong(BoxesRunTime.unboxToLong((Object)v));
                    return BoxedUnit.UNIT;
                });
            } else if ("float".equals(string)) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                    bb.putFloat(BoxesRunTime.unboxToFloat((Object)v));
                    return BoxedUnit.UNIT;
                });
            } else if ("date".equals(string)) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                    bb.putLong(((Date)v).getTime());
                    return BoxedUnit.UNIT;
                });
            } else if ("boolean".equals(string)) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                    AvroSimpleFeatureUtils$.$anonfun$getWriteMethod$7(bb, v);
                    return BoxedUnit.UNIT;
                });
            } else if ("uuid".equals(string)) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)16), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                    AvroSimpleFeatureUtils$.MODULE$.putUUID(bb, (UUID)v);
                    return BoxedUnit.UNIT;
                });
            } else if ("byte[]".equals(string)) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Function2 & Serializable & scala.Serializable)(bb, v) -> {
                    AvroSimpleFeatureUtils$.MODULE$.putBytes(bb, (byte[])v);
                    return BoxedUnit.UNIT;
                });
            } else {
                String msg = new StringBuilder(69).append("Invalid collection type: '").append(label).append("'. Only primitives and Dates are supported.").toString();
                throw new IllegalArgumentException(msg);
            }
        }
        return tuple2;
    }

    private Function0<Object> getReadMethod(String label, ByteBuffer bb) {
        Function0 & Serializable & scala.Serializable intersect;
        String string = label.toLowerCase(Locale.US);
        if ("string".equals(string)) {
            intersect = (Function0 & Serializable & scala.Serializable)() -> MODULE$.getString(bb);
        } else {
            boolean bl = "int".equals(string) ? true : "integer".equals(string);
            if (bl) {
                intersect = (Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.boxToInteger((int)bb.getInt());
            } else if ("double".equals(string)) {
                intersect = (Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.boxToDouble((double)bb.getDouble());
            } else if ("long".equals(string)) {
                intersect = (Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.boxToLong((long)bb.getLong());
            } else if ("float".equals(string)) {
                intersect = (Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.boxToFloat((float)bb.getFloat());
            } else if ("boolean".equals(string)) {
                intersect = (Function0 & Serializable & scala.Serializable)() -> bb.get() > 0;
            } else if ("date".equals(string)) {
                intersect = (Function0 & Serializable & scala.Serializable)() -> new Date(bb.getLong());
            } else if ("uuid".equals(string)) {
                intersect = (Function0 & Serializable & scala.Serializable)() -> MODULE$.getUUID(bb);
            } else if ("byte[]".equals(string)) {
                intersect = (Function0 & Serializable & scala.Serializable)() -> MODULE$.getBytes(bb);
            } else {
                String msg = new StringBuilder(69).append("Invalid collection type: '").append(label).append("'. Only primitives and Dates are supported.").toString();
                throw new IllegalArgumentException(msg);
            }
        }
        return intersect;
    }

    private int getTotalBytes(int bytesPerItem, int size, Iterator<?> values, String label) {
        int n;
        if (bytesPerItem == -1) {
            int n2;
            String string = label.toLowerCase();
            if ("string".equals(string)) {
                n2 = BoxesRunTime.unboxToInt((Object)values.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)AvroSimpleFeatureUtils$.$anonfun$getTotalBytes$1(x$13))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            } else if ("byte[]".equals(string)) {
                n2 = BoxesRunTime.unboxToInt((Object)values.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)AvroSimpleFeatureUtils$.$anonfun$getTotalBytes$2(x$14))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            } else {
                throw new IllegalArgumentException("invalid type");
            }
            n = n2;
        } else {
            n = bytesPerItem * size;
        }
        return n;
    }

    private String getString(ByteBuffer bb) {
        int size = bb.getInt();
        byte[] buf = new byte[size];
        bb.get(buf);
        return new String(buf, StandardCharsets.UTF_8);
    }

    private ByteBuffer putString(ByteBuffer bb, String s) {
        return this.putBytes(bb, s.getBytes(StandardCharsets.UTF_8));
    }

    private ByteBuffer putBytes(ByteBuffer bb, byte[] arr) {
        return bb.putInt(arr.length).put(arr);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes(ByteBuffer bb) {
        void var3_3;
        int sz = bb.getInt();
        byte[] bytes = new byte[sz];
        bb.get(bytes, 0, sz);
        return var3_3;
    }

    private ByteBuffer putUUID(ByteBuffer bb, UUID uuid) {
        return bb.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
    }

    private UUID getUUID(ByteBuffer bb) {
        return new UUID(bb.getLong(), bb.getLong());
    }

    public static final /* synthetic */ long $anonfun$createTypeMap$4(Object value) {
        return ((Date)value).getTime();
    }

    public static final /* synthetic */ Object $anonfun$decodeMap$1(Function0 keyReadMethod$1, Function0 valueReadMethod$1, HashMap map$1, int x$5) {
        Object key = keyReadMethod$1.apply();
        Object value = valueReadMethod$1.apply();
        return map$1.put(key, value);
    }

    public static final /* synthetic */ void $anonfun$schemaToSft$1(SimpleFeatureTypeBuilder builder$1, String ga) {
        builder$1.setDefaultGeometry(ga);
        builder$1.add(ga, Geometry.class);
    }

    public static final /* synthetic */ boolean $anonfun$addSchemaToBuilder$3(Schema.Type x$9) {
        Schema.Type type = x$9;
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public static final /* synthetic */ void $anonfun$encodeNonEmptyMap$1(Function2 keyPutMethod$1, ByteBuffer bb$2, Function2 valuePutMethod$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object k = tuple2._1();
        Object v = tuple2._2();
        keyPutMethod$1.apply((Object)bb$2, k);
        BoxedUnit boxedUnit = (BoxedUnit)valuePutMethod$1.apply((Object)bb$2, v);
    }

    public static final /* synthetic */ void $anonfun$getWriteMethod$7(ByteBuffer bb, Object v) {
        if (BoxesRunTime.unboxToBoolean((Object)v)) {
            bb.put((byte)1);
        } else {
            bb.put((byte)0);
        }
    }

    public static final /* synthetic */ int $anonfun$getTotalBytes$1(Object x$13) {
        return ((String)x$13).getBytes(StandardCharsets.UTF_8).length + 4;
    }

    public static final /* synthetic */ int $anonfun$getTotalBytes$2(Object x$14) {
        return ((byte[])x$14).length + 4;
    }

    private AvroSimpleFeatureUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.FEATURE_ID_AVRO_FIELD_NAME = "__fid__";
        this.AVRO_SIMPLE_FEATURE_VERSION = "__version__";
        this.AVRO_SIMPLE_FEATURE_USERDATA = "__userdata__";
        this.VERSION = 5;
        this.AVRO_NAMESPACE = "org.geomesa";
        this.primitiveTypes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{String.class, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Boolean.class, Boolean.TYPE}));
    }
}

