/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.avro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.SerializationOption$;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureUtils;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureUtils$;
import org.locationtech.geomesa.features.avro.AvroSimpleFeatureWriter$;
import org.locationtech.geomesa.features.avro.FieldNameEncoder;
import org.locationtech.geomesa.features.avro.FieldNameEncoder$;
import org.locationtech.geomesa.features.avro.serialization.AvroUserDataSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.NotImplementedError;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001\u0002\f\u0018\u0001\tB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")q\f\u0001C\u0001A\"9Q\r\u0001b\u0001\n\u00131\u0007B\u0002;\u0001A\u0003%q\rC\u0004v\u0001\t\u0007I\u0011\u0002<\t\ri\u0004\u0001\u0015!\u0003x\u0011\u001dY\bA1A\u0005\nYDa\u0001 \u0001!\u0002\u00139\bbB?\u0001\u0005\u0004%IA \u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003\u0000\u0011%\t9\u0001\u0001a\u0001\n\u0013\tI\u0001C\u0005\u0002\u0014\u0001\u0001\r\u0011\"\u0003\u0002\u0016!A\u0011\u0011\u0005\u0001!B\u0013\tY\u0001C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u00111\u0006\u0001\u0005\n\u0005ur!CA%/\u0005\u0005\t\u0012AA&\r!1r#!A\t\u0002\u00055\u0003BB0\u0014\t\u0003\ty\u0005C\u0005\u0002RM\t\n\u0011\"\u0001\u0002T\t9\u0012I\u001e:p'&l\u0007\u000f\\3GK\u0006$XO]3Xe&$XM\u001d\u0006\u00031e\tA!\u0019<s_*\u0011!dG\u0001\tM\u0016\fG/\u001e:fg*\u0011A$H\u0001\bO\u0016|W.Z:b\u0015\tqr$\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001!\u0003\ry'oZ\u0002\u0001'\r\u00011e\u000b\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019y%M[3diB\u0019AF\r\u001b\u000e\u00035R!AL\u0018\u0002\u0005%|'B\u0001\r1\u0015\t\tt$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003g5\u00121\u0002R1uk6<&/\u001b;feB\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005eR\u0014a\u00024fCR,(/\u001a\u0006\u0003w}\tqa\u001c9f]\u001eL7/\u0003\u0002>m\ti1+[7qY\u00164U-\u0019;ve\u0016\f1a\u001d4u!\t)\u0004)\u0003\u0002Bm\t\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\u0002\t=\u0004Ho\u001d\t\u0004\t6\u0003fBA#L!\t1\u0015*D\u0001H\u0015\tA\u0015%\u0001\u0004=e>|GO\u0010\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*S\u0001\u0007!J,G-\u001a4\n\u00059{%aA*fi*\u0011A*\u0013\t\u0003#rs!A\u0015.\u000f\u0005MKfB\u0001+Y\u001d\t)vK\u0004\u0002G-&\t\u0001%\u0003\u0002\u001f?%\u0011A$H\u0005\u00035mI!aW\r\u0002'M+'/[1mSj\fG/[8o\u001fB$\u0018n\u001c8\n\u0005us&aE*fe&\fG.\u001b>bi&|gn\u00149uS>t'BA.\u001a\u0003\u0019a\u0014N\\5u}Q\u0019\u0011m\u00193\u0011\u0005\t\u0004Q\"A\f\t\u000by\u001a\u0001\u0019A \t\u000f\t\u001b\u0001\u0013!a\u0001\u0007\u0006Q1m\u001c8wKJ$XM]:\u0016\u0003\u001d\u00042\u0001[5l\u001b\u0005I\u0015B\u00016J\u0005\u0015\t%O]1z!\u0011AGN\\9\n\u00055L%!\u0003$v]\u000e$\u0018n\u001c82!\tAw.\u0003\u0002q\u0013\n1\u0011I\\=SK\u001a\u0004\"\u0001\u001b:\n\u0005ML%aA!os\u0006Y1m\u001c8wKJ$XM]:!\u0003)Ign\u00197vI\u00164\u0015\u000eZ\u000b\u0002oB\u0011\u0001\u000e_\u0005\u0003s&\u0013qAQ8pY\u0016\fg.A\u0006j]\u000edW\u000fZ3GS\u0012\u0004\u0013aD5oG2,H-Z+tKJ$\u0015\r^1\u0002!%t7\r\\;eKV\u001bXM\u001d#bi\u0006\u0004\u0013a\u00034jK2$wJ\u001a4tKR,\u0012a \t\u0004Q\u0006\u0005\u0011bAA\u0002\u0013\n\u0019\u0011J\u001c;\u0002\u0019\u0019LW\r\u001c3PM\u001a\u001cX\r\u001e\u0011\u0002\rM\u001c\u0007.Z7b+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005=Q\"A\u0018\n\u0007\u0005EqF\u0001\u0004TG\",W.Y\u0001\u000bg\u000eDW-\\1`I\u0015\fH\u0003BA\f\u0003;\u00012\u0001[A\r\u0013\r\tY\"\u0013\u0002\u0005+:LG\u000fC\u0005\u0002 5\t\t\u00111\u0001\u0002\f\u0005\u0019\u0001\u0010J\u0019\u0002\u000fM\u001c\u0007.Z7bA\u0005I1/\u001a;TG\",W.\u0019\u000b\u0005\u0003/\t9\u0003C\u0004\u0002*=\u0001\r!a\u0003\u0002\u0003M\fQa\u001e:ji\u0016$b!a\u0006\u00020\u0005M\u0002BBA\u0019!\u0001\u0007A'A\u0003eCR,X\u000eC\u0004\u00026A\u0001\r!a\u000e\u0002\u0007=,H\u000fE\u0002-\u0003sI1!a\u000f.\u0005\u001d)enY8eKJ$\u0002\"a\u0006\u0002@\u0005\u0005\u0013Q\t\u0005\b\u0003k\t\u0002\u0019AA\u001c\u0011\u001d\t\u0019%\u0005a\u0001\u0003\u0017\t1BZ5fY\u0012\u001c6\r[3nC\"1\u0011qI\tA\u0002E\fQA^1mk\u0016\fq#\u0011<s_NKW\u000e\u001d7f\r\u0016\fG/\u001e:f/JLG/\u001a:\u0011\u0005\t\u001c2CA\no)\t\tY%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003+R3aQA,W\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\u0013Ut7\r[3dW\u0016$'bAA2\u0013\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0014Q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class AvroSimpleFeatureWriter
implements DatumWriter<SimpleFeature> {
    private final Function1<Object, Object>[] converters;
    private final boolean includeFid;
    private final boolean includeUserData;
    private final int fieldOffset;
    private Schema schema;

    public static Set<Enumeration.Value> $lessinit$greater$default$2() {
        return AvroSimpleFeatureWriter$.MODULE$.$lessinit$greater$default$2();
    }

    private Function1<Object, Object>[] converters() {
        return this.converters;
    }

    private boolean includeFid() {
        return this.includeFid;
    }

    private boolean includeUserData() {
        return this.includeUserData;
    }

    private int fieldOffset() {
        return this.fieldOffset;
    }

    private Schema schema() {
        return this.schema;
    }

    private void schema_$eq(Schema x$1) {
        this.schema = x$1;
    }

    public void setSchema(Schema s) {
        this.schema_$eq(s);
    }

    public void write(SimpleFeature datum, Encoder out) {
        block2: {
            out.writeInt(AvroSimpleFeatureUtils$.MODULE$.VERSION());
            if (this.includeFid()) {
                out.writeString(datum.getID());
            }
            for (int i = 0; i < this.converters().length; ++i) {
                Object value = datum.getAttribute(i);
                Schema.Field field = (Schema.Field)this.schema().getFields().get(i + this.fieldOffset());
                this.write(out, field.schema(), value == null ? null : this.converters()[i].apply(value));
            }
            if (!this.includeUserData()) break block2;
            AvroUserDataSerialization$.MODULE$.serialize(out, datum.getUserData());
        }
    }

    private void write(Encoder out, Schema fieldSchema, Object value) {
        block9: {
            Schema.Type type;
            while (true) {
                if (Schema.Type.STRING.equals(type = fieldSchema.getType())) {
                    out.writeString((CharSequence)value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (Schema.Type.BYTES.equals(type)) {
                    out.writeBytes((ByteBuffer)value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (Schema.Type.INT.equals(type)) {
                    out.writeInt(BoxesRunTime.unboxToInt((Object)value));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (Schema.Type.LONG.equals(type)) {
                    out.writeLong(BoxesRunTime.unboxToLong((Object)value));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (Schema.Type.DOUBLE.equals(type)) {
                    out.writeDouble(BoxesRunTime.unboxToDouble((Object)value));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (Schema.Type.FLOAT.equals(type)) {
                    out.writeFloat(BoxesRunTime.unboxToFloat((Object)value));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (Schema.Type.BOOLEAN.equals(type)) {
                    out.writeBoolean(BoxesRunTime.unboxToBoolean((Object)value));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (Schema.Type.NULL.equals(type)) {
                    out.writeNull();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (!Schema.Type.UNION.equals(type)) break;
                int unionIdx = value == null ? 1 : 0;
                out.writeIndex(unionIdx);
                fieldSchema = (Schema)fieldSchema.getTypes().get(unionIdx);
            }
            throw new NotImplementedError(new StringBuilder(33).append("Unsupported Avro attribute type: ").append(type).toString());
        }
    }

    public AvroSimpleFeatureWriter(SimpleFeatureType sft, Set<Enumeration.Value> opts) {
        FieldNameEncoder nameEncoder = new FieldNameEncoder(AvroSimpleFeatureUtils$.MODULE$.VERSION(), FieldNameEncoder$.MODULE$.$lessinit$greater$default$2());
        Map<String, AvroSimpleFeatureUtils.Binding> typeMap = AvroSimpleFeatureUtils$.MODULE$.createTypeMap(sft, nameEncoder);
        this.converters = (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DataUtilities.attributeNames((SimpleFeatureType)sft))).map((Function1 & Serializable & scala.Serializable)n -> ((AvroSimpleFeatureUtils.Binding)typeMap.apply((Object)nameEncoder.encode((String)n))).conv(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        this.includeFid = !SerializationOption.SerializationOptions$.MODULE$.withoutId$extension(SerializationOption$.MODULE$.SerializationOptions(opts));
        this.includeUserData = SerializationOption.SerializationOptions$.MODULE$.withUserData$extension(SerializationOption$.MODULE$.SerializationOptions(opts));
        this.fieldOffset = this.includeFid() ? 2 : 1;
        this.schema = AvroSimpleFeatureUtils$.MODULE$.generateSchema(sft, this.includeUserData(), this.includeFid(), sft.getName().getNamespaceURI());
    }
}

