/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.avro.serialization;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.serialization.HintKeySerialization$;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import org.locationtech.jts.geom.Geometry;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AvroUserDataSerializationV4$
implements LazyLogging {
    public static AvroUserDataSerializationV4$ MODULE$;
    private final String NullMarkerString;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new AvroUserDataSerializationV4$();
    }

    private Logger logger$lzycompute() {
        AvroUserDataSerializationV4$ avroUserDataSerializationV4$ = this;
        synchronized (avroUserDataSerializationV4$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String NullMarkerString() {
        return this.NullMarkerString;
    }

    public void serialize(Encoder out, java.util.Map<?, ?> map) {
        Map filtered = (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AvroUserDataSerializationV4$.$anonfun$serialize$1(x0$1)));
        out.writeArrayStart();
        out.setItemCount((long)filtered.size());
        filtered.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AvroUserDataSerializationV4$.$anonfun$serialize$2(out, x0$2);
            return BoxedUnit.UNIT;
        });
        out.writeArrayEnd();
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<Object, Object> deserialize(Decoder in) {
        void var3_3;
        int size = (int)in.readArrayStart();
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        this.deserializeWithSize(in, size, map);
        return var3_3;
    }

    public void deserialize(Decoder in, java.util.Map<Object, Object> map) {
        this.deserializeWithSize(in, (int)in.readArrayStart(), map);
    }

    private void deserializeWithSize(Decoder in, int size, java.util.Map<Object, Object> map) {
        int remaining = size;
        while (remaining > 0) {
            String valueClass;
            Object object;
            String keyClass;
            String string = keyClass = in.readString();
            String string2 = this.NullMarkerString();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = null;
            } else {
                String string3 = keyClass;
                String string4 = "org.geotools.factory.Hints$Key";
                object = !(string3 != null ? !string3.equals(string4) : string4 != null) ? HintKeySerialization$.MODULE$.idToKey().apply((Object)in.readString()) : this.read(in, Class.forName(keyClass));
            }
            Object key = object;
            String string5 = valueClass = in.readString();
            String string6 = this.NullMarkerString();
            Object value = !(string5 != null ? !string5.equals(string6) : string6 != null) ? null : this.read(in, Class.forName(valueClass));
            map.put(key, value);
            if (--remaining != 0) continue;
            remaining = (int)in.arrayNext();
        }
    }

    private void write(Encoder out, Object value) {
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            out.writeString(string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            out.writeInt(Predef$.MODULE$.Integer2int(n));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Long) {
            Long l = (Long)object;
            out.writeLong(Predef$.MODULE$.Long2long(l));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Float) {
            Float f = (Float)object;
            out.writeFloat(Predef$.MODULE$.Float2float(f));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Double) {
            Double d = (Double)object;
            out.writeDouble(Predef$.MODULE$.Double2double(d));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            out.writeBoolean(Predef$.MODULE$.Boolean2boolean(bl));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Date) {
            Date date = (Date)object;
            out.writeLong(date.getTime());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            out.writeBytes(byArray);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            out.writeBytes(WKBUtils$.MODULE$.write(geometry));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof UUID) {
            UUID uUID = (UUID)object;
            out.writeLong(uUID.getMostSignificantBits());
            out.writeLong(uUID.getLeastSignificantBits());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof List) {
            List list = (List)object;
            this.writeList(out, list);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported value: ").append(value).append(" (").append(value.getClass()).append(")").toString());
        }
    }

    private Object read(Decoder in, Class<?> clas) {
        Object object;
        Class<?> clazz = clas;
        if (String.class.isAssignableFrom(clazz)) {
            object = in.readString().intern();
        } else if (Integer.class.isAssignableFrom(clazz)) {
            object = BoxesRunTime.boxToInteger((int)in.readInt());
        } else if (Long.class.isAssignableFrom(clazz)) {
            object = BoxesRunTime.boxToLong((long)in.readLong());
        } else if (Float.class.isAssignableFrom(clazz)) {
            object = BoxesRunTime.boxToFloat((float)in.readFloat());
        } else if (Double.class.isAssignableFrom(clazz)) {
            object = BoxesRunTime.boxToDouble((double)in.readDouble());
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            object = BoxesRunTime.boxToBoolean((boolean)in.readBoolean());
        } else if (Date.class.isAssignableFrom(clazz)) {
            object = new Date(in.readLong());
        } else if (byte[].class.equals(clazz)) {
            object = this.readBytes(in);
        } else if (Geometry.class.isAssignableFrom(clazz)) {
            object = WKBUtils$.MODULE$.read(this.readBytes(in));
        } else if (UUID.class.isAssignableFrom(clazz)) {
            object = new UUID(in.readLong(), in.readLong());
        } else if (List.class.isAssignableFrom(clazz)) {
            object = this.readList(in);
        } else if (Hints.Key.class.isAssignableFrom(clazz)) {
            object = HintKeySerialization$.MODULE$.idToKey().apply((Object)in.readString());
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported value class: ").append(clas).toString());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readBytes(Decoder in) {
        void var3_3;
        ByteBuffer buffer = in.readBytes(null);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(buffer.remaining(), ClassTag$.MODULE$.Byte());
        buffer.get(bytes);
        return var3_3;
    }

    private void writeList(Encoder out, List<Object> list) {
        out.writeArrayStart();
        out.setItemCount((long)list.size());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1 & Serializable & scala.Serializable)value -> {
            AvroUserDataSerializationV4$.$anonfun$writeList$1(out, value);
            return BoxedUnit.UNIT;
        });
        out.writeArrayEnd();
    }

    /*
     * WARNING - void declaration
     */
    private List<Object> readList(Decoder in) {
        void var3_3;
        int size = (int)in.readArrayStart();
        ArrayList<Object> list = new ArrayList<Object>(size);
        int remaining = size;
        while (remaining > 0) {
            String clas;
            String string = clas = in.readString();
            String string2 = this.NullMarkerString();
            Object value = !(string != null ? !string.equals(string2) : string2 != null) ? null : this.read(in, Class.forName(clas));
            list.add(value);
            if (--remaining != 0) continue;
            remaining = (int)in.arrayNext();
        }
        return var3_3;
    }

    private boolean canSerialize(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof Hints.Key) {
            Hints.Key key = (Hints.Key)object;
            bl = HintKeySerialization$.MODULE$.canSerialize(key);
        } else {
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$serialize$1(Tuple2 x0$1) {
        boolean bl;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object key = tuple2._1();
            Object value = tuple2._2();
            if (MODULE$.canSerialize(key)) {
                bl = true;
            } else {
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn("Can't serialize Map entry ({},{}) - it will be skipped.", new Object[]{key, value});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = false;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$serialize$2(Encoder out$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Object key = tuple2._1();
            Object value = tuple2._2();
            out$1.startItem();
            if (key == null) {
                out$1.writeString(MODULE$.NullMarkerString());
            } else {
                out$1.writeString(key.getClass().getName());
                MODULE$.write(out$1, key);
            }
            if (value == null) {
                out$1.writeString(MODULE$.NullMarkerString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                out$1.writeString(value.getClass().getName());
                MODULE$.write(out$1, value);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$writeList$1(Encoder out$2, Object value) {
        out$2.startItem();
        if (value == null) {
            out$2.writeString(MODULE$.NullMarkerString());
        } else {
            out$2.writeString(value.getClass().getName());
            MODULE$.write(out$2, value);
        }
    }

    private AvroUserDataSerializationV4$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.NullMarkerString = "<null>";
    }
}

