/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.concurrent;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.locationtech.geomesa.utils.concurrent.CachedThreadPool$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0001\u0003\u00015\u0011\u0001cQ1dQ\u0016$G\u000b\u001b:fC\u0012\u0004vn\u001c7\u000b\u0005\r!\u0011AC2p]\u000e,(O]3oi*\u0011QAB\u0001\u0006kRLGn\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001d]\u0001\"aD\u000b\u000e\u0003AQ!aA\t\u000b\u0005I\u0019\u0012\u0001B;uS2T\u0011\u0001F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0017!\t9\u0012IY:ue\u0006\u001cG/\u0012=fGV$xN]*feZL7-\u001a\t\u00031}i\u0011!\u0007\u0006\u00035m\tAb]2bY\u0006dwnZ4j]\u001eT!\u0001H\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011AH\u0001\u0004G>l\u0017B\u0001\u0011\u001a\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011\t\u0002!\u0011!Q\u0001\n\r\n!\"\\1y)\"\u0014X-\u00193t!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\rIe\u000e\u001e\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051r\u0003CA\u0017\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012*\u0001\u0004\u0019\u0003b\u0002\u0019\u0001\u0001\u0004%I!M\u0001\nCZ\f\u0017\u000e\\1cY\u0016,\u0012a\t\u0005\bg\u0001\u0001\r\u0011\"\u00035\u00035\tg/Y5mC\ndWm\u0018\u0013fcR\u0011Q\u0007\u000f\t\u0003IYJ!aN\u0013\u0003\tUs\u0017\u000e\u001e\u0005\bsI\n\t\u00111\u0001$\u0003\rAH%\r\u0005\u0007w\u0001\u0001\u000b\u0015B\u0012\u0002\u0015\u00054\u0018-\u001b7bE2,\u0007\u0005\u000b\u0002;{A\u0011AEP\u0005\u0003\u007f\u0015\u0012\u0001B^8mCRLG.\u001a\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0003\u0015\tX/Z;f+\u0005\u0019\u0005c\u0001#F\u000f6\t\u0011#\u0003\u0002G#\tQA*\u001b8lK\u0012d\u0015n\u001d;1\u0005!K\bcA%Kq6\t\u0001A\u0002\u0003L\u0001\u0001a%a\u0005+sC\u000e\\\u0017M\u00197f\rV$XO]3UCN\\WCA'T'\tQe\nE\u0002\u0010\u001fFK!\u0001\u0015\t\u0003\u0015\u0019+H/\u001e:f)\u0006\u001c8\u000e\u0005\u0002S'2\u0001A!\u0002+K\u0005\u0004)&!\u0001+\u0012\u0005YK\u0006C\u0001\u0013X\u0013\tAVEA\u0004O_RD\u0017N\\4\u0011\u0005\u0011R\u0016BA.&\u0005\r\te.\u001f\u0005\t;*\u0013\t\u0011)A\u0005=\u0006A!/\u001e8oC\ndW\r\u0005\u0002`E6\t\u0001M\u0003\u0002b'\u0005!A.\u00198h\u0013\t\u0019\u0007M\u0001\u0005Sk:t\u0017M\u00197f\u0011!)'J!A!\u0002\u0013\t\u0016A\u0002:fgVdG\u000fC\u0003+\u0015\u0012\u0005q\rF\u0002iS*\u00042!\u0013&R\u0011\u0015if\r1\u0001_\u0011\u0015)g\r1\u0001R\u0011\u0015a'\n\"\u0011n\u0003\u0011!wN\\3\u0015\u0003UBQa\u001c&\u0005BA\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002cB\u0011!/\u001e\b\u0003IML!\u0001^\u0013\u0002\rA\u0013X\rZ3g\u0013\t1xO\u0001\u0004TiJLgn\u001a\u0006\u0003i\u0016\u0002\"AU=\u0005\u0013i\\\u0018\u0011!A\u0001\u0006\u0003)&aA0%c!1A\u0010\u0001Q\u0001\n\r\u000ba!];fk\u0016\u0004\u0003b\u0002@\u0001\u0005\u0004%Ia`\u0001\u0006i\u0006\u001c8n]\u000b\u0003\u0003\u0003\u0001R\u0001RA\u0002\u0003\u000fI1!!\u0002\u0012\u0005\u001dA\u0015m\u001d5TKR\u0004D!!\u0003\u0002\u000eA!\u0011JSA\u0006!\r\u0011\u0016Q\u0002\u0003\f\u0003\u001f\t\t\"!A\u0001\u0002\u000b\u0005QKA\u0002`IIB\u0001\"a\u0005\u0001A\u0003%\u0011\u0011A\u0001\u0007i\u0006\u001c8n\u001d\u0011\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0011aB:u_B\u0004X\rZ\u000b\u0003\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0001\u0012AB1u_6L7-\u0003\u0003\u0002&\u0005}!!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u000e\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003\"CA\u0017\u0001\t\u0007I\u0011BA\u0018\u0003\u0011awnY6\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]\u0002#A\u0003m_\u000e\\7/\u0003\u0003\u0002<\u0005U\"!\u0004*fK:$(/\u00198u\u0019>\u001c7\u000e\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u0019\u0003\u0015awnY6!\u0011!a\u0007A1A\u0005\n\u0005\rSCAA#!\u0011\t\u0019$a\u0012\n\t\u0005%\u0013Q\u0007\u0002\n\u0007>tG-\u001b;j_:D\u0001\"!\u0014\u0001A\u0003%\u0011QI\u0001\u0006I>tW\r\t\u0005\u0007\u0003#\u0002A\u0011I7\u0002\u0011MDW\u000f\u001e3po:Dq!!\u0016\u0001\t\u0003\n9&A\u0006tQV$Hm\\<o\u001d><HCAA-!\u0011!\u00151\f0\n\u0007\u0005u\u0013C\u0001\u0003MSN$\bbBA1\u0001\u0011\u0005\u00131M\u0001\u000bSN\u001c\u0006.\u001e;e_^tGCAA3!\r!\u0013qM\u0005\u0004\u0003S*#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003[\u0002A\u0011IA2\u00031I7\u000fV3s[&t\u0017\r^3e\u0011\u001d\t\t\b\u0001C!\u0003g\n\u0001#Y<bSR$VM]7j]\u0006$\u0018n\u001c8\u0015\r\u0005\u0015\u0014QOA@\u0011!\t9(a\u001cA\u0002\u0005e\u0014a\u0002;j[\u0016|W\u000f\u001e\t\u0004I\u0005m\u0014bAA?K\t!Aj\u001c8h\u0011!\t\t)a\u001cA\u0002\u0005\r\u0015\u0001B;oSR\u00042aDAC\u0013\r\t9\t\u0005\u0002\t)&lW-\u00168ji\"9\u00111\u0012\u0001\u0005B\u00055\u0015aB3yK\u000e,H/\u001a\u000b\u0004k\u0005=\u0005bBAI\u0003\u0013\u0003\rAX\u0001\bG>lW.\u00198e\u0011\u001d\t)\n\u0001C\u0005\u0003/\u000baB];o\u001fJ\fV/Z;f)\u0006\u001c8\u000eF\u00026\u00033C\u0001\"a'\u0002\u0014\u0002\u0007\u0011QT\u0001\u0005i\u0006\u001c8\u000e\r\u0003\u0002 \u0006\r\u0006\u0003B%K\u0003C\u00032AUAR\t-\t)+!'\u0002\u0002\u0003\u0005)\u0011A+\u0003\u0007}#C\u0007C\u0004\u0002*\u0002!\t&a+\u0002\u00159,w\u000fV1tW\u001a{'/\u0006\u0003\u0002.\u0006MFCBAX\u0003k\u000b9\f\u0005\u0003J\u0015\u0006E\u0006c\u0001*\u00024\u00121A+a*C\u0002UCa!XAT\u0001\u0004q\u0006\u0002CA]\u0003O\u0003\r!!-\u0002\u000bY\fG.^3\b\u000f\u0005u&\u0001#\u0001\u0002@\u0006\u00012)Y2iK\u0012$\u0006N]3bIB{w\u000e\u001c\t\u0004[\u0005\u0005gAB\u0001\u0003\u0011\u0003\t\u0019m\u0005\u0003\u0002B\u0006\u0015\u0007c\u0001\u0013\u0002H&\u0019\u0011\u0011Z\u0013\u0003\r\u0005s\u0017PU3g\u0011\u001dQ\u0013\u0011\u0019C\u0001\u0003\u001b$\"!a0\t\u0015\u0005E\u0017\u0011\u0019b\u0001\n\u0013\t\u0019.\u0001\u0003q_>dWCAAk!\ry\u0011q[\u0005\u0004\u00033\u0004\"A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_JD\u0011\"!8\u0002B\u0002\u0006I!!6\u0002\u000bA|w\u000e\u001c\u0011\t\u0011\u0005-\u0015\u0011\u0019C\u0001\u0003C$2!NAr\u0011\u001d\t\t*a8A\u0002yC\u0001\"a:\u0002B\u0012\u0005\u0011\u0011^\u0001\u0007gV\u0014W.\u001b;\u0015\t\u0005-\u0018\u0011 \u0019\u0005\u0003[\f)\u0010E\u0003\u0010\u0003_\f\u00190C\u0002\u0002rB\u0011aAR;ukJ,\u0007c\u0001*\u0002v\u0012Y\u0011q_As\u0003\u0003\u0005\tQ!\u0001V\u0005\ryF%\u000e\u0005\b\u0003#\u000b)\u000f1\u0001_\u0001")
public class CachedThreadPool
extends AbstractExecutorService
implements LazyLogging {
    private final int maxThreads;
    private volatile int org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available;
    private final LinkedList<TrackableFutureTask<?>> org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue;
    private final HashSet<TrackableFutureTask<?>> org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks;
    private final AtomicBoolean stopped;
    private final ReentrantLock org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock;
    private final Condition org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        CachedThreadPool cachedThreadPool = this;
        synchronized (cachedThreadPool) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public int org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available() {
        return this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available;
    }

    public void org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available_$eq(int x$1) {
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available = x$1;
    }

    public LinkedList<TrackableFutureTask<?>> org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue() {
        return this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue;
    }

    public HashSet<TrackableFutureTask<?>> org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks() {
        return this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    public ReentrantLock org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock() {
        return this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock;
    }

    public Condition org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done() {
        return this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done;
    }

    @Override
    public void shutdown() {
        this.stopped().set(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.stopped().set(true);
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().lock();
        try {
            void var2_1;
            ArrayList waiting = new ArrayList(this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue());
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue().clear();
            Iterator<TrackableFutureTask<?>> running = new ArrayList(this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks()).iterator();
            while (running.hasNext()) {
                ((Future)running.next()).cancel(true);
            }
            return var2_1;
        }
        finally {
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.stopped().get();
    }

    @Override
    public boolean isTerminated() {
        return this.stopped().get() && this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available() == this.maxThreads;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().lock();
        try {
            boolean bl;
            if (this.isTerminated()) {
                bl = true;
            } else {
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done().await(timeout, unit);
                bl = this.isTerminated();
            }
            return bl;
        }
        finally {
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().unlock();
        }
    }

    @Override
    public void execute(Runnable command) {
        RunnableFuture runnableFuture;
        if (this.stopped().get()) {
            throw new RejectedExecutionException("Trying to execute a task but executor service is shut down");
        }
        Runnable runnable = command;
        if (runnable instanceof TrackableFutureTask && ((TrackableFutureTask)runnable).org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer() == this) {
            TrackableFutureTask trackableFutureTask = (TrackableFutureTask)runnable;
            runnableFuture = trackableFutureTask;
        } else {
            runnableFuture = this.newTaskFor(runnable, (Object)null);
        }
        RunnableFuture task = runnableFuture;
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$runOrQueueTask((TrackableFutureTask<?>)task);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$runOrQueueTask(TrackableFutureTask<?> task) {
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().lock();
        try {
            if (this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available() <= 0) {
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue().offer(task);
                return;
            }
            try {
                CachedThreadPool$.MODULE$.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$pool().execute(task);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder().append((Object)"CachedThreadPool rejected queued task (likely due to shutdown),").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating new single thread executor: ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task, rejectedExecutionException}))).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ExecutorService pool = Executors.newSingleThreadExecutor();
                pool.execute(task);
                pool.shutdown();
            }
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available_$eq(this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available() - 1);
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks().add(task);
            return;
        }
        finally {
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().unlock();
        }
    }

    public <T> TrackableFutureTask<T> newTaskFor(Runnable runnable, T value2) {
        return new TrackableFutureTask<T>(this, runnable, value2);
    }

    public CachedThreadPool(int maxThreads) {
        this.maxThreads = maxThreads;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available = maxThreads;
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue = new LinkedList();
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks = new HashSet();
        this.stopped = new AtomicBoolean(false);
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock = new ReentrantLock();
        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done = this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().newCondition();
    }

    public class TrackableFutureTask<T>
    extends FutureTask<T> {
        private final Runnable runnable;
        public final /* synthetic */ CachedThreadPool $outer;

        @Override
        public void done() {
            this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().lock();
            try {
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available_$eq(this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$available() + 1);
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$tasks().remove(this);
                TrackableFutureTask<?> next2 = this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$queue().poll();
                if (next2 == null) {
                    if (this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().isTerminated()) {
                        this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$done().signalAll();
                    }
                } else {
                    this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$runOrQueueTask(next2);
                }
                return;
            }
            finally {
                this.org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer().org$locationtech$geomesa$utils$concurrent$CachedThreadPool$$lock().unlock();
            }
        }

        @Override
        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TrackableFutureTask[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.runnable}));
        }

        public /* synthetic */ CachedThreadPool org$locationtech$geomesa$utils$concurrent$CachedThreadPool$TrackableFutureTask$$$outer() {
            return this.$outer;
        }

        public TrackableFutureTask(CachedThreadPool $outer, Runnable runnable, T result) {
            this.runnable = runnable;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(runnable, result);
        }
    }
}

