/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0001\u0003\u00015\u0011QBU3oI\u0016\u0014\u0018N\\4He&$'BA\u0002\u0005\u0003!9Wm\u001c;p_2\u001c(BA\u0003\u0007\u0003\u0015)H/\u001b7t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+qi\u0011A\u0006\u0006\u0003/a\tAb]2bY\u0006dwnZ4j]\u001eT!!\u0007\u000e\u0002\u0011QL\b/Z:bM\u0016T\u0011aG\u0001\u0004G>l\u0017BA\u000f\u0017\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n1!\u001a8w!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003hK>l'BA\u0013\t\u0003\rQGo]\u0005\u0003O\t\u0012\u0001\"\u00128wK2|\u0007/\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005)\u0001pU5{KB\u0011qbK\u0005\u0003YA\u00111!\u00138u\u0011!q\u0003A!A!\u0002\u0013Q\u0013!B=TSj,\u0007\"\u0002\u0019\u0001\t\u0003\t\u0014A\u0002\u001fj]&$h\b\u0006\u00033iU2\u0004CA\u001a\u0001\u001b\u0005\u0011\u0001\"B\u00100\u0001\u0004\u0001\u0003\"B\u00150\u0001\u0004Q\u0003\"\u0002\u00180\u0001\u0004Q\u0003b\u0002\u001d\u0001\u0005\u0004%I!O\u0001\u0005OJLG-F\u0001;!\t\u00194(\u0003\u0002=\u0005\tAqI]5e':\f\u0007\u000f\u0003\u0004?\u0001\u0001\u0006IAO\u0001\u0006OJLG\r\t\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0003\u0019\u0001\u0018\u000e_3mgV\t!\t\u0005\u0003D\u0011*kU\"\u0001#\u000b\u0005\u00153\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u000fB\t!bY8mY\u0016\u001cG/[8o\u0013\tIEIA\u0002NCB\u0004BaD&+U%\u0011A\n\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005=q\u0015BA(\u0011\u0005\u0019!u.\u001e2mK\"1\u0011\u000b\u0001Q\u0001\n\t\u000bq\u0001]5yK2\u001c\b\u0005C\u0004T\u0001\t\u0007I\u0011\u0002+\u0002\tal\u0015N\\\u000b\u0002\u001b\"1a\u000b\u0001Q\u0001\n5\u000bQ\u0001_'j]\u0002Bq\u0001\u0017\u0001C\u0002\u0013%A+\u0001\u0003y\u001b\u0006D\bB\u0002.\u0001A\u0003%Q*A\u0003y\u001b\u0006D\b\u0005C\u0004]\u0001\t\u0007I\u0011B/\u0002\t]LG-Z\u000b\u0002=B\u0011qbX\u0005\u0003AB\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004c\u0001\u0001\u0006IAX\u0001\u0006o&$W\r\t\u0005\bI\u0002\u0001\r\u0011\"\u0003f\u0003\u0015\u0019w.\u001e8u+\u00051\u0007CA\bh\u0013\tA\u0007C\u0001\u0003M_:<\u0007b\u00026\u0001\u0001\u0004%Ia[\u0001\nG>,h\u000e^0%KF$\"\u0001\\8\u0011\u0005=i\u0017B\u00018\u0011\u0005\u0011)f.\u001b;\t\u000fAL\u0017\u0011!a\u0001M\u0006\u0019\u0001\u0010J\u0019\t\rI\u0004\u0001\u0015)\u0003g\u0003\u0019\u0019w.\u001e8uA!)A\u000f\u0001C\u0001k\u00061!/\u001a8eKJ$2\u0001\u001c<|\u0011\u001598\u000f1\u0001y\u0003\u0015\u0001x.\u001b8u!\t\t\u00130\u0003\u0002{E\t)\u0001k\\5oi\")Ap\u001da\u0001\u001b\u00061q/Z5hQRDQ\u0001\u001e\u0001\u0005\u0002y$B\u0001\\@\u0002\n!9\u0011\u0011A?A\u0002\u0005\r\u0011AC7vYRL\u0007k\\5oiB\u0019\u0011%!\u0002\n\u0007\u0005\u001d!E\u0001\u0006Nk2$\u0018\u000eU8j]RDQ\u0001`?A\u00025Ca\u0001\u001e\u0001\u0005\u0002\u00055A#\u00027\u0002\u0010\u0005e\u0001\u0002CA\t\u0003\u0017\u0001\r!a\u0005\u0002\u00151Lg.Z*ue&tw\rE\u0002\"\u0003+I1!a\u0006#\u0005)a\u0015N\\3TiJLgn\u001a\u0005\u0007y\u0006-\u0001\u0019A'\t\rQ\u0004A\u0011AA\u000f)\u0015a\u0017qDA\u0015\u0011!\t\t#a\u0007A\u0002\u0005\r\u0012aD7vYRLG*\u001b8f'R\u0014\u0018N\\4\u0011\u0007\u0005\n)#C\u0002\u0002(\t\u0012q\"T;mi&d\u0015N\\3TiJLgn\u001a\u0005\u0007y\u0006m\u0001\u0019A'\t\rQ\u0004A\u0011AA\u0017)\u0015a\u0017qFA\u001d\u0011!\t\t$a\u000bA\u0002\u0005M\u0012a\u00029pYf<wN\u001c\t\u0004C\u0005U\u0012bAA\u001cE\t9\u0001k\u001c7zO>t\u0007B\u0002?\u0002,\u0001\u0007Q\n\u0003\u0004u\u0001\u0011\u0005\u0011Q\b\u000b\u0006Y\u0006}\u0012\u0011\n\u0005\t\u0003\u0003\nY\u00041\u0001\u0002D\u0005aQ.\u001e7uSB{G._4p]B\u0019\u0011%!\u0012\n\u0007\u0005\u001d#E\u0001\u0007Nk2$\u0018\u000eU8ms\u001e|g\u000e\u0003\u0004}\u0003w\u0001\r!\u0014\u0005\u0007i\u0002!\t!!\u0014\u0015\u000b1\fy%!\u0017\t\u0011\u0005E\u00131\na\u0001\u0003'\n\u0001bZ3p[\u0016$(/\u001f\t\u0004C\u0005U\u0013bAA,E\tAq)Z8nKR\u0014\u0018\u0010\u0003\u0004}\u0003\u0017\u0002\r!\u0014\u0005\u0007\u0003;\u0002A\u0011A/\u0002\u000f%\u001cX)\u001c9us\"1\u0011\u0011\r\u0001\u0005\u0002\u0015\fAa]5{K\"9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014\u0001C5uKJ\fGo\u001c:\u0016\u0005\u0005%\u0004CBA6\u0003w\n\tI\u0004\u0003\u0002n\u0005]d\u0002BA8\u0003kj!!!\u001d\u000b\u0007\u0005MD\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0019\u0011\u0011\u0010\t\u0002\u000fA\f7m[1hK&!\u0011QPA@\u0005!IE/\u001a:bi>\u0014(bAA=!A!qb\u0013&N\u0011\u001d\t)\t\u0001C\u0001\u0003\u000f\u000bQa\u00197fCJ$\u0012\u0001\u001c\u0005\b\u0003\u0017\u0003A\u0011BAG\u0003%!(/\u00198tY\u0006$X\r\u0006\u0003\u0002\u0010\u0006U\u0005#BA6\u0003#S\u0013\u0002BAJ\u0003\u007f\u00121aU3r\u0011\u001d\t9*!#A\u00025\u000b\u0011\u0001\u001f\u0005\b\u00037\u0003A\u0011BAO\u0003\u00159\u0018\u000eZ3o)\u0011\ty)a(\t\u000f\u0005]\u0015\u0011\u0014a\u0001\u001b\u0002")
public class RenderingGrid
implements LazyLogging {
    private final GridSnap grid;
    private final Map<Tuple2<Object, Object>, Object> org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels;
    private final double xMin;
    private final double xMax;
    private final boolean wide;
    private long count;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        RenderingGrid renderingGrid = this;
        synchronized (renderingGrid) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private GridSnap grid() {
        return this.grid;
    }

    public Map<Tuple2<Object, Object>, Object> org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels() {
        return this.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels;
    }

    private double xMin() {
        return this.xMin;
    }

    private double xMax() {
        return this.xMax;
    }

    private boolean wide() {
        return this.wide;
    }

    private long count() {
        return this.count;
    }

    private void count_$eq(long x$1) {
        this.count = x$1;
    }

    public void render(Point point, double weight) {
        int j = this.grid().j(point.getY());
        if (j != -1) {
            this.translate(point.getX()).foreach((Function1)new Serializable(this, weight, j){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RenderingGrid $outer;
                private final double weight$1;
                private final int j$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(i, this.j$1);
                    this.$outer.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().update((Object)sp2, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.$outer.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().apply((Object)sp2)) + this.weight$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.weight$1 = weight$1;
                    this.j$1 = j$1;
                }
            });
        }
        this.count_$eq(this.count() + 1L);
    }

    public void render(MultiPoint multiPoint, double weight) {
        int i;
        for (i = 0; i < multiPoint.getNumGeometries(); ++i) {
            this.render((Point)multiPoint.getGeometryN(i), weight);
        }
        this.count_$eq(this.count() + (long)(1 - i));
    }

    /*
     * Exception decompiling
     */
    public void render(LineString lineString, double weight) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 321->390)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void render(MultiLineString multiLineString, double weight) {
        int i;
        for (i = 0; i < multiLineString.getNumGeometries(); ++i) {
            this.render((LineString)multiLineString.getGeometryN(i), weight);
        }
        this.count_$eq(this.count() + (long)(1 - i));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render(Polygon polygon, double weight) {
        Envelope envelope = polygon.getEnvelopeInternal();
        Seq<Object> imins = this.translate(envelope.getMinX());
        Seq<Object> imaxes = this.translate(envelope.getMaxX());
        int jmin = this.grid().j(envelope.getMinY());
        int jmax = this.grid().j(envelope.getMaxY());
        if (imins.isEmpty() || imaxes.isEmpty() || jmin == -1 || jmax == -1) {
            try {
                Geometry intersection2 = polygon.intersection(this.grid().envelope());
                if (!intersection2.isEmpty()) {
                    this.render(intersection2, weight);
                    this.count_$eq(this.count() - 1L);
                }
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option2.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error intersecting polygon [", "] with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{polygon, this.grid().envelope()})), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
        } else {
            int imin = BoxesRunTime.unboxToInt((Object)imins.head());
            int iLength = BoxesRunTime.unboxToInt((Object)imaxes.head()) - imin + 1;
            int jLength = jmax - jmin + 1;
            BufferedImage image = new BufferedImage(iLength, jLength, 12);
            Graphics2D graphics = image.createGraphics();
            LinearRing border = polygon.getExteriorRing();
            int[] xPoints = (int[])Array$.MODULE$.ofDim(border.getNumPoints(), ClassTag$.MODULE$.Int());
            int[] yPoints = (int[])Array$.MODULE$.ofDim(border.getNumPoints(), ClassTag$.MODULE$.Int());
            for (int i = 0; i < xPoints.length; ++i) {
                Coordinate coord = border.getCoordinateN(i);
                xPoints[i] = BoxesRunTime.unboxToInt((Object)this.translate(coord.x).head()) - imin;
                yPoints[i] = this.grid().j(coord.y) - jmin;
            }
            graphics.fillPolygon(xPoints, yPoints, xPoints.length);
            WritableRaster raster = image.getRaster();
            IntRef i = IntRef.create((int)0);
            IntRef j = IntRef.create((int)0);
            while (i.elem < iLength) {
                while (j.elem < jLength) {
                    if (raster.getSample(i.elem, j.elem, 0) != 0) {
                        imins.foreach((Function1)new Serializable(this, weight, jmin, i, j){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ RenderingGrid $outer;
                            private final double weight$2;
                            private final int jmin$1;
                            private final IntRef i$2;
                            private final IntRef j$3;

                            public final void apply(int im) {
                                this.apply$mcVI$sp(im);
                            }

                            public void apply$mcVI$sp(int im) {
                                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(this.i$2.elem + im, this.j$3.elem + this.jmin$1);
                                this.$outer.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().update((Object)sp2, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.$outer.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().apply((Object)sp2)) + this.weight$2)));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.weight$2 = weight$2;
                                this.jmin$1 = jmin$1;
                                this.i$2 = i$2;
                                this.j$3 = j$3;
                            }
                        });
                    }
                    ++j.elem;
                }
                j.elem = 0;
                ++i.elem;
            }
        }
        this.count_$eq(this.count() + 1L);
    }

    public void render(MultiPolygon multiPolygon, double weight) {
        int i;
        for (i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            this.render((Polygon)multiPolygon.getGeometryN(i), weight);
        }
        this.count_$eq(this.count() + (long)(1 - i));
    }

    public void render(Geometry geometry, double weight) {
        block10: {
            block4: {
                int i;
                Geometry geometry2;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block3: {
                                        geometry2 = geometry;
                                        if (!(geometry2 instanceof Point)) break block3;
                                        Point point = (Point)geometry2;
                                        this.render(point, weight);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    if (!(geometry2 instanceof LineString)) break block5;
                                    LineString lineString = (LineString)geometry2;
                                    this.render(lineString, weight);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                if (!(geometry2 instanceof Polygon)) break block6;
                                Polygon polygon = (Polygon)geometry2;
                                this.render(polygon, weight);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (!(geometry2 instanceof MultiPoint)) break block7;
                            MultiPoint multiPoint = (MultiPoint)geometry2;
                            this.render(multiPoint, weight);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        if (!(geometry2 instanceof MultiLineString)) break block8;
                        MultiLineString multiLineString = (MultiLineString)geometry2;
                        this.render(multiLineString, weight);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!(geometry2 instanceof MultiPolygon)) break block9;
                    MultiPolygon multiPolygon = (MultiPolygon)geometry2;
                    this.render(multiPolygon, weight);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (!(geometry2 instanceof GeometryCollection)) break block10;
                GeometryCollection geometryCollection = (GeometryCollection)geometry2;
                for (i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                    this.render(geometryCollection.getGeometryN(i), weight);
                }
                this.count_$eq(this.count() + (long)(1 - i));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected geometry type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geometry})));
    }

    public boolean isEmpty() {
        return this.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().isEmpty();
    }

    public long size() {
        return this.count();
    }

    public Iterator<Tuple2<Tuple2<Object, Object>, Object>> iterator() {
        return this.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().iterator();
    }

    public void clear() {
        this.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().clear();
    }

    private Seq<Object> translate(double x) {
        double xt;
        double xt2;
        Seq<Object> seq = x < this.xMin() ? ((xt2 = x + 360.0 * package$.MODULE$.ceil((this.xMin() - x) / (double)360)) > this.xMax() ? (Seq<Object>)Seq$.MODULE$.empty() : this.widen(xt2)) : (x > this.xMax() ? ((xt = x - 360.0 * package$.MODULE$.ceil((x - this.xMax()) / (double)360)) < this.xMin() ? (Seq<Object>)Seq$.MODULE$.empty() : this.widen(xt)) : this.widen(x));
        return seq;
    }

    private Seq<Object> widen(double x) {
        Seq seq;
        if (this.wide()) {
            Builder seq2 = Seq$.MODULE$.newBuilder();
            for (double xup = x - 360.0 * package$.MODULE$.floor((x - this.xMin()) / (double)360); xup <= this.xMax(); xup += 360.0) {
                seq2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.grid().i(xup)));
            }
            seq = (Seq)seq2.result();
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.grid().i(x)}));
        }
        return seq;
    }

    private final void writeNext$1(double weight$3, IntRef iN$1, IntRef jN$1, ObjectRef i0$1, Iterator bresenham$1) {
        Tuple2 tuple2;
        while ((tuple2 = (Tuple2)bresenham$1.next()) != null) {
            Tuple2.mcII.sp sp2;
            int i = tuple2._1$mcI$sp();
            int j = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(i, j);
            int i2 = sp3._1$mcI$sp();
            int j2 = sp3._2$mcI$sp();
            Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(i2, j2);
            this.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().update((Object)sp4, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().apply((Object)sp4)) + weight$3)));
            ((IterableLike)((Seq)i0$1.elem).tail()).foreach((Function1)new Serializable(this, weight$3, i0$1, i2, j2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RenderingGrid $outer;
                private final double weight$3;
                private final ObjectRef i0$1;
                private final int i$1;
                private final int j$2;

                public final void apply(int i0N) {
                    this.apply$mcVI$sp(i0N);
                }

                public void apply$mcVI$sp(int i0N) {
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(this.i$1 - BoxesRunTime.unboxToInt((Object)((Seq)this.i0$1.elem).head()) + i0N, this.j$2);
                    this.$outer.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().update((Object)sp2, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.$outer.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels().apply((Object)sp2)) + this.weight$3)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.weight$3 = weight$3;
                    this.i0$1 = i0$1;
                    this.i$1 = i$1;
                    this.j$2 = j$2;
                }
            });
            if (bresenham$1.hasNext()) continue;
            iN$1.elem = i2;
            jN$1.elem = j2;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public RenderingGrid(Envelope env, int xSize, int ySize) {
        LazyLogging.class.$init$((LazyLogging)this);
        this.grid = new GridSnap(env, xSize, ySize);
        this.org$locationtech$geomesa$utils$geotools$RenderingGrid$$pixels = Map$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToDouble((double)0.0));
        this.xMin = env.getMinX();
        this.xMax = env.getMaxX();
        this.wide = this.xMax() - this.xMin() > 360.0;
        this.count = 0L;
    }
}

