/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.geomesa.utils.geotools.GridSnap;
import org.locationtech.geomesa.utils.index.SizeSeparatedBucketIndex$;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import org.locationtech.geomesa.utils.index.SpatialIndex$class;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\teg\u0001B\u0001\u0003\u00015\u0011\u0001dU5{KN+\u0007/\u0019:bi\u0016$')^2lKRLe\u000eZ3y\u0015\t\u0019A!A\u0003j]\u0012,\u0007P\u0003\u0002\u0006\r\u0005)Q\u000f^5mg*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001+\tq1d\u0005\u0003\u0001\u001fU!\u0003C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\rE\u0002\u0017/ei\u0011AA\u0005\u00031\t\u0011Ab\u00159bi&\fG.\u00138eKb\u0004\"AG\u000e\r\u0001\u0011)A\u0004\u0001b\u0001;\t\tA+\u0005\u0002\u001fCA\u0011\u0001cH\u0005\u0003AE\u0011qAT8uQ&tw\r\u0005\u0002\u0011E%\u00111%\u0005\u0002\u0004\u0003:L\bCA\u0013-\u001b\u00051#BA\u0014)\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI#&\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0013aA2p[&\u0011QF\n\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\t\u0011=\u0002!\u0011!Q\u0001\nA\nQa]5{KN\u00042!M\u001d=\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026\u0019\u00051AH]8pizJ\u0011AE\u0005\u0003qE\tq\u0001]1dW\u0006<W-\u0003\u0002;w\t\u00191+Z9\u000b\u0005a\n\u0002\u0003\u0002\t>\u007f}J!AP\t\u0003\rQ+\b\u000f\\33!\t\u0001\u0002)\u0003\u0002B#\t1Ai\\;cY\u0016D\u0001b\u0011\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0012q\n+8m[3u\u001bVdG/\u001b9mS\u0016\u0014\b\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B \u0002#e\u0014UoY6fi6+H\u000e^5qY&,'\u000f\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0003\u001d)\u0007\u0010^3oiN\u0004\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\t\u001d,w.\u001c\u0006\u0003\u001b\"\t1A\u001b;t\u0013\ty%J\u0001\u0005F]Z,Gn\u001c9f\u0011\u0015\t\u0006\u0001\"\u0001S\u0003\u0019a\u0014N\\5u}Q)1\u000bV+W/B\u0019a\u0003A\r\t\u000f=\u0002\u0006\u0013!a\u0001a!91\t\u0015I\u0001\u0002\u0004y\u0004bB#Q!\u0003\u0005\ra\u0010\u0005\b\u000fB\u0003\n\u00111\u0001I\u0011\u001dI\u0006A1A\u0005\ni\u000bQ\u0001^5feN,\u0012a\u0017\t\u00049~\u0003W\"A/\u000b\u0005y\u000b\u0012AC2pY2,7\r^5p]&\u0011!(\u0018\t\u0003C\nl\u0011\u0001\u0001\u0004\u0005G\u0002!AM\u0001\u0003US\u0016\u00148C\u00012\u0010\u0011!1'M!b\u0001\n\u00039\u0017\u0001C7bqNK'0\u001a-\u0016\u0003}B\u0001\"\u001b2\u0003\u0002\u0003\u0006IaP\u0001\n[\u0006D8+\u001b>f1\u0002B\u0001b\u001b2\u0003\u0006\u0004%\taZ\u0001\t[\u0006D8+\u001b>f3\"AQN\u0019B\u0001B\u0003%q(A\u0005nCb\u001c\u0016N_3ZA!AqN\u0019B\u0001B\u0003%\u0001/A\u0004ck\u000e\\W\r^:\u0011\u0007A\t8/\u0003\u0002s#\t)\u0011I\u001d:bsB\u0019\u0001#\u001d;\u0011\tUdh0G\u0007\u0002m*\u0011q\u000f_\u0001\u000bG>t7-\u001e:sK:$(BA={\u0003\u0011)H/\u001b7\u000b\u0003m\fAA[1wC&\u0011QP\u001e\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bcA@\u0002\u00069\u0019\u0001#!\u0001\n\u0007\u0005\r\u0011#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\tIA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007\t\u0002BCA\u0007E\n\u0005\t\u0015!\u0003\u0002\u0010\u0005AqM]5e':\f\u0007\u000f\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002B\u0001\tO\u0016|Go\\8mg&!\u0011\u0011DA\n\u0005!9%/\u001b3T]\u0006\u0004\bBB)c\t\u0003\ti\u0002F\u0005a\u0003?\t\t#a\t\u0002&!1a-a\u0007A\u0002}Baa[A\u000e\u0001\u0004y\u0004BB8\u0002\u001c\u0001\u0007\u0001\u000f\u0003\u0005\u0002\u000e\u0005m\u0001\u0019AA\b\u0011%\tIC\u0019a\u0001\n\u0003\tY#A\u0003f[B$\u00180\u0006\u0002\u0002.A\u0019\u0001#a\f\n\u0007\u0005E\u0012CA\u0004C_>dW-\u00198\t\u0013\u0005U\"\r1A\u0005\u0002\u0005]\u0012!C3naRLx\fJ3r)\u0011\tI$a\u0010\u0011\u0007A\tY$C\u0002\u0002>E\u0011A!\u00168ji\"Q\u0011\u0011IA\u001a\u0003\u0003\u0005\r!!\f\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002F\t\u0004\u000b\u0015BA\u0017\u0003\u0019)W\u000e\u001d;zA!\"\u00111IA%!\r\u0001\u00121J\u0005\u0004\u0003\u001b\n\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005E#M1A\u0005\n\u0005M\u0013\u0001B7bqb+\"!!\u0016\u0011\u0007A\t9&C\u0002\u0002ZE\u00111!\u00138u\u0011!\tiF\u0019Q\u0001\n\u0005U\u0013!B7bqb\u0003\u0003\"CA1E\n\u0007I\u0011BA*\u0003\u0011i\u0017\r_-\t\u0011\u0005\u0015$\r)A\u0005\u0003+\nQ!\\1y3\u0002Bq!!\u001bc\t\u0003\tY'\u0001\u0004ck\u000e\\W\r\u001e\u000b\u0006i\u00065\u0014\u0011\u000f\u0005\b\u0003_\n9\u00071\u0001@\u0003\u0005A\bbBA:\u0003O\u0002\raP\u0001\u0002s\"9\u0011\u0011\u000e2\u0005\u0002\u0005]Dc\u0001;\u0002z!9\u00111PA;\u0001\u0004A\u0015\u0001C3om\u0016dw\u000e]3\t\u000f\u0005}$\r\"\u0001\u0002\u0002\u0006A\u0011\u000e^3sCR|'\u000f\u0006\u0006\u0002\u0004\u0006%\u0015QRAI\u0003+\u0003B!MAC3%\u0019\u0011qQ\u001e\u0003\u0011%#XM]1u_JDq!a#\u0002~\u0001\u0007q(\u0001\u0003y[&t\u0007bBAH\u0003{\u0002\raP\u0001\u0005s6Lg\u000eC\u0004\u0002\u0014\u0006u\u0004\u0019A \u0002\tal\u0017\r\u001f\u0005\b\u0003/\u000bi\b1\u0001@\u0003\u0011IX.\u0019=\t\u000f\u0005m%\r\"\u0001\u0002\u001e\u0006!1/\u001b>f)\t\t)\u0006C\u0004\u0002\"\n$\t!a)\u0002\u000b\rdW-\u0019:\u0015\u0005\u0005e\u0002bBATE\u0012%\u0011\u0011V\u0001\u0006g:\f\u0007\u000f\u0017\u000b\u0005\u0003+\nY\u000bC\u0004\u0002p\u0005\u0015\u0006\u0019A \t\u000f\u0005=&\r\"\u0003\u00022\u0006)1O\\1q3R!\u0011QKAZ\u0011\u001d\t\u0019(!,A\u0002}2a!a.c\u0001\u0005e&\u0001\u0004+jKJLE/\u001a:bi>\u00148#BA[\u001f\u0005\r\u0005BCAF\u0003k\u0013\t\u0011)A\u0005\u007f!Q\u0011qRA[\u0005\u0003\u0005\u000b\u0011B \t\u0015\u0005M\u0015Q\u0017B\u0001B\u0003%q\b\u0003\u0006\u0002\u0018\u0006U&\u0011!Q\u0001\n}Bq!UA[\t\u0003\t)\r\u0006\u0006\u0002H\u0006-\u0017QZAh\u0003#\u0004B!!3\u000266\t!\rC\u0004\u0002\f\u0006\r\u0007\u0019A \t\u000f\u0005=\u00151\u0019a\u0001\u007f!9\u00111SAb\u0001\u0004y\u0004bBAL\u0003\u0007\u0004\ra\u0010\u0005\u000b\u0003+\f)L1A\u0005\n\u0005M\u0013\u0001B7bq&D\u0011\"!7\u00026\u0002\u0006I!!\u0016\u0002\u000b5\f\u00070\u001b\u0011\t\u0015\u0005u\u0017Q\u0017b\u0001\n\u0013\t\u0019&\u0001\u0003nS:T\u0007\"CAq\u0003k\u0003\u000b\u0011BA+\u0003\u0015i\u0017N\u001c6!\u0011)\t)/!.C\u0002\u0013%\u00111K\u0001\u0005[\u0006D(\u000eC\u0005\u0002j\u0006U\u0006\u0015!\u0003\u0002V\u0005)Q.\u0019=kA!Q\u0011Q^A[\u0001\u0004%I!a\u0015\u0002\u0003%D!\"!=\u00026\u0002\u0007I\u0011BAz\u0003\u0015Iw\fJ3r)\u0011\tI$!>\t\u0015\u0005\u0005\u0013q^A\u0001\u0002\u0004\t)\u0006C\u0005\u0002z\u0006U\u0006\u0015)\u0003\u0002V\u0005\u0011\u0011\u000e\t\u0005\u000b\u0003{\f)\f1A\u0005\n\u0005M\u0013!\u00016\t\u0015\t\u0005\u0011Q\u0017a\u0001\n\u0013\u0011\u0019!A\u0003k?\u0012*\u0017\u000f\u0006\u0003\u0002:\t\u0015\u0001BCA!\u0003\u007f\f\t\u00111\u0001\u0002V!I!\u0011BA[A\u0003&\u0011QK\u0001\u0003U\u0002B!B!\u0004\u00026\u0002\u0007I\u0011\u0002B\b\u0003\u0011IG/\u001a:\u0016\u0005\tE\u0001#\u0002B\n\u0005+IR\"\u0001=\n\u0007\u0005\u001d\u0005\u0010\u0003\u0006\u0003\u001a\u0005U\u0006\u0019!C\u0005\u00057\t\u0001\"\u001b;fe~#S-\u001d\u000b\u0005\u0003s\u0011i\u0002\u0003\u0006\u0002B\t]\u0011\u0011!a\u0001\u0005#A\u0011B!\t\u00026\u0002\u0006KA!\u0005\u0002\u000b%$XM\u001d\u0011\t\u0011\t\u0015\u0012Q\u0017C#\u0003W\tq\u0001[1t\u001d\u0016DH\u000f\u000b\u0003\u0003$\t%\u0002\u0003\u0002B\u0016\u0005ci!A!\f\u000b\u0007\t=\u0012#\u0001\u0006b]:|G/\u0019;j_:LAAa\r\u0003.\t9A/Y5me\u0016\u001c\u0007\u0002\u0003B\u001c\u0003k#\tE!\u000f\u0002\t9,\u0007\u0010\u001e\u000b\u00023!9!Q\b\u0001!\u0002\u0013Y\u0016A\u0002;jKJ\u001c\b\u0005C\u0004\u0003B\u0001!\tEa\u0011\u0002\r%t7/\u001a:u)!\tID!\u0012\u0003N\tE\u0003bB&\u0003@\u0001\u0007!q\t\t\u0004\u0013\n%\u0013b\u0001B&\u0015\nAq)Z8nKR\u0014\u0018\u0010C\u0004\u0003P\t}\u0002\u0019\u0001@\u0002\u0007-,\u0017\u0010C\u0004\u0003T\t}\u0002\u0019A\r\u0002\u000bY\fG.^3\t\u000f\t]\u0003\u0001\"\u0011\u0003Z\u00051!/Z7pm\u0016$R!\u0007B.\u0005;Bqa\u0013B+\u0001\u0004\u00119\u0005C\u0004\u0003P\tU\u0003\u0019\u0001@\t\u000f\t\u0005\u0004\u0001\"\u0011\u0003d\u0005\u0019q-\u001a;\u0015\u000be\u0011)Ga\u001a\t\u000f-\u0013y\u00061\u0001\u0003H!9!q\nB0\u0001\u0004q\bb\u0002B6\u0001\u0011\u0005#QN\u0001\u0006cV,'/\u001f\u000b\u000b\u0003\u0007\u0013yG!\u001d\u0003t\tU\u0004bBAF\u0005S\u0002\ra\u0010\u0005\b\u0003\u001f\u0013I\u00071\u0001@\u0011\u001d\t\u0019J!\u001bA\u0002}Bq!a&\u0003j\u0001\u0007q\bC\u0004\u0003l\u0001!\tE!\u001f\u0015\u0005\u0005\r\u0005bBAN\u0001\u0011\u0005\u0013Q\u0014\u0005\b\u0003C\u0003A\u0011IAR\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007\u000b!b]3mK\u000e$H+[3s)\r\u0001'Q\u0011\u0005\b\u0003w\u0012y\b1\u0001I\u000f\u001d\u0011II\u0001E\u0001\u0005\u0017\u000b\u0001dU5{KN+\u0007/\u0019:bi\u0016$')^2lKRLe\u000eZ3y!\r1\"Q\u0012\u0004\u0007\u0003\tA\tAa$\u0014\u0007\t5u\u0002C\u0004R\u0005\u001b#\tAa%\u0015\u0005\t-\u0005B\u0003BL\u0005\u001b\u0013\r\u0011\"\u0001\u0003\u001a\u0006aA)\u001a4bk2$H+[3sgV\t\u0001\u0007\u0003\u0005\u0003\u001e\n5\u0005\u0015!\u00031\u00035!UMZ1vYR$\u0016.\u001a:tA!Q!\u0011\u0015BG#\u0003%\tAa)\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0011\u0011)Ka.\u0016\u0005\t\u001d&f\u0001\u0019\u0003*.\u0012!1\u0016\t\u0005\u0005[\u0013\u0019,\u0004\u0002\u00030*!!\u0011\u0017B\u0017\u0003%)hn\u00195fG.,G-\u0003\u0003\u00036\n=&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121ADa(C\u0002uA!Ba/\u0003\u000eF\u0005I\u0011\u0001B_\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU!!q\u0018Bb+\t\u0011\tMK\u0002@\u0005S#a\u0001\bB]\u0005\u0004i\u0002B\u0003Bd\u0005\u001b\u000b\n\u0011\"\u0001\u0003J\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*BAa0\u0003L\u00121AD!2C\u0002uA!Ba4\u0003\u000eF\u0005I\u0011\u0001Bi\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU!!1\u001bBl+\t\u0011)NK\u0002I\u0005S#a\u0001\bBg\u0005\u0004i\u0002")
public class SizeSeparatedBucketIndex<T>
implements SpatialIndex<T>,
StrictLogging {
    public final Seq<Tuple2<Object, Object>> org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$sizes;
    public final double org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$xBucketMultiplier;
    public final double org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$yBucketMultiplier;
    public final Envelope org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents;
    private final Seq<Tier> tiers;
    private final Logger logger;

    public static <T> Envelope $lessinit$greater$default$4() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> double $lessinit$greater$default$3() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> double $lessinit$greater$default$2() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> Seq<Tuple2<Object, Object>> $lessinit$greater$default$1() {
        return SizeSeparatedBucketIndex$.MODULE$.$lessinit$greater$default$1();
    }

    public static Seq<Tuple2<Object, Object>> DefaultTiers() {
        return SizeSeparatedBucketIndex$.MODULE$.DefaultTiers();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Iterator<T> query(Envelope bbox) {
        return SpatialIndex$class.query(this, bbox);
    }

    private Seq<Tier> tiers() {
        return this.tiers;
    }

    @Override
    public void insert(Geometry geom, String key2, T value2) {
        Envelope envelope = geom.getEnvelopeInternal();
        Tier tier = this.selectTier(envelope);
        if (tier.empty()) {
            tier.empty_$eq(false);
        }
        tier.bucket(envelope).put(key2, value2);
    }

    @Override
    public T remove(Geometry geom, String key2) {
        Envelope envelope = geom.getEnvelopeInternal();
        return this.selectTier(envelope).bucket(envelope).remove(key2);
    }

    @Override
    public T get(Geometry geom, String key2) {
        Envelope envelope = geom.getEnvelopeInternal();
        return this.selectTier(envelope).bucket(envelope).get(key2);
    }

    @Override
    public Iterator<T> query(double xmin, double ymin, double xmax, double ymax) {
        return this.tiers().iterator().flatMap((Function1)new Serializable(this, xmin, ymin, xmax, ymax){
            public static final long serialVersionUID = 0L;
            private final double xmin$1;
            private final double ymin$1;
            private final double xmax$1;
            private final double ymax$1;

            public final Iterator<T> apply(Tier x$1) {
                return x$1.iterator(this.xmin$1, this.ymin$1, this.xmax$1, this.ymax$1);
            }
            {
                this.xmin$1 = xmin$1;
                this.ymin$1 = ymin$1;
                this.xmax$1 = xmax$1;
                this.ymax$1 = ymax$1;
            }
        });
    }

    @Override
    public Iterator<T> query() {
        return this.query(this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinX(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinY(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMaxX(), this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMaxY());
    }

    @Override
    public int size() {
        IntRef size2 = IntRef.create((int)0);
        this.tiers().foreach((Function1)new Serializable(this, size2){
            public static final long serialVersionUID = 0L;
            private final IntRef size$1;

            public final void apply(Tier tier) {
                this.size$1.elem += tier.size();
            }
            {
                this.size$1 = size$1;
            }
        });
        return size2.elem;
    }

    @Override
    public void clear() {
        this.tiers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tier x$2) {
                x$2.clear();
            }
        });
    }

    private Tier selectTier(Envelope envelope) {
        double width = envelope.getWidth();
        double height = envelope.getHeight();
        return (Tier)this.tiers().find((Function1)new Serializable(this, width, height){
            public static final long serialVersionUID = 0L;
            private final double width$1;
            private final double height$1;

            public final boolean apply(Tier t) {
                return t.maxSizeX() >= this.width$1 && t.maxSizeY() >= this.height$1;
            }
            {
                this.width$1 = width$1;
                this.height$1 = height$1;
            }
        }).getOrElse((Function0)new Serializable(this, envelope){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SizeSeparatedBucketIndex $outer;
            private final Envelope envelope$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Envelope ", " exceeds the max tier size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.envelope$1, this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$sizes.last()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.envelope$1 = envelope$1;
            }
        });
    }

    public SizeSeparatedBucketIndex(Seq<Tuple2<Object, Object>> sizes, double xBucketMultiplier, double yBucketMultiplier, Envelope extents) {
        this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$sizes = sizes;
        this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$xBucketMultiplier = xBucketMultiplier;
        this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$yBucketMultiplier = yBucketMultiplier;
        this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents = extents;
        SpatialIndex$class.$init$(this);
        StrictLogging.class.$init$((StrictLogging)this);
        Predef$.MODULE$.require(sizes.nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No valid tier sizes specified";
            }
        });
        Predef$.MODULE$.require(sizes.lengthCompare(1) == 0 || sizes.sliding(2).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<Tuple2<Object, Object>> x0$2) {
                Seq<Tuple2<Object, Object>> seq = x0$2;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Tuple2 tuple2 = (Tuple2)((SeqLike)some.get()).apply(0);
                    Tuple2 tuple22 = (Tuple2)((SeqLike)some.get()).apply(1);
                    if (tuple2 != null) {
                        double x1 = tuple2._1$mcD$sp();
                        double y1 = tuple2._2$mcD$sp();
                        if (tuple22 != null) {
                            double x2 = tuple22._1$mcD$sp();
                            double y2 = tuple22._2$mcD$sp();
                            boolean bl = x1 <= x2 && y1 <= y2;
                            return bl;
                        }
                    }
                }
                throw new MatchError(seq);
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Tiers must be ordered by increasing size";
            }
        });
        this.tiers = (Seq)sizes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SizeSeparatedBucketIndex $outer;

            public final Tier apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    double width = tuple2._1$mcD$sp();
                    double height = tuple2._2$mcD$sp();
                    int xSize = (int)scala.math.package$.MODULE$.ceil(this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getWidth() * this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$xBucketMultiplier / width);
                    int ySize = (int)scala.math.package$.MODULE$.ceil(this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getHeight() * this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$yBucketMultiplier / height);
                    ConcurrentHashMap[][] buckets = (ConcurrentHashMap[][])Array$.MODULE$.fill(xSize, ySize, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ConcurrentHashMap<String, T> apply() {
                            return new ConcurrentHashMap<K, V>();
                        }
                    }, ClassTag$.MODULE$.apply(ConcurrentHashMap.class));
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Creating tier for size ({} {}) with buckets [{}x{}]", new Object[]{BoxesRunTime.boxToDouble((double)width), BoxesRunTime.boxToDouble((double)height), BoxesRunTime.boxToInteger((int)xSize), BoxesRunTime.boxToInteger((int)ySize)});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Tier tier = new Tier(this.$outer, width, height, buckets, new GridSnap(this.$outer.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents, xSize, ySize));
                    return tier;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public class Tier {
        private final double maxSizeX;
        private final double maxSizeY;
        public final ConcurrentHashMap<String, T>[][] org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets;
        private final GridSnap gridSnap;
        private volatile boolean empty;
        private final int maxX;
        private final int maxY;
        public final /* synthetic */ SizeSeparatedBucketIndex $outer;

        public double maxSizeX() {
            return this.maxSizeX;
        }

        public double maxSizeY() {
            return this.maxSizeY;
        }

        public boolean empty() {
            return this.empty;
        }

        public void empty_$eq(boolean x$1) {
            this.empty = x$1;
        }

        private int maxX() {
            return this.maxX;
        }

        private int maxY() {
            return this.maxY;
        }

        public ConcurrentHashMap<String, T> bucket(double x, double y) {
            return this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(x)][this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(y)];
        }

        public ConcurrentHashMap<String, T> bucket(Envelope envelope) {
            return this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX((envelope.getMinX() + envelope.getMaxX()) / 2.0)][this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY((envelope.getMinY() + envelope.getMaxY()) / 2.0)];
        }

        public Iterator<T> iterator(double xmin, double ymin, double xmax, double ymax) {
            return this.empty() ? package$.MODULE$.Iterator().empty() : new TierIterator(xmin, ymin, xmax, ymax);
        }

        /*
         * WARNING - void declaration
         */
        public int size() {
            int n;
            if (this.empty()) {
                n = 0;
            } else {
                void var1_1;
                int size2 = 0;
                for (int i = 0; i <= this.maxX(); ++i) {
                    for (int j = 0; j <= this.maxY(); ++j) {
                        size2 += this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[i][j].size();
                    }
                }
                n = var1_1;
            }
            return n;
        }

        public void clear() {
            for (int i = 0; i <= this.maxX(); ++i) {
                for (int j = 0; j <= this.maxY(); ++j) {
                    this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[i][j].clear();
                }
            }
        }

        public int org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(double x) {
            int i = this.gridSnap.i(x);
            return i != -1 ? i : (x < this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinX() ? 0 : this.maxX());
        }

        public int org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(double y) {
            int j = this.gridSnap.j(y);
            return j != -1 ? j : (y < this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$$extents.getMinY() ? 0 : this.maxY());
        }

        public /* synthetic */ SizeSeparatedBucketIndex org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$$outer() {
            return this.$outer;
        }

        public Tier(SizeSeparatedBucketIndex<T> $outer, double maxSizeX, double maxSizeY, ConcurrentHashMap<String, T>[][] buckets, GridSnap gridSnap) {
            this.maxSizeX = maxSizeX;
            this.maxSizeY = maxSizeY;
            this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets = buckets;
            this.gridSnap = gridSnap;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.empty = true;
            this.maxX = buckets.length - 1;
            this.maxY = buckets[0].length - 1;
        }

        public class TierIterator
        implements Iterator<T> {
            private final int maxi;
            private final int minj;
            private final int maxj;
            private int i;
            private int j;
            private java.util.Iterator<T> iter;

            public Iterator<T> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                return Iterator.class.grouped((Iterator)this, (int)size2);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private int maxi() {
                return this.maxi;
            }

            private int minj() {
                return this.minj;
            }

            private int maxj() {
                return this.maxj;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            private int j() {
                return this.j;
            }

            private void j_$eq(int x$1) {
                this.j = x$1;
            }

            private java.util.Iterator<T> iter() {
                return this.iter;
            }

            private void iter_$eq(java.util.Iterator<T> x$1) {
                this.iter = x$1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean hasNext() {
                while (!this.iter().hasNext()) {
                    if (this.i() == this.maxi() && this.j() == this.maxj()) {
                        if (!false) return false;
                        return true;
                    }
                    if (this.j() < this.maxj()) {
                        this.j_$eq(this.j() + 1);
                    } else {
                        this.j_$eq(this.minj());
                        this.i_$eq(this.i() + 1);
                    }
                    this.iter_$eq(this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$TierIterator$$$outer().org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.i()][this.j()].values().iterator());
                }
                return true;
            }

            public T next() {
                return this.iter().next();
            }

            public /* synthetic */ Tier org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$TierIterator$$$outer() {
                return Tier.this;
            }

            public TierIterator(double xmin, double ymin, double xmax, double ymax) {
                if (Tier.this == null) {
                    throw null;
                }
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.maxi = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(xmax + Tier.this.maxSizeX());
                this.minj = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(ymin - Tier.this.maxSizeY());
                this.maxj = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapY(ymax + Tier.this.maxSizeY());
                this.i = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$snapX(xmin - Tier.this.maxSizeX());
                this.j = this.minj();
                this.iter = Tier.this.org$locationtech$geomesa$utils$index$SizeSeparatedBucketIndex$Tier$$buckets[this.i()][this.j()].values().iterator();
            }
        }
    }
}

