/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u001b\t\tb)\u001b7f'&TX-R:uS6\fGo\u001c:\u000b\u0005\r!\u0011AA5p\u0015\t)a!A\u0003vi&d7O\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\u000f\u000e\u0003YQ!a\u0006\r\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005eQ\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003m\t1aY8n\u0013\tibCA\u0006MCjLHj\\4hS:<\u0007\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\rQ\f'oZ3u!\ty\u0011%\u0003\u0002#!\t!Aj\u001c8h\u0011!!\u0003A!A!\u0002\u0013)\u0013!B3se>\u0014\bCA\b'\u0013\t9\u0003CA\u0003GY>\fG\u000f\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003&\u0003a)7\u000f^5nCR,GMQ=uKN\u0004VM\u001d$fCR,(/\u001a\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5z\u0003'\r\t\u0003]\u0001i\u0011A\u0001\u0005\u0006?)\u0002\r\u0001\t\u0005\u0006I)\u0002\r!\n\u0005\u0006S)\u0002\r!\n\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0003%!\bN]3tQ>dG-F\u0001!\u0011\u00191\u0004\u0001)A\u0005A\u0005QA\u000f\u001b:fg\"|G\u000e\u001a\u0011\t\u000fa\u0002\u0001\u0019!C\u0005s\u0005AQm\u001d;j[\u0006$X-F\u0001;!\ty1(\u0003\u0002=!\t1Ai\\;cY\u0016DqA\u0010\u0001A\u0002\u0013%q(\u0001\u0007fgRLW.\u0019;f?\u0012*\u0017\u000f\u0006\u0002A\u0007B\u0011q\"Q\u0005\u0003\u0005B\u0011A!\u00168ji\"9A)PA\u0001\u0002\u0004Q\u0014a\u0001=%c!1a\t\u0001Q!\ni\n\u0011\"Z:uS6\fG/\u001a\u0011\t\u000f!\u0003\u0001\u0019!C\u0005\u0013\u0006yQ\u000f\u001d3bi\u0016$Wi\u001d;j[\u0006$X-F\u0001K!\ry1*J\u0005\u0003\u0019B\u0011aa\u00149uS>t\u0007b\u0002(\u0001\u0001\u0004%IaT\u0001\u0014kB$\u0017\r^3e\u000bN$\u0018.\\1uK~#S-\u001d\u000b\u0003\u0001BCq\u0001R'\u0002\u0002\u0003\u0007!\n\u0003\u0004S\u0001\u0001\u0006KAS\u0001\u0011kB$\u0017\r^3e\u000bN$\u0018.\\1uK\u0002BQ\u0001\u000f\u0001\u0005\u0002Q#\"\u0001I+\t\u000bY\u001b\u0006\u0019\u0001\u0011\u0002\u000f]\u0014\u0018\u000e\u001e;f]\")\u0001\f\u0001C\u00013\u00061Q\u000f\u001d3bi\u0016$2\u0001\u0011.]\u0011\u0015Yv\u000b1\u0001!\u0003\u0011\u0019\u0018N_3\t\u000bu;\u0006\u0019\u0001\u0011\u0002\u000b\r|WO\u001c;\t\u000b}\u0003A\u0011A%\u0002%\u001d,GOQ=uKN\u0004VM\u001d$fCR,(/\u001a\u0005\u0006C\u0002!\tAY\u0001\u0005I>tW\r\u0006\u0002dMB\u0011q\u0002Z\u0005\u0003KB\u0011qAQ8pY\u0016\fg\u000eC\u0003\\A\u0002\u0007\u0001\u0005")
public class FileSizeEstimator
implements LazyLogging {
    private final long target;
    private final long threshold;
    private double estimate;
    private Option<Object> updatedEstimate;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FileSizeEstimator fileSizeEstimator = this;
        synchronized (fileSizeEstimator) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private long threshold() {
        return this.threshold;
    }

    private double estimate() {
        return this.estimate;
    }

    private void estimate_$eq(double x$1) {
        this.estimate = x$1;
    }

    private Option<Object> updatedEstimate() {
        return this.updatedEstimate;
    }

    private void updatedEstimate_$eq(Option<Object> x$1) {
        this.updatedEstimate = x$1;
    }

    public long estimate(long written) {
        return package$.MODULE$.max(1L, package$.MODULE$.round((double)(this.target - written) / this.estimate()));
    }

    public void update(long size2, long count2) {
        BoxedUnit boxedUnit;
        if (size2 > 0L && count2 > 0L && package$.MODULE$.abs(size2 - this.target) > this.threshold()) {
            BoxedUnit boxedUnit2;
            double update = (double)size2 / (double)count2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Updating bytesPerFeature from {} to {} based on writing {} features in {} bytes", new Object[]{BoxesRunTime.boxToDouble((double)this.estimate()), BoxesRunTime.boxToDouble((double)update), BoxesRunTime.boxToLong((long)count2), BoxesRunTime.boxToLong((long)size2)});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.estimate_$eq(update);
            this.updatedEstimate_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)((float)this.estimate()))));
        } else if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Not updating bytesPerFeature from {} based on writing {} features in {} bytes", new Object[]{BoxesRunTime.boxToDouble((double)this.estimate()), BoxesRunTime.boxToLong((long)count2), BoxesRunTime.boxToLong((long)size2)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<Object> getBytesPerFeature() {
        return this.updatedEstimate();
    }

    public boolean done(long size2) {
        return size2 > this.target || package$.MODULE$.abs(size2 - this.target) < this.threshold();
    }

    public FileSizeEstimator(long target, float error, float estimatedBytesPerFeature) {
        this.target = target;
        LazyLogging.class.$init$((LazyLogging)this);
        Predef$.MODULE$.require(error >= 0.0f && error < 1.0f, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Error must be a percentage between [0,1)";
            }
        });
        this.threshold = package$.MODULE$.round((double)target * (double)error);
        this.estimate = estimatedBytesPerFeature;
        this.updatedEstimate = None$.MODULE$;
    }
}

