/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import java.util.Date;
import org.locationtech.geomesa.curve.Z2SFC$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.stats.BinnedArray$StringBinning$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeqLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011-a\u0001B\u0001\u0003\u00015\u00111BQ5o]\u0016$\u0017I\u001d:bs*\u00111\u0001B\u0001\u0006gR\fGo\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001U\u0019aba&\u0014\u0005\u0001y\u0001C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0018\u0003\u001d\u0011\u0017N\u001c8j]\u001e\u0004B\u0001\u0007*\u0004\u0016:\u0011\u0011D\n\b\u00035\u0015r!a\u0007\u0013\u000f\u0005q\u0019cBA\u000f#\u001d\tq\u0012%D\u0001 \u0015\t\u0001C\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!q!B\u0014\u0003\u0011\u0003A\u0013a\u0003\"j]:,G-\u0011:sCf\u0004\"!\u000b\u0016\u000e\u0003\t1Q!\u0001\u0002\t\u0002-\u001a\"AK\b\t\u000b5RC\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\u0005A\u0003\"\u0002\u0019+\t\u0003\t\u0014!B1qa2LXC\u0001\u001a8)\r\u0019\u0004*\u0014\u000b\u0003i\u0001\u00032!\u000b\u00016!\t1t\u0007\u0004\u0001\u0005\u000baz#\u0019A\u001d\u0003\u0003Q\u000b\"AO\u001f\u0011\u0005AY\u0014B\u0001\u001f\u0012\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u0005 \n\u0005}\n\"aA!os\"9\u0011iLA\u0001\u0002\b\u0011\u0015AC3wS\u0012,gnY3%cA\u00191IR\u001b\u000e\u0003\u0011S!!R\t\u0002\u000fI,g\r\\3di&\u0011q\t\u0012\u0002\t\u00072\f7o\u001d+bO\")\u0011j\fa\u0001\u0015\u00061A.\u001a8hi\"\u0004\"\u0001E&\n\u00051\u000b\"aA%oi\")aj\fa\u0001\u001f\u00061!m\\;oIN\u0004B\u0001\u0005)6k%\u0011\u0011+\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0007\u000bMS\u0013\u0011\u0001+\u0003\u000f\tKgN\\5oOV\u0011QKX\n\u0003%>A\u0001\"\u0013*\u0003\u0006\u0004%\taV\u000b\u0002\u0015\"A\u0011L\u0015B\u0001B\u0003%!*A\u0004mK:<G\u000f\u001b\u0011\t\u00119\u0013&Q1A\u0005\u0002m+\u0012\u0001\u0018\t\u0005!AkV\f\u0005\u00027=\u0012)\u0001H\u0015b\u0001s!A\u0001M\u0015B\u0001B\u0003%A,A\u0004c_VtGm\u001d\u0011\t\u000b5\u0012F\u0011\u00012\u0015\u0007\r,g\rE\u0002e%vk\u0011A\u000b\u0005\u0006\u0013\u0006\u0004\rA\u0013\u0005\u0006\u001d\u0006\u0004\r\u0001\u0018\u0005\u0006QJ3\t![\u0001\fI&\u0014Xm\u0019;J]\u0012,\u0007\u0010\u0006\u0002KU\")1n\u001aa\u0001Y\u0006)a/\u00197vKB\u0011\u0001#\\\u0005\u0003]F\u0011A\u0001T8oO\")\u0001O\u0015D\u0001c\u00069\u0011N\u001c3fq>3GC\u0001&s\u0011\u0015Yw\u000e1\u0001^\u0011\u0015!(K\"\u0001v\u0003-iW\rZ5b]Z\u000bG.^3\u0015\u0005u3\b\"B<t\u0001\u0004Q\u0015!B5oI\u0016D\b\"\u0002(S\r\u0003IHC\u0001/{\u0011\u00159\b\u00101\u0001K\u0011\u0015a(K\"\u0001~\u0003\u001dI7OQ3m_^$2A`A\u0002!\t\u0001r0C\u0002\u0002\u0002E\u0011qAQ8pY\u0016\fg\u000eC\u0003lw\u0002\u0007QlB\u0004\u0002\b)B\t!!\u0003\u0002\u000f\tKgN\\5oOB\u0019A-a\u0003\u0007\rMS\u0003\u0012AA\u0007'\r\tYa\u0004\u0005\b[\u0005-A\u0011AA\t)\t\tI\u0001C\u00041\u0003\u0017!\t!!\u0006\u0016\t\u0005]\u0011q\u0004\u000b\u0007\u00033\t9#!\u000b\u0015\t\u0005m\u0011\u0011\u0005\t\u0005IJ\u000bi\u0002E\u00027\u0003?!a\u0001OA\n\u0005\u0004I\u0004BCA\u0012\u0003'\t\t\u0011q\u0001\u0002&\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\t\r3\u0015Q\u0004\u0005\u0007\u0013\u0006M\u0001\u0019\u0001&\t\u000f9\u000b\u0019\u00021\u0001\u0002,A1\u0001\u0003UA\u000f\u0003;1q!a\f+\u0003\u0003\t\tD\u0001\nXQ>dWMT;nE\u0016\u0014()\u001b8oS:<W\u0003BA\u001a\u0003s\u0019B!!\f\u00026A!AMUA\u001c!\r1\u0014\u0011\b\u0003\u0007q\u00055\"\u0019A\u001d\t\u0015%\u000biC!A!\u0002\u0013Qe\u000b\u0003\u0006O\u0003[\u0011\t\u0011)A\u0005\u0003\u007f\u0001b\u0001\u0005)\u00028\u0005]\u0002bB\u0017\u0002.\u0011\u0005\u00111\t\u000b\u0007\u0003\u000b\n9%!\u0013\u0011\u000b\u0011\fi#a\u000e\t\r%\u000b\t\u00051\u0001K\u0011\u001dq\u0015\u0011\ta\u0001\u0003\u007fA!\"!\u0014\u0002.\t\u0007I\u0011BA(\u0003\ri\u0017N\\\u000b\u0002Y\"A\u00111KA\u0017A\u0003%A.\u0001\u0003nS:\u0004\u0003BCA,\u0003[\u0011\r\u0011\"\u0003\u0002P\u0005\u0019Q.\u0019=\t\u0011\u0005m\u0013Q\u0006Q\u0001\n1\fA!\\1yA!Q\u0011qLA\u0017\u0005\u0004%I!!\u0019\u0002\u000f\tLgnU5{KV\u0011\u00111\r\t\u0004!\u0005\u0015\u0014bAA4#\t1Ai\\;cY\u0016D\u0011\"a\u001b\u0002.\u0001\u0006I!a\u0019\u0002\u0011\tLgnU5{K\u0002Bq\u0001[A\u0017\t\u0003\ny\u0007F\u0002K\u0003cBaa[A7\u0001\u0004a\u0007b\u00029\u0002.\u0011\u0005\u0013Q\u000f\u000b\u0004\u0015\u0006]\u0004bB6\u0002t\u0001\u0007\u0011q\u0007\u0005\bi\u00065B\u0011IA>)\u0011\t9$! \t\r]\fI\b1\u0001K\u0011\u001dq\u0015Q\u0006C!\u0003\u0003#B!a\u0010\u0002\u0004\"1q/a A\u0002)Cq\u0001`A\u0017\t\u0003\n9\tF\u0002\u007f\u0003\u0013Cqa[AC\u0001\u0004\t9\u0004\u0003\u0005\u0002\u000e\u00065b\u0011CAH\u00035\u0019wN\u001c<feR$v\u000eT8oOR\u0019A.!%\t\u000f-\fY\t1\u0001\u00028!A\u0011QSA\u0017\r#\t9*A\bd_:4XM\u001d;Ge>lGj\u001c8h)\u0011\t9$!'\t\r-\f\u0019\n1\u0001m\r\u0019\tiJ\u000b\u0001\u0002 \nQ\u0011J\u001c;CS:t\u0017N\\4\u0014\t\u0005m\u0015\u0011\u0015\t\u0006I\u00065\u00121\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0016\u0001\u00026bm\u0006LA!!-\u0002(\n9\u0011J\u001c;fO\u0016\u0014\bBC%\u0002\u001c\n\u0005\t\u0015!\u0003K-\"Qa*a'\u0003\u0002\u0003\u0006I!a.\u0011\rA\u0001\u00161UAR\u0011\u001di\u00131\u0014C\u0001\u0003w#b!!0\u0002@\u0006\u0005\u0007c\u00013\u0002\u001c\"1\u0011*!/A\u0002)CqATA]\u0001\u0004\t9\f\u0003\u0005\u0002\u000e\u0006mE\u0011KAc)\ra\u0017q\u0019\u0005\bW\u0006\r\u0007\u0019AAR\u0011!\t)*a'\u0005R\u0005-G\u0003BAR\u0003\u001bDaa[Ae\u0001\u0004agABAiU\u0001\t\u0019NA\u0006M_:<')\u001b8oS:<7\u0003BAh\u0003+\u0004R\u0001ZA\u0017\u0003/\u0004B!!*\u0002Z&\u0019a.a*\t\u0015%\u000byM!A!\u0002\u0013Qe\u000b\u0003\u0006O\u0003\u001f\u0014\t\u0011)A\u0005\u0003?\u0004b\u0001\u0005)\u0002X\u0006]\u0007bB\u0017\u0002P\u0012\u0005\u00111\u001d\u000b\u0007\u0003K\f9/!;\u0011\u0007\u0011\fy\r\u0003\u0004J\u0003C\u0004\rA\u0013\u0005\b\u001d\u0006\u0005\b\u0019AAp\u0011!\ti)a4\u0005R\u00055Hc\u00017\u0002p\"91.a;A\u0002\u0005]\u0007\u0002CAK\u0003\u001f$\t&a=\u0015\t\u0005]\u0017Q\u001f\u0005\u0007W\u0006E\b\u0019\u00017\u0007\r\u0005e(\u0006AA~\u0005-!\u0015\r^3CS:t\u0017N\\4\u0014\t\u0005]\u0018Q \t\u0006I\u00065\u0012q \t\u0005\u0005\u0003\u00119!\u0004\u0002\u0003\u0004)!!QAAV\u0003\u0011)H/\u001b7\n\t\t%!1\u0001\u0002\u0005\t\u0006$X\r\u0003\u0006J\u0003o\u0014\t\u0011)A\u0005\u0015ZC!BTA|\u0005\u0003\u0005\u000b\u0011\u0002B\b!\u0019\u0001\u0002+a@\u0002\u0000\"9Q&a>\u0005\u0002\tMAC\u0002B\u000b\u0005/\u0011I\u0002E\u0002e\u0003oDa!\u0013B\t\u0001\u0004Q\u0005b\u0002(\u0003\u0012\u0001\u0007!q\u0002\u0005\t\u0003\u001b\u000b9\u0010\"\u0015\u0003\u001eQ\u0019ANa\b\t\u000f-\u0014Y\u00021\u0001\u0002\u0000\"A\u0011QSA|\t#\u0012\u0019\u0003\u0006\u0003\u0002\u0000\n\u0015\u0002BB6\u0003\"\u0001\u0007AN\u0002\u0004\u0003*)\u0002!1\u0006\u0002\u0010\u000f\u0016|W.\u001a;ss\nKgN\\5oON!!q\u0005B\u0017!\u0015!\u0017Q\u0006B\u0018!\u0011\u0011\tDa\u000f\u000e\u0005\tM\"\u0002\u0002B\u001b\u0005o\tAaZ3p[*\u0019!\u0011\b\u0005\u0002\u0007)$8/\u0003\u0003\u0003>\tM\"\u0001C$f_6,GO]=\t\u0015%\u00139C!A!\u0002\u0013Qe\u000b\u0003\u0006O\u0005O\u0011\t\u0011)A\u0005\u0005\u0007\u0002b\u0001\u0005)\u00030\t=\u0002bB\u0017\u0003(\u0011\u0005!q\t\u000b\u0007\u0005\u0013\u0012YE!\u0014\u0011\u0007\u0011\u00149\u0003\u0003\u0004J\u0005\u000b\u0002\rA\u0013\u0005\b\u001d\n\u0015\u0003\u0019\u0001B\"\u0011!\tiIa\n\u0005R\tECc\u00017\u0003T!91Na\u0014A\u0002\t=\u0002\u0002CAK\u0005O!\tFa\u0016\u0015\t\t=\"\u0011\f\u0005\u0007W\nU\u0003\u0019\u00017\u0007\r\tu#\u0006\u0001B0\u000511En\\1u\u0005&tg.\u001b8h'\u0011\u0011YF!\u0019\u0011\t\u0011\u0014&1\r\t\u0005\u0003K\u0013)'\u0003\u0003\u0003h\u0005\u001d&!\u0002$m_\u0006$\bBC%\u0003\\\t\u0005\t\u0015!\u0003K-\"QaJa\u0017\u0003\u0002\u0003\u0006IA!\u001c\u0011\rA\u0001&1\rB2\u0011\u001di#1\fC\u0001\u0005c\"bAa\u001d\u0003v\t]\u0004c\u00013\u0003\\!1\u0011Ja\u001cA\u0002)CqA\u0014B8\u0001\u0004\u0011i\u0007\u0003\u0006\u0002`\tm#\u0019!C\u0005\u0005w*\"A! \u0011\u0007A\u0011y(C\u0002\u0003hEA\u0011\"a\u001b\u0003\\\u0001\u0006IA! \t\u000f!\u0014Y\u0006\"\u0011\u0003\u0006R\u0019!Ja\"\t\r-\u0014\u0019\t1\u0001m\u0011\u001d\u0001(1\fC!\u0005\u0017#2A\u0013BG\u0011\u001dY'\u0011\u0012a\u0001\u0005GBq\u0001\u001eB.\t\u0003\u0012\t\n\u0006\u0003\u0003d\tM\u0005BB<\u0003\u0010\u0002\u0007!\nC\u0004O\u00057\"\tEa&\u0015\t\t5$\u0011\u0014\u0005\u0007o\nU\u0005\u0019\u0001&\t\u000fq\u0014Y\u0006\"\u0011\u0003\u001eR\u0019aPa(\t\u000f-\u0014Y\n1\u0001\u0003d\u00191!1\u0015\u0016\u0001\u0005K\u0013Q\u0002R8vE2,')\u001b8oS:<7\u0003\u0002BQ\u0005O\u0003B\u0001\u001a*\u0003*B!\u0011Q\u0015BV\u0013\u0011\t9'a*\t\u0015%\u0013\tK!A!\u0002\u0013Qe\u000b\u0003\u0006O\u0005C\u0013\t\u0011)A\u0005\u0005c\u0003b\u0001\u0005)\u0003*\n%\u0006bB\u0017\u0003\"\u0012\u0005!Q\u0017\u000b\u0007\u0005o\u0013ILa/\u0011\u0007\u0011\u0014\t\u000b\u0003\u0004J\u0005g\u0003\rA\u0013\u0005\b\u001d\nM\u0006\u0019\u0001BY\u0011)\tyF!)C\u0002\u0013%\u0011\u0011\r\u0005\n\u0003W\u0012\t\u000b)A\u0005\u0003GBq\u0001\u001bBQ\t\u0003\u0012\u0019\rF\u0002K\u0005\u000bDaa\u001bBa\u0001\u0004a\u0007b\u00029\u0003\"\u0012\u0005#\u0011\u001a\u000b\u0004\u0015\n-\u0007bB6\u0003H\u0002\u0007!\u0011\u0016\u0005\bi\n\u0005F\u0011\tBh)\u0011\u0011IK!5\t\r]\u0014i\r1\u0001K\u0011\u001dq%\u0011\u0015C!\u0005+$BA!-\u0003X\"1qOa5A\u0002)Cq\u0001 BQ\t\u0003\u0012Y\u000eF\u0002\u007f\u0005;Dqa\u001bBm\u0001\u0004\u0011IK\u0002\u0004\u0003b*\u0002!1\u001d\u0002\u000e'R\u0014\u0018N\\4CS:t\u0017N\\4\u0014\t\t}'Q\u001d\t\u0006I\u00065\"q\u001d\t\u0005\u0005S\u0014yOD\u0002\u0011\u0005WL1A!<\u0012\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u001fBz\u0005\u0019\u0019FO]5oO*\u0019!Q^\t\t\u0015%\u0013yN!A!\u0002\u0013Qe\u000bC\u0006\u0003z\n}'\u0011!Q\u0001\n\tm\u0018!\u0003:bo\n{WO\u001c3t!\u0019\u0001\u0002Ka:\u0003h\"9QFa8\u0005\u0002\t}HCBB\u0001\u0007\u0007\u0019)\u0001E\u0002e\u0005?Da!\u0013B\u007f\u0001\u0004Q\u0005\u0002\u0003B}\u0005{\u0004\rAa?\t\u001b\r%!q\u001cI\u0001\u0012\u000f\u0007K\u0011BB\u0006\u0003\rAHEM\u000b\u0003\u0005wD1ba\u0004\u0003`\"\u0005\t\u0015)\u0003\u0003|\u0006!\u0001\u0010\n\u001a!\u0011-\u0019\u0019Ba8\t\u0006\u0004%Ia!\u0006\u0002\u000bM$\u0018M\u001d;\u0016\u0005\t\u001d\bbCB\r\u0005?D\t\u0011)Q\u0005\u0005O\faa\u001d;beR\u0004\u0003bCB\u000f\u0005?D)\u0019!C\u0005\u0007+\t1!\u001a8e\u0011-\u0019\tCa8\t\u0002\u0003\u0006KAa:\u0002\t\u0015tG\r\t\u0005\u000b\u0007K\u0011y\u000e#b\u0001\n\u00139\u0016\u0001\u00058pe6\fG.\u001b>fI2+gn\u001a;i\u0011)\u0019ICa8\t\u0002\u0003\u0006KAS\u0001\u0012]>\u0014X.\u00197ju\u0016$G*\u001a8hi\"\u0004\u0003BCB\u0017\u0005?D)\u0019!C\u0005/\u0006a\u0001O]3gSbdUM\\4uQ\"Q1\u0011\u0007Bp\u0011\u0003\u0005\u000b\u0015\u0002&\u0002\u001bA\u0014XMZ5y\u0019\u0016tw\r\u001e5!\u0011-\u0019)Da8\t\u0006\u0004%Iaa\u000e\u0002\rA\u0014XMZ5y+\t\u0019I\u0004\u0005\u0003\u0002&\u000em\u0012\u0002\u0002By\u0003OC1ba\u0010\u0003`\"\u0005\t\u0015)\u0003\u0004:\u00059\u0001O]3gSb\u0004\u0003\u0002CAG\u0005?$\tfa\u0011\u0015\u00071\u001c)\u0005C\u0004l\u0007\u0003\u0002\rAa:\t\u0011\u0005U%q\u001cC)\u0007\u0013\"BAa:\u0004L!11na\u0012A\u00021<qaa\u0014+\u0011\u0003\u0019\t&A\u0007TiJLgn\u001a\"j]:Lgn\u001a\t\u0004I\u000eMca\u0002BqU!\u00051QK\n\u0004\u0007'z\u0001bB\u0017\u0004T\u0011\u00051\u0011\f\u000b\u0003\u0007#B!b!\u0018\u0004T\t\u0007I\u0011BB0\u0003-\u0011\u0015m]34m\rC\u0017M]:\u0016\u0005\r\u0005\u0004#\u0002\t\u0004d\r\u001d\u0014bAB3#\t)\u0011I\u001d:bsB\u0019\u0001c!\u001b\n\u0007\r-\u0014C\u0001\u0003DQ\u0006\u0014\b\"CB8\u0007'\u0002\u000b\u0011BB1\u00031\u0011\u0015m]34m\rC\u0017M]:!\u0011)\u0019\u0019ha\u0015C\u0002\u0013\u00051QO\u0001\r\u0005\u0006\u001cXm\r\u001cM_^,7\u000f^\u000b\u0003\u0007OB\u0011b!\u001f\u0004T\u0001\u0006Iaa\u001a\u0002\u001b\t\u000b7/Z\u001a7\u0019><Xm\u001d;!\u0011)\u0019iha\u0015C\u0002\u0013\u00051QO\u0001\u000e\u0005\u0006\u001cXm\r\u001cIS\u001eDWm\u001d;\t\u0013\r\u000551\u000bQ\u0001\n\r\u001d\u0014A\u0004\"bg\u0016\u001cd\u0007S5hQ\u0016\u001cH\u000f\t\u0005\t\u0007\u000b\u001b\u0019\u0006\"\u0001\u0004\b\u0006Ian\u001c:nC2L'0\u001a\u000b\u0005\u0005O\u001cI\t\u0003\u0005\u0004\f\u000e\r\u0005\u0019\u0001Bt\u0003\u0005\u0019\b\u0002CBH\u0007'\"\ta!%\u0002\u001f9|'/\\1mSj,'i\\;oIN$BAa?\u0004\u0014\"9aj!$A\u0002\tm\bc\u0001\u001c\u0004\u0018\u0012)\u0001\b\u0001b\u0001s!1Q\u0006\u0001C\u0001\u00077#Ba!(\u0004 B!\u0011\u0006ABK\u0011\u001912\u0011\u0014a\u0001/!Q11\u0015\u0001C\u0002\u0013\u0005!a!*\u0002\r\r|WO\u001c;t+\t\u00199\u000b\u0005\u0003\u0011\u0007Gb\u0007\u0002CBV\u0001\u0001\u0006Iaa*\u0002\u000f\r|WO\u001c;tA!)\u0011\n\u0001C\u0001/\"1a\n\u0001C\u0001\u0007c+\"aa-\u0011\rA\u00016QSBK\u0011\u0019\u0001\u0004\u0001\"\u0001\u00048R\u0019An!/\t\r]\u001c)\f1\u0001K\u0011\u001d\u0019i\f\u0001C\u0001\u0007\u007f\u000bQa\u00197fCJ$\"a!1\u0011\u0007A\u0019\u0019-C\u0002\u0004FF\u0011A!\u00168ji\"91\u0011\u001a\u0001\u0005\u0002\r-\u0017aA1eIR11\u0011YBg\u0007\u001fDqa[Bd\u0001\u0004\u0019)\nC\u0005\u0004R\u000e\u001d\u0007\u0013!a\u0001Y\u0006)1m\\;oi\"1\u0001\u000e\u0001C\u0001\u0007+$2ASBl\u0011\u0019Y71\u001ba\u0001Y\"1\u0001\u000f\u0001C\u0001\u00077$2ASBo\u0011\u001dY7\u0011\u001ca\u0001\u0007+Ca\u0001\u001e\u0001\u0005\u0002\r\u0005H\u0003BBK\u0007GDaa^Bp\u0001\u0004Q\u0005B\u0002(\u0001\t\u0003\u00199\u000f\u0006\u0003\u00044\u000e%\bBB<\u0004f\u0002\u0007!\n\u0003\u0004}\u0001\u0011\u00051Q\u001e\u000b\u0004}\u000e=\bbB6\u0004l\u0002\u00071Q\u0013\u0005\n\u0007g\u0004\u0011\u0013!C\u0001\u0007k\fQ\"\u00193eI\u0011,g-Y;mi\u0012\u0012TCAB|U\ra7\u0011`\u0016\u0003\u0007w\u0004Ba!@\u0005\b5\u00111q \u0006\u0005\t\u0003!\u0019!A\u0005v]\u000eDWmY6fI*\u0019AQA\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0005\n\r}(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class BinnedArray<T> {
    private final Binning<T> binning;
    private final long[] counts;

    public long[] counts() {
        return this.counts;
    }

    public int length() {
        return this.binning.length();
    }

    public Tuple2<T, T> bounds() {
        return this.binning.bounds();
    }

    public long apply(int index) {
        return this.counts()[index];
    }

    public void clear() {
        for (int i = 0; i < this.length(); ++i) {
            this.counts()[i] = 0L;
        }
    }

    public void add(T value2, long count2) {
        int i = this.indexOf(value2);
        if (i != -1) {
            this.counts()[i] = this.counts()[i] + count2;
        }
    }

    public long add$default$2() {
        return 1L;
    }

    public int directIndex(long value2) {
        return this.binning.directIndex(value2);
    }

    public int indexOf(T value2) {
        return this.binning.indexOf(value2);
    }

    public T medianValue(int index) {
        return this.binning.medianValue(index);
    }

    public Tuple2<T, T> bounds(int index) {
        return this.binning.bounds(index);
    }

    public boolean isBelow(T value2) {
        return this.binning.isBelow(value2);
    }

    public BinnedArray(Binning<T> binning) {
        this.binning = binning;
        this.counts = (long[])Array$.MODULE$.fill(this.length(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }, ClassTag$.MODULE$.Long());
    }

    public static abstract class Binning<T> {
        private final int length;
        private final Tuple2<T, T> bounds;

        public int length() {
            return this.length;
        }

        public Tuple2<T, T> bounds() {
            return this.bounds;
        }

        public abstract int directIndex(long var1);

        public abstract int indexOf(T var1);

        public abstract T medianValue(int var1);

        public abstract Tuple2<T, T> bounds(int var1);

        public abstract boolean isBelow(T var1);

        public Binning(int length2, Tuple2<T, T> bounds2) {
            this.length = length2;
            this.bounds = bounds2;
        }
    }

    public static class IntBinning
    extends WholeNumberBinning<Integer> {
        @Override
        public long convertToLong(Integer value2) {
            return Predef$.MODULE$.Integer2int(value2);
        }

        @Override
        public Integer convertFromLong(long value2) {
            return Predef$.MODULE$.int2Integer((int)value2);
        }

        public IntBinning(int length2, Tuple2<Integer, Integer> bounds2) {
            super(length2, bounds2);
        }
    }

    public static class LongBinning
    extends WholeNumberBinning<Long> {
        @Override
        public long convertToLong(Long value2) {
            return Predef$.MODULE$.Long2long(value2);
        }

        @Override
        public Long convertFromLong(long value2) {
            return Predef$.MODULE$.long2Long(value2);
        }

        public LongBinning(int length2, Tuple2<Long, Long> bounds2) {
            super(length2, bounds2);
        }
    }

    public static class DateBinning
    extends WholeNumberBinning<Date> {
        @Override
        public long convertToLong(Date value2) {
            return value2.getTime();
        }

        @Override
        public Date convertFromLong(long value2) {
            return new Date(value2);
        }

        public DateBinning(int length2, Tuple2<Date, Date> bounds2) {
            super(length2, bounds2);
        }
    }

    public static class FloatBinning
    extends Binning<Float> {
        public final Tuple2<Float, Float> org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds;
        private final float binSize;

        private float binSize() {
            return this.binSize;
        }

        @Override
        public int directIndex(long value2) {
            return -1;
        }

        @Override
        public int indexOf(Float value2) {
            int i;
            return Predef$.MODULE$.Float2float(value2) < Predef$.MODULE$.Float2float((Float)this.org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds._1()) || Predef$.MODULE$.Float2float(value2) > Predef$.MODULE$.Float2float((Float)this.org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds._2()) ? -1 : ((i = (int)package$.MODULE$.floor((double)((Predef$.MODULE$.Float2float(value2) - Predef$.MODULE$.Float2float((Float)this.org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds._1())) / this.binSize()))) < 0 || i > super.length() ? -1 : (i == super.length() ? super.length() - 1 : i));
        }

        @Override
        public Float medianValue(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return Predef$.MODULE$.float2Float(Predef$.MODULE$.Float2float((Float)this.org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds._1()) + this.binSize() / (float)2 + this.binSize() * (float)index);
        }

        @Override
        public Tuple2<Float, Float> bounds(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return new Tuple2((Object)Predef$.MODULE$.float2Float(Predef$.MODULE$.Float2float((Float)this.org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds._1()) + this.binSize() * (float)index), (Object)Predef$.MODULE$.float2Float(Predef$.MODULE$.Float2float((Float)this.org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds._1()) + this.binSize() * (float)(index + 1)));
        }

        @Override
        public boolean isBelow(Float value2) {
            return Predef$.MODULE$.Float2float(value2) < Predef$.MODULE$.Float2float((Float)this.org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds._1());
        }

        public FloatBinning(int length2, Tuple2<Float, Float> bounds2) {
            this.org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds = bounds2;
            super(length2, bounds2);
            Predef$.MODULE$.require(Predef$.MODULE$.Float2float((Float)bounds2._1()) < Predef$.MODULE$.Float2float((Float)bounds2._2()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FloatBinning $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Upper bound must be greater than lower bound: lower='", "' upper='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds._1(), this.$outer.org$locationtech$geomesa$utils$stats$BinnedArray$FloatBinning$$bounds._2()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.binSize = (Predef$.MODULE$.Float2float((Float)bounds2._2()) - Predef$.MODULE$.Float2float((Float)bounds2._1())) / (float)super.length();
        }
    }

    public static class DoubleBinning
    extends Binning<Double> {
        public final Tuple2<Double, Double> org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds;
        private final double binSize;

        private double binSize() {
            return this.binSize;
        }

        @Override
        public int directIndex(long value2) {
            return -1;
        }

        @Override
        public int indexOf(Double value2) {
            int i;
            return Predef$.MODULE$.Double2double(value2) < Predef$.MODULE$.Double2double((Double)this.org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds._1()) || Predef$.MODULE$.Double2double(value2) > Predef$.MODULE$.Double2double((Double)this.org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds._2()) ? -1 : ((i = (int)package$.MODULE$.floor((Predef$.MODULE$.Double2double(value2) - Predef$.MODULE$.Double2double((Double)this.org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds._1())) / this.binSize())) < 0 || i > super.length() ? -1 : (i == super.length() ? super.length() - 1 : i));
        }

        @Override
        public Double medianValue(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double((Double)this.org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds._1()) + this.binSize() / (double)2 + this.binSize() * (double)index);
        }

        @Override
        public Tuple2<Double, Double> bounds(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return new Tuple2((Object)Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double((Double)this.org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds._1()) + this.binSize() * (double)index), (Object)Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double((Double)this.org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds._1()) + this.binSize() * (double)(index + 1)));
        }

        @Override
        public boolean isBelow(Double value2) {
            return Predef$.MODULE$.Double2double(value2) < Predef$.MODULE$.Double2double((Double)this.org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds._1());
        }

        public DoubleBinning(int length2, Tuple2<Double, Double> bounds2) {
            this.org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds = bounds2;
            super(length2, bounds2);
            Predef$.MODULE$.require(Predef$.MODULE$.Double2double((Double)bounds2._1()) < Predef$.MODULE$.Double2double((Double)bounds2._2()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DoubleBinning $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Upper bound must be greater than lower bound: lower='", "' upper='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds._1(), this.$outer.org$locationtech$geomesa$utils$stats$BinnedArray$DoubleBinning$$bounds._2()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.binSize = (Predef$.MODULE$.Double2double((Double)bounds2._2()) - Predef$.MODULE$.Double2double((Double)bounds2._1())) / (double)super.length();
        }
    }

    public static class StringBinning
    extends WholeNumberBinning<String> {
        private Tuple2<String, String> x$2;
        private String start;
        private String end;
        private int normalizedLength;
        private int prefixLength;
        private String prefix;
        private volatile byte bitmap$0;

        private Tuple2 x$2$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    Tuple2 tuple2 = this.bounds();
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        String start = (String)tuple2._1();
                        String end = (String)tuple2._2();
                        this.x$2 = tuple22 = new Tuple2((Object)start, (Object)end);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    } else {
                        throw new MatchError(tuple2);
                    }
                }
                return this.x$2;
            }
        }

        private String start$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.start = (String)this.x$2()._1();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.start;
            }
        }

        private String end$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.end = (String)this.x$2()._2();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
                return this.end;
            }
        }

        private int normalizedLength$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.normalizedLength = this.start().length();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
                return this.normalizedLength;
            }
        }

        private int prefixLength$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.prefixLength = ((GenSeqLike)new StringOps(Predef$.MODULE$.augmentString(this.start())).zip((GenIterable)Predef$.MODULE$.wrapString(this.end()), Predef$.MODULE$.fallbackStringCanBuildFrom())).indexWhere((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, Object> x0$1) {
                            Tuple2<Object, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                char r;
                                char l = tuple2._1$mcC$sp();
                                boolean bl = l != (r = tuple2._2$mcC$sp());
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
                return this.prefixLength;
            }
        }

        private String prefix$lzycompute() {
            StringBinning stringBinning = this;
            synchronized (stringBinning) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.prefix = this.start().substring(0, this.prefixLength());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
                return this.prefix;
            }
        }

        private /* synthetic */ Tuple2 x$2() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.x$2$lzycompute() : this.x$2;
        }

        private String start() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.start$lzycompute() : this.start;
        }

        private String end() {
            return (byte)(this.bitmap$0 & 4) == 0 ? this.end$lzycompute() : this.end;
        }

        private int normalizedLength() {
            return (byte)(this.bitmap$0 & 8) == 0 ? this.normalizedLength$lzycompute() : this.normalizedLength;
        }

        private int prefixLength() {
            return (byte)(this.bitmap$0 & 0x10) == 0 ? this.prefixLength$lzycompute() : this.prefixLength;
        }

        private String prefix() {
            return (byte)(this.bitmap$0 & 0x20) == 0 ? this.prefix$lzycompute() : this.prefix;
        }

        @Override
        public long convertToLong(String value2) {
            long l;
            String normalized = (String)new StringOps(Predef$.MODULE$.augmentString(BinnedArray$StringBinning$.MODULE$.normalize(value2))).padTo(this.normalizedLength(), (Object)BoxesRunTime.boxToCharacter((char)'0'), Predef$.MODULE$.StringCanBuildFrom());
            if (new StringOps(Predef$.MODULE$.augmentString(normalized)).$less((Object)this.start())) {
                l = 0L;
            } else if (new StringOps(Predef$.MODULE$.augmentString(normalized)).$greater((Object)this.end())) {
                l = Long.MAX_VALUE;
            } else {
                String sigDigits = ((String)new StringOps(Predef$.MODULE$.augmentString(normalized.substring(this.prefixLength()))).padTo(12, (Object)BoxesRunTime.boxToCharacter((char)BinnedArray$StringBinning$.MODULE$.Base36Lowest()), Predef$.MODULE$.StringCanBuildFrom())).substring(0, 12);
                l = Long.parseLong(sigDigits, 36);
            }
            return l;
        }

        @Override
        public String convertFromLong(long value2) {
            return new StringBuilder().append((Object)this.prefix()).append((Object)((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(Long.toString(value2, 36))).reverse())).padTo(12, (Object)BoxesRunTime.boxToCharacter((char)BinnedArray$StringBinning$.MODULE$.Base36Lowest()), Predef$.MODULE$.StringCanBuildFrom()))).reverse()).replaceFirst("0+$", "")).toString();
        }

        public StringBinning(int length2, Tuple2<String, String> rawBounds) {
            super(length2, BinnedArray$StringBinning$.MODULE$.normalizeBounds(rawBounds));
        }
    }

    public static class GeometryBinning
    extends WholeNumberBinning<Geometry> {
        @Override
        public long convertToLong(Geometry value2) {
            Point point;
            Geometry geometry = value2;
            Point point2 = geometry instanceof Point ? (point = (Point)geometry) : Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geometry));
            Point centroid = point2;
            return Z2SFC$.MODULE$.index(centroid.getX(), centroid.getY(), true);
        }

        @Override
        public Geometry convertFromLong(long value2) {
            Tuple2 tuple2 = Z2SFC$.MODULE$.invert(value2);
            if (tuple2 != null) {
                Tuple2.mcDD.sp sp2;
                double x = tuple2._1$mcD$sp();
                double y = tuple2._2$mcD$sp();
                Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(x, y);
                double x2 = sp3._1$mcD$sp();
                double y2 = sp3._2$mcD$sp();
                return GeometryUtils$.MODULE$.geoFactory().createPoint(new Coordinate(x2, y2));
            }
            throw new MatchError((Object)tuple2);
        }

        public GeometryBinning(int length2, Tuple2<Geometry, Geometry> bounds2) {
            super(length2, bounds2);
        }
    }

    public static abstract class WholeNumberBinning<T>
    extends Binning<T> {
        public final Tuple2<T, T> org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$bounds;
        private final long org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min;
        private final long org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$max;
        private final double binSize;

        public long org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min() {
            return this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min;
        }

        public long org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$max() {
            return this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$max;
        }

        private double binSize() {
            return this.binSize;
        }

        @Override
        public int directIndex(long value2) {
            int i;
            return value2 < this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min() || value2 > this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$max() ? -1 : ((i = (int)package$.MODULE$.floor((double)(value2 - this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min()) / this.binSize())) < 0 || i > super.length() ? -1 : (i == super.length() ? super.length() - 1 : i));
        }

        @Override
        public int indexOf(T value2) {
            return this.directIndex(this.convertToLong(value2));
        }

        @Override
        public T medianValue(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            long l = this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min() + package$.MODULE$.round(this.binSize() / (double)2 + this.binSize() * (double)index);
            return (T)(l > this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$max() ? this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$bounds._2() : this.convertFromLong(l));
        }

        @Override
        public Tuple2<T, T> bounds(int index) {
            if (index < 0 || index > super.length()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            long loLong = this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min() + (long)package$.MODULE$.ceil(this.binSize() * (double)index);
            long hiLong = package$.MODULE$.max(loLong, this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min() + (long)package$.MODULE$.floor(this.binSize() * (double)(index + 1)));
            Object lo = loLong <= this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min() ? this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$bounds._1() : this.convertFromLong(loLong);
            Object hi = hiLong >= this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$max() ? this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$bounds._2() : this.convertFromLong(hiLong);
            return new Tuple2(lo, hi);
        }

        @Override
        public boolean isBelow(T value2) {
            return this.convertToLong(value2) < this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min();
        }

        public abstract long convertToLong(T var1);

        public abstract T convertFromLong(long var1);

        public WholeNumberBinning(int length2, Tuple2<T, T> bounds2) {
            this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$bounds = bounds2;
            super(length2, bounds2);
            this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min = this.convertToLong(bounds2._1());
            this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$max = this.convertToLong(bounds2._2());
            Predef$.MODULE$.require(this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min() < this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$max(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WholeNumberBinning $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Upper bound must be greater than lower bound: lower='", "'(", ") upper='", "'(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$bounds._1(), BoxesRunTime.boxToLong((long)this.$outer.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min()), this.$outer.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$bounds._2(), BoxesRunTime.boxToLong((long)this.$outer.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$max())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.binSize = (double)(this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$max() - this.org$locationtech$geomesa$utils$stats$BinnedArray$WholeNumberBinning$$min()) / (double)super.length();
        }
    }
}

